/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.livedata;

import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.util.ParamChecker;

public final class LiveDataRow {
    private static final double ZERO = 0.0;
    private final LoggerData loggerData;
    private double minValue;
    private double maxValue;
    private double currentValue;
    private boolean updated = false;

    public LiveDataRow(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        this.loggerData = loggerData;
    }

    public LoggerData getLoggerData() {
        return this.loggerData;
    }

    public String getName() {
        return this.loggerData.getName();
    }

    public String getMinValue() {
        return this.loggerData.getSelectedConvertor().format(this.minValue);
    }

    public String getMaxValue() {
        return this.loggerData.getSelectedConvertor().format(this.maxValue);
    }

    public String getCurrentValue() {
        return this.loggerData.getSelectedConvertor().format(this.currentValue);
    }

    public String getUnits() {
        return this.loggerData.getSelectedConvertor().getUnits();
    }

    public void updateValue(double d) {
        this.currentValue = d;
        if (this.currentValue < this.minValue || !this.updated) {
            this.minValue = this.currentValue;
        }
        if (this.currentValue > this.maxValue || !this.updated) {
            this.maxValue = this.currentValue;
        }
        this.updated = true;
    }

    public void reset() {
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.currentValue = 0.0;
        this.updated = false;
    }
}

