/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.livedata;

import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.livedata.LiveDataRow;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public final class LiveDataTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3712433453224086342L;
    private final String[] columnNames = new String[]{"Logger Data", "Min Value", "Current Value", "Max Value", "Units"};
    private final List<LoggerData> registeredLoggerData = Collections.synchronizedList(new LinkedList());
    private final Map<LoggerData, LiveDataRow> dataRowMap = Collections.synchronizedMap(new LinkedHashMap());

    public synchronized int getRowCount() {
        return this.dataRowMap.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public synchronized Object getValueAt(int n, int n2) {
        LiveDataRow liveDataRow = this.dataRowMap.get(this.registeredLoggerData.get(n));
        switch (n2) {
            case 0: {
                return liveDataRow.getName();
            }
            case 1: {
                return liveDataRow.getMinValue();
            }
            case 2: {
                return liveDataRow.getCurrentValue();
            }
            case 3: {
                return liveDataRow.getMaxValue();
            }
            case 4: {
                return liveDataRow.getUnits();
            }
        }
        return "Error!";
    }

    public synchronized void addParam(LoggerData loggerData) {
        if (!this.registeredLoggerData.contains(loggerData)) {
            this.dataRowMap.put(loggerData, new LiveDataRow(loggerData));
            this.registeredLoggerData.add(loggerData);
            this.fireTableDataChanged();
        }
    }

    public synchronized void removeParam(LoggerData loggerData) {
        this.registeredLoggerData.remove(loggerData);
        this.dataRowMap.remove(loggerData);
        this.fireTableDataChanged();
    }

    public synchronized void updateParam(LoggerData loggerData, double d) {
        LiveDataRow liveDataRow = this.dataRowMap.get(loggerData);
        if (liveDataRow != null) {
            liveDataRow.updateValue(d);
            int n = this.registeredLoggerData.indexOf(loggerData);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public synchronized void reset() {
        for (LiveDataRow liveDataRow : this.dataRowMap.values()) {
            liveDataRow.reset();
        }
        this.fireTableDataChanged();
    }

    public synchronized void resetRow(LoggerData loggerData) {
        LiveDataRow liveDataRow = this.dataRowMap.get(loggerData);
        if (liveDataRow != null) {
            liveDataRow.reset();
            this.fireTableDataChanged();
        }
    }
}

