/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.maf;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.tab.maf.MafTab;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class MafUpdateHandler
implements DataUpdateHandler {
    private static final Logger LOGGER = Logger.getLogger(MafUpdateHandler.class);
    private static final String MAFV = "P18";
    private static final String AF_LEARNING_1 = "P4";
    private static final String AF_CORRECTION_1 = "P3";
    private MafTab mafTab;
    private double lastMafv;
    private long lastUpdate;

    public synchronized void registerData(LoggerData loggerData) {
    }

    public synchronized void handleDataUpdate(Response response) {
        if (this.mafTab.isRecordData() && this.containsData(response, MAFV, AF_LEARNING_1, AF_CORRECTION_1)) {
            double d;
            double d2;
            boolean bl = true;
            if (this.containsData(response, "E3") || this.containsData(response, "E33")) {
                d2 = -1.0;
                if (this.containsData(response, "E3")) {
                    d2 = (int)this.findValue(response, "E3");
                    LOGGER.trace((Object)("MAF:[CL/OL:E3]:  " + d2));
                }
                if (this.containsData(response, "E33")) {
                    d2 = (int)this.findValue(response, "E33");
                    LOGGER.trace((Object)("MAF:[CL/OL:E33]: " + d2));
                }
                bl = this.mafTab.isValidClOl(d2);
                LOGGER.trace((Object)("MAF:[CL/OL]:     " + bl));
            }
            if (bl && this.containsData(response, "P58")) {
                d2 = this.findValue(response, "P58");
                LOGGER.trace((Object)("MAF:[AFR:P58]: " + d2));
                bl = this.mafTab.isValidAfr(d2);
                LOGGER.trace((Object)("MAF:[AFR]:     " + bl));
            }
            if (bl && this.containsData(response, "P8")) {
                d2 = this.findValue(response, "P8");
                LOGGER.trace((Object)("MAF:[RPM:P8]: " + d2));
                bl = this.mafTab.isValidRpm(d2);
                LOGGER.trace((Object)("MAF:[RPM]:    " + bl));
            }
            if (bl && this.containsData(response, "P12")) {
                d2 = this.findValue(response, "P12");
                LOGGER.trace((Object)("MAF:[MAF:P12]: " + d2));
                bl = this.mafTab.isValidMaf(d2);
                LOGGER.trace((Object)("MAF:[MAF]:     " + bl));
            }
            if (bl && this.containsData(response, "P11")) {
                d2 = this.findValue(response, "P11");
                LOGGER.trace((Object)("MAF:[IAT:P11]: " + d2));
                bl = this.mafTab.isValidIntakeAirTemp(d2);
                LOGGER.trace((Object)("MAF:[IAT]:     " + bl));
            }
            if (bl && this.containsData(response, "P2")) {
                d2 = this.findValue(response, "P2");
                LOGGER.trace((Object)("MAF:[CT:P2]: " + d2));
                bl = this.mafTab.isValidCoolantTemp(d2);
                LOGGER.trace((Object)("MAF:[CT]:    " + bl));
            }
            if (bl && this.containsData(response, MAFV)) {
                d2 = this.findValue(response, MAFV);
                long l = System.currentTimeMillis();
                d = Math.abs((d2 - this.lastMafv) / (double)(l - this.lastUpdate) * 1000.0);
                LOGGER.trace((Object)("MAF:[dMAFv/dt]: " + d));
                bl = this.mafTab.isValidMafvChange(d);
                LOGGER.trace((Object)("MAF:[dMAFv/dt]: " + bl));
                this.lastMafv = d2;
                this.lastUpdate = l;
            }
            if (bl && (this.containsData(response, "E23") || this.containsData(response, "E54"))) {
                d2 = -1.0;
                if (this.containsData(response, "E23")) {
                    d2 = this.findValue(response, "E23");
                    LOGGER.trace((Object)("MAF:[TIP:E23]: " + d2));
                }
                if (this.containsData(response, "E54")) {
                    d2 = this.findValue(response, "E54");
                    LOGGER.trace((Object)("MAF:[TIP:E54]: " + d2));
                }
                bl = this.mafTab.isValidTipInThrottle(d2);
                LOGGER.trace((Object)("MAF:[TIP]:     " + bl));
            }
            if (bl) {
                d2 = this.findValue(response, MAFV);
                final double d3 = this.findValue(response, AF_LEARNING_1);
                d = this.findValue(response, AF_CORRECTION_1);
                LOGGER.trace((Object)("MAF Data: " + d2 + "v, " + d + "%"));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MafUpdateHandler.this.mafTab.addData(d2, d3 + d);
                    }
                });
            }
        }
    }

    private boolean containsData(Response response, String ... stringArray) {
        Set<LoggerData> set = response.getData();
        for (String string : stringArray) {
            boolean bl = false;
            for (LoggerData loggerData : set) {
                if (!loggerData.getId().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private double findValue(Response response, String string) {
        for (LoggerData loggerData : response.getData()) {
            if (!string.equals(loggerData.getId())) continue;
            return response.getDataValue(loggerData);
        }
        throw new IllegalStateException("Expected data item " + string + " not in response.");
    }

    public synchronized void deregisterData(LoggerData loggerData) {
    }

    public synchronized void cleanUp() {
    }

    public synchronized void reset() {
    }

    public void setMafTab(MafTab mafTab) {
        this.mafTab = mafTab;
    }
}

