/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.playback;

import com.romraider.logger.ecu.comms.query.ResponseImpl;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.playback.PlaybackManager;
import com.romraider.util.ThreadUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaybackManagerImpl
implements PlaybackManager {
    private final List<? extends LoggerData> loggerDatas;
    private final DataUpdateHandler[] dataUpdateHandlers;

    public PlaybackManagerImpl(List<? extends LoggerData> list, DataUpdateHandler ... dataUpdateHandlerArray) {
        this.loggerDatas = list;
        this.dataUpdateHandlers = dataUpdateHandlerArray;
    }

    @Override
    public void load(File file) {
        for (DataUpdateHandler dataUpdateHandler : this.dataUpdateHandlers) {
            dataUpdateHandler.registerData(this.loggerDatas.get(10));
            dataUpdateHandler.registerData(this.loggerDatas.get(20));
            dataUpdateHandler.registerData(this.loggerDatas.get(30));
        }
    }

    @Override
    public void play() {
        double d = 0.0;
        while (true) {
            for (DataUpdateHandler dataUpdateHandler : this.dataUpdateHandlers) {
                ResponseImpl responseImpl = new ResponseImpl();
                responseImpl.setDataValue(this.loggerDatas.get(10), d);
                responseImpl.setDataValue(this.loggerDatas.get(20), d);
                responseImpl.setDataValue(this.loggerDatas.get(30), d);
                dataUpdateHandler.handleDataUpdate(responseImpl);
                d += 100.0;
            }
            ThreadUtil.sleep(100L);
        }
    }

    @Override
    public void play(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void step(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

