/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.logger.ecu.ui.swing.menubar.EcuLoggerMenu;
import com.romraider.logger.ecu.ui.swing.menubar.EcuLoggerMenuItem;
import com.romraider.logger.ecu.ui.swing.menubar.EcuLoggerRadioButtonMenuItem;
import com.romraider.logger.ecu.ui.swing.menubar.action.AboutAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.DisconnectAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.ExitAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.LoadProfileAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.LogFileAbsoluteTimestampAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.LogFileControllerSwitchAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.LogFileLocationAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.LoggerDefinitionLocationAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.ReloadProfileAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.ResetConnectionAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.ResetEcuAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.SaveProfileAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.SaveProfileAsAction;
import com.romraider.logger.ecu.ui.swing.menubar.action.UpdateLoggerDefAction;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcuLoggerMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 7081586516953740186L;

    public EcuLoggerMenuBar(EcuLogger ecuLogger, List<ExternalDataSource> list) {
        EcuLoggerMenu ecuLoggerMenu = new EcuLoggerMenu("File", 70);
        ecuLoggerMenu.add(new EcuLoggerMenuItem("Load Profile...", new LoadProfileAction(ecuLogger), 76, KeyStroke.getKeyStroke(76, 2)));
        ecuLoggerMenu.add(new EcuLoggerMenuItem("Reload Profile", new ReloadProfileAction(ecuLogger), 80, KeyStroke.getKeyStroke(80, 2)));
        ecuLoggerMenu.add(new EcuLoggerMenuItem("Save Profile", new SaveProfileAction(ecuLogger), 83, KeyStroke.getKeyStroke(83, 2)));
        ecuLoggerMenu.add(new EcuLoggerMenuItem("Save Profile As...", new SaveProfileAsAction(ecuLogger), 65, KeyStroke.getKeyStroke(83, 3)));
        ecuLoggerMenu.add(new JSeparator());
        ecuLoggerMenu.add(new EcuLoggerMenuItem("Exit", new ExitAction(ecuLogger), 88));
        this.add(ecuLoggerMenu);
        EcuLoggerMenu ecuLoggerMenu2 = new EcuLoggerMenu("Settings", 83);
        ecuLoggerMenu2.add(new EcuLoggerMenuItem("Logger Definition Location...", new LoggerDefinitionLocationAction(ecuLogger), 68, KeyStroke.getKeyStroke(68, 2)));
        ecuLoggerMenu2.add(new EcuLoggerMenuItem("Log File Output Location...", new LogFileLocationAction(ecuLogger), 79, KeyStroke.getKeyStroke(79, 2)));
        ecuLoggerMenu2.add(new JSeparator());
        ecuLoggerMenu2.add(new EcuLoggerRadioButtonMenuItem("Control File Logging With Defogger Switch", 67, KeyStroke.getKeyStroke(67, 2), new LogFileControllerSwitchAction(ecuLogger), ecuLogger.getSettings().isFileLoggingControllerSwitchActive()));
        ecuLoggerMenu2.add(new EcuLoggerRadioButtonMenuItem("Use Absolute Timestamp In Log File", 84, KeyStroke.getKeyStroke(84, 2), new LogFileAbsoluteTimestampAction(ecuLogger), ecuLogger.getSettings().isFileLoggingAbsoluteTimestamp()));
        this.add(ecuLoggerMenu2);
        EcuLoggerMenu ecuLoggerMenu3 = new EcuLoggerMenu("Connection", 67);
        ecuLoggerMenu3.add(new EcuLoggerMenuItem("Reset", new ResetConnectionAction(ecuLogger), 82, KeyStroke.getKeyStroke(82, 2)));
        ecuLoggerMenu3.add(new EcuLoggerMenuItem("Disconnect", new DisconnectAction(ecuLogger), 68, KeyStroke.getKeyStroke(68, 2)));
        this.add(ecuLoggerMenu3);
        EcuLoggerMenu ecuLoggerMenu4 = new EcuLoggerMenu("Tools", 84);
        ecuLoggerMenu4.add(new EcuLoggerMenuItem("Reset ECU", new ResetEcuAction(ecuLogger), 82, KeyStroke.getKeyStroke(118, 0)));
        this.add(ecuLoggerMenu4);
        EcuLoggerMenu ecuLoggerMenu5 = new EcuLoggerMenu("Plugins", 80);
        ecuLoggerMenu5.setEnabled(!list.isEmpty());
        for (ExternalDataSource externalDataSource : list) {
            Action action = externalDataSource.getMenuAction(ecuLogger);
            if (action == null) continue;
            ecuLoggerMenu5.add(new EcuLoggerMenuItem(externalDataSource.getName(), action));
        }
        this.add(ecuLoggerMenu5);
        EcuLoggerMenu ecuLoggerMenu6 = new EcuLoggerMenu("Help", 72);
        ecuLoggerMenu6.add(new EcuLoggerMenuItem("Update Logger Definition...", new UpdateLoggerDefAction(ecuLogger), 85));
        ecuLoggerMenu6.add(new JSeparator());
        ecuLoggerMenu6.add(new EcuLoggerMenuItem("About RomRaider", new AboutAction(ecuLogger), 65));
        this.add(ecuLoggerMenu6);
    }
}

