/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.action;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.ui.swing.menubar.action.AbstractAction;
import com.romraider.logger.ecu.ui.swing.menubar.util.FileHelper;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class SaveProfileAsAction
extends AbstractAction {
    public SaveProfileAsAction(EcuLogger ecuLogger) {
        super(ecuLogger);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.saveProfileAs();
        }
        catch (Exception exception) {
            this.logger.reportError(exception);
        }
    }

    private void saveProfileAs() throws Exception {
        File file;
        File file2 = FileHelper.getFile(this.logger.getSettings().getLoggerProfileFilePath());
        JFileChooser jFileChooser = FileHelper.getProfileFileChooser(file2);
        if (!(jFileChooser.showSaveDialog(this.logger) != 0 || (file = jFileChooser.getSelectedFile()).exists() && JOptionPane.showConfirmDialog(this.logger, file.getName() + " already exists! Overwrite?") != 0)) {
            String string = FileHelper.saveProfileToFile(this.logger.getCurrentProfile(), file);
            this.logger.getSettings().setLoggerProfileFilePath(string);
            this.logger.reportMessageInTitleBar("Profile: " + string);
            this.logger.reportMessage("Profile succesfully saved as: " + string);
        }
    }
}

