/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.vertical;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public final class VerticalLabelUI
extends BasicLabelUI {
    private static Rectangle PAINT_ICON_R = new Rectangle();
    private static Rectangle PAINT_TEXT_R = new Rectangle();
    private static Rectangle PAINT_VIEW_R = new Rectangle();
    private static Insets PAINT_VIEW_INSETS = new Insets(0, 0, 0, 0);
    protected boolean clockwise;

    public VerticalLabelUI(boolean bl) {
        this.clockwise = bl;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height, dimension.width);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        PAINT_VIEW_INSETS = jComponent.getInsets(PAINT_VIEW_INSETS);
        VerticalLabelUI.PAINT_VIEW_R.x = VerticalLabelUI.PAINT_VIEW_INSETS.left;
        VerticalLabelUI.PAINT_VIEW_R.y = VerticalLabelUI.PAINT_VIEW_INSETS.top;
        VerticalLabelUI.PAINT_VIEW_R.height = jComponent.getWidth() - (VerticalLabelUI.PAINT_VIEW_INSETS.left + VerticalLabelUI.PAINT_VIEW_INSETS.right);
        VerticalLabelUI.PAINT_VIEW_R.width = jComponent.getHeight() - (VerticalLabelUI.PAINT_VIEW_INSETS.top + VerticalLabelUI.PAINT_VIEW_INSETS.bottom);
        VerticalLabelUI.PAINT_ICON_R.height = 0;
        VerticalLabelUI.PAINT_ICON_R.width = 0;
        VerticalLabelUI.PAINT_ICON_R.y = 0;
        VerticalLabelUI.PAINT_ICON_R.x = 0;
        VerticalLabelUI.PAINT_TEXT_R.height = 0;
        VerticalLabelUI.PAINT_TEXT_R.width = 0;
        VerticalLabelUI.PAINT_TEXT_R.y = 0;
        VerticalLabelUI.PAINT_TEXT_R.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, PAINT_VIEW_R, PAINT_ICON_R, PAINT_TEXT_R);
        int n = fontMetrics.stringWidth(string2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.clockwise) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(jComponent.getHeight() / 2 - n / 2, -jComponent.getWidth());
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight() / 2 - n / 2, 0);
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalLabelUI.PAINT_ICON_R.x, VerticalLabelUI.PAINT_ICON_R.y);
        }
        if (string != null) {
            int n2 = VerticalLabelUI.PAINT_TEXT_R.x;
            int n3 = VerticalLabelUI.PAINT_TEXT_R.y + fontMetrics.getAscent();
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string2, n2, n3);
            } else {
                this.paintDisabledText(jLabel, graphics, string2, n2, n3);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    static {
        labelUI = new VerticalLabelUI(false);
    }
}

