/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.tab;

import com.romraider.util.ParamChecker;
import jamlab.Polyfit;
import jamlab.Polyval;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XYTrendline
extends AbstractXYDataset {
    private static final long serialVersionUID = 1375705537694372443L;
    private List<XYDataItem> items = new ArrayList<XYDataItem>();
    private double[] xVals = new double[0];
    private double[] yPoly = new double[0];
    private final XYSeries series;
    private Polyfit polyfit;

    public XYTrendline(XYSeries xYSeries) {
        ParamChecker.checkNotNull(xYSeries);
        this.series = xYSeries;
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable<String> getSeriesKey(int n) {
        return "foo";
    }

    public synchronized int getItemCount(int n) {
        return this.yPoly.length;
    }

    public synchronized Number getY(int n, int n2) {
        return this.yPoly[n2];
    }

    public synchronized Number getX(int n, int n2) {
        return this.xVals[n2];
    }

    public synchronized void update(int n) {
        if (this.series.getItemCount() <= n) {
            return;
        }
        this.items = new ArrayList<XYDataItem>(this.series.getItems());
        this.xVals = new double[this.items.size()];
        double[] dArray = new double[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            XYDataItem xYDataItem = this.items.get(i);
            this.xVals[i] = xYDataItem.getX().doubleValue();
            dArray[i] = xYDataItem.getY().doubleValue();
        }
        try {
            this.polyfit = new Polyfit(this.xVals, dArray, n);
            this.yPoly = this.calculate(this.xVals);
        }
        catch (Exception exception) {
            throw new UndeclaredThrowableException(exception);
        }
    }

    public synchronized double[] calculate(double[] dArray) {
        if (this.polyfit == null) {
            throw new IllegalStateException("Interpolation required");
        }
        Polyval polyval = new Polyval(dArray, this.polyfit);
        return polyval.getYout();
    }

    public synchronized Polyfit getPolyFit() {
        if (this.polyfit == null) {
            throw new IllegalStateException("Interpolation required");
        }
        return this.polyfit;
    }

    public synchronized void clear() {
        this.items.clear();
        this.xVals = new double[0];
        this.yPoly = new double[0];
        this.polyfit = null;
    }
}

