/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.innovate.lc1.plugin;

import com.romraider.logger.innovate.generic.plugin.DataConvertor;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import org.apache.log4j.Logger;

public final class Lc1DataConvertor
implements DataConvertor {
    private static final Logger LOGGER = Logger.getLogger(Lc1DataConvertor.class);
    private static final double MAX_AFR = 20.33;

    public double convert(byte[] byArray) {
        LOGGER.trace((Object)("Converting LC-1 bytes: " + HexUtil.asHex(byArray)));
        if (this.isLc1(byArray) && this.isHeaderValid(byArray)) {
            if (this.isError(byArray)) {
                int n = -1 * this.getLambda(byArray);
                LOGGER.error((Object)("LC-1 error: " + HexUtil.asHex(byArray) + " --> " + n));
                return n;
            }
            if (this.isOk(byArray)) {
                double d = this.getAfr(byArray);
                LOGGER.trace((Object)("LC-1 AFR: " + d));
                return d > 20.33 ? 20.33 : d;
            }
            LOGGER.trace((Object)("LC-1 response out of range (overrun?): " + HexUtil.asHex(byArray)));
            return 20.33;
        }
        LOGGER.error((Object)("LC-1 unrecognized response: " + HexUtil.asHex(byArray)));
        return 0.0;
    }

    private double getAfr(byte[] byArray) {
        return (double)((this.getLambda(byArray) + 500) * this.getAf(byArray)) / 10000.0;
    }

    private int getAf(byte[] byArray) {
        return (byArray[2] & 1) << 7 | byArray[3];
    }

    private boolean isLc1(byte[] byArray) {
        return byArray.length >= 6 && ByteUtil.matchOnes(byArray[2], 66) && ByteUtil.matchZeroes(byArray[2], 160);
    }

    private boolean isHeaderValid(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[0], 178) && ByteUtil.matchOnes(byArray[1], 128);
    }

    private boolean isOk(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[2], 66) && ByteUtil.matchZeroes(byArray[2], 188);
    }

    private boolean isError(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[2], 90) && ByteUtil.matchZeroes(byArray[2], 164);
    }

    private int getLambda(byte[] byArray) {
        return (byArray[4] & 0x3F) << 7 | byArray[5];
    }
}

