/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table3D;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;

public class Table1D
extends Table {
    private static final long serialVersionUID = -8747180767803835631L;
    private Color axisColor = new Color(255, 255, 255);

    public Table1D(Settings settings) {
        super(settings);
    }

    public void populateTable(byte[] byArray) {
        this.centerLayout.setRows(1);
        this.centerLayout.setColumns(this.getDataSize());
        super.populateTable(byArray);
        for (int i = 0; i < this.getDataSize(); ++i) {
            this.centerPanel.add(this.getDataCell(i));
        }
        this.add((Component)new JLabel(this.name + " (" + ((Scale)this.scales.get(this.scaleIndex)).getUnit() + ")", 0), "North");
    }

    public String toString() {
        return super.toString() + " (1D)";
    }

    public boolean isIsAxis() {
        return this.isAxis;
    }

    public void setIsAxis(boolean bl) {
        this.isAxis = bl;
    }

    public void clearSelection() {
        super.clearSelection();
    }

    public void clearSelection(boolean bl) {
        if (bl) {
            super.clearSelection();
        } else {
            this.clearSelection();
        }
    }

    public void colorize() {
        super.colorize();
    }

    public void cursorUp() {
        if (this.type == 5) {
            if (this.highlightY > 0 && this.data[this.highlightY].isSelected().booleanValue()) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 4 || this.type == 1) {
            // empty if block
        }
    }

    public void cursorDown() {
        if (this.type == 5) {
            if (this.axisParent.getType() == 3) {
                if (this.highlightY < this.getDataSize() - 1 && this.data[this.highlightY].isSelected().booleanValue()) {
                    this.selectCellAt(this.highlightY + 1);
                }
            } else if (this.axisParent.getType() == 2 && this.data[this.highlightY].isSelected().booleanValue()) {
                this.axisParent.selectCellAt(this.highlightY);
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            ((Table3D)this.axisParent).selectCellAt(this.highlightY, this);
        } else if (this.type == 1) {
            // empty if block
        }
    }

    public void cursorLeft() {
        if (this.type == 5) {
            if (this.axisParent.getType() == 2 && this.data[this.highlightY].isSelected().booleanValue()) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.highlightY > 0) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 1 && this.data[this.highlightY].isSelected().booleanValue() && this.highlightY > 0) {
            this.selectCellAt(this.highlightY - 1);
        }
    }

    public void cursorRight() {
        if (this.type == 5 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.axisParent.getType() == 3) {
                ((Table3D)this.axisParent).selectCellAt(this.highlightY, this);
            } else if (this.axisParent.getType() == 2) {
                this.selectCellAt(this.highlightY + 1);
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.highlightY < this.getDataSize() - 1) {
                this.selectCellAt(this.highlightY + 1);
            }
        } else if (this.type == 1 && this.data[this.highlightY].isSelected().booleanValue() && this.highlightY < this.getDataSize() - 1) {
            this.selectCellAt(this.highlightY + 1);
        }
    }

    public void startHighlight(int n, int n2) {
        if (this.isAxis) {
            this.axisParent.clearSelection();
        }
        super.startHighlight(n, n2);
    }

    public StringBuffer getTableAsString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.getDataSize(); ++i) {
            stringBuffer.append(this.data[i].getText());
            if (i >= this.getDataSize() - 1) continue;
            stringBuffer.append("\t");
        }
        return stringBuffer;
    }

    public String getCellAsString(int n) {
        return this.data[n].getText();
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public void setLiveValue(String string) {
        this.liveValue = string;
        Table table = this.getAxisParent();
        if (table != null) {
            table.highlightLiveData();
        }
    }

    public boolean isLiveDataSupported() {
        return false;
    }
}

