/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.logger.ecu.ui.swing.vertical.VerticalLabelUI;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.swing.TableFrame;
import com.romraider.util.AxisRange;
import com.romraider.util.ColorScaler;
import com.romraider.util.ParamChecker;
import com.romraider.util.TableAxisUtil;
import com.romraider.xml.RomAttributeParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Table3D
extends Table {
    private static final long serialVersionUID = 3103448753263606599L;
    private Table1D xAxis = new Table1D(new Settings());
    private Table1D yAxis = new Table1D(new Settings());
    private DataCell[][] data = new DataCell[1][1];
    private boolean swapXY = false;
    private boolean flipX = false;
    private boolean flipY = false;

    public Table3D(Settings settings) {
        super(settings);
        this.verticalOverhead += 39;
        this.horizontalOverhead += 10;
    }

    public Table1D getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(Table1D table1D) {
        this.xAxis = table1D;
    }

    public Table1D getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(Table1D table1D) {
        this.yAxis = table1D;
    }

    public boolean getSwapXY() {
        return this.swapXY;
    }

    public void setSwapXY(boolean bl) {
        this.swapXY = bl;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean bl) {
        this.flipX = bl;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean bl) {
        this.flipY = bl;
    }

    public void setSizeX(int n) {
        this.data = new DataCell[n][this.data[0].length];
        this.centerLayout.setColumns(n + 1);
    }

    public int getSizeX() {
        return this.data.length;
    }

    public void setSizeY(int n) {
        this.data = new DataCell[this.data.length][n];
        this.centerLayout.setRows(n + 1);
    }

    public int getSizeY() {
        return this.data[0].length;
    }

    public void populateTable(byte[] byArray) throws NullPointerException, ArrayIndexOutOfBoundsException {
        int n;
        int n2;
        int n3;
        this.centerPanel.add(new JLabel());
        if (!this.beforeRam) {
            this.ramOffset = this.container.getRomID().getRamOffset();
        }
        boolean bl = this.locked;
        this.locked = false;
        try {
            this.xAxis.setRom(this.container);
            this.xAxis.populateTable(byArray);
            this.yAxis.setRom(this.container);
            this.yAxis.populateTable(byArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (n3 = 0; n3 < this.xAxis.getDataSize(); ++n3) {
            this.centerPanel.add(this.xAxis.getDataCell(n3));
        }
        n3 = 0;
        int n4 = this.swapXY ? this.xAxis.getDataSize() : this.yAxis.getDataSize();
        int n5 = this.swapXY ? this.yAxis.getDataSize() : this.xAxis.getDataSize();
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                int n6;
                int n7 = this.flipY ? n5 - n - 1 : n;
                int n8 = n6 = this.flipX ? n4 - n2 - 1 : n2;
                if (this.swapXY) {
                    int n9 = n7;
                    n7 = n6;
                    n6 = n9;
                }
                this.data[n7][n6] = new DataCell((Scale)this.scales.get(this.scaleIndex), this.settings.getCellSize());
                this.data[n7][n6].setTable(this);
                if (this.storageType == 99) {
                    byte[] byArray2 = new byte[]{byArray[this.storageAddress + n3 * 4 - this.ramOffset], byArray[this.storageAddress + n3 * 4 - this.ramOffset + 1], byArray[this.storageAddress + n3 * 4 - this.ramOffset + 2], byArray[this.storageAddress + n3 * 4 - this.ramOffset + 3]};
                    this.data[n7][n6].setBinValue(RomAttributeParser.byteToFloat(byArray2, this.endian));
                } else {
                    this.data[n7][n6].setBinValue(RomAttributeParser.parseByteValue(byArray, this.endian, this.storageAddress + n3 * this.storageType - this.ramOffset, this.storageType));
                }
                if (bl) {
                    this.data[n7][n6].setForeground(Color.GRAY);
                }
                this.data[n7][n6].setXCoord(n7);
                this.data[n7][n6].setYCoord(n6);
                this.data[n7][n6].setOriginalValue(this.data[n7][n6].getBinValue());
                ++n3;
            }
        }
        for (n2 = 0; n2 < this.yAxis.getDataSize(); ++n2) {
            this.centerPanel.add(this.yAxis.getDataCell(n2));
            for (n = 0; n < this.xAxis.getDataSize(); ++n) {
                this.centerPanel.add(this.data[n][n2]);
            }
        }
        this.locked = bl;
        GridLayout gridLayout = new GridLayout(2, 1);
        JPanel jPanel = new JPanel(gridLayout);
        this.add((Component)jPanel, "North");
        jPanel.add((Component)new JLabel(this.name, 0), "North");
        jPanel.add((Component)new JLabel(this.xAxis.getName() + " (" + this.xAxis.getScale().getUnit() + ")", 0), "North");
        JLabel jLabel = new JLabel(this.yAxis.getName() + " (" + this.yAxis.getScale().getUnit() + ")");
        jLabel.setUI(new VerticalLabelUI(false));
        this.add((Component)jLabel, "West");
        this.add((Component)new JLabel(this.getScale().getUnit(), 0), "South");
    }

    public void colorize() {
        double d;
        double d2;
        if (this.compareType == 0) {
            if (!this.isStatic && !this.isAxis) {
                DataCell[] dataCellArray;
                int n;
                int n2;
                DataCell[][] dataCellArray2;
                d2 = Double.MIN_VALUE;
                double d3 = Double.MAX_VALUE;
                if (this.getScale().getMax() != 0.0 || this.getScale().getMin() != 0.0) {
                    d2 = this.getScale().getMax();
                    d3 = this.getScale().getMin();
                } else {
                    dataCellArray2 = this.data;
                    n2 = dataCellArray2.length;
                    for (n = 0; n < n2; ++n) {
                        for (DataCell dataCell : dataCellArray = dataCellArray2[n]) {
                            d = dataCell.getValue();
                            if (d > d2) {
                                d2 = d;
                            }
                            if (!(d < d3)) continue;
                            d3 = d;
                        }
                    }
                }
                dataCellArray2 = this.data;
                n2 = dataCellArray2.length;
                for (n = 0; n < n2; ++n) {
                    for (DataCell dataCell : dataCellArray = dataCellArray2[n]) {
                        d = dataCell.getValue();
                        if (d > d2 || d < d3) {
                            dataCell.setColor(this.settings.getWarningColor());
                            continue;
                        }
                        double d4 = d2 - d3 == 0.0 ? 0.5 : (d - d3) / (d2 - d3);
                        dataCell.setColor(ColorScaler.getScaledColor(d4, this.settings));
                    }
                }
            }
        } else {
            if (!this.isStatic) {
                DataCell[] dataCellArray;
                int n;
                d2 = Double.MIN_VALUE;
                DataCell[][] dataCellArray3 = this.data;
                int n3 = dataCellArray3.length;
                for (n = 0; n < n3; ++n) {
                    for (DataCell dataCell : dataCellArray = dataCellArray3[n]) {
                        if (!(Math.abs(dataCell.getBinValue() - dataCell.getOriginalValue()) > d2)) continue;
                        d2 = Math.abs(dataCell.getBinValue() - dataCell.getOriginalValue());
                    }
                }
                dataCellArray3 = this.data;
                n3 = dataCellArray3.length;
                for (n = 0; n < n3; ++n) {
                    for (DataCell dataCell : dataCellArray = dataCellArray3[n]) {
                        double d5 = Math.abs(dataCell.getBinValue() - dataCell.getOriginalValue());
                        d = d2 == 0.0 ? 0.0 : d5 / d2;
                        if (d == 0.0) {
                            dataCell.setColor(UNCHANGED_VALUE_COLOR);
                        } else {
                            dataCell.setColor(ColorScaler.getScaledColor(d, this.settings));
                        }
                        if (dataCell.getBinValue() > dataCell.getOriginalValue()) {
                            dataCell.setBorder(BorderFactory.createLineBorder(this.settings.getIncreaseBorder()));
                            continue;
                        }
                        if (dataCell.getBinValue() < dataCell.getOriginalValue()) {
                            dataCell.setBorder(BorderFactory.createLineBorder(this.settings.getDecreaseBorder()));
                            continue;
                        }
                        dataCell.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                    }
                }
            }
            this.xAxis.colorize();
            this.yAxis.colorize();
        }
        if (!this.isStatic) {
            DataCell[][] dataCellArray = this.data;
            int n = dataCellArray.length;
            for (int i = 0; i < n; ++i) {
                DataCell[] dataCellArray4;
                for (DataCell dataCell : dataCellArray4 = dataCellArray[i]) {
                    if (dataCell.getBinValue() > dataCell.getOriginalValue()) {
                        dataCell.setBorder(BorderFactory.createLineBorder(this.settings.getIncreaseBorder()));
                        continue;
                    }
                    if (dataCell.getBinValue() < dataCell.getOriginalValue()) {
                        dataCell.setBorder(BorderFactory.createLineBorder(this.settings.getDecreaseBorder()));
                        continue;
                    }
                    dataCell.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                }
            }
        }
    }

    public void compare(int n) {
        this.compareType = n;
        DataCell[][] dataCellArray = this.data;
        int n2 = dataCellArray.length;
        for (int i = 0; i < n2; ++i) {
            DataCell[] dataCellArray2;
            for (DataCell dataCell : dataCellArray2 = dataCellArray[i]) {
                if (n == 1) {
                    dataCell.setCompareValue(dataCell.getOriginalValue());
                }
                dataCell.setCompareType(n);
                dataCell.setCompareDisplay(this.compareDisplay);
                dataCell.updateDisplayValue();
            }
        }
        this.colorize();
    }

    public void setFrame(TableFrame tableFrame) {
        this.frame = tableFrame;
        this.xAxis.setFrame(tableFrame);
        this.yAxis.setFrame(tableFrame);
        tableFrame.pack();
    }

    public Dimension getFrameSize() {
        int n;
        int n2 = this.verticalOverhead + this.cellHeight * this.data[0].length;
        int n3 = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        }
        int n4 = n = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (n3 < n) {
            n3 = n;
        }
        return new Dimension(n3, n2);
    }

    public String toString() {
        return super.toString() + " (3D)";
    }

    public void increment(double d) {
        if (!this.isStatic && !this.locked) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                for (int j = 0; j < this.getSizeY(); ++j) {
                    if (!this.data[i][j].isSelected().booleanValue()) continue;
                    this.data[i][j].increment(d);
                }
            }
        }
        this.xAxis.increment(d);
        this.yAxis.increment(d);
        this.colorize();
    }

    public void multiply(double d) {
        if (!this.isStatic && !this.locked) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                for (int j = 0; j < this.getSizeY(); ++j) {
                    if (!this.data[i][j].isSelected().booleanValue()) continue;
                    this.data[i][j].multiply(d);
                }
            }
        }
        this.xAxis.multiply(d);
        this.yAxis.multiply(d);
        this.colorize();
    }

    public void clearSelection() {
        this.xAxis.clearSelection(true);
        this.yAxis.clearSelection(true);
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                this.data[i][j].setSelected(false);
            }
        }
    }

    public void highlight(int n, int n2) {
        if (this.highlight) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                for (int j = 0; j < this.getSizeY(); ++j) {
                    if ((j >= this.highlightY && j <= n2 || j <= this.highlightY && j >= n2) && (i >= this.highlightX && i <= n || i <= this.highlightX && i >= n)) {
                        this.data[i][j].setHighlighted(true);
                        continue;
                    }
                    this.data[i][j].setHighlighted(false);
                }
            }
        }
    }

    public void stopHighlight() {
        this.highlight = false;
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                if (!this.data[i][j].isHighlighted()) continue;
                this.data[i][j].setSelected(true);
                this.data[i][j].setHighlighted(false);
            }
        }
    }

    public void setRevertPoint() {
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                this.data[i][j].setOriginalValue(this.data[i][j].getBinValue());
            }
        }
        this.yAxis.setRevertPoint();
        this.xAxis.setRevertPoint();
        this.colorize();
    }

    public void undoAll() {
        this.clearLiveDataTrace();
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                this.data[i][j].setBinValue(this.data[i][j].getOriginalValue());
            }
        }
        this.yAxis.undoAll();
        this.xAxis.undoAll();
        this.colorize();
    }

    public void undoSelected() {
        this.clearLiveDataTrace();
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                if (!this.data[i][j].isSelected().booleanValue()) continue;
                this.data[i][j].setBinValue(this.data[i][j].getOriginalValue());
            }
        }
        this.yAxis.undoSelected();
        this.xAxis.undoSelected();
        this.colorize();
    }

    public byte[] saveFile(byte[] byArray) {
        if (!this.isStatic && this.userLevel <= this.settings.getUserLevel() && (this.userLevel < 5 || this.settings.isSaveDebugTables())) {
            byArray = this.xAxis.saveFile(byArray);
            byArray = this.yAxis.saveFile(byArray);
            int n = 0;
            int n2 = this.swapXY ? this.xAxis.getDataSize() : this.yAxis.getDataSize();
            int n3 = this.swapXY ? this.yAxis.getDataSize() : this.xAxis.getDataSize();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n4;
                    byte[] byArray2;
                    int n5;
                    int n6 = this.flipY ? n3 - j - 1 : j;
                    int n7 = n5 = this.flipX ? n2 - i - 1 : i;
                    if (this.swapXY) {
                        int n8 = n6;
                        n6 = n5;
                        n5 = n8;
                    }
                    if (this.storageType != 99) {
                        byArray2 = RomAttributeParser.parseIntegerValue((int)this.data[n6][n5].getBinValue(), this.endian, this.storageType);
                        for (n4 = 0; n4 < this.storageType; ++n4) {
                            byArray[n * this.storageType + n4 + this.storageAddress - this.ramOffset] = byArray2[n4];
                        }
                    } else {
                        byArray2 = RomAttributeParser.floatToByte((float)this.data[n6][n5].getBinValue(), this.endian);
                        for (n4 = 0; n4 < 4; ++n4) {
                            byArray[n * 4 + n4 + this.storageAddress - this.ramOffset] = byArray2[n4];
                        }
                    }
                    ++n;
                }
            }
        }
        return byArray;
    }

    public void setRealValue(String string) {
        if (!this.isStatic && !this.locked) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                for (int j = 0; j < this.getSizeY(); ++j) {
                    if (!this.data[i][j].isSelected().booleanValue()) continue;
                    this.data[i][j].setRealValue(string);
                }
            }
        }
        this.xAxis.setRealValue(string);
        this.yAxis.setRealValue(string);
        this.colorize();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.xAxis.addKeyListener(keyListener);
        this.yAxis.addKeyListener(keyListener);
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                this.data[i][j].addKeyListener(keyListener);
            }
        }
    }

    public void selectCellAt(int n, Table1D table1D) {
        if (table1D.getType() == 5) {
            this.selectCellAt(0, n);
        } else {
            this.selectCellAt(n, 0);
        }
    }

    public void deSelectCellAt(int n, int n2) {
        this.clearSelection();
        this.data[n][n2].setSelected(false);
        this.highlightX = n;
        this.highlightY = n2;
    }

    public void selectCellAt(int n, int n2) {
        this.clearSelection();
        this.data[n][n2].setSelected(true);
        this.highlightX = n;
        this.highlightY = n2;
    }

    public void selectCellAtWithoutClear(int n, int n2) {
        this.data[n][n2].setSelected(true);
        this.highlightX = n;
        this.highlightY = n2;
    }

    public void cursorUp() {
        if (this.highlightY > 0 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX, this.highlightY - 1);
        } else if (!this.xAxis.isStatic() && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.xAxis.selectCellAt(this.highlightX);
        } else {
            this.xAxis.cursorUp();
            this.yAxis.cursorUp();
        }
    }

    public void cursorDown() {
        if (this.highlightY < this.getSizeY() - 1 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX, this.highlightY + 1);
        } else {
            this.xAxis.cursorDown();
            this.yAxis.cursorDown();
        }
    }

    public void cursorLeft() {
        if (this.highlightX > 0 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX - 1, this.highlightY);
        } else if (!this.yAxis.isStatic() && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.yAxis.selectCellAt(this.highlightY);
        } else {
            this.xAxis.cursorLeft();
            this.yAxis.cursorLeft();
        }
    }

    public void cursorRight() {
        if (this.highlightX < this.getSizeX() - 1 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX + 1, this.highlightY);
        } else {
            this.xAxis.cursorRight();
            this.yAxis.cursorRight();
        }
    }

    public void startHighlight(int n, int n2) {
        this.xAxis.clearSelection();
        this.yAxis.clearSelection();
        super.startHighlight(n, n2);
    }

    public void copySelection() {
        boolean bl = false;
        int[] nArray = new int[4];
        nArray[0] = this.getSizeX();
        nArray[1] = this.getSizeY();
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                if (!this.data[i][j].isSelected().booleanValue()) continue;
                if (i < nArray[0]) {
                    nArray[0] = i;
                    bl = true;
                }
                if (i > nArray[2]) {
                    nArray[2] = i;
                    bl = true;
                }
                if (j < nArray[1]) {
                    nArray[1] = j;
                    bl = true;
                }
                if (j <= nArray[3]) continue;
                nArray[3] = j;
                bl = true;
            }
        }
        if (bl) {
            String string = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer("[Selection3D]" + string);
            for (int i = nArray[1]; i <= nArray[3]; ++i) {
                for (int j = nArray[0]; j <= nArray[2]; ++j) {
                    if (this.data[j][i].isSelected().booleanValue()) {
                        stringBuffer.append(this.data[j][i].getText());
                    } else {
                        stringBuffer.append("x");
                    }
                    if (j >= nArray[2]) continue;
                    stringBuffer.append("\t");
                }
                if (i < nArray[3]) {
                    stringBuffer.append(string);
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(stringBuffer)), null);
            }
        } else {
            this.xAxis.copySelection();
            this.yAxis.copySelection();
        }
    }

    public void copyTable() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[Table3D]" + string);
        stringBuffer.append(this.xAxis.getTableAsString()).append(string);
        for (int i = 0; i < this.getSizeY(); ++i) {
            stringBuffer.append(this.yAxis.getCellAsString(i)).append("\t");
            for (int j = 0; j < this.getSizeX(); ++j) {
                stringBuffer.append(this.data[j][i].getText());
                if (j >= this.getSizeX() - 1) continue;
                stringBuffer.append("\t");
            }
            if (i >= this.getSizeY() - 1) continue;
            stringBuffer.append(string);
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(stringBuffer)), null);
    }

    public void paste() {
        StringTokenizer stringTokenizer = new StringTokenizer("");
        String string = "";
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = stringTokenizer.nextToken();
        if ("[Table3D]".equalsIgnoreCase(string2)) {
            String string3 = System.getProperty("line.separator");
            String string4 = "[Table1D]" + string3 + stringTokenizer.nextToken(string3);
            StringBuffer stringBuffer = new StringBuffer("[Table1D]" + string3 + stringTokenizer.nextToken("\t"));
            StringBuffer stringBuffer2 = new StringBuffer("[Table3D]" + string3 + stringTokenizer.nextToken("\t") + stringTokenizer.nextToken(string3));
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("\t").append(stringTokenizer.nextToken("\t"));
                stringBuffer2.append(string3).append(stringTokenizer.nextToken("\t")).append(stringTokenizer.nextToken(string3));
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string4), null);
            this.xAxis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(stringBuffer)), null);
            this.yAxis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(stringBuffer2)), null);
            this.pasteValues();
            this.colorize();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        } else if ("[Selection3D]".equalsIgnoreCase(string2)) {
            this.pasteValues();
            this.colorize();
        } else if ("[Selection1D]".equalsIgnoreCase(string2)) {
            this.xAxis.paste();
            this.yAxis.paste();
        }
    }

    public void pasteCompare() {
        StringTokenizer stringTokenizer = new StringTokenizer("");
        String string = "";
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = stringTokenizer.nextToken();
        if ("[Table3D]".equalsIgnoreCase(string2)) {
            String string3 = System.getProperty("line.separator");
            String string4 = "[Table1D]" + string3 + stringTokenizer.nextToken(string3);
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(string3));
                stringBuffer.append(stringTokenizer2.nextToken("\t")).append("\t");
                while (stringTokenizer2.hasMoreTokens()) {
                    stringBuffer2.append(stringTokenizer2.nextToken()).append("\t");
                }
                stringBuffer2.append(string3);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string4), null);
            this.xAxis.pasteCompare();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuffer.toString()), null);
            this.yAxis.pasteCompare();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuffer2.toString()), null);
            this.pasteCompareValues();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
        this.colorize();
    }

    public void pasteCompareValues() {
        StringTokenizer stringTokenizer = new StringTokenizer("");
        try {
            String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this.getSizeY(); ++i) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            for (int j = 0; j < this.getSizeX(); ++j) {
                String string = stringTokenizer.nextToken();
                this.data[j][i].setCompareRealValue(string);
            }
        }
    }

    public void pasteValues() {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer("");
        String string2 = System.getProperty("line.separator");
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        if ("[Selection3D]".equalsIgnoreCase(string)) {
            n = this.highlightX;
            n2 = this.highlightY;
        }
        for (int i = n2; i < this.getSizeY(); ++i) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(string2));
            for (int j = n; j < this.getSizeX(); ++j) {
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string3 = stringTokenizer2.nextToken();
                try {
                    if (this.data[j][i].getText().equalsIgnoreCase(string3)) continue;
                    this.data[j][i].setRealValue(string3);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public void applyColorSettings(Settings settings) {
        this.settings = settings;
        for (int i = 0; i < this.getSizeY(); ++i) {
            for (int j = 0; j < this.getSizeX(); ++j) {
                this.setMaxColor(settings.getMaxColor());
                this.setMinColor(settings.getMinColor());
                this.data[j][i].setHighlightColor(settings.getHighlightColor());
                this.data[j][i].setIncreaseBorder(settings.getIncreaseBorder());
                this.data[j][i].setDecreaseBorder(settings.getDecreaseBorder());
                this.data[j][i].setFont(settings.getTableFont());
                this.data[j][i].repaint();
            }
        }
        this.setAxisColor(settings.getAxisColor());
        this.xAxis.applyColorSettings(settings);
        this.yAxis.applyColorSettings(settings);
        this.cellHeight = (int)settings.getCellSize().getHeight();
        this.cellWidth = (int)settings.getCellSize().getWidth();
        this.validateScaling();
        this.resize();
        this.colorize();
    }

    public void setAxisColor(Color color) {
        this.xAxis.setAxisColor(color);
        this.yAxis.setAxisColor(color);
    }

    public void validateScaling() {
        super.validateScaling();
        this.xAxis.validateScaling();
        this.yAxis.validateScaling();
    }

    public void refreshValues() {
        if (!this.isStatic && !this.isAxis) {
            DataCell[][] dataCellArray = this.data;
            int n = dataCellArray.length;
            for (int i = 0; i < n; ++i) {
                DataCell[] dataCellArray2;
                for (DataCell dataCell : dataCellArray2 = dataCellArray[i]) {
                    dataCell.refreshValue();
                }
            }
        }
    }

    public boolean isLiveDataSupported() {
        return !ParamChecker.isNullOrEmpty(this.xAxis.getLogParam()) && !ParamChecker.isNullOrEmpty(this.yAxis.getLogParam());
    }

    protected void highlightLiveData() {
        if (this.overlayLog && this.frame.isVisible()) {
            AxisRange axisRange = TableAxisUtil.getLiveDataRangeForAxis(this.xAxis);
            AxisRange axisRange2 = TableAxisUtil.getLiveDataRangeForAxis(this.yAxis);
            this.clearSelection();
            boolean bl = true;
            for (int i = axisRange.getStartIndex(); i <= axisRange.getEndIndex(); ++i) {
                for (int j = axisRange2.getStartIndex(); j <= axisRange2.getEndIndex(); ++j) {
                    if (bl) {
                        this.startHighlight(i, j);
                        bl = false;
                    } else {
                        this.highlight(i, j);
                    }
                    DataCell dataCell = this.data[i][j];
                    dataCell.setLiveDataTrace(true);
                    dataCell.setDisplayValue(dataCell.getRealValue() + (ParamChecker.isNullOrEmpty(this.liveValue) ? "" : ':' + this.liveValue));
                }
            }
            this.stopHighlight();
            this.frame.getToolBar().setLiveDataValue(this.liveValue);
        }
    }

    public void clearLiveDataTrace() {
        for (int i = 0; i < this.getSizeX(); ++i) {
            for (int j = 0; j < this.getSizeY(); ++j) {
                this.data[i][j].setLiveDataTrace(false);
                this.data[i][j].updateDisplayValue();
            }
        }
    }

    public void setScaleIndex(int n) {
        super.setScaleIndex(n);
        this.xAxis.setScaleByName(this.getScale().getName());
        this.yAxis.setScaleByName(this.getScale().getName());
    }

    public DataCell[][] get3dData() {
        return this.data;
    }

    public double getMin() {
        if (this.getScale().getMin() == 0.0 && this.getScale().getMax() == 0.0) {
            double d = Double.MAX_VALUE;
            DataCell[][] dataCellArray = this.data;
            int n = dataCellArray.length;
            for (int i = 0; i < n; ++i) {
                DataCell[] dataCellArray2;
                for (DataCell dataCell : dataCellArray2 = dataCellArray[i]) {
                    double d2 = dataCell.getValue();
                    if (!(d2 < d)) continue;
                    d = d2;
                }
            }
            return d;
        }
        return this.getScale().getMin();
    }

    public double getMax() {
        if (this.getScale().getMin() == 0.0 && this.getScale().getMax() == 0.0) {
            double d = Double.MIN_VALUE;
            DataCell[][] dataCellArray = this.data;
            int n = dataCellArray.length;
            for (int i = 0; i < n; ++i) {
                DataCell[] dataCellArray2;
                for (DataCell dataCell : dataCellArray2 = dataCellArray[i]) {
                    double d2 = dataCell.getValue();
                    if (!(d2 > d)) continue;
                    d = d2;
                }
            }
            return d;
        }
        return this.getScale().getMax();
    }
}

