/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.ecm.graphics.Graph3dFrameManager;
import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.data.GraphDataListener;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.maps.Table3D;
import com.romraider.swing.TableFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableToolBar
extends JToolBar
implements MouseListener,
ItemListener,
ActionListener,
GraphDataListener {
    private static final long serialVersionUID = 8697645329367637930L;
    private static final Logger LOGGER = Logger.getLogger(TableToolBar.class);
    private JButton incrementFine = new JButton(new ImageIcon("./graphics/icon-incfine.png"));
    private JButton decrementFine = new JButton(new ImageIcon("./graphics/icon-decfine.png"));
    private JButton incrementCoarse = new JButton(new ImageIcon("./graphics/icon-inccoarse.png"));
    private JButton decrementCoarse = new JButton(new ImageIcon("./graphics/icon-deccoarse.png"));
    private JButton enable3d = new JButton(new ImageIcon("./graphics/3d_render.png"));
    private JButton setValue = new JButton("Set");
    private JButton multiply = new JButton("Mul");
    private JFormattedTextField incrementByFine = new JFormattedTextField(new DecimalFormat("#.####"));
    private JFormattedTextField incrementByCoarse = new JFormattedTextField(new DecimalFormat("#.####"));
    private JFormattedTextField setValueText = new JFormattedTextField(new DecimalFormat("#.####"));
    private JComboBox scaleSelection = new JComboBox();
    private JCheckBox overlayLog = new JCheckBox("Overlay Log");
    private JButton clearOverlay = new JButton("Clear Overlay");
    private JLabel liveDataValue = new JLabel();
    private Table table;
    private TableFrame frame;

    public TableToolBar(Table table, TableFrame tableFrame) {
        Serializable serializable;
        this.table = table;
        this.setFrame(tableFrame);
        this.setFloatable(false);
        this.setLayout(new FlowLayout(0));
        JPanel jPanel = new JPanel();
        jPanel.add(this.incrementFine);
        jPanel.add(this.decrementFine);
        jPanel.add(this.incrementByFine);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.incrementCoarse);
        jPanel2.add(this.decrementCoarse);
        jPanel2.add(this.incrementByCoarse);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.setValueText);
        jPanel3.add(this.setValue);
        jPanel3.add(this.multiply);
        this.add(jPanel3);
        if (table.getType() == 3) {
            this.add(this.enable3d);
        }
        if (table.isLiveDataSupported()) {
            serializable = new JPanel();
            serializable.add(this.overlayLog);
            serializable.add(this.clearOverlay);
            this.add((Component)serializable);
        }
        this.incrementFine.setPreferredSize(new Dimension(33, 33));
        this.incrementFine.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.decrementFine.setPreferredSize(new Dimension(33, 33));
        this.decrementFine.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.incrementCoarse.setPreferredSize(new Dimension(33, 33));
        this.incrementCoarse.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.decrementCoarse.setPreferredSize(new Dimension(33, 33));
        this.decrementCoarse.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.enable3d.setPreferredSize(new Dimension(33, 33));
        this.enable3d.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.setValue.setPreferredSize(new Dimension(33, 23));
        this.setValue.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.multiply.setPreferredSize(new Dimension(33, 23));
        this.multiply.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.scaleSelection.setPreferredSize(new Dimension(80, 23));
        this.scaleSelection.setFont(new Font("Tahoma", 0, 11));
        this.clearOverlay.setPreferredSize(new Dimension(75, 23));
        this.clearOverlay.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 1));
        this.incrementByFine.setAlignmentX(0.5f);
        this.incrementByFine.setAlignmentY(0.5f);
        this.incrementByFine.setPreferredSize(new Dimension(45, 23));
        this.incrementByCoarse.setAlignmentX(0.5f);
        this.incrementByCoarse.setAlignmentY(0.5f);
        this.incrementByCoarse.setPreferredSize(new Dimension(45, 23));
        this.setValueText.setAlignmentX(0.5f);
        this.setValueText.setAlignmentY(0.5f);
        this.setValueText.setPreferredSize(new Dimension(45, 23));
        this.incrementFine.setToolTipText("Increment Value (Fine)");
        this.decrementFine.setToolTipText("Decrement Value (Fine)");
        this.incrementCoarse.setToolTipText("Increment Value (Coarse)");
        this.decrementCoarse.setToolTipText("Decrement Value (Coarse)");
        this.enable3d.setToolTipText("Render data in 3d");
        this.setValue.setToolTipText("Set Absolute Value");
        this.setValueText.setToolTipText("Set Absolute Value");
        this.incrementByFine.setToolTipText("Fine Value Adjustment");
        this.incrementByCoarse.setToolTipText("Coarse Value Adjustment");
        this.multiply.setToolTipText("Multiply Value");
        this.overlayLog.setToolTipText("Enable Overlay Of Real Time Log Data");
        this.clearOverlay.setToolTipText("Clear Log Data Overlay Highlights");
        this.incrementFine.addMouseListener(this);
        this.decrementFine.addMouseListener(this);
        this.incrementCoarse.addMouseListener(this);
        this.decrementCoarse.addMouseListener(this);
        this.enable3d.addMouseListener(this);
        this.setValue.addMouseListener(this);
        this.multiply.addMouseListener(this);
        this.scaleSelection.addItemListener(this);
        this.overlayLog.addItemListener(this);
        this.clearOverlay.addActionListener(this);
        try {
            this.incrementByFine.setValue(Math.abs(table.getScale().getFineIncrement()));
            this.incrementByCoarse.setValue(Math.abs(table.getScale().getCoarseIncrement()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new AbstractAction(){
            private static final long serialVersionUID = -6008026264821746092L;

            public void actionPerformed(ActionEvent actionEvent) {
                TableToolBar.this.getTable().requestFocus();
                TableToolBar.this.setValue();
            }
        };
        InputMap inputMap = this.getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, "enterAction");
        this.getActionMap().put(inputMap.get(keyStroke), (Action)((Object)serializable));
        this.incrementFine.getInputMap().put(keyStroke, "enterAction");
        this.decrementFine.getInputMap().put(keyStroke, "enterAction");
        this.incrementCoarse.getInputMap().put(keyStroke, "enterAction");
        this.decrementCoarse.getInputMap().put(keyStroke, "enterAction");
        this.incrementByFine.getInputMap().put(keyStroke, "enterAction");
        this.incrementByCoarse.getInputMap().put(keyStroke, "enterAction");
        this.setValueText.getInputMap().put(keyStroke, "enterAction");
        this.setValue.getInputMap().put(keyStroke, "enterAction");
        this.incrementFine.getInputMap().put(keyStroke, "enterAction");
        this.setScales(table.getScales());
    }

    public Table getTable() {
        return this.table;
    }

    public void setScales(Vector<Scale> vector) {
        this.scaleSelection.removeItemListener(this);
        for (int i = 0; i < vector.size(); ++i) {
            this.scaleSelection.addItem(vector.get(i).getName());
        }
        this.scaleSelection.addItemListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.incrementCoarse) {
            this.incrementCoarse();
        } else if (mouseEvent.getSource() == this.decrementCoarse) {
            this.decrementCoarse();
        } else if (mouseEvent.getSource() == this.enable3d) {
            this.enable3d();
        } else if (mouseEvent.getSource() == this.incrementFine) {
            this.incrementFine();
        } else if (mouseEvent.getSource() == this.decrementFine) {
            this.decrementFine();
        } else if (mouseEvent.getSource() == this.multiply) {
            this.multiply();
        } else if (mouseEvent.getSource() == this.setValue) {
            this.setValue();
        }
        this.table.colorize();
    }

    public void setValue() {
        this.table.setRealValue(this.setValueText.getText());
    }

    public void multiply() {
        this.table.multiply(Double.parseDouble(this.setValueText.getText()));
    }

    public void incrementFine() {
        this.table.increment(Double.parseDouble(String.valueOf(this.incrementByFine.getValue())));
    }

    public void decrementFine() {
        this.table.increment(0.0 - Double.parseDouble(String.valueOf(this.incrementByFine.getValue())));
    }

    public void incrementCoarse() {
        this.table.increment(Double.parseDouble(String.valueOf(this.incrementByCoarse.getValue())));
    }

    public void decrementCoarse() {
        this.table.increment(0.0 - Double.parseDouble(String.valueOf(this.incrementByCoarse.getValue())));
    }

    public void enable3d() {
        int n = 0;
        int n2 = 0;
        Vector<float[]> vector = new Vector<float[]>();
        if (this.table.getType() == 3) {
            Object object;
            Table3D table3D = (Table3D)this.table;
            DataCell[][] dataCellArray = table3D.get3dData();
            n2 = dataCellArray.length;
            DataCell[] dataCellArray2 = dataCellArray[0];
            n = dataCellArray2.length;
            for (int i = n - 1; i >= 0; --i) {
                object = new float[n2];
                for (int j = 0; j < n2; ++j) {
                    DataCell dataCell = dataCellArray[j][i];
                    object[j] = (float)dataCell.getValue();
                }
                vector.add((float[])object);
            }
            Table1D table1D = ((Table3D)this.table).getXAxis();
            object = ((Table3D)this.table).getYAxis();
            DataCell[] dataCellArray3 = table1D.getData();
            int n3 = dataCellArray3.length;
            double[] dArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray[i] = dataCellArray3[i].getValue();
            }
            dataCellArray3 = ((Table)object).getData();
            n3 = dataCellArray3.length;
            double[] dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                double d = dataCellArray3[i].getValue();
                BigDecimal bigDecimal = new BigDecimal(d).setScale(2, 4);
                dArray2[i] = bigDecimal.doubleValue();
            }
            String string = ((Table3D)this.table).getXAxis().getName();
            String string2 = ((Table3D)this.table).getYAxis().getName();
            String string3 = ((Table3D)this.table).getCategory();
            double d = this.table.getMax();
            double d2 = this.table.getMin();
            LOGGER.debug((Object)("Scale: " + d + "," + d2));
            Graph3dFrameManager.openGraph3dFrame(vector, (double)d2, (double)d, (double[])dArray, (double[])dArray2, (String)string, (String)string3, (String)string2, (String)this.table.getName());
            GraphData.addGraphDataListener((GraphDataListener)this);
        }
    }

    public void setCoarseValue(double d) {
        this.incrementByCoarse.setText(String.valueOf(d));
        try {
            this.incrementByCoarse.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setFineValue(double d) {
        this.incrementByFine.setText(String.valueOf(d));
        try {
            this.incrementByFine.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void focusSetValue(char c) {
        this.setValueText.requestFocus();
        this.setValueText.setText(String.valueOf(c));
    }

    public void setInputMap(InputMap inputMap) {
        this.incrementFine.setInputMap(0, inputMap);
        this.decrementFine.setInputMap(0, inputMap);
        this.incrementCoarse.setInputMap(0, inputMap);
        this.decrementCoarse.setInputMap(0, inputMap);
        this.setValue.setInputMap(0, inputMap);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public TableFrame getFrame() {
        return this.frame;
    }

    public void setFrame(TableFrame tableFrame) {
        this.frame = tableFrame;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.scaleSelection) {
            this.table.setScaleIndex(this.scaleSelection.getSelectedIndex());
        } else if (itemEvent.getSource() == this.overlayLog) {
            this.table.setOverlayLog(this.overlayLog.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clearOverlay) {
            this.table.clearLiveDataTrace();
        }
    }

    public void setLiveDataValue(String string) {
        this.liveDataValue.setText(string);
    }

    public void newGraphData(int n, int n2, float f) {
        Table3D table3D = (Table3D)this.table;
        table3D.selectCellAt(n, table3D.getSizeY() - n2 - 1);
        this.table.setRealValue(String.valueOf(f));
    }

    public void selectStateChange(int n, int n2, boolean bl) {
        if (bl) {
            Table3D table3D = (Table3D)this.table;
            table3D.selectCellAtWithoutClear(n, table3D.getSizeY() - n2 - 1);
        } else {
            Table3D table3D = (Table3D)this.table;
            table3D.deSelectCellAt(n, table3D.getSizeY() - n2 - 1);
        }
    }
}

