#!/bin/busybox sh
export PATH="/root/bin:${FKSH_HOM}/tools:${PATH}"
StopNickel.sh
export KOBO_passwd=''
authlog="${FKSH_LOG%.*}_auth.log"
[ -f "$authlog" ] || authlog=/dev/null

## close almost file descripters and set EVENT[01]FD
EVENT0FD=''
EVENT1FD=''
for fdp in /proc/$$/fd/* ; do
  [ -e $fdp -o -L $fdp ] || continue
  fd=${fdp##*/}
  [ $maxfd -lt $fd ] && maxfd=$fd
  case "$(readlink -f $fdp)" in
  /dev/input/event0) EVENT0FD=$fd ; continue ;;
  /dev/input/event1) EVENT1FD=$fd ; continue ;;
  esac
  case "$fd" in
  0|1|2 ) ;;
  *) eval "exec $fd<&- $fd>&-" ;;
  esac
done

if [ -n "$EVENT0FD" ] ; then
  dd bs=16 of=/dev/null <&$EVENT0FD 2>/dev/null &
  ev0pid=$!
else
  ev0pid=''
fi

export TMPAUTHD=$(mktemp -d A_XXXXXX)

evCode () {
  local l k t
  awk '{
    printf "\\0\\0\\0\\0\\0\\0\\0\\0" ;
    printf "\\%o\\%o", int($1%256), int($1/256);
    printf "\\%o\\%o", int($2%256), int($2/256);
    printf "\\%o\\%o", int($3%256), int($3/256);
    printf "\\0\\0\n"
  }' | while read -r l ; do printf "$l" ; done > $1
  case "$2" in
  [1-9] )
    k=$2; t=$TMPAUTHD/x4
    while [ $k -gt 0 ] ; do k=$((k-1)); cat $1 $1 > $t; cat $t $t > $1; done
    rm -f $t
  ;;
  esac
}

savedImg=$TMPAUTHD/savedImg.raw.gz

onEXIT () {
  dontNap.sh 120
  [ -f $savedImg ] && dispPics.sh $savedImg
  # i dont know why this flushes /dev/input/event1,
  # whats 0 1 1 ?, found by my experiment.
  flushEV1=$TMPAUTHD/flushEV1
  printf '0 1 1\n0 0 0\n' | evCode $flushEV1 4  # 512x16 bytes
  dd bs=16 if=$flushEV1 of=/dev/input/event1 2>/dev/null
  [ -n "$ev0pid" ] && kill $ev0pid
  sSW=$TMPAUTHD/sSW
  printf '1 116 0\n1 116 1\n1 116 0\n' | evCode $sSW
  [ -n "$rtc" ] && dd bs=16 if=$sSW of=/dev/input/event0 2>/dev/null
  rm -rf $TMPAUTHD
  ContNickel.sh
}
trap onEXIT EXIT

if [ -z "$1" ] ; then 
  # on boot
  rtc=''
else
  # on sleep
  dispPics.sh -i sleep.seq
  read rtc0 < /sys/class/rtc/rtc0/since_epoch
  echo mem > /sys/power/state
  # wakeup from sleep
  read rtc < /sys/class/rtc/rtc0/since_epoch
  rtc=$((rtc-rtc0))
fi

customauth=$FKSH_ONB/bin/auth
[ -x "$customauth" ] || exit 0

KOBO_passwd="$($customauth $rtc)" # 1st call, get the password
[ -z "$KOBO_passwd" ] && exit 0

date +%n%y-%m-%dT%T >> $authlog  ## null if nologging

[ -z "$1" ] && screenShot-raw.sh $savedImg silent
# chrt -f -p 99 $$
$customauth >> $authlog 2>/dev/null # 2nd call, authenticate
exit 0
