#!/bin/busybox sh
ln -s $$ $FKSH_HOM/excludeInit || exit 0
[ -f $FKSH_RAM/BOOT ] && exit 0
if busybox mount -t tmpfs none -o size=256k,mode=1733 $FKSH_RAM ; then
  echo "$1" > $FKSH_RAM/BOOT
  [ -f $FKSH_LOG ] && printf '\n --** BOOT **--\n\n' >> $FKSH_LOG
else
  rm -f $FKSH_HOM/excludeInit
  exit 0
fi
rm -f $FKSH_HOM/excludeInit
touch $FKSH_RAM/microSD_id
mkdir -m 700 $FKSH_RAM/private

( # go background
cd /

blkid0p=$FKSH_HOM/blkid.0p
# wait until /mnt/onboard is mounted
iwait=100000
[ -f $FKSH_HOM/.initwait ] && read iwait < $FKSH_HOM/.initwait
usleep $iwait
n=0
while : ; do
  [ -f /proc/mounts ] && grep -q '^/dev/mmcblk0p3 ' /proc/mounts && break
  usleep 1000 # 1msec
  n=$((n+1))
done
[ -f $FKSH_LOG ] && printf '#* init.sh starts wait=%d *#\n' $n >>$FKSH_LOG
if [ $n -eq 0 ] ; then
  echo $((iwait-32363))
else
  echo $((iwait+n*20000))
fi > $FKSH_HOM/.initwait

# swap
swappt="$(fdisk -l | awk '
  {gsub(/ [^0-9]* /," ");}
  $5=="82"{printf "%s", $1; exit 0;}' )"
if [ -b "$swappt" ] && ! grep -q "^${swappt} " /proc/swaps ; then
  grep -q -m 1 "^${swappt}:" $blkid0p || mkswap -L koboswap "$swappt"
  swapon "$swappt"
fi

# /home
homedev="$(sed -n '/LABEL="kobohome"/{s/:.*//;p;q;}' $blkid0p)"
if [ -b "$homedev" ] &&
      ! grep -q -E "(^${homedev} |^[^ ]* /home )" /proc/mounts ; then
  if [ ! -d /home ] ; then
    mkdir -m 000 /home
    chattr +i /home
  fi
  busybox mount $homedev -t ext4 -o noatime,nodiratime /home
fi

# pts
[ -d /dev/pts ] || mkdir -m 000 -p /dev/pts
grep '^devpts /dev/pts' /proc/mounts ||
  busybox mount -t devpts devpts /dev/pts

$FKSH_HOM/tools/config.sh &

# loop back device
ifconfig lo 127.0.0.1

# correct the stupid setting
busybox umount /var/log

# nickel saver
$FKSH_HOM/tools/nickelSaver.sh &

blkid | grep '^/dev/mmcblk0p' > $FKSH_HOM/blkid.0p

# clean screenShots .wait files
find $FKSH_ONB/images -name '*.wait' -exec rm -f '{}' \;

) &
exit 0

