#!/bin/busybox sh
#
# Copyright (C) 2013 fakesh. http://sourceforge.jp/users/fakesh/
# MIT/X Consortium License
#

vers=4

unset LD_LIBRARY_PATH LD_PRELOAD

me="$(readlink -f "$0")"
cd /
case "$mkBackupLOG" in
*.txt) ;;
*)
  export mkBackupLOG="/mnt/onboard/backup$(date +%y%m%d%H%M).log.txt"
  "$me" "$@" 2>&1 | tee "$mkBackupLOG"
  ## log cleaner
  sedcmd="$(printf 's/[^\b]{%d}\b{%d}//g;' 32 32 16 16 8 8 4 4 2 2 1 1)"
  sed -i -r "$sedcmd" "$mkBackupLOG" >/dev/null 2>&1
  exit 0
;;
esac

vol=mmcblk1

wrappingMD_sh="${me%/*}/wrapping-mount-dosfsck.sh" # ext4 KOBOeReader

imgsz=''
eval $(fbset | awk '$1=="geometry"{ printf "w=%d;h=%d;bpp=%d;", $2, $3, $6;}')
if [ "$bpp" = 16 ] ; then
  imgsz="${w}x${h}"
  bs=$((w*h*bpp/8)); cnt=1
  while [ $bs -ge 65536 ] ; do
    [ $((bs%1)) -eq 1 ] && break  # hardly breaks
    bs=$((bs/2)); cnt=$((cnt*2))
  done
  dda="bs=$bs count=$cnt"
fi

imgBase=''
dispImg () {
  local i
  [ -z "$imgBase" ] && return
  case "$1" in
  black) dd if=/dev/zero $dda ;;
  white) dd if=/dev/zero $dda | tr \\0 \\377 ;;
  resume)
    dispImg black
    dispImg white
    if [ -f last.raw ] ; then
      cat last.raw
    else
      dd if=/dev/zero $dda
    fi
  ;;
  *.gz) [ -f "$1" ] && zcat "$1" ;;
  *) i="$imgBase$1.raw.gz" ;
    if [ -f "$i" ] ; then
      zcat "$i"
    else
      dd if=/dev/zero $dda
    fi
  ;;
  esac 2>/dev/null | /usr/local/Kobo/pickel showpic 1
  return 0
}

wdir=$(mktemp -d /tmp/koboBackup_XXXXXX)
cd $wdir

onbImgDir="${FKSH_ONB:=/mnt/onboard/.fakesh}/images"
case "$me" in
*-oneShot.sh)
  myName=easyKoboBackup
  imgBase="${me%/*}/$imgsz"
  if [ -f "$imgBase".raw.gz -a -n "$imgsz" ] ; then
    killall update-animator.sh
    onbImgDirKBK="$onbImgDir/koboBackup"
    if [ -d "$onbImgDir" -a ! -d "$onbImgDirKBK" ] ; then
      mkdir "$onbImgDirKBK"
      cp -p "${imgBase%/*}"/*.raw.gz "$onbImgDirKBK"
    fi
  fi
;;
*)
  myName=koboBackup.sh
  imgBase="$onbImgDir/koboBackup/$imgsz"
  if [ -f "$imgBase".raw.gz -a -n "$imgsz" ] ; then
    dd if=/dev/fb0 of=last.raw $dda
  fi
;;
esac >/dev/null 2>&1
printf 'This is %s, Version %s\n\n' $myName $vers
dispImg black
dispImg white
dispImg ''

date '+---- %T ----'
printf \\n

sedfdisk='/^$/d;
/^Command/d;
1,/^Disk /{/^Disk/p;d};
/^Disk /d;
/cylinders$/d;
/^Units/{x;p;x;}'

echo 'Current INNER disk geometory:'
printf 'u\np\nu\np\nq\n' | fdisk /dev/mmcblk0 | sed "$sedfdisk"
printf \\n
echo 'Current INNER block device attributes:'
blkid | sort
printf \\n

dotKobo=/mnt/onboard/.kobo
verFile=$dotKobo/version
if [ -f $verFile ] ; then
  echo 'Current firmware version, hardware:'
  read fw < $verFile
  hw=${fw##*,}; fw="${fw#*,}"; fw="${fw#*,}"
  echo  "${fw%%,*}, $hw"
  printf \\n
fi

wnkCyc=$wdir/whinkerCyc
: > $wnkCyc
ledR=/sys/class/leds/pmic_ledsr/brightness
ledG=/sys/class/leds/pmic_ledsg/brightness
ledB=/sys/class/leds/pmic_ledsb/brightness
[ -f "$ledR" ] || ledR=/dev/null
[ -f "$ledG" ] || ledG=/dev/null
[ -f "$ledB" ] || ledB=/dev/null
{ # backgound job
  cd /
  while : ; do
    if [ ! -f $wnkCyc ] ; then
      echo 0 > "$ledR"
      echo 0 > "$ledG"
      echo 0 > "$ledB"
      exit 0
    fi
    wwait=250  # msec
    while read mcs r g b dum ; do
      # args check
      [ 0 -lt "$mcs" -a "$mcs" -le 2000 ] || continue
      [ 0 -le "$r" -a "$r" -le 255 ] || continue
      [ 0 -le "$g" -a "$g" -le 255 ] || continue
      [ 0 -le "$b" -a "$b" -le 255 ] || continue
      echo $r > "$ledR"
      echo $g > "$ledG"
      echo $b > "$ledB"
      usleep $((mcs*1000))
      wwait=""
    done < $wnkCyc
    [ -n "$wwait" ] && usleep $((wwait*1000))
  done < /dev/null > /dev/null 2>&1
} &

pipetrash=$wdir/pipe-trash
cntFile=/tmp/StopNickel_Stop_Count  # for fakesh package
magicMSG='_#the#end#of#messages#$$#_'
pipeCleanerPID=''
pipeCleaner () {
  : > $pipetrash
  while : ; do
    while read -r l ; do
      echo "$(date +%T) $l" >> $pipetrash
      [ "$magicMSG" = "$l" ] || continue
      [ -n "$1" ] && kill -CONT $1
      [ -f $cntFile ] && echo 0 > $cntFile
      printf '\n  -  -  -  dropped messages to nickel  -  -  -\n'
      cat $pipetrash
      rm -f $pipetrash
      printf \\n
      exit 0
    done < /tmp/nickel-hardware-status
  done &
  pipeCleanerPID=$!
  return 0
}

nickelCtrl () {
  local pid l n
  pid=$(pidof nickel)
  case "$1" in
  STOP)
    if [ -z "$pid" ] ; then
      pipeCleaner
      echo 'But nickel is already DEAD... OK, NO PROBLEM'
      return 1
    fi
    if awk '$1!="State:"{next;}
            $2=="T"{exit 0;}
            {exit 1;}' /proc/$pid/status ; then
      printf  '\n***ERROR nickel is alive and STOPed. WHY?\n'
      dispImg resume
      cd /; rm -rf $wdir
      exit 2
    fi
    [ -f $cntFile ] && echo 99999 > $cntFile
    kill -STOP $pid
    pipeCleaner $pid
    return 0
  ;;
  CONT)
    [ -n "$pid" ] && echo 'Sent signal CONT to nickel.'
    printf '\n%s\n' "$magicMSG" > /tmp/nickel-hardware-status
    waitTries=60
    while : ; do
      usleep 500000 # 0.5sec
      [ -f $pipetrash ] || break
      if [ $waitTries -le 0 ] ; then
        printf '\n!!! pipeCleaner alive\n'
        kill $pipeCleanerPID
        break
      fi
      waitTries=$((waitTries-1))
    done
    return
  ;;
  esac
}

# check /dev/mmcblk0p2 (recoveryfs) is not mounted
if grep -q '^/dev/mmcblk0p2' /proc/mounts ; then
  echo '***ERROR recoveryfs is mounted. Invoke umount /dev/mmcblk0p2'
  dispImg resume
  cd /; rm -rf $wdir
  exit 1
fi

paramfile=/mnt/onboard/koboBackup.param
paramfileLOG=${mkBackupLOG%.log*}.param
exitMsgAdded=''
# exitWithMsg msg exitStatus
exitWithMsg () {
  sync; sync; sync
  eval $(date '+tm=%s;t=%T')
  printf '%s\n\n---- %s ----\n' "$1" $t
  if [ -f ${paramfile}CUR ] ; then
    rm -rf $paramfileLOG
    mv ${paramfile}CUR $paramfileLOG  # no new i-node
  fi
  if [ "$2" -eq 0 ] ; then
    if [ $tm0 -gt 0 ] ; then
      tm=$((tm-tm0))
      printf 'It took %dmin%dsec to write.\n' $((tm/60)) $((tm%60))
    fi
    yel=0
  else
    yel=99
  fi
  printf \\n
  if [ -d ./src/etc/init.d ] ; then
    (
      cd ./src/etc
      tar cfz - init.d | busybox uuencode -m init.d.tgz
    )
    printf \\n
  fi
  for mtpt in */ ; do
    [ -d "$mtpt" ] && umount ${mtpt%/}
  done >/dev/null 2>&1
  printf '10 %d 99 0\n690 0 0 0\n' $yel > $wnkCyc
  if grep -q "$vol\$" /proc/partitions ; then
    dispImg eje
    printf 'Please eject microSD media'
    while : ; do
      printf .
      sleep 1
      grep -q "$vol\$" /proc/partitions || break
    done
    printf '\nEjected\n\n%s\n\n' "$(date '+---- %T ----')"
  fi
  printf '500 99 99 99\n400 0 0 0\n' > $wnkCyc
  dispImg ''
  echo 'Send signal CONT to udevd, etc...'
  for p in $(pidof hindenburg fickel udevd) ; do kill -CONT $p ; done
  echo 'Wait more 12 secs for cleaning pipe.'
  sleep 12 # udev is insistent
  dispImg resume
  nickelCtrl CONT
  date '+---- %T ----'
  printf '\nExit.\n'
  cd /; rm -rf $wdir
  exit $2
}

# wait inserting microSD
wSec=30
n=0
while : ; do
  if grep -q "$vol\$" /proc/partitions ; then
    if [ $n -eq 0 ] ; then
      echo "Dont insert microSD, FIRST! Eject microSD."
      dispImg resume
      cd /; rm -rf $wdir
      exit 3
    else
      printf 'Found'
      break
    fi
  elif [ $n -eq 0 ] ; then
    echo 'Send signal STOP to nickel, udevd, etc.'
    nickelCtrl STOP
    for p in $(pidof udevd fickel hindenburg) ; do kill -STOP $p ; done
    printf '30 99 0 0\n30 99 99 0\n30 0 99 0\n400 0 0 0\n' > $wnkCyc
    dispImg ins
    echo "Insert microSD in $wSec secs."
  elif [ $n -gt $wSec ] ; then
    printf ' Timeout\n\n'
    exitWithMsg '***ERROR Timeout.' 3
  fi
  sleep 1
  n=$((n+1))
  printf .
done
printf \\n
usleep 2500000 # for insert time lag 2.5sec
printf \\n
eval $(date '+tm0=%s;t=%T')
printf 'Start writing\n---- %s ----\n\n' $t
pzz="$(awk -v "d=$vol" '
  $4==d{printf "%d", int($3/512)}
  ' /proc/partitions)"
pz=$(( (pzz/2)*2 - 1 ))
pzz=$((pzz+1))

if [ -z "$pz" ] ; then
  exitWithMsg '+++ NO microSD media.' 0
fi

printf '20 99 0 0\n930 0 0 99\n' > $wnkCyc
dispImg ''
## default patitioning unit = 512KiB 32x32x512B
echo 'Current file system INNER disk space usages'
p1s=$(fdisk -lu /dev/mmcblk0 |
  awk '/^\//&&$1=="/dev\/mmcblk0p1"{print $2;}')
p1lim=$(( (p1s+32*32-1)/(32*32) + 1 ))
p1=$p1lim
# rootfs 50.0% 512.0=1024*0.50
eval "$(df / | awk -v p1=$p1 '/^\//{
  printf "p2=%d; echo \"rootfs:     %5d/%dMiB %s\"",
    p1+2*int($3/512.0), $3/1024, $2/1024, $5
  }')"
mkdir -m 000 src
mount /dev/mmcblk0p2 -t ext4 -o ro,noatime,nodiratime src
# recoveryfs +100MiB /512.0+200
eval "$(df ./src | awk -v p2=$p2 '/^\//{
  printf "p3=%d; echo \"recoveryfs: %5d/%dMiB %s\"",
    p2+2*int($3/1024.0)+200, $3/1024, $2/1024, $5
  }')"
printf \\n
p3type=c
p3size=$(( (pz-p3) / 2 ))
if [ $p3size -lt 128 ] ; then
  exitWithMsg '***ERROR too small microSD media.' 5
elif [ $p3size -lt 2000 ] ; then
  # 1GB or 2GB
  spclfld='spcl:auto'  # sectors per cluster for mkdosfs
elif [ $p3size -lt 4000 ] ; then
  # 4GB
  spclfld=spcl:16
elif [ $p3size -lt 8000 ] ; then
  # 8GB
  spclfld=spcl:32
else
  # > 8GB
  spclfld=spcl:64
fi
pt="$p1 $p2 $p3 $pz $spclfld"

## manual partitioning
ptTop=''; pszRoot=$(( (p2-p1)/2 )); pszRecov=$(( (p3-p2)/2 ))
pszSwap=''; pszHome=''; pszExtra=''
for pf in $dotKobo/koboBackupCustom*/[Kk][Bb].* $dotKobo/[Kk][Bb].* ; do
  [ -e "$pf" -o -L "$pf" ] || continue
  prm="$(echo "${pf##*[Kk][Bb].}" | tr A-Z a-z)"
  case "$prm" in
  top[2-9][0-9] | top[1-9][0-9][0-9] | top[1-9][0-9][0-9] |\
  top[1-9][0-9][0-9][0-9] | top[1-9][0-9][0-9][0-9][0-9] )
    ptTop=${prm#top}
  ;;
  root*[1-9]*)
    pszRoot=$(echo $prm | sed -r 's/^[^1-9]*([0-9]*).*/\1/')
  ;;
  recov*[1-9]*)
    pszRecov=$(echo $prm | sed -r 's/^[^1-9]*([0-9]*).*/\1/')
  ;;
  swap*[1-9]*)
    pszSwap=$(echo $prm | sed -r 's/^[^1-9]*([0-9]*).*/\1/')
  ;;
  home*[1-9]*)
    pszHome=$(echo $prm | sed -r 's/^[^1-9]*([0-9]*).*/\1/')
    [ -z "$pszSwap" ] && pszSwap=64 # default swap space size = 64MiB
  ;;
  extra*[1-9]*)
    pszExtra=$(echo $prm | sed -r 's/^[^1-9]*([0-9]*).*/\1/')
    [ -z "$pszExtra" ] && pszHome=256 # default home space size = 256MiB
    [ -z "$pszSwap" ] && pszSwap=64
  ;;
  spclauto | spcl16 | spcl32 | spcl64 | spclext4 )
    spclfld="spcl:${prm#spcl}"
  ;;
  *) continue ;;
  esac
  [ -z "$ptTop" ] && ptTop=$p1
  rm -rf "$pf"
done
rm -rf $dotKobo/koboBackupCustom*
if [ -n "$ptTop" ] ; then
  p=$pz
  pt="$p $spclfld"
  if [ -n "$pszExtra" ] ; then
    p=$((p-2*$pszExtra))
    pt="$p $pt"
  fi
  if [ -n "$pszHome" ] ; then
    p=$((p-2*$pszHome))
    pt="$p $pt"
  fi
  if [ -n "$pszSwap" ] ; then
    p=$((p-2*$pszSwap))
    pt="$p $pt"
  fi
  pt="$ptTop $((ptTop+2*pszRoot)) $((ptTop+2*pszRoot+2*pszRecov)) $pt"
  echo "$pt" > $paramfile
fi
rm -rf ${paramfile}CUR
if [ -f $paramfile ] ; then
  mv -f $paramfile $paramfile.dos
  tr -d '\r\0' < $paramfile.dos > $paramfile
  rm -f $paramfile.dos
  read paramIn < $paramfile
  case "$paramIn" in
  [1-9]*)
    pt="$paramIn"
    printf 'Found custom parameter file "%s":\n%s\n\n' \
      ${paramfile##*/} "$pt"
  ;;
  *) paramIn="" ;; # get default param and exit 0
  esac
  mv -f $paramfile ${paramfile}CUR
fi

echo 'Partitioning of OUTER disk will be:'
pp=''
n=0
for p in $pt ; do
  case "$p" in
  spcl:*) spcl=${p#spcl:}; continue ;;
  [!1-9]*) continue ;;
  esac
  if [ -z "$pp" ] ; then
    pp=$p
    pt_reform=$p
    [ $p -lt $p1lim ] && exitWithMsg "Must be $p1lim <= $p" 6
    p1=$p
    continue
  fi
  n=$((n+1))
  if [ $p -gt $pz ] ; then
    [ $p -gt $pzz ] && p=$pzz
    pz=$p
  fi
  [ $pp -lt $p ] || exitWithMsg "Must be $pp < $p for $lvl" 7
  case $n in
  1) lvl="rootfs" ;;
  2) lvl="recoveryfs" ;;
  3) lvl="KOBOeReader" ;;
  4) n=5; lvl="koboswap" ;;
  6) lvl="kobohome" ;;
  7) lvl="koboextra" ;;
  *) lvl="" ;;
  esac
  echo $n $pp $p | awk -v "lvl=$lvl" '
    {printf "%d: %7.1fMiB %s\n", $1, ($3 - $2)/2.0, lvl}'
  pp=$p
  pt_reform="$pt_reform $p"
done
mtoptp3=''
ln -s ./src/bin/busybox mkfs.vfat
case "$spcl" in
4|8|16|32|64|128)
  mkdosfs=./src/bin/mkdosfs
  if [ -x $mkdosfs -a ! -L $mkdosfs ] ; then
    ln -s $mkdosfs mkdosfs
    echo "KOBOeReader: $spcl sectors/cluster"
    pt_reform="$pt_reform spcl:$spcl"
  else
    echo "!!! NO /bin/mkdosfs on recoveryfs. Use mkfs.vfat"
    echo "KOBOeReader: auto sectors/cluster"
    spcl=''
    pt_reform="$pt_reform spcl:auto"
  fi
;;
0 | ext4)
  echo 'KOBOeReader: ext4 # Best choice !!'
  spcl=0
  p3type=83
  mtoptp3='-t ext4 -o norelatime,noatime,nodiratime'
  pt_reform="$pt_reform spcl:ext4"
;;
*)
  echo "KOBOeReader: auto sectors/cluster"
  spcl=''
  pt_reform="$pt_reform spcl:auto"
;;
esac
pt="$pt_reform"
if [ $n -lt 3 ] ; then
  exitWithMsg '***ERROR too few partitions.' 12
fi
ptn=$n
printf '\nOK '
if [ $ptn -le 3 ] ; then
  printf '%d partitions will be prepared.\n' $ptn
else
  printf '%d+1 partitions will be prepared.\n' $((ptn-1))
fi
if [ -f ${paramfile}CUR ] ; then
  if [ -z "$paramIn" ] ; then
    mv -f ${paramfile}CUR $paramfile
    echo "$pt" > $paramfile
    cat <<- EOPTNMSGdr
	You can customize the partitioning by editing
	the file "${paramfile##*/}".
	contents: $pt
	EOPTNMSGdr
  else
    rm -rf $paramfileLOG
    mv ${paramfile}CUR $paramfileLOG  # no new i-node
    echo "$pt" > $paramfileLOG
    cat <<- EOPTNMSGre
	You can recustomize the partitioning by editing
	the file "${paramfileLOG##*/}" and rename it to "${paramfile##*/}".
	contents: $pt
	EOPTNMSGre
  fi
else
  cat <<- EOPTNMSG
	You can customize the partitioning by
	PROMPT# echo "$pt" >$paramfile
	and edit the file "${paramfile##*/}"
	EOPTNMSG
fi
printf \\n
cat << 'EoNOTEspcl'
           cluster size (partition size)
spcl:auto   auto by mkfs.vfat
spcl:8      4KiB (256MiB--1TiB)
spcl:16     8KiB (512MiB--2TiB)
spcl:32    16KiB (1GiB--4TiB)
spcl:64    32KiB (2GiB--8TiB)
spcl:128   64KiB (4GiB--16TiB)
spcl:ext4   ext4
EoNOTEspcl

mkDevices () {
  rm -f $vol "$vol"p[1-9]*
  while read major minor blocks nam ; do
    case "$nam" in $vol*)
      rm -f "$nam"
      mknod -m 600 "$nam" b $major $minor
    ;; esac
  done < /proc/partitions
}
mkDevices

fdiskBatch () {
  printf \\n
  pp=''
  n=0
  for p in $pt '' ; do
    case "$p" in [!1-9]*) continue ;; esac
    if [ -z "$pp" ] ; then
      printf '\no\n'
      pp=$p
      continue
    fi
    if [ -z "$p" ] ; then
      printf 'u\np\nu\np\n%s\n' $1
      break
    fi
    n=$((n+1))
    [ $p -gt $pz ] && p=$pz
    case $n in
    1|2|3)
      printf 'n\np\n%d\n%d\n%d\n' $n $pp $((p-1))
      [ $n -eq 3 ] && printf 't\n3\n%s\n' $p3type # FAT32(LBA)
    ;;
    4)
      printf 'n\ne\n%d\n%d\n' $pp $((pz-1))
      n=5
      printf 'n\n%d\n%d\nt\n5\n82\n' $pp $((p-1))
    ;;
    *)
      printf 'n\n%d\n%d\n' $pp $((p-1))
    ;;
    esac
    pp=$p
  done | fdisk -H 32 -S 32 $vol | sed "$sedfdisk"
}

printf  '\n ==== fdisk SIMULATION ====\n'
fdiskBatch q

if [ -f $paramfile ] ; then
   tm0=0
   exitWithMsg "$(printf '\n == Finish DRY RUNNING ==')" 0
fi

if [ YES != "$1" ] ; then
  printf '\nAre you ready? [N/YES(type YES)] '
  read YN
  case $YN in
  YES) echo "$YN" ;;
  *) tm0=0; exitWithMsg 'Canceled.' 0 ;;
  esac
fi
exec 0<&-  # close stdin

printf \\n
date '+---- %T ----'
printf \\n
printf '20 99 0 0\n630 0 0 99\n' > $wnkCyc
dispImg wrt
echo "Copy current META data (S/N, ... etc.)"
echo "Invoke: dd if=/dev/mmcblk0 of=$vol bs=512K count=$((p1-1))"
dd if=/dev/mmcblk0 of=$vol bs=512K count=$((p1-1))

printf \\n
echo "Clear partition table"
echo "Invoke: dd if=/dev/zero of=$vol bs=2 seek=223 count=32"
dd if=/dev/zero of=$vol bs=2 seek=223 count=32

for rtld in ./src/lib/ld-linux*.so.* '' ; do
  [ -x "$rtld" ] && break
done
runOnRecoveryfs () {
  local x rtld
  x="$1"
  shift
  if [ -x "$rtld" -a -x "./$x" ] ; then
    if "$rtld" --verify "./$x" >/dev/null 2>&1 ; then
      LD_LIBRARY_PATH='./src/usr/lib:./src/lib' "$rtld" "./$x" "$@"
    else
      LD_LIBRARY_PATH='./src/usr/lib:./src/lib' "./$x" "$@"
    fi
  else
    "$x" "$@"
  fi
}

ln -s /bin/busybox blockdev
ln -s ./src/bin/busybox hdparm
if ./blockdev 2>&1 | grep -q 'applet not found' ; then
  rm -f blockdev
  if [ -x /sbin/blockdev -a ! -L /sbin/blockdev ] ; then
    ln -s /sbin/blockdev blockdev
    rm -f hdparm
  elif runOnRecoveryfs hdparm 2>&1 | grep -q 'applet not found' ; then
    printf '!!! ATTENTION. NO blockdev, NO hdparm.\n'
    rm -f hdparm
  fi
fi

partprobeALT () {
  sync; sync; sync
  if [ -x ./blockdev ] ; then
    ./blockdev --rereadpt ./$vol
  elif [ -x ./hdparm ] ; then
    runOnRecoveryfs hdparm -z ./$vol
  else
    echo w | fdisk -H 32 -S 32 ./$vol
  fi >/dev/null 2>&1
}
partprobeALT

printf \\n
echo " ==== Partitioning ===="
fdiskBatch w >/dev/null
partprobeALT
mkDevices

fdisk -l $vol ||
  exitWithMsg "fdisk fails partitioning" 13
echo 'Device files:'
ls -l "$vol"*
n=1
while [ $n -le $ptn ] ; do
  [ -e "${vol}p$n" ] || exitWithMsg "fdisk fails partitioning" 14
  n=$((n+1))
done

PLATFORM=freescale
[ $(dd if=/dev/mmcblk0 bs=512 skip=1024 count=1 2>/dev/null |
      grep -c "HW CONFIG") -eq 1 ] && PLATFORM=ntx508

UBOOT="src/upgrade/$PLATFORM/u-boot.bin"
if [ "$PLATFORM" = ntx508 ] ; then
  ln -s ./src/bin/ntx_hwconfig ntx_hwconfig
  PCB=$(runOnRecoveryfs ntx_hwconfig -s -p /dev/mmcblk0 PCB)
  RAM=$(runOnRecoveryfs ntx_hwconfig -s -p /dev/mmcblk0 RAMType)
  NEW_UBOOT="src/upgrade/$PLATFORM/u-boot_mddr_256-$PCB-$RAM.bin"
  [ -e "$NEW_UBOOT" ] && UBOOT="$NEW_UBOOT"
fi
[ -e "$UBOOT" ] || exitWithMsg "NO U-Boot: $UBOOT" 15

printf \\n
echo "Install: U-Boot"
echo "Invoke: dd if=$UBOOT of=$vol bs=1K seek=1 skip=1"
dd if=$UBOOT of=$vol bs=1K seek=1 skip=1 ||
  exitWithMsg "Fail:" 16

KERNEL="src/upgrade/$PLATFORM/uImage"
[ -e "$KERNEL" ] || exitWithMsg "NO kernel: $KERNEL" 17

printf \\n
echo "Install: kernel"
echo "Invoke: dd if=$KERNEL of=$vol bs=512 seek=2048"
dd if=$KERNEL of=$vol bs=512 seek=2048 ||
  exitWithMsg "Fail:" 18

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n430 0 0 99\n' > $wnkCyc

printf \\n
echo "Format partitions..."
mkfs=mkfs.ext4
ln -s ./src/sbin/$mkfs $mkfs
[ -x ./$mkfs ] || exitWithMsg "***ERROR NO: $mkfs" 19

printf \\n
echo "Invoke: $mkfs -v -L rootfs -m 0 ${vol}p1"
runOnRecoveryfs $mkfs -v -L rootfs -m 0 "$vol"p1 ||
  exitWithMsg "***ERROR $mkfs ${vol}p1" 20

printf \\n
echo "Invoke: $mkfs -v -L recoveryfs -m 0 ${vol}p2"
runOnRecoveryfs $mkfs -v -L recoveryfs -m 0 "$vol"p2 ||
  exitWithMsg "***ERROR $mkfs ${vol}p2" 21

printf \\n
if [ -z "$spcl" ] ; then
  echo "Invoke: mkfs.vfat -v -n KOBOeReader ${vol}p3"
  runOnRecoveryfs mkfs.vfat -v -n KOBOeReader "$vol"p3 ||
    exitWithMsg "***ERROR mkfs.vfat ${vol}p3" 22
elif [ $spcl -gt 0 ] ; then
  echo "Invoke: /bin/mkdosfs -F 32 -s $spcl -v -n KOBOeReader ${vol}p3"
  runOnRecoveryfs mkdosfs -F 32 -s $spcl -v -n KOBOeReader "$vol"p3 ||
    exitWithMsg "***ERROR mkdosfs ${vol}p3" 22
else
  echo "Invoke: $mkfs -v -L KOBOeReader -m 0 ${vol}p3"
  runOnRecoveryfs $mkfs -v -L KOBOeReader -m 0 "$vol"p3 ||
    exitWithMsg "***ERROR $mkfs ${vol}p3" 22
fi

printf \\n
ln -s ./src/bin/busybox mkswap
if [ -e "$vol"p5 ] ; then
  if runOnRecoveryfs mkswap 2>&1 | grep 'applet not found' ; then
    exitMsgAdded=' without formatting a swap partition.'
    echo '!!! swap partition is not formatted. OK.'
  else
    echo "Invoke: mkswap -L koboswap ${vol}p5"
    runOnRecoveryfs mkswap -L koboswap "$vol"p5 ||
      exitWithMsg "***ERROR mkswap ${vol}p5" 23
  fi
fi

if [ -e "$vol"p6 ] ; then
  printf \\n
  echo "Invoke: $mkfs -v -L kobohome -m 0 ${vol}p6"
  runOnRecoveryfs $mkfs -v -L kobohome -m 0 "$vol"p6 ||
    exitWithMsg "***ERROR $mkfs ${vol}p6" 24
fi

if [ -e "$vol"p7 ] ; then
  printf \\n
  echo "Invoke: $mkfs -v -L kobohome -m 0 ${vol}p7"
  runOnRecoveryfs $mkfs -v -L koboextra -m 0 "$vol"p7 ||
    exitWithMsg "***ERROR $mkfs ${vol}p7" 24
fi
sync; sync; sync

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n130 0 0 99\n' > $wnkCyc

printf \\n
echo "Cloning recoveryfs"
mkdir -m 000 dst
mtopt="norelatime,noatime,nodiratime"
mount -t ext4 -o $mtopt "$vol"p2 dst ||
  exitWithMsg "***ERROR mounting ${vol}p2" 25
for d in src/.* src/* ; do
  case "${d#*/}" in
  . | .. | 'lost+found') continue ;;
  esac
  [ -e "$d" -o -L "$d" ] || continue
  printf '%s ' "${d#*/}"
  cp -a "$d" dst/ ||
    exitWithMsg "***ERROR " 25
done
## change: /sbin/mkfs.vfat /etc/fakesh/tools/wrapping-mount-dosfsck.sh
##   /bin/mount /bin/umount /bin/dosfsck 
if [ ! -L dst/sbin/mkfs.vfat ] &&
      grep -q '# a part of fakesh-kobo' dst/sbin/mkfs.vfat ; then
    printf '\nRestore /sbin/mkfs.vfat on recoveryfs'
    rm -rf dst/sbin/mkfs.vfat
    ln -s ../bin/busybox dst/sbin/mkfs.vfat
fi
if [ -d dst/etc/fakesh ] ; then
  printf \\n
  $wrappingMD_sh '- on recoveryfs' dst restore
  printf ',\nand delete etc/fakesh'
  rm -rf dst/etc/fakesh
fi
# wrap
if [ -n "$spcl" ] ; then
  if [ $spcl -gt 0 -a -x dst/bin/mkdosfs ] ; then
    printf '\nReplacing "mkfs.vfat" to "/bin/mkdosfs -F 32 -s %d"' $spcl
    ## dst/sbin/mkdosfs is busybox 
    rm -rf dst/sbin/mkfs.vfat
    cat > dst/sbin/mkfs.vfat <<- EOWRAP1
	#!/bin/busybox sh
	# a part of fakesh-kobo
	exec /bin/mkdosfs -F 32 -s $spcl "\$@"
	EOWRAP1
    chmod 755 dst/sbin/mkfs.vfat
  elif [ $spcl -eq 0 -a -x dst/sbin/mkfs.ext4 ] ; then
    printf '\nReplacing "mkfs.vfat -n" to "mkfs.ext4 -m 0 -L" on recoveryfs.'
    rm -rf dst/sbin/mkfs.vfat
    cat > dst/sbin/mkfs.vfat <<- 'EOWRAP2'
	#!/bin/busybox sh
	# a part of fakesh-kobo
	a='set --'; n=1
	for i do
	  case "$i" in
	  -*n*) a="$a ${i%n*}L${i##*n}" ;; # change
	  *) a="$a \"\${$n}\"" ;;
	  esac
	  n=$((n+1))
	done
	eval "$a"
	exec /sbin/mkfs.ext4 -m 0 "$@"
	EOWRAP2
    chmod 755 dst/sbin/mkfs.vfat
    printf \\n
    $wrappingMD_sh '- on recoveryfs' dst
    printf .
  fi
fi

printf \\n
sync; sync; sync
umount dst ||
  exitWithMsg "***ERROR unmounting ${vol}p2" 26

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n80 0 0 99\n' > $wnkCyc

printf \\n
fstgz=src/upgrade/fs.tgz
[ -e $fstgz ] ||
  exitWithMsg "***ERROR No $fstgz" 27
mount -t ext4 -o $mtopt "$vol"p1 dst ||
  exitWithMsg "***ERROR mounting ${vol}p1" 28
echo "Expanding factory image of rootfs. Take a while..."
tar xfz $fstgz -C dst ||
  exitWithMsg "***ERROR " 29
if [ "$spcl" = 0 ] ; then
  $wrappingMD_sh '- on rootfs' dst
  printf .\\n
fi
sync; sync; sync
umount dst ||
  exitWithMsg "***ERROR unmounting ${vol}p1" 30

printf \\n
date '+---- %T ----'
printf \\n
dbtgz=src/upgrade/db.tgz
[ -e $dbtgz ] ||
  exitWithMsg "***ERROR No $dbtgz" 31
mount $mtoptp3 "$vol"p3 dst ||
  exitWithMsg "***ERROR mounting ${vol}p3" 32
echo "Expanding factory image of KOBOeReader"
tar xfz $dbtgz -C dst ||
  exitWithMsg "***ERROR " 33
[ "$spcl" = 0 ] && chmod 1777 dst
sync; sync; sync
umount dst ||
  exitWithMsg "***ERROR unmounting ${vol}p3" 34
rmdir dst ||
  exitWithMsg "***ERROR nonempty dst" 35

printf \\n
ubmmc="src/etc/u-boot/$PLATFORM/u-boot.mmc"
[ -e $ubmmc ] ||
  exitWithMsg "***ERROR No $ubmmc" 36
echo "Invoke: dd if=$ubmmc of=$vol bs=128K seek=6 count=1"
dd if=$ubmmc of=$vol bs=128K seek=6 count=1 ||
  exitWithMsg "Fail:" 37

printf \\n
exitWithMsg "|+++ OKOKOK SUCCESSFULLY BACKUPED +++|$exitMsgAdded" 0

exit 0
