#!/bin/busybox sh
[ -f "$FKSH_ONB/fakesh.conf" ] || exit 0
hMAC='random'
dMAC='random'
usbIP='192.168.192.176'

sedCnv='s/#.*//;
  s/  *//g;
  s/\\\\/\\134/g;
  s/\\40/ /g;
  s/\\134/\\/g;'
usbnetON () {
  local i optHWaddr v k
  [ -f $FKSH_ONB/fakesh.conf ] || return 1
  while read -r v ; do
    v="$(printf '%s' "$v" | sed "$sedCnv")"
    k="${v%%:*}"; v="${v#*:}"
    case "$k" in
    usbnet_ip) usbIP="$v" ;;
    usbnet_h*) hMAC="$v" ;; # random if no lines in $FKSH_ONB/fakesh.conf
    usbnet_d*) dMAC="$v" ;; # random if no lines in $FKSH_ONB/fakesh.conf
    esac
  done < $FKSH_ONB/fakesh.conf
  case "$hMAC" in
  '' | random ) optHWaddr='' ;;
  *) optHWaddr="host_addr=$hMAC" ;;
  esac
  case "$dMAC" in
  '' | random ) ;;
  *) optHWaddr="$optHWaddr dev_addr=$dMAC" ;;
  esac
  for i in 1 2 5 10 50 100 ; do
    ## ?? use modules of ntx508 even old Touch ??
    grep -q '^arcotg_udc' /proc/modules ||
      insmod /drivers/ntx508/usb/gadget/arcotg_udc.ko
    grep -q '^g_ether' /proc/modules ||
      insmod /drivers/ntx508/usb/gadget/g_ether.ko $optHWaddr
    ifconfig | grep -q '^usb0' ||
      ifconfig usb0 "$usbIP"
    usleep 100
    if ifconfig usb0 | grep -q "inet addr:$usbIP" ; then
      if [ -z "$dMAC" ] ; then
        read v < /sys/class/net/usb0/address
        sed -i -r "s/^ *(usbnet_d[^:]*:)/\\1 $v /" $FKSH_ONB/fakesh.conf
      fi
      if [ -z "$hMAC" ] ; then
        v="$(dmesg |awk '/^usb0: HOST MAC /{v=$4;}END{printf "%s", v}')"
        sed -i -r "s/^ *(usbnet_h[^:]*:)/\\1 $v /" $FKSH_ONB/fakesh.conf
      fi
      return 0
    fi
    usleep $((i*10000))  # ix10 msec
  done
  return 1
}

usbnetOFF () {
  local i
  i=60  # at least 2
  while [ $i -gt 0 ] ; do
    if grep -q '^g_ether' /proc/modules ; then
      ifconfig usb0 down
      rmmod g_ether
    elif grep -q '^arcotg_udc' /proc/modules ; then
      rmmod arcotg_udc
    else
      return 0
    fi
    usleep 5000  # 5 msec
    i=$((i-1))
  done
  return 1
}

case "$1" in
[Oo][Nn]|1) usbnetON || exit 1 ;;
[Oo][Ff][Ff]|0) usbnetOFF || exit 1 ;;
plug)
  case "$ACTION" in
  add) usbnetON || exit 1 ;;
  remove) usbnetOFF || exit 1 ;;
  esac
;;
esac

exit 0
