/*
 *
 * Galatea Life-Like Behavior Manager:
 *
 * 2004,2010 Takuya NISHIMOTO
 * 2010 Yuichoro KOYATA
 * 
 */

package galatea.agent;

public class Agent {
	// 
	private String mask_;

	private String background_;

	private double clock_, clockHead_;

	private double headMoveNoSpeak_, headMoveSpeak_;

	private int agentSpeakState_;

	// bodyTransXXX : only x,y are used
	private Vector3D bodyTrans_;

	private Vector3D bodyTransBase_;

	private double bodyScale_, bodyScaleBase_;

	// bodyRot
	private Vector3D bodyRot_;

	private Vector3D bodyRotBase_;

	private Vector3D bodyRotTargetDelta_;

	private int bodyRotTargetCount_;

	// headRot
	private Vector3D headRot_;

	private Vector3D headRotBase_;

	private Vector3D headRotTargetDelta_;

	private int headRotTargetCount_;

	// eyeRot
	private Vector3D eyeRot_;

	// emotion
	private String expType_, expTypeTarget_;

	private double expLevel_, expLevelBase_, expLevelTarget_, expLevelMax_,
			expLevelRange_;

	// alpha (transparency)

	// nodding
	private Vector3D headRotNodding_;

	private double noddingRange_;

	private int noddingCount_;

	private int noddingCountMax_;

	private double noddingStartClock_;

	private int noddingType_;
	private String speaker_;
	private float speakSpeed_; 

	public String getSpeaker() {
		return speaker_;
	}
		
	public void setSpeakSpeed(float f) {
		speakSpeed_ = f;
	} 	

	// add by koyata
	private int headCount, bodyCount, rotFrame_kyt, rotCount_kyt;

	private Vector3D headPrev, bodyPrev, eyePrev, headNext, bodyNext, eyeNext,
			delta_kyt, rotNext_kyt, rotPrev_kyt;

	private void _calcNodding() {
		if (noddingCount_ > 0) {
			double amp = (double) noddingCount_ / noddingCountMax_; // Math.sin(
																	// Math.PI *
																	// noddingCount_
																	// /
																	// noddingCountMax_);
			noddingCount_ -= 1;

			double t = clockHead_ - noddingStartClock_;
			switch (noddingType_) {
			case 1:
				// nodding
				double nx = Math.sin(t * 10.0) * noddingRange_ * amp;
				headRotNodding_.set(nx, 0, 0);
				break;
			case 2:
				// refuse
				double nz = Math.sin(t * 10.0) * noddingRange_ * amp;
				headRotNodding_.set(0, 0, nz);
				break;
			default:
				break;
			}
		}
	}

	private void _calcHeadMovement() {
		if (headRotTargetCount_ > 0) {
			headRotBase_.add(headRotTargetDelta_);
			headRotTargetCount_ -= 1;
		}

		headRot_.x = headRotBase_.x + Math.cos(clockHead_ * 0.4) * 0.30
				+ Math.cos(clockHead_ * 4.0) * 0.10;
		headRot_.y = headRotBase_.y + Math.cos(clockHead_ * 0.1) * 0.05
				+ Math.cos(clockHead_ * 4.0) * 0.02;
		headRot_.z = headRotBase_.z + Math.cos(clockHead_ * 0.9) * 0.15
				+ Math.cos(clockHead_ * 3.0) * 0.07;

		_calcNodding();
		headRot_.add(headRotNodding_);

		headRot_.applyLimitter();
	}

	private void _calcBodyMovement() {
		if (bodyRotTargetCount_ > 0) {
			bodyRotBase_.add(bodyRotTargetDelta_);
			bodyRotTargetCount_ -= 1;
		}

		bodyRot_.x = bodyRotBase_.x + Math.cos(clock_ * 1.6) * 0.20;
		bodyRot_.y = bodyRotBase_.y + Math.cos(clock_ * 1.2) * 0.10;

		bodyTrans_.x = bodyTransBase_.x + Math.cos(clock_ * 2.5) * 0.001;
		bodyTrans_.y = bodyTransBase_.y + Math.cos(clock_ * 1.5) * 0.001;

		bodyScale_ = bodyScaleBase_ + Math.cos(clock_ * 0.2) * 0.005;
	}

	private void _calcEmotionChange() {
		if (!expType_.equals(expTypeTarget_)) {
			if (expLevelBase_ < 10.0) {
				expLevelBase_ = 0;
				expType_ = expTypeTarget_;
			} else {
				expLevelBase_ -= 20.0;
			}
		} else {
			expLevelBase_ += (expLevelTarget_ - expLevelBase_) * 0.05; // 0.5
		}
		expLevel_ = expLevelBase_ - Math.cos(clock_ * 5.0) * expLevelRange_;
		if (expLevel_ > expLevelMax_) {
			expLevel_ = expLevelMax_;
		}
		if (expLevel_ < 0) {
			expLevel_ = 0;
		}
	}

	public Agent(String mask, String speaker, String bg, double scale) {

		headMoveNoSpeak_ = 1.0;
		headMoveSpeak_ = 0.9;

		clock_ = 0.0;
		clockHead_ = 0.0;

		mask_ = mask;

		speaker_ = speaker;
		speakSpeed_ = 1.0f;

		bodyTransBase_ = new Vector3D(0, 0, 0);
		bodyTrans_ = new Vector3D(0, 0, 0);

		bodyScale_ = scale;
		bodyScaleBase_ = scale;

		bodyRot_ = new Vector3D(0, 0, 0);
		bodyRotBase_ = new Vector3D(0, 0, 0);
		bodyRotTargetDelta_ = new Vector3D(0, 0, 0);
		bodyRotTargetCount_ = 0;

		headRot_ = new Vector3D(0, 0, 0);
		headRot_.setLimitter(10, 10, 10);
		headRotBase_ = new Vector3D(0, 0, 0);
		headRotTargetDelta_ = new Vector3D(0, 0, 0);
		headRotTargetCount_ = 0;

		eyeRot_ = new Vector3D(0, 0, 0);
		eyeRot_.setLimitter(20, 10, 20);

		expLevel_ = 0.0;
		expLevelBase_ = 0.0;
		expLevelTarget_ = 0.0;
		expLevelMax_ = 100.0;
		expLevelRange_ = 10.0;
		expType_ = "NEUTRAL";
		expTypeTarget_ = "NEUTRAL";

		agentSpeakState_ = 0;
		noddingRange_ = 0.0;
		noddingCountMax_ = 20;
		noddingCount_ = 0;
		headRotNodding_ = new Vector3D(0, 0, 0);

		// kyt
		headPrev = new Vector3D(0, 0, 0);
		bodyPrev = new Vector3D(0, 0, 0);
		headNext = new Vector3D(0, 0, 0);
		bodyNext = new Vector3D(0, 0, 0);
		delta_kyt = new Vector3D(0, 0, 0);
		rotNext_kyt = new Vector3D(0, 0, 0);
		rotPrev_kyt = new Vector3D(0, 0, 0);
	}

	public synchronized void calc() {
		_calcEmotionChange();
		// _calcHeadMovement();
		// _calcBodyMovement();
		calcRotDelta_kyt(); // 目標角度への移動
		calcAutoMove_kyt(); // 動きの「ゆらぎ」生成
	}

	public synchronized void setHeadMove(double headMoveNoSpeak,
			double headMoveSpeak) {
		headMoveNoSpeak_ = headMoveNoSpeak;
		headMoveSpeak_ = headMoveSpeak;
	}

	public synchronized void addClock(double delta) {
		clock_ += delta;
		if (agentSpeakState_ == 2) {
			clockHead_ += delta * headMoveSpeak_;
		} else {
			clockHead_ += delta * headMoveNoSpeak_;
		}
	}

	public synchronized void setAgentSpeakState(int state) {
		agentSpeakState_ = state;
	}

	public synchronized void setBackground(String background) {
		background_ = background;
	}

	public synchronized String getBackground() {
		return background_;
	}

	public synchronized String getMask() {
		return mask_;
	}

	public synchronized void startNodding(double level) {
		noddingRange_ = level;
		noddingCount_ = noddingCountMax_;
		noddingStartClock_ = clockHead_;
		noddingType_ = 1;
	}

	public synchronized void startRefuse(double level) {
		noddingRange_ = level;
		noddingCount_ = noddingCountMax_;
		noddingStartClock_ = clockHead_;
		noddingType_ = 2;
	}

	public synchronized void setEmotionTarget(String emotion, double level) {
		expTypeTarget_ = emotion;
		expLevelTarget_ = level;
		expLevelMax_ = level;
	}

	public synchronized void setEmotionTarget(String emotion) {
		setEmotionTarget(emotion, 90);
	}

	public synchronized void setEmotionNow(String emotion, double level) {
		expType_ = emotion;
		expLevel_ = level;

		expTypeTarget_ = emotion;
		expLevelTarget_ = level;
		expLevelMax_ = level;
	}

	public synchronized void setEmotionNow(String emotion) {
		setEmotionNow(emotion, 90);
	}

	public synchronized void setEyeRotNow(double tx, double ty, double tz) {
		eyeRot_.set(tx, ty, tz);
		eyeRot_.applyLimitter();
	}

	public synchronized void setBodyRotTarget(double tx, double ty, double tz) {
		bodyRotTargetCount_ = 16;
		// TODO: implement Vector3D operator
		bodyRotTargetDelta_.x = (tx - bodyRotBase_.x) / bodyRotTargetCount_;
		bodyRotTargetDelta_.y = (ty - bodyRotBase_.y) / bodyRotTargetCount_;
		headRotTargetDelta_.z = 0.0;

	}

	public synchronized void setBodyRotNow(double tx, double ty, double tz) {
		bodyRot_.set(tx, ty, tz);
	}

	public synchronized void setHeadRotTarget(double tx, double ty, double tz) {
		headRotTargetCount_ = 16;
		// TODO: implement Vector3D operator
		headRotTargetDelta_.x = (tx - headRotBase_.x) / headRotTargetCount_;
		headRotTargetDelta_.y = (ty - headRotBase_.y) / headRotTargetCount_;
		headRotTargetDelta_.z = (tz - headRotBase_.z) / headRotTargetCount_;

	}

	public synchronized void setHeadRotNow(double tx, double ty, double tz) {
		headRot_.set(tx, ty, tz);
	}

	public synchronized void setRotTarget(double tx, double ty, double tz) {
		setBodyRotTarget(tx, ty, tz);
		setHeadRotTarget(tx, ty, tz);
		setEyeRotNow(tx, ty, tz);
	}

	public synchronized void setRotTarget_kyt(double tx, double ty, double tz,
			int frame) {
		// 現在角度から目標角度までを任意関数で補完して動かすための関数

		// tx, ty, tz : 移動動作の目標角度
		// frame : 移動動作に費やすframe数

		if (frame <= 1) {
			setRotNow(tx, ty, tz);
		} else {
			rotFrame_kyt = rotCount_kyt = frame;
			headNext.set(tx, ty, tz);
			bodyNext.set(tx, ty, tz);
			headPrev.set(headRotBase_);
			bodyPrev.set(bodyRotBase_);
		}
	}

	public synchronized void calcRotDelta_kyt() {
		if (rotCount_kyt-- > 0) {
			// ex.1 : 線形補完
//
//			headRotTargetDelta_.x = (headNext.x - headPrev.x) / rotFrame_kyt;
//			headRotTargetDelta_.y = (headNext.y - headPrev.y) / rotFrame_kyt;
//			headRotTargetDelta_.z = (headNext.z - headPrev.z) / rotFrame_kyt;
//
//			headRotBase_.add(headRotTargetDelta_);
//			headRot_.set(headRotBase_);

			// bodyRotTargetDelta_.x = (bodyNext.x - bodyPrev.x) / rotFrame_kyt;
			// bodyRotTargetDelta_.y = (bodyNext.y - bodyPrev.y) / rotFrame_kyt;
			// bodyRotTargetDelta_.z = (bodyNext.z - bodyPrev.z) / rotFrame_kyt;
			//    		
			// bodyRotBase_.add(bodyRotTargetDelta_);
			// bodyRot_.set(bodyRotBase_);

			// ex.2 : シグモイド補完
			/*
			 * double amp; amp = headNext.x - headPrev.x; headRotBase_.x = amp /
			 * (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + headPrev.x; amp = headNext.y - headPrev.y;
			 * headRotBase_.y = amp / (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + headPrev.y; amp = headNext.z - headPrev.z;
			 * headRotBase_.z = amp / (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + headPrev.z; headRot_.set(headRotBase_);
			 * 
			 * amp = bodyNext.x - bodyPrev.x; bodyRotBase_.x = amp / (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + bodyPrev.x; amp = bodyNext.y - bodyPrev.y;
			 * bodyRotBase_.y = amp / (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + bodyPrev.y; amp = bodyNext.z - bodyPrev.z;
			 * bodyRotBase_.z = amp / (1 +
			 * Math.exp(-amp*2*((rotFrame_kyt-rotCount_kyt)/(double)rotFrame_kyt -
			 * 0.5))) + bodyPrev.z; bodyRot_.set(bodyRotBase_);
			 */
			
			// ex.3 : 2次系step応答
			double rate = calc2ndOrderStepResponse(rotFrame_kyt - rotCount_kyt,5.0/(double)rotFrame_kyt);
			headRotBase_.x = (headNext.x - headPrev.x) *rate + headPrev.x;
			headRotBase_.y = (headNext.y - headPrev.y) *rate + headPrev.y;
			headRotBase_.z = (headNext.z - headPrev.z) *rate + headPrev.z;

			headRot_.set(headRotBase_);
		}
	}

	public double calc2ndOrderStepResponse(double t, double a) {
		double expValue = Math.exp(-a * t);
		return 1 - expValue - a * t * expValue;
	}

	public synchronized void calcAutoMove_kyt() {
		// 従来ソースでは「目標角度への移動」と「動きのゆらぎ」の機能が
		// 1つの関数で実装されていたが、
		// ゆらぎ生成機能だけを切り離したのがこの関数

		double amp = 1.0;

		// head
		headRot_.x = headRotBase_.x + Math.cos(clockHead_ * 0.4) * 0.30 * amp
				+ Math.cos(clockHead_ * 4.0) * 0.10 * amp;
		headRot_.y = headRotBase_.y + Math.cos(clockHead_ * 0.1) * 0.05 * amp
				+ Math.cos(clockHead_ * 4.0) * 0.02 * amp;
		headRot_.z = headRotBase_.z + Math.cos(clockHead_ * 0.9) * 0.15 * amp
				+ Math.cos(clockHead_ * 3.0) * 0.07 * amp;
		headRot_.applyLimitter();

		// body
		bodyRot_.x = bodyRotBase_.x + Math.cos(clock_ * 1.6) * 0.20 * amp;
		bodyRot_.y = bodyRotBase_.y + Math.cos(clock_ * 1.2) * 0.10 * amp;

		bodyTrans_.x = bodyTransBase_.x + Math.cos(clock_ * 2.5) * 0.001 * amp;
		bodyTrans_.y = bodyTransBase_.y + Math.cos(clock_ * 1.5) * 0.001 * amp;

		bodyScale_ = bodyScaleBase_ + Math.cos(clock_ * 0.2) * 0.005 * amp;
	}

	public synchronized void setRotNow(double tx, double ty, double tz) {
		setBodyRotNow(tx, ty, tz);
		setHeadRotNow(tx, ty, tz);
		setEyeRotNow(tx, ty, tz);
	}

	public synchronized Vector3D getEyeRot() {
		return eyeRot_;
	}

	public synchronized Vector3D getHeadRot() {
		return headRot_;
	}

	public synchronized Vector3D getBodyRot() {
		return bodyRot_;
	}

	public synchronized Vector3D getBodyTrans() {
		return bodyTrans_;
	}

	public synchronized double getBodyScale() {
		return bodyScale_;
	}

	public synchronized String getExpType() {
		return expType_;
	}

	public synchronized double getExpLevel() {
		return expLevel_;
	}

	// for AMMCL.java
	public String getOutputText(String str) {
		return str;
	}


}