/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: InterpretedEvent.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */
package galatea.dialog;

import galatea.io.DeviceEvent;
import galatea.io.DeviceEvent.State;
import galatea.io.DeviceEvent.Type;
import galatea.relaxer.event.EventEv;

import java.io.StringReader;


public class InterpretedEvent extends DeviceEvent {
	private InterpretedEvent(String str2) {
		super(Type.INPUT, State.READY, "input", str2);
	}

	public static InterpretedEvent newInstance(String src, String content) {
		String text = content;
		String script = "$utterance='" + content + "'";
		String xmlevent = 
			"<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>"
			+"<text>" + text + "</text>"
			+"<script>" + script + "</script></interpreted></ev>";
		return new InterpretedEvent(xmlevent);
	}
	
	public static InterpretedEvent newInstance(
			String src, String text, String slot, String val) {
		String script = 
			"$utterance='" + text + "';" + slot + "='" + val + "';" 
			+ slot + "$.justfilled=true;";
		String xmlevent = 
			"<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>"
			+"<text>" + text + "</text>"
			+"<script>" + script + "</script></interpreted></ev>";
		return new InterpretedEvent(xmlevent);
	}
	
	public static InterpretedEvent newInstance(String xmlevent) {
		return new InterpretedEvent(xmlevent);
	}
}
