/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: DocLoader.java,v 1.6 2009/09/10 08:44:19 nishimoto Exp $
 */

package galatea.document;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import galatea.dialog.DialogManager;
import galatea.dialog.window.DialogManagerWindow;
import galatea.httpclient.NetUtil;
import galatea.util.Util;


import org.w3c.dom.Element;

public class DocLoader {
	private Element element_;
	private IAbstractDoc doc_;
	private StateMap stateMap_;
	private String warnings_;
	
	private static void debug(String msg) {
		// System.err.println("DocLoader: " + msg);
	}
	
	/**
	 * load document via http
	 * @param poststring 
	 * @param file: local path of cache file 
	 * @param path: source file path
	 * @param dialog: http://server/file.vxml#dialog
	 */
	public DocLoader(String filename, String path, String fragment, String poststring) 
		throws Exception
	{
		if (poststring.equals("undefined")) {
			poststring = null;
		}
		debug(filename + " " + path + " fragment:" + fragment + " post:" + poststring);
		doc_ = null;
		warnings_ = "";
		try {
			if (poststring != null && poststring.length() > 0) {
				// filename += "?" + poststring;
				element_ = NetUtil.loadXMLFile(filename, true, poststring);
				debug("element=" + NetUtil.makeString(element_));
			} else {
				element_ = NetUtil.loadXMLFile(filename);
				debug("element=" + NetUtil.makeString(element_));
			}
			String topName = NetUtil.getTopName(element_);
			debug("topName=" + topName);
			if ( topName.equals("vxml") ) {
				doc_ = new VXMLDoc(element_, path, fragment);
			} else if( topName.equals("pdoc") ) {
				doc_ = new PDoc(element_, path, fragment);
			} else if( topName.equals("grammar") ) {
				doc_ = new GrammarDoc(element_, path, fragment);
			} else {
				throw new DocError(filename);
			}
		} catch (Exception e) {
			throw new DocError(filename + "\n" + e.toString());
		}
		warnings_ = doc_.getDocWarnings();
		stateMap_ = doc_.getStateMap();
	}
	
	
	public StateMap getStateMap() {
		return stateMap_;
	}
	
	public String getWarnings() {
		return warnings_;
	}
	
	public String getSrcAsString() {
		if (element_ == null) return "";
		return NetUtil.makeString(element_);
	}
	
	public String getTranslatedAsString() {
		if (stateMap_ == null) return "";
		return stateMap_.toString();
	}
	
	
	/**
	 * for galatea -p
	 */
	public static String convert(String uri)
	{
		String ret = "";
		try {
			String path = Util.getUriWithoutFragment(uri);
			String dialog = Util.getUriFragment(uri);
			debug("convert uri=" + uri +" path="+ path +" dialog="+ dialog);
			DocLoader loader = new DocLoader(uri, path, dialog, "");
			StateMap stateMap = loader.getStateMap();
			if (stateMap == null) {
				System.err.println("DocLoader stopped: stateMap null.");
				return ret;
			}
			ret = loader.getWarnings() + "\n" + stateMap.toString();
		} catch(DocError e){
			e.printStackTrace(System.err);
			System.err.println("DocLoader stopped.");
		} catch(java.io.FileNotFoundException e){
			e.printStackTrace(System.err);
			System.err.println("DocLoader stopped.");
		} catch(org.xml.sax.SAXParseException e){
			e.printStackTrace(System.err);
			System.err.println("Source:"+uri);
			System.err.println("Line:"+e.getLineNumber()+" Column:"+e.getColumnNumber());
			System.err.println("DocLoader stopped.");
		} catch(java.lang.Exception e){
			e.printStackTrace();
			System.err.println("DocLoader stopped.");
		}
		return ret;
	}
	
	public static void main(String argv[]) 
	{
		String p = "http://localhost:3000/product/index.vxml";
		String s = convert(p);
		System.out.print(s);
	}
	
}
