/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: RecordOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.dialog.RuntimeError;
import galatea.util.Util;

public class RecordOutItem extends OutItem
{
	private String tempFileName_ = "";
	private double maxDurationInSec = 10.0;
	
	public void setTempFileName(String tempFileName) {
		this.tempFileName_ = tempFileName;
	}

	public void setMaxDurationInSec(double maxDurationInSec) {
		this.maxDurationInSec = maxDurationInSec;
	}

	public RecordOutItem() {
		tempFileName_ = Util.mktemp(".wav");
	}
	
	public String toString()
	{
		String s = "<record";
		s += ">";
		s += tempFileName_;
		s += "</record>";
		return s;
	}
	
	public String getTempFileName() {
		return tempFileName_;
	}
	
	public double getMaxDurationInSec() 
	{
		return maxDurationInSec;
	}

	public long getMaxDurationInMilliSec() {
		return (long)(maxDurationInSec * 1000.0);
	}
}
