/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocPdoc</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="pdoc">
 *       <attribute name="version">
 *         <data type="float"/>
 *       </attribute>
 *       <optional>
 *        <ref name="head"/>
 *       </optional>
 *       <ref name="body"/>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="pdoc"&gt;
 *       &lt;attribute name="version"&gt;
 *         &lt;data type="float"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;optional&gt;
 *        &lt;ref name="head"/&gt;
 *       &lt;/optional&gt;
 *       &lt;ref name="body"/&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version pdoc.rng (Thu Oct 02 00:02:08 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class PdocPdoc implements java.io.Serializable, Cloneable {
    private float version_;
    private String head_;
    private PdocBody body_;
    private Element xmlElement;

    /**
     * Creates a <code>PdocPdoc</code>.
     *
     */
    public PdocPdoc() {
    }

    /**
     * Creates a <code>PdocPdoc</code>.
     *
     * @param source
     */
    public PdocPdoc(PdocPdoc source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocPdoc(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocPdoc(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocPdoc(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocPdoc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocPdoc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocPdoc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the PdocPdoc <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocPdoc source) {
        int size;
        version_ = source.version_;
        head_ = source.head_;
        if (source.body_ != null) {
            setBody((PdocBody)source.getBody().clone());
        }
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        head_ = URelaxer.getElementPropertyAsStringByStack(stack, "head");
        setBody(new PdocBody(stack));
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocPdoc((PdocPdoc)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("pdoc");
        int size;
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        if (this.head_ != null) {
            URelaxer.setElementPropertyByString(element, "head", this.head_);
        }
        this.body_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocPdoc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocPdoc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the float property <b>version</b>.
     *
     * @return float
     */
    public float getVersion() {
        return (version_);
    }

    /**
     * Sets the float property <b>version</b>.
     *
     * @param version
     */
    public void setVersion(float version) {
        this.version_ = version;
    }

    /**
     * Gets the float property <b>version</b>.
     *
     * @return Float
     */
    public Float getVersionAsFloat() {
        return (new Float(version_));
    }

    /**
     * Sets the float property <b>version</b>.
     *
     * @param version
     */
    public void setVersion(Float version) {
        this.version_ = version.floatValue();
    }

    /**
     * Gets the String property <b>head</b>.
     *
     * @return String
     */
    public String getHead() {
        return (head_);
    }

    /**
     * Sets the String property <b>head</b>.
     *
     * @param head
     */
    public void setHead(String head) {
        this.head_ = head;
    }

    /**
     * Gets the PdocBody property <b>body</b>.
     *
     * @return PdocBody
     */
    public PdocBody getBody() {
        return (body_);
    }

    /**
     * Sets the PdocBody property <b>body</b>.
     *
     * @param body
     */
    public void setBody(PdocBody body) {
        this.body_ = body;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<pdoc");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(getVersion()));
        buffer.append("\"");
        buffer.append(">");
        if (head_ != null) {
            buffer.append("<head>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getHead())));
            buffer.append("</head>");
        }
        body_.makeTextElement(buffer);
        buffer.append("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<pdoc");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(getVersion()));
        buffer.write("\"");
        buffer.write(">");
        if (head_ != null) {
            buffer.write("<head>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getHead())));
            buffer.write("</head>");
        }
        body_.makeTextElement(buffer);
        buffer.write("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<pdoc");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(getVersion()));
        buffer.print("\"");
        buffer.print(">");
        if (head_ != null) {
            buffer.print("<head>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getHead())));
            buffer.print("</head>");
        }
        body_.makeTextElement(buffer);
        buffer.print("</pdoc>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getHeadAsString() {
        return (URelaxer.getString(getHead()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(Float.parseFloat(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setHeadByString(String string) {
        setHead(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets attribute.
     *
     * @return String
     */
    public String getBody_Start() {
        if (body_ == null) {
            return (null);
        }
        return (body_.getStart());
    }

    /**
     * Gets attribute.
     *
     * @param start
     */
    public void setBody_Start(String start) {
        if (body_ == null) {
            body_ = new PdocBody();
        }
        body_.setStart(start);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocPdoc</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pdoc")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return (false);
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null) {
            if (URelaxer.isTargetElement(child, "head")) {
                target.popElement();
            }
        }
        $match$ = true;
        if (!PdocBody.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocPdoc</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocPdoc</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
