/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlObject</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="object">
 *       <optional>
 *         <attribute name="name">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="cond">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="expr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchhint">
 *           <choice>
 *             <value type="NMTOKEN">prefetch</value>
 *             <value type="NMTOKEN">safe</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchtimeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxage">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxstale">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="classid">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="codebase">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="data">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="type">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="codetype">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="archive">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <ref name="audio"/>
 *             <ref name="prompt"/>
 *             <ref name="param"/>
 *             <ref name="catch"/>
 *             <ref name="noinput"/>
 *             <ref name="error"/>
 *             <ref name="help"/>
 *             <ref name="nomatch"/>
 *             <ref name="filled"/>
 *             <ref name="property"/>
 *             <ref name="value"/>
 *             <ref name="enumerate"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="object"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="name"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="cond"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="expr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchhint"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;prefetch&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;safe&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchtimeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxage"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxstale"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="classid"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="codebase"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="data"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="codetype"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="archive"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prompt"/&gt;
 *             &lt;ref name="param"/&gt;
 *             &lt;ref name="catch"/&gt;
 *             &lt;ref name="noinput"/&gt;
 *             &lt;ref name="error"/&gt;
 *             &lt;ref name="help"/&gt;
 *             &lt;ref name="nomatch"/&gt;
 *             &lt;ref name="filled"/&gt;
 *             &lt;ref name="property"/&gt;
 *             &lt;ref name="value"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Thu Oct 02 00:02:05 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlObject implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlFormChoice {
    public static final String FETCHHINT_PREFETCH = "prefetch";
    public static final String FETCHHINT_SAFE = "safe";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String name_;
    private String cond_;
    private String expr_;
    private String fetchhint_;
    private String fetchtimeout_;
    private String maxage_;
    private String maxstale_;
    private String classid_;
    private String codebase_;
    private String data_;
    private String type_;
    private String codetype_;
    private String archive_;
    // List<IVxmlObjectMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlObject</code>.
     *
     */
    public VxmlObject() {
    }

    /**
     * Creates a <code>VxmlObject</code>.
     *
     * @param source
     */
    public VxmlObject(VxmlObject source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlObject</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlObject(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlObject</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlObject(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlObject</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlObject(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlObject</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlObject</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlObject</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlObject</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlObject</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlObject</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlObject(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlObject</code> by the VxmlObject <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlObject source) {
        int size;
        name_ = source.name_;
        cond_ = source.cond_;
        expr_ = source.expr_;
        fetchhint_ = source.fetchhint_;
        fetchtimeout_ = source.fetchtimeout_;
        maxage_ = source.maxage_;
        maxstale_ = source.maxstale_;
        classid_ = source.classid_;
        codebase_ = source.codebase_;
        data_ = source.data_;
        type_ = source.type_;
        codetype_ = source.codetype_;
        archive_ = source.archive_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlObjectMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlObject</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlObject</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlObject</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        fetchhint_ = URelaxer.getAttributePropertyAsString(element, "fetchhint");
        fetchtimeout_ = URelaxer.getAttributePropertyAsString(element, "fetchtimeout");
        maxage_ = URelaxer.getAttributePropertyAsString(element, "maxage");
        maxstale_ = URelaxer.getAttributePropertyAsString(element, "maxstale");
        classid_ = URelaxer.getAttributePropertyAsString(element, "classid");
        codebase_ = URelaxer.getAttributePropertyAsString(element, "codebase");
        data_ = URelaxer.getAttributePropertyAsString(element, "data");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        codetype_ = URelaxer.getAttributePropertyAsString(element, "codetype");
        archive_ = URelaxer.getAttributePropertyAsString(element, "archive");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlPrompt.isMatch(stack)) {
                addContent(new VxmlPrompt(stack));
            } else if (VxmlParam.isMatch(stack)) {
                addContent(new VxmlParam(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlFilled.isMatch(stack)) {
                addContent(new VxmlFilled(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlObject((VxmlObject)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "object");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.fetchhint_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchhint", this.fetchhint_);
        }
        if (this.fetchtimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchtimeout", this.fetchtimeout_);
        }
        if (this.maxage_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxage", this.maxage_);
        }
        if (this.maxstale_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxstale", this.maxstale_);
        }
        if (this.classid_ != null) {
            URelaxer.setAttributePropertyByString(element, "classid", this.classid_);
        }
        if (this.codebase_ != null) {
            URelaxer.setAttributePropertyByString(element, "codebase", this.codebase_);
        }
        if (this.data_ != null) {
            URelaxer.setAttributePropertyByString(element, "data", this.data_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.codetype_ != null) {
            URelaxer.setAttributePropertyByString(element, "codetype", this.codetype_);
        }
        if (this.archive_ != null) {
            URelaxer.setAttributePropertyByString(element, "archive", this.archive_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlObject</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlObject</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlObject</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlObject</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlObject</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlObject</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>fetchhint</b>.
     *
     * @return String
     */
    public String getFetchhint() {
        return (fetchhint_);
    }

    /**
     * Sets the String property <b>fetchhint</b>.
     *
     * @param fetchhint
     */
    public void setFetchhint(String fetchhint) {
        this.fetchhint_ = fetchhint;
    }

    /**
     * Gets the String property <b>fetchtimeout</b>.
     *
     * @return String
     */
    public String getFetchtimeout() {
        return (fetchtimeout_);
    }

    /**
     * Sets the String property <b>fetchtimeout</b>.
     *
     * @param fetchtimeout
     */
    public void setFetchtimeout(String fetchtimeout) {
        this.fetchtimeout_ = fetchtimeout;
    }

    /**
     * Gets the String property <b>maxage</b>.
     *
     * @return String
     */
    public String getMaxage() {
        return (maxage_);
    }

    /**
     * Sets the String property <b>maxage</b>.
     *
     * @param maxage
     */
    public void setMaxage(String maxage) {
        this.maxage_ = maxage;
    }

    /**
     * Gets the String property <b>maxstale</b>.
     *
     * @return String
     */
    public String getMaxstale() {
        return (maxstale_);
    }

    /**
     * Sets the String property <b>maxstale</b>.
     *
     * @param maxstale
     */
    public void setMaxstale(String maxstale) {
        this.maxstale_ = maxstale;
    }

    /**
     * Gets the String property <b>classid</b>.
     *
     * @return String
     */
    public String getClassid() {
        return (classid_);
    }

    /**
     * Sets the String property <b>classid</b>.
     *
     * @param classid
     */
    public void setClassid(String classid) {
        this.classid_ = classid;
    }

    /**
     * Gets the String property <b>codebase</b>.
     *
     * @return String
     */
    public String getCodebase() {
        return (codebase_);
    }

    /**
     * Sets the String property <b>codebase</b>.
     *
     * @param codebase
     */
    public void setCodebase(String codebase) {
        this.codebase_ = codebase;
    }

    /**
     * Gets the String property <b>data</b>.
     *
     * @return String
     */
    public String getData() {
        return (data_);
    }

    /**
     * Sets the String property <b>data</b>.
     *
     * @param data
     */
    public void setData(String data) {
        this.data_ = data;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the String property <b>codetype</b>.
     *
     * @return String
     */
    public String getCodetype() {
        return (codetype_);
    }

    /**
     * Sets the String property <b>codetype</b>.
     *
     * @param codetype
     */
    public void setCodetype(String codetype) {
        this.codetype_ = codetype;
    }

    /**
     * Gets the String property <b>archive</b>.
     *
     * @return String
     */
    public String getArchive() {
        return (archive_);
    }

    /**
     * Sets the String property <b>archive</b>.
     *
     * @param archive
     */
    public void setArchive(String archive) {
        this.archive_ = archive;
    }

    /**
     * Gets the IVxmlObjectMixed property <b>content</b>.
     *
     * @return IVxmlObjectMixed[]
     */
    public IVxmlObjectMixed[] getContent() {
        IVxmlObjectMixed[] array = new IVxmlObjectMixed[content_.size()];
        return ((IVxmlObjectMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlObjectMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlObjectMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlObjectMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlObjectMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlObjectMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlObjectMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlObjectMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlObjectMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlObjectMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlObjectMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlObjectMixed
     */
    public IVxmlObjectMixed getContent(int index) {
        return ((IVxmlObjectMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlObjectMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlObjectMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlObjectMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlObjectMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlObjectMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlObjectMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlObjectMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlObjectMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "object", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (fetchhint_ != null) {
            buffer.append(" ");
            buffer.append("fetchhint");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.append("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.append(" ");
            buffer.append("fetchtimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.append("\"");
        }
        if (maxage_ != null) {
            buffer.append(" ");
            buffer.append("maxage");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.append("\"");
        }
        if (maxstale_ != null) {
            buffer.append(" ");
            buffer.append("maxstale");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.append("\"");
        }
        if (classid_ != null) {
            buffer.append(" ");
            buffer.append("classid");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getClassid())));
            buffer.append("\"");
        }
        if (codebase_ != null) {
            buffer.append(" ");
            buffer.append("codebase");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCodebase())));
            buffer.append("\"");
        }
        if (data_ != null) {
            buffer.append(" ");
            buffer.append("data");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getData())));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" ");
            buffer.append("type");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }
        if (codetype_ != null) {
            buffer.append(" ");
            buffer.append("codetype");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCodetype())));
            buffer.append("\"");
        }
        if (archive_ != null) {
            buffer.append(" ");
            buffer.append("archive");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getArchive())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "object", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "object", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (fetchhint_ != null) {
            buffer.write(" ");
            buffer.write("fetchhint");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.write("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.write(" ");
            buffer.write("fetchtimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.write("\"");
        }
        if (maxage_ != null) {
            buffer.write(" ");
            buffer.write("maxage");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.write("\"");
        }
        if (maxstale_ != null) {
            buffer.write(" ");
            buffer.write("maxstale");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.write("\"");
        }
        if (classid_ != null) {
            buffer.write(" ");
            buffer.write("classid");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getClassid())));
            buffer.write("\"");
        }
        if (codebase_ != null) {
            buffer.write(" ");
            buffer.write("codebase");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCodebase())));
            buffer.write("\"");
        }
        if (data_ != null) {
            buffer.write(" ");
            buffer.write("data");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getData())));
            buffer.write("\"");
        }
        if (type_ != null) {
            buffer.write(" ");
            buffer.write("type");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }
        if (codetype_ != null) {
            buffer.write(" ");
            buffer.write("codetype");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCodetype())));
            buffer.write("\"");
        }
        if (archive_ != null) {
            buffer.write(" ");
            buffer.write("archive");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getArchive())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "object", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "object", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (fetchhint_ != null) {
            buffer.print(" ");
            buffer.print("fetchhint");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.print("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.print(" ");
            buffer.print("fetchtimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.print("\"");
        }
        if (maxage_ != null) {
            buffer.print(" ");
            buffer.print("maxage");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.print("\"");
        }
        if (maxstale_ != null) {
            buffer.print(" ");
            buffer.print("maxstale");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.print("\"");
        }
        if (classid_ != null) {
            buffer.print(" ");
            buffer.print("classid");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getClassid())));
            buffer.print("\"");
        }
        if (codebase_ != null) {
            buffer.print(" ");
            buffer.print("codebase");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCodebase())));
            buffer.print("\"");
        }
        if (data_ != null) {
            buffer.print(" ");
            buffer.print("data");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getData())));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" ");
            buffer.print("type");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }
        if (codetype_ != null) {
            buffer.print(" ");
            buffer.print("codetype");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCodetype())));
            buffer.print("\"");
        }
        if (archive_ != null) {
            buffer.print(" ");
            buffer.print("archive");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getArchive())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlObjectMixed value = (IVxmlObjectMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "object", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchhintAsString() {
        return (URelaxer.getString(getFetchhint()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchtimeoutAsString() {
        return (URelaxer.getString(getFetchtimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxageAsString() {
        return (URelaxer.getString(getMaxage()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxstaleAsString() {
        return (URelaxer.getString(getMaxstale()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getClassidAsString() {
        return (URelaxer.getString(getClassid()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCodebaseAsString() {
        return (URelaxer.getString(getCodebase()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDataAsString() {
        return (URelaxer.getString(getData()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCodetypeAsString() {
        return (URelaxer.getString(getCodetype()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getArchiveAsString() {
        return (URelaxer.getString(getArchive()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchhintByString(String string) {
        setFetchhint(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchtimeoutByString(String string) {
        setFetchtimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxageByString(String string) {
        setMaxage(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxstaleByString(String string) {
        setMaxstale(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setClassidByString(String string) {
        setClassid(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCodebaseByString(String string) {
        setCodebase(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDataByString(String string) {
        setData(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCodetypeByString(String string) {
        setCodetype(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setArchiveByString(String string) {
        setArchive(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlObject</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "object")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPrompt.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParam.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlFilled.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlObject</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlObject</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
