package galatea.agent;

import galatea.util.HashArray;
import galatea.util.Property;
import galatea.util.Util;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;

public class AgentUtil {

	static void loadConfigFile(String conf) 
	{
    	File conffile = new File(conf);
    	if(conffile.canRead()) {
            try {
                Properties props = new Properties(System.getProperties());
                props.load(new FileInputStream(conffile));
                System.setProperties(props);
            } catch(Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
    	}
	}
	
	static HashArray loadAgents() 
	{
		HashArray agents = new HashArray();
        int nagent = Property.getAsInt("Behavior.NumAgent", 3);
        for (int i = 0; i < nagent; i++) {
            String key;
            key = "Behavior.Agent." + (i+1);
            String str = Property.getAsStr(key, "woman01 woman01 female01 bg01 1.0");
            List<String> v = Util.makeTokenizedList(str, " ");
            double d = Double.parseDouble((String)v.get(4));
            agents.put
                ((String)v.get(0), 
                 new Agent((String)v.get(1), (String)v.get(2), (String)v.get(3), d));
        }
        return agents;
	}

	static String getDefaultAgent()
	{
		return Property.getAsStr("Behavior.DefaultAgent", "woman01");	
	}
	
}
