/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 */

package galatea.agent;

import galatea.util.AMBuffer;
import galatea.util.Util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GalateaBase
{
    protected Pattern pattern1_, pattern2_, pattern3_, pattern4_, pattern4_kyt;
    protected AMBuffer ambuf_;
    protected boolean debug_ = false;
    protected String className = "___";

    public GalateaBase()
    {
        ambuf_ = new AMBuffer(Util.getSystemDefaultCharset()); 
        pattern1_ = Pattern.compile("^From @(\\S+) (\\S+) (\\S+) = (.*)$");
        pattern2_ = Pattern.compile("^(\\S+) (\\S+)$");
        pattern3_ = Pattern.compile("^(\\S+) (\\S+) (\\S+)$");
        pattern4_ = Pattern.compile("^(\\S+) (\\S+) = (.*)$");
        pattern4_kyt = Pattern.compile("^(\\S+) (\\S+) (\\S+) (\\S+)$");
    }

    public void setClassName(String n)
    {
    	className = n;
    }

    public void debugPrint(String string) {
        if (debug_) {
	    	System.err.println(className + ": " + string);
	    	System.err.flush();
        }
    }

    public void send(String str)
    {
        ambuf_.send(str);
       	debugPrint("send: " + str);
    }

    public void sleep(int millisec)
    {
        try {
            Thread.sleep(millisec);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void iteration()
    {
        sleep(1);
        String str = ambuf_.receive();
        if (str.length() > 0) {
            debugPrint("receive: " + str);
            
            // ^From @(\\S+) (\\S+) (\\S+) = (.*)$
            Matcher matcher1 = pattern1_.matcher(str);
            if (matcher1.matches()) {
                String module = matcher1.group(1);
                String cmd    = matcher1.group(2);
                String slot   = matcher1.group(3);
                String arg    = matcher1.group(4);
                debugPrint("match: " + module + " " + slot + " " + cmd + " " + arg);
                if (cmd.equals("set")) {
                    debugPrint("set: " + module + " " + slot + " " + arg);
                    handleSet(module, slot, arg);
                } else if (cmd.equals("rep")) {
                    debugPrint("rep: " + module + " " + slot + " " + arg);
                    handleRep(module, slot, arg);
                } else if (cmd.equals("tell")) {
                    debugPrint("tell: " + module + " " + slot + " " + arg);
                    handleTell(module, slot, arg);
                }
            }

            // ^(\\S+) (\\S+) = (.*)$
            Matcher matcher4 = pattern4_.matcher(str);
            if (matcher4.matches()) {
                String module = "___";
                String cmd    = matcher4.group(1);
                String slot   = matcher4.group(2);
                String arg    = matcher4.group(3);
                if (cmd.equals("set")) {
                    debugPrint("set: " + module + " " + slot + " " + arg);
                    handleSet(module, slot, arg);
                }
            }
        }
    }

    public void handleSet(String module, String slot, String arg)
    {
    }

    public void handleRep(String module, String slot, String arg)
    {
    }

    public void handleTell(String module, String slot, String arg)
    {
    }

    public void run()
    {
        send("rep Status.power = ON");
        while (true) {
            iteration();
        }
    }


}
