package galatea.agent;

import galatea.util.Getopt;
import galatea.util.HashArray;
import galatea.util.Util;

import java.util.ArrayList;

public class MacroCommandLayer extends GalateaBase {
    private int state = 0;
    // sequence for Speak
    //   state0 : IDLE
    //   state1 : wait FSM/SSM "rep Speak.stat = READY"
    //   state2 : wait FSM/SSM "rep Speak.stat = IDLE"
    // sequence for MouthMove
    //   state0 : IDLE
    //   state3 : wait FSM     "rep Speak.stat = READY"
    //   state4 : wait FSM     "rep Speak.stat = IDLE"
    private boolean ready_ssm = false;
    private boolean ready_fsm = false;
    private HashArray agents_;
    private String currAgent_;

    public MacroCommandLayer()
    {
    	super();
        currAgent_ = AgentUtil.getDefaultAgent();
        agents_ = AgentUtil.loadAgents();
    }
    
	public void handleRep(String module, String slot, String arg)
    {
    	switch(state) {
    	case 0:
    		break;
    	case 1:
    		handleRepOnState1(module, slot, arg);
    		break;
    	case 2:
    		handleRepOnState2(module, slot, arg);
    		break;
    	case 3:
    		handleRepOnState3(module, slot, arg);
    		break;
    	case 4:
    		handleRepOnState4(module, slot, arg);
    		break;
    	}
    }

    private void handleRepOnState1(String module, String slot, String arg) 
    {
    	if (module.equals("SSM")) {
    		if (slot.equals("Speak.pho")) {
    			String phones = arg.replaceAll("\\[", " ").replaceAll("\\]", "");
    			send("to @FSM set LipSync.pho = " + phones);
    			send("to @FSM inq Speak.stat");
    		} else if (slot.equals("Speak.stat")) {
    			if (arg.equals("READY")) {
    				ready_ssm = true;
    			} else if (arg.equals("READY")) {
    				ready_ssm = false;
    				ready_fsm = false;
    			}
    		}
    	} else if (module.equals("FSM")) {
    		if (slot.equals("Speak.stat")) {
				if (arg.equals("READY")) {
					ready_fsm = true;
				} else if (arg.equals("ERROR")) {
					ready_ssm = false;
					ready_fsm = false;
				}
			}
    	}
    	if (ready_fsm && ready_ssm) {
    		state = 2;
    		send("to @SSM set Speak = + 0");
    		send("to @FSM set Speak = + 0");
    	}
	}

	private void handleRepOnState2(String module, String slot, String arg) 
	{
    	if (module.equals("SSM")) {
    		if (slot.equals("Speak.stat")) {
    			if (arg.equals("IDLE")) {
    				ready_ssm = false;
    			}
    		}
    	} else if (module.equals("FSM")) {
    		if (slot.equals("Speak.stat")) {
    			if (arg.equals("IDLE")) {
    				ready_fsm = false;
    			}
    		}
    	}
    	if (ready_fsm == false && ready_ssm == false) {
    		state = 0;
    	}
	}

	private void handleRepOnState3(String module, String slot, String arg) 
	{
		if (module.equals("FSM")) {
			if (slot.equals("Speak.stat")) {
				if (arg.equals("READY")) {
					state = 4;
					ready_ssm = false;
					ready_fsm = true;
					send("to FSM set Speak = + 0");
				} else if (arg.equals("ERROR")) {
					state = 0;
					ready_ssm = false;
					ready_fsm = false;
				}
			}
		}
	}

	private void handleRepOnState4(String module, String slot, String arg) 
	{
		if (module.equals("FSM")) {
			if (slot.equals("Speak.stat")) {
				if (arg.equals("IDLE")) {
					state = 0;
					ready_fsm = false;
				}
			}
		}
	}

    public void handleSet(String module, String slot, String arg)
    {
    	if (slot.equals("Speak")) {
    		doSetSpeak(arg);
    	} else if (slot.equals("Mask")) {
    		doSetMask(arg);
    	} else if (slot.equals("MoveMouth")) {
    		if (arg.equals("STOP")) {
    			state = 0;
    			send("to @SSMl set Speak = STOP");
    			ready_ssm = false;
    			ready_fsm = false;
    		} else if (arg.startsWith("scale ")) {
    			ArrayList<String> a = Util.makeTokenizedList(arg, " ");
    			if (a.size() == 2) {
    				state = 3;
    				send("to @FSM set MouthScale = " + a.get(0));
    				send("to @FSM set LipSync.pho = " + a.get(1));
    				ready_fsm = false;
    			}
    		} else {
    			state = 3;
				send("to @FSM set LipSync.pho = " + arg);
				ready_fsm = false;
    		}
    	} else if (slot.equals("SpeakSpeed")) {
    		Agent g = (Agent)agents_.get(currAgent_);
    		g.setSpeakSpeed(Float.parseFloat(arg));
    	} else if (slot.equals("AutoMove")) {
    		send("to @FS-MCL set AutoMove = " + arg);
    	} else if (slot.equals("AutoGaze")) {
    		//
    	} else if (slot.equals("Emotion")) {
    		//
    	} else if (slot.equals("AutoEmotionSpeak")) {
    		//
    	}
    }

    private void doSetSpeak(String arg) {
    	if (arg.equals("STOP")) {
    		state = 0;
    		send("to @FSM set Speak = STOP");
    		send("to @SSM set Speak = STOP");
    		ready_ssm = false;
    		ready_fsm = false;
    	} else {
    		if (state != 0) {
        		send("to @FSM set Speak = STOP");
        		send("to @SSM set Speak = STOP");
    		}
    		state = 1;
    		send("to @FSM prop Speak.stat = AutoOutput");
    		send("to @SSM prop Speak.stat = AutoOutput");
    		send("to @SSM prop Speak.pho = AutoOutput");
    		send("to @SSM set Text = " + arg);
    	}
	}

    private void doSetMask(String arg) 
    {
    	ArrayList<String> a = Util.makeTokenizedList(arg, " ");
    	switch (a.size()) {
    	case 6:
    	    send("to @FS-MCL set Mask = " + a.get(0));
    	    send("to @FS-MCL set EmotionNow = " + a.get(1) + " " + a.get(2));
    	    send("to @FS-MCL set RotNow = " + a.get(3) + " " + a.get(4) + " " + a.get(5));
    	    if (!currAgent_.equals(a.get(0))) {
    	    	currAgent_ = a.get(0);
    	    	send("to @SSM set Speaker = " + getCurrSpeaker());
    	    }
    		break;
    	case 3:
    		if (! currAgent_.equals(a.get(0))) {
    			currAgent_ = a.get(0);
    			send("to @SSM set Speaker = " + getCurrSpeaker());
    		}
    	    send("to @FS-MCL set Mask = " + a.get(0));
    	    send("to @FS-MCL set EmotionNow = " + a.get(1) + " " + a.get(2));
    		break;
    	case 2:
    		if (! currAgent_.equals(a.get(0))) {
    			currAgent_ = a.get(0);
    			send("to @SSM set Speaker = " + getCurrSpeaker());
    		}
    	    send("to @FS-MCL set Mask = " + a.get(0));
    	    send("to @FS-MCL set EmotionNow = " + a.get(1));
    		break;
    	case 1:
    		if (! currAgent_.equals(a.get(0))) {
    			currAgent_ = a.get(0);
    			send("to @SSM set Speaker = " + getCurrSpeaker());
    		}
    	    send("to @FS-MCL set Mask = " + a.get(0));
    		break;
    	}
	}

	private String getCurrSpeaker() {
		Agent a = (Agent)agents_.get(currAgent_);
		return a.getSpeaker();
	}

	public void handleTell(String module, String slot, String arg)
    {
    }
    
    
    public static void main(String argv[])
    {
    	String conf = "gdm.conf";
    	Getopt g = new Getopt("", argv, "c:");
    	g.setOpterr(false);
    	int c;
    	while ((c = g.getopt()) != -1){
            switch (c)	{
            case 'c':
                conf = g.getOptarg();
                break;
            }
    	}
    	AgentUtil.loadConfigFile(conf);
    	MacroCommandLayer m = new MacroCommandLayer();
    	m.run();
    }
}
