package galatea.agent;

import galatea.util.Getopt;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Par extends GalateaBase {
	private int id;
	private ArrayList<String> queue1;
	private Pattern pattern5_;

    public Par()
    {
    	super();
    	id = 0;
    	queue1 = new ArrayList<String>();
        pattern5_ = Pattern.compile("^(\\S+)\\s+(\\S+)$");
        setClassName(this.getClass().getName());
        // debug_ = true;
    }
    
	public void handleRep(String module, String slot, String arg)
    {
		if (module.equals("SSM")) {
			if (slot.equals("Speak.stat") && arg.equals("READY")) {
				debugPrint("SSM Speak.stat -> execQueue()");
				execQueue();
			}
		} else if (module.equals("FSM") && arg.equals("READY")) {
			if (slot.equals("Speak.stat")) {
				debugPrint("FSM Speak.stat -> execQueue()");
				execQueue();
			}
		}
    }

	public void handleTell(String module, String slot, String arg)
    {
		if (module.equals("SND")) {
			if (slot.equals("start")) {
				execQueue();
			}
		}
	}
     
    public void handleSet(String module, String slot, String arg)
    {
    	if (slot.equals("Init")) {
    		debugPrint("par: " + module + " " + slot + " " + arg);
    		try {
    			id = Integer.parseInt(arg);
    		} catch (NumberFormatException e) {
    			id = 0;
    		}
    		queue1 = new ArrayList<String>();
    	} else if (slot.equals("Cmd")) {
    		queue1.add(arg);
    	} else if (slot.equals("Run")) {
    		if (arg.equals("NOW")) {
				debugPrint("Run NOW -> execQueue()");
    			execQueue();
    		}
    	}
    }

    private void execQueue() {
    	assert(id == 1);
    	while (queue1.size() > 0) {
    		String cmd = queue1.remove(0);
    		Matcher matcher5 = pattern5_.matcher(cmd);
    		if (matcher5.matches()) {
	            String left  = matcher5.group(1);
	            String right = matcher5.group(2);
	            if (left.equals("sleep")) {
	            	sleep((int)(Float.parseFloat(right) * 1000.0f));
	            } 
    		} else {
            	send(cmd);
            }
    	}
	}

    public static void main(String argv[])
    {
    	String conf = "gdm.conf";
    	Getopt g = new Getopt("", argv, "c:");
    	g.setOpterr(false);
    	int c;
    	while ((c = g.getopt()) != -1){
            switch (c)	{
            case 'c':
                conf = g.getOptarg();
                break;
            }
    	}
    	AgentUtil.loadConfigFile(conf);
    	Par m = new Par();
    	m.run();
    }
}
