/*
 * Galatea Dialog Studio:
 * (c)2009 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: SetupWindow.java,v 1.4 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.dialog.window;

import galatea.util.SubProcess;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SetupWindow
{
	private void _makeWindow(int width, int height) throws Exception {
		JFrame frame = new JFrame("Galatea Dialog Studio : Setup");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		JPanel mainPanel = new JPanel(new GridBagLayout());
		GridBagConstraints mainPanelConstraints = WindowUtil.initPos();

		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		
		WindowUtil.setPos(c, 0, 4, 1, 1);
		JButton buttonGo = new JButton("test 1"); 
		panel.add(buttonGo, c);
		buttonGo.addActionListener( new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				SubProcess sp = new SubProcess("cat /home/nishi/.bashrc", "/home/nishi");
				if (sp.run() == true) {
					sp.waitForTerminate();
					while (sp.isStdoutReadable()) {
						String s = sp.receiveFromStdoutNB2();
						System.out.println(s);
					}
					System.out.println("[done]");
				}
			}}
		);
		WindowUtil.nextRow(c);
		
		WindowUtil.setPos(c, 0, 4, 1, 1);
		JButton buttonValidate = new JButton("Validate"); 
		panel.add(buttonValidate, c);
		buttonValidate.addActionListener( new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
			}}
		);
		WindowUtil.nextRow(c);
		
		WindowUtil.setPos(mainPanelConstraints, 0, 4, 1, 1); // full width, strech both
		mainPanel.add(panel, mainPanelConstraints);

		frame.getContentPane().add(mainPanel);
		
		frame.setSize(width, height);
		frame.setVisible(true);
	}

	public SetupWindow() {
		try {
			WindowUtil.setLookAndFeel();
			_makeWindow(640, 480);
		} catch(Exception e) { 
			System.out.println(e); 
		}
	}
	
	public static void main(String args[]) throws Exception {
		SetupWindow w = new SetupWindow();
	}

}

