/*
 * Galatea Dialog Manager:
 * (c)2003-2004 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AMThread.java,v 1.5 2009/03/07 14:16:12 nishimoto Exp $
 */
package galatea.io;

import galatea.dialog.ISystemEventLogger;
import galatea.io.julius.JuliusSubModule;
import galatea.logger.Logger;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;
import galatea.util.AMBuffer;
import galatea.util.Util;

import java.util.ArrayList;

public class AMThread extends Thread implements ISenderToDevice
{
	private int runLevel_ = 0;
	
	private Logger logger_ = new Logger(this.getClass());
	private AMBuffer ambuf_;
	private ArrayList<ISubModule> subModules_ = new ArrayList<ISubModule>(); 

	public AMThread() {
		setName("AMThread");
		ambuf_ = new AMBuffer(Util.getSystemDefaultCharset());
		outputNative("rep Run = POWEROFF");
		logger_.print("rep Run = POWEROFF");
	}
	
	public void addSubModule(ISubModule s, 
			IReceiverFromSubModule r, ISystemEventLogger l) {
		subModules_.add(s);
		s.setSender(this);
		s.setReceiver(r);
		s.setLogger(l);
	}
	
	public void outputNative(String str) {
		// 仮想サブモジュールを実装する
		// 例えば to @SIM set DialogName & SlotAlias を監視する
		for (int i = 0, n = subModules_.size(); i < n; i++) {
			ISubModule s = subModules_.get(i);
			if ( s != null && s.filterOutputNative(str) == true) 
				return;
		}
		ambuf_.send(str);
	}
	
	/**
	 *  returns
	 *  true  : repeat
	 *  false : quit 
	 */
	private synchronized boolean _iteration() {
		String str = ambuf_.receive();
		logger_.ASSERT(str != null, "AMT str != null");
		if ( str.length() == 0 ) {
			// dbg.print("AMT received nothing");
			return true;
		}
		logger_.print(str);
		for (int i = 0; i < subModules_.size(); i++) {
			ISubModule s = subModules_.get(i);
			if ( s != null && s.receiveFromDevice(str) == true) 
				return true;
		}
		return true;
	}

	// implements ISenderToDevice
	public void send(String msg) {
		ambuf_.send(msg);
	}
	
	// implements Runnable
	public void run()
	{
//		String s = System.getProperty("AMThread.StartupWait", "0");
//		dbg.print("AMThread.StartupWait:" + s);
//		int waitms = (int)(Double.parseDouble(s) * 1000.0);
//		try { 
//			Thread.sleep(waitms);
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
		while(_iteration()) {
			try { 
				Thread.sleep(1, 0);
			} catch (Exception e) {e.printStackTrace();}
		}
	}

	public ArrayList<ISubModule> getSubModules() {
		return subModules_;
	}

	public void setPauseMode(boolean b) {
		logger_.print("setPauseMode " + Boolean.toString(b));
		for (ISubModule i : subModules_) {
			if (i instanceof JuliusSubModule) {
				JuliusSubModule j = (JuliusSubModule)i;
				j.setPauseMode(b);
			}
		}
	}

}
