/*
 * $Id: KeypadWindow.java,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
 */


package galatea.io.plugins;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KeypadWindow {
	
	private JLabel label_ = null;
	private JFrame frame_;
	private String text_;
	
	private void _makeWindow() throws Exception {
		frame_ = new JFrame("Keypad");
		frame_.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints constraints = new GridBagConstraints();
		
		constraints.anchor = GridBagConstraints.NORTH;
		constraints.fill = GridBagConstraints.BOTH;
		constraints.insets = new Insets(3, 5, 3, 5); // fixme
		constraints.weightx = 1;
		
		constraints.gridy = 0;
		constraints.gridwidth = 2; // fixme
		constraints.gridx = 0;
		constraints.weightx = 1;
		label_ = new JLabel();
		panel.add(label_, constraints);
		
		frame_.getContentPane().add(panel);
		
		frame_.setSize(400, 60);
		frame_.setVisible(true);
	}
	
	
	public KeypadWindow(KeyListener kl) {
		try {
			_makeWindow();
			clearInputText();
			frame_.addKeyListener(kl);
		} catch(Exception e) { 
			System.out.println(e); 
		}
	}
	
	public int getInputLength() {
		return text_.length();
	}

	public String getInputText() {
		return text_;
	}

	public void clearInputText() {
		text_ = ""; 
		label_.setText(text_);
	}
	
	public void addChar(char keyChar) {
		text_ += keyChar;
		label_.setText(text_);
	}
	
	public static void main(String args[]) throws Exception
	{
		KeypadWindow kw = new KeypadWindow(new KeyListener() {
			public void keyTyped(KeyEvent e) {
				System.out.println(e.paramString());
			}
			public void keyPressed(KeyEvent e) {
			}
			public void keyReleased(KeyEvent e) {
			}
		});
	}



}

