/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class RetargetedInnerClassAttributeRemover
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private boolean retargeted;

    public void visitProgramClass(ProgramClass programClass) {
        int n;
        int n2 = programClass.u2attributesCount;
        Attribute[] attributeArray = programClass.attributes;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Attribute attribute = attributeArray[n];
            this.retargeted = false;
            attribute.accept(programClass, this);
            if (this.retargeted) continue;
            attributeArray[n3++] = attribute;
        }
        for (n = n3; n < n2; ++n) {
            attributeArray[n] = null;
        }
        programClass.u2attributesCount = n3;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.checkTarget(clazz);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.checkTarget(clazz);
        this.checkTarget(enclosingMethodAttribute.referencedClass);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.checkTarget(classConstant.referencedClass);
    }

    private void checkTarget(Clazz clazz) {
        if (clazz != null && ClassMerger.getTargetClass(clazz) != null) {
            this.retargeted = true;
        }
    }
}

