/* Purpose: create a player character */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"

/*
 * How often the autoroller will update the display and pause
 * to check for user interuptions.
 * Bigger values will make the autoroller faster, but slower
 * system may have problems because the user can't stop the
 * autoroller for this number of rolls.
 */
#define AUTOROLLER_STEP		25L

/*
 * Define this to cut down processor use while autorolling
 */
/*#define AUTOROLLER_DELAY*/

/*
 * Maximum number of tries for selection of a proper quest monster
 */
#define MAX_TRIES 100

#define MAX_CLASS_CHOICE     MAX_CLASS

/*
 * Forward declare
 */
typedef struct birther birther;

/*
 * A structure to hold "rolled" information
 */
struct birther
{
	s16b age;
	s16b wt;
	s16b ht;
	s16b sc;

	s32b au;

	s16b stat[6];
	s16b hp[50];

	s16b chaos_patron;

	char history[4][60];
};



/*
 * The last character displayed
 */
static birther prev;



/*
 * Forward declare
 */
typedef struct hist_type hist_type;

/*
 * Player background information
 */
struct hist_type
{
	cptr info;			    /* Textual History */

	byte roll;			    /* Frequency of this entry */
	byte chart;			    /* Chart index */
	byte next;			    /* Next chart index */
	byte bonus;			    /* Social Class Bonus + 50 */
};


/*
 * Background information (see below)
 *
 * Chart progression by race:
 *   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56
 *   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61
 *   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66
 *
 * XXX XXX XXX This table *must* be correct or drastic errors may occur!
 */
static hist_type bg[] =
{
#ifdef JP
	{"ʢλҤǧΤ餵Ƥޤ",			 10, 2, 3, 25},
	{"ʢλҤǤǧΤϤƤޤ",			 20, 2, 3, 35},
	{"ͤλҶΤΰͤǤ",			 95, 2, 3, 45},
	{"ĹҤǤ",						100, 2, 3, 50},
#else
	{"You are the illegitimate and unacknowledged child ",   10, 1, 2, 25},
	{"You are the illegitimate but acknowledged child ",     20, 1, 2, 35},
	{"You are one of several children ",                     95, 1, 2, 45},
	{"You are the first child ",                            100, 1, 2, 50},
#endif


#ifdef JP
	{"ʤۤ",					 40, 1, 2, 65},
	{"ʤϼ",					 65, 1, 2, 80},
	{"ʤĮͤ",					 80, 1, 2, 90},
	{"ʤϿͤ",					 90, 1, 2,105},
	{"ʤεΤ",				 96, 1, 2,120},
	{"ʤϺ٤εμ̤߰뵮²",				 99, 1, 2,130},
	{"ʤϥСβȤηԤ",				100, 1, 2,140},
#else
	{"of a Serf.  ",                                         40, 2, 3, 65},
	{"of a Yeoman.  ",                                       65, 2, 3, 80},
	{"of a Townsman.  ",                                     80, 2, 3, 90},
	{"of a Guildsman.  ",                                    90, 2, 3, 105},
	{"of a Landed Knight.  ",                                96, 2, 3, 120},
	{"of a Noble Family in the Courts of Chaos.  ",          99, 2, 3, 130},
	{"of the Royal Blood Line of Amber.  ",                 100, 2, 3, 140},
#endif


#ifdef JP
	{"ʤϰȤΤʪǤ",				 20, 3,50, 20},
	{"ʤϰȤθؤǤ",				 80, 3,50, 55},
	{"ʤϲ²ڤˤƤޤ",			100, 3,50, 60},
#else
	{"You are the black sheep of the family.  ",             20, 3, 50, 20},
	{"You are a credit to the family.  ",                    80, 3, 50, 55},
	{"You are a well liked child.  ",                       100, 3, 50, 60},
#endif


#ifdef JP
	{"ʤϥƥ²ΥդǤ",		 40, 4, 1, 50},
	{"ʤϥƥ²ΥդǤ",		 75, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 90, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 95, 4, 1, 60},
	{"ʤϥ䡼²ΥդǤ",		 98, 4, 1, 65},
	{"ʤϥ䡼²ΥդǤ",				100, 4, 1, 70},
#else
	{"Your mother was of the Teleri.  ",			 40, 4, 1, 50},
	{"Your father was of the Teleri.  ",			 75, 4, 1, 55},
	{"Your mother was of the Noldor.  ",		 	 90, 4, 1, 55},
	{"Your father was of the Noldor.  ",		 	 95, 4, 1, 60},
	{"Your mother was of the Vanyar.  ",			 98, 4, 1, 65},
	{"Your father was of the Vanyar.  ",			100, 4, 1, 70},
#endif


#ifdef JP
	{"ͤλҶΤΰͤǤ",			 60, 9, 54, 50},
	{"γǤ",					100, 9, 54, 55},
#else
	{"You are one of several children ",			 60, 7, 8, 50},
	{"You are the only child ",					100, 7, 8, 55},
#endif


#ifdef JP
	{"ʤϥƥ²Υդ",				 75, 7, 8, 50},
	{"ʤϥΥɡ²Υդ",			 95, 7, 8, 55},
	{"ʤϥ䡼²Υդ",			100, 7, 8, 60},
#else
	{"of a Teleri ",						 75, 8, 9, 50},
	{"of a Noldor ",						 95, 8, 9, 55},
	{"of a Vanyar ",						100, 8, 9, 60},
#endif


#ifdef JP
	{"󥸥㡼",					 40, 8,9, 80},
	{"㡼",					 70, 8,9, 90},
	{"Τ",						 87, 8,9,110},
	{"ᥤ",						 95, 8,9,125},
	{"Ҥ",						 99, 8,9,140},
	{"",						100, 8,9,145},
#else
	{"Ranger.  ",						 40, 9, 54, 80},
	{"Archer.  ",						 70, 9, 54, 90},
	{"Warrior.  ",						 87, 9, 54, 110},
	{"Mage.  ",							 95, 9, 54, 125},
	{"Prince.  ",						 99, 9, 54, 140},
	{"King.  ",							100, 9, 54, 145},
#endif


#ifdef JP
	{"ۥӥåȤβͤλҶΤΰͤǤ",		 85,11,3, 45},
	{"ۥӥåȤΰγǤ",			        100,11,3, 55},
#else
	{"You are one of several children of a Hobbit ",		 85, 10, 11, 45},
	{"You are the only child of a Hobbit ",		        100, 10, 11, 55},
#endif


#ifdef JP
	{"ʤϸ𿩤",							 20,10,11, 55},
	{"ʤϼŹ",						 30,10,11, 80},
	{"ʤʴ",							 40,10,11, 90},
	{"ʤϲȼ",							 50,10,11,100},
	{"ʤǦӤμԤ",							 80,10,11,110},
	{"ʤΤ",							 95,10,11,115},
	{"ʤϥᥤ",							 99,10,11,125},
	{"ʤϰ²Ĺ",							100,10,11,140},
#else
	{"Bum.  ",							 20, 11, 3, 55},
	{"Tavern Owner.  ",						 30, 11, 3, 80},
	{"Miller.  ",						 40, 11, 3, 90},
	{"Home Owner.  ",						 50, 11, 3, 100},
	{"Burglar.  ",						 80, 11, 3, 110},
	{"Warrior.  ",						 95, 11, 3, 115},
	{"Mage.  ",							 99, 11, 3, 125},
	{"Clan Elder.  ",						100, 11, 3, 140},
#endif


#ifdef JP
	{"ΡδͤλҶΤΰͤǤ",		 85,14,3, 45},
	{"ΡΰγǤ",			        100,14,3, 55},
#else
	{"You are one of several children of a Gnome ",		 85, 13, 14, 45},
	{"You are the only child of a Gnome ",			100, 13, 14, 55},
#endif


#ifdef JP
	{"ʤʪ𤤤",							 20,13,14, 55},
	{"ʤϥۥ᤭",							 50,13,14, 70},
	{"ʤϤĴҼԤ",							 75,13,14, 85},
	{"ʤΤ",							 95,13,14,100},
	{"ʤϥᥤ",							100,13,14,125},
#else
	{"Beggar.  ",						 20, 14, 3, 55},
	{"Braggart.  ",						 50, 14, 3, 70},
	{"Prankster.  ",						 75, 14, 3, 85},
	{"Warrior.  ",						 95, 14, 3, 100},
	{"Mage.  ",							100, 14, 3, 125},
#endif


#ifdef JP
	{"ɥդͤλҶΤΰͤǤ",		 25,17,18, 40},
	{"ɥդΰγǤ",			        100,17,18, 50},
#else
	{"You are one of two children of a Dwarven ",		 25, 16, 17, 40},
	{"You are the only child of a Dwarven ",			100, 16, 17, 50},
#endif


#ifdef JP
	{"ʤť",							 10,16,17, 60},
	{"ʤϴ֤",							 25,16,17, 75},
	{"ʤϹפ",							 75,16,17, 90},
	{"ʤΤ",							 90,16,17,110},
	{"ʤϥץ꡼Ȥ",					 99,16,17,130},
	{"ʤϲ",							100,16,17,150},
#else
	{"Thief.  ",						 10, 17, 18, 60},
	{"Prison Guard.  ",						 25, 17, 18, 75},
	{"Miner.  ",						 75, 17, 18, 90},
	{"Warrior.  ",						 90, 17, 18, 110},
	{"Priest.  ",						 99, 17, 18, 130},
	{"King.  ",							100, 17, 18, 150},
#endif


#ifdef JP
	{"ʤϰȤΤʪǤ",						 15,18,57,10},
	{"ʤϰȤθؤǤ",						 85,18,57, 50},
	{"ʤϲ²ڤˤƤޤ",				100,18,57, 55},
#else
	{"You are the black sheep of the family.  ",		 15, 18, 57, 10},
	{"You are a credit to the family.  ",			 85, 18, 57, 50},
	{"You are a well liked child.  ",				100, 18, 57, 55},
#endif


#ifdef JP
	{"ʤϥǤ̩ˤƤޤ",	 25,19,20, 25},
	{"ʤϥǤ̩ˤƤޤ",	100,19,20, 25},
#else
	{"Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25},
	{"Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25},
#endif


#ifdef JP
	{"ʤܻۤҤǤ",						 40,20, 3, 65},
	{"ʤϼܻҤǤ",						 65,20, 3, 80},
	{"ʤĮܻͤҤǤ",						 80,20, 3, 90},
	{"ʤϿܻͤҤǤ",						 90,20, 3,105},
	{"ʤεΤܻҤǤ",					 96,20, 3,120},
	{"ʤϼ̤߰뵮²ܻҤǤ",				 99,20, 3,130},
	{"ʤϲȤηԤܻҤǤ",			100,20, 3,140},
#else
	{"You are the adopted child ",				100, 20, 2, 50},
#endif


#ifdef JP
	{"ʤƶȥ",				 30,22,23, 20},
	{"ʤƶȥ",				 60,22,23, 25},
	{"ʤϵ֥ȥ",					 75,22,23, 30},
	{"ʤϵ֥ȥ",					 90,22,23, 35},
	{"ʤϿȥ",					 95,22,23, 40},
	{"ʤϿȥ",					100,22,23, 45},
#else
	{"Your mother was a Cave-Troll ",				 30, 22, 23, 20},
	{"Your father was a Cave-Troll ",				 60, 22, 23, 25},
	{"Your mother was a Hill-Troll ",				 75, 22, 23, 30},
	{"Your father was a Hill-Troll ",				 90, 22, 23, 35},
	{"Your mother was a Water-Troll ",				 95, 22, 23, 40},
	{"Your father was a Water-Troll ",				100, 22, 23, 45},
#endif


#ifdef JP
	{"åǤ",							  5,23,62, 60},
	{"ΤǤ",							 95,23,62, 55},
	{"ѻդǤ",							 99,23,62, 65},
	{"²ĹǤ",						100,23,62, 80},
#else
	{"Cook.  ",							  5, 23, 62, 60},
	{"Warrior.  ",						 95, 23, 62, 55},
	{"Shaman.  ",						 99, 23, 62, 65},
	{"Clan Chief.  ",						100, 23, 62, 80},
#endif


#ifdef JP
	{"ʤϿ֥饦Ʒ",				 20,50,51, 50},
	{"ʤϥ֥饦Ʒ",					 60,50,51, 50},
	{"ʤøƷ",					 70,50,51, 50},
	{"ʤϥ꡼Ʒ",					 80,50,51, 50},
	{"ʤĤƷ",						 90,50,51, 50},
	{"ʤϥ֥롼쥤Ʒ",				100,50,51, 50},
#else
	{"You have dark brown eyes, ",				 20, 50, 51, 50},
	{"You have brown eyes, ",					 60, 50, 51, 50},
	{"You have hazel eyes, ",					 70, 50, 51, 50},
	{"You have green eyes, ",					 80, 50, 51, 50},
	{"You have blue eyes, ",					 90, 50, 51, 50},
	{"You have blue-gray eyes, ",				100, 50, 51, 50},
#endif


#ifdef JP
	{"ʤ餫",							 70,51,52, 50},
	{"Ǥä",							 90,51,52, 50},
	{"뤷",							100,51,52, 50},
#else
	{"straight ",						 70, 51, 52, 50},
	{"wavy ",							 90, 51, 52, 50},
	{"curly ",							100, 51, 52, 50},
#endif


#ifdef JP
	{"ȱ",						 30,52,53, 50},
	{"ȱ",						 70,52,53, 50},
	{"Ȥӿȱ",					 80,52,53, 50},
	{"֤ȱ",						 90,52,53, 50},
	{"֥ɤȱ",				100,52,53, 50},
#else
	{"black hair, ",						 30, 52, 53, 50},
	{"brown hair, ",						 70, 52, 53, 50},
	{"auburn hair, ",						 80, 52, 53, 50},
	{"red hair, ",						 90, 52, 53, 50},
	{"blond hair, ",						100, 52, 53, 50},
#endif


#ifdef JP
	{"ȩ򤷤Ƥޤ",					 10,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 30,53, 0, 50},
	{"̤ȩ򤷤Ƥޤ",				 80,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 90,53, 0, 50},
	{"Ʃ̤褦ȩ򤷤Ƥޤ",		100,53, 0, 50},
#else
	{"and a very dark complexion.",				 10, 53, 0, 50},
	{"and a dark complexion.",					 30, 53, 0, 50},
	{"and an average complexion.",				 80, 53, 0, 50},
	{"and a fair complexion.",					 90, 53, 0, 50},
	{"and a very fair complexion.",				100, 53, 0, 50},
#endif


#ifdef JP
	{"ʤ뤤졼Ʒ",					 85,54,55, 50},
	{"ʤ뤤֥롼Ʒ",					 95,54,55, 50},
	{"ʤ뤤꡼Ʒ",					100,54,55, 50},
#else
	{"You have light grey eyes, ",				 85, 54, 55, 50},
	{"You have light blue eyes, ",				 95, 54, 55, 50},
	{"You have light green eyes, ",				100, 54, 55, 50},
#endif


#ifdef JP
	{"ʤ餫",							 75,55,56, 50},
	{"Ǥä",							100,55,56, 50},
#else
	{"straight ",						 75, 55, 56, 50},
	{"wavy ",							100, 55, 56, 50},
#endif


#ifdef JP
	{"ȱȩ򤷤Ƥޤ",				 75,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				 85,56, 0, 50},
	{"֥ɤȱȩ򤷤Ƥޤ",				 95,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				100,56, 0, 50},
#else
	{"black hair, and a fair complexion.",			 75, 56, 0, 50},
	{"brown hair, and a fair complexion.",			 85, 56, 0, 50},
	{"blond hair, and a fair complexion.",			 95, 56, 0, 50},
	{"silver hair, and a fair complexion.",			100, 56, 0, 50},
#endif


#ifdef JP
	{"ʤϿ֥饦Ʒ",					 99,57,58, 50},
	{"ʤϵ֤Ʒ",					100,57,58, 60},
#else
	{"You have dark brown eyes, ",				 99, 57, 58, 50},
	{"You have glowing red eyes, ",				100, 57, 58, 60},
#endif


#ifdef JP
	{"ʤ餫",							 90,58,59, 50},
	{"Ǥä",							100,58,59, 50},
#else
	{"straight ",						 90, 58, 59, 50},
	{"wavy ",							100, 58, 59, 50},
#endif


#ifdef JP
	{"ȱ",						 75,59,60, 50},
	{"ȱ",						100,59,60, 50},
#else
	{"black hair, ",						 75, 59, 60, 50},
	{"brown hair, ",						100, 59, 60, 50},
#endif


#ifdef JP
	{" 30cm ۤɤΥҥ",						 25,60,61, 50},
	{" 60cm ۤɤΥҥ",						 60,60,61, 51},
	{" 90cm ۤɤΥҥ",					 90,60,61, 53},
	{" 1m20cm ۤɤΥҥ ",						100,60,61, 55},
#else
	{"a one foot beard, ",					 25, 60, 61, 50},
	{"a two foot beard, ",					 60, 60, 61, 51},
	{"a three foot beard, ",					 90, 60, 61, 53},
	{"a four foot beard, ",					100, 60, 61, 55},
#endif


#ifdef JP
	{"ȩ򤷤Ƥޤ",					100,61, 0, 50},
#else
	{"and a dark complexion.",					100, 61, 0, 50},
#endif


#ifdef JP
	{"ʤϥ٥ȤĤ褦ФƷ",					 60,62,63, 50},
	{"ʤϱʪΤ褦ʲƷ",					 85,62,63, 50},
	{"ʤĤäƷ",				 99,62,63, 50},
	{"ʤϵ֤Ʒ",					100,62,63, 55},
#else
	{"You have slime green eyes, ",				 60, 62, 63, 50},
	{"You have puke yellow eyes, ",				 85, 62, 63, 50},
	{"You have blue-bloodshot eyes, ",				 99, 62, 63, 50},
	{"You have glowing red eyes, ",				100, 62, 63, 55},
#endif


#ifdef JP
	{"餷",							 33,63,64, 50},
	{"Է",							 66,63,64, 50},
	{"餮ä",							100,63,64, 50},
#else
	{"dirty ",							 33, 63, 64, 50},
	{"mangy ",							 66, 63, 64, 50},
	{"oily ",							100, 63, 64, 50},
#endif


#ifdef JP
	{"參ͤȱ",					 33,64,65, 50},
	{"뤤ֿȱ",						 66,64,65, 50},
	{"Ť翧ȱ",						100,64,65, 50},
#else
	{"sea-weed green hair, ",					 33, 64, 65, 50},
	{"bright red hair, ",					 66, 64, 65, 50},
	{"dark purple hair, ",					100, 64, 65, 50},
#endif


#ifdef JP
	{"п",							 25,65,66, 50},
	{"Ĥ",							 50,65,66, 50},
	{"",							 75,65,66, 50},
	{"",							100,65,66, 50},
#else
	{"and green ",						 25, 65, 66, 50},
	{"and blue ",						 50, 65, 66, 50},
	{"and white ",						 75, 65, 66, 50},
	{"and black ",						100, 65, 66, 50},
#endif


#ifdef JP
	{"֥ĥ֥Ĥȩ򤷤Ƥޤ",						 33,66, 0, 50},
	{"֥餱ȩ򤷤Ƥޤ",						 66,66, 0, 50},
	{"ȩ򤷤Ƥޤ",						100,66, 0, 50},
#else
	{"ulcerous skin.",						 33, 66, 0, 50},
	{"scabby skin.",						 66, 66, 0, 50},
	{"leprous skin.",                       100, 66, 0, 50},
#endif


#ifdef JP
	{"ǧΤƤʤҶǤ",          50, 68, 50, 45},
	{"줿ҶǤ",           80, 68, 50, 65},
	{"᤯̤줿ҶǤ",      100, 68, 50, 55},
#else
	{"You are an unacknowledged child of ", 50, 67, 68, 45},
	{"You are a rebel child of ",         80, 67, 68, 65},
	{"You are a long lost child of ",     100, 67, 68, 55},
#endif


#ifdef JP
	{"ʤ̾Τ̥Сβ²",               50, 67, 68, 80 },
	{"ʤ軰ΥС²", 65, 67, 68, 90 },
	{"ʤΥС²", 79, 67, 68, 100 },
	{"ʤϥ٥",       80, 67, 68, 130 },
	{"ʤϥå",        83, 67, 68, 105 },
	{"ʤϥեɡ",       84, 67, 68, 105 },
	{"ʤϥ֥ɤ",        85, 67, 68, 90 },
	{"ʤϥե",        87, 67, 68, 100 },
	{"ʤϥ顼ɤ",       88, 67, 68, 125 },
	{"ʤϥǥɥ",      89, 67, 68, 120 },
	{"ʤϥ",       90, 67, 68, 140 },
	{"ʤϥ٥ͥǥȤ",     91, 67, 68, 115 },
	{"ʤϥ",       92, 67, 68, 110 },
	{"ʤϥꥢ",       93, 67, 68, 105 },
	{"ʤϥ",        94, 67, 68, 95 },
	{"ʤϥ֥쥤",        95, 67, 68, 115 },
	{"ʤϥեʤ",        96, 67, 68, 110 },
	{"ʤϥå",         97, 67, 68, 135 },
	{"ʤϥʥɤ",      98, 67, 68, 90 },
	{"ʤϥޡ",       99, 67, 68, 105 },
	{"ʤϥޡƥ",       100, 67,68, 80 },
#else
	{"an unknown Amberite.  ",               50, 68, 50, 80 },
	{"an unknown third generation Amberite.  ", 65, 68, 50, 90 },
	{"an unknown second generation Amberite.  ", 79, 68, 50, 100 },
	{"Oberon.  ",       80, 68, 50, 130 },
	{"Osric.  ",        83, 68, 50, 105 },
	{"Finndo.  ",       84, 68, 50, 105 },
	{"Brand.  ",        85, 68, 50, 90 },
	{"Flora.  ",        87, 68, 50, 100 },
	{"Gerard.  ",       88, 68, 50, 125 },
	{"Deirdre.  ",      89, 68, 50, 120 },
	{"Random.  ",       90, 68, 50, 140 },
	{"Benedict.  ",     91, 68, 50, 115 },
	{"Corwin.  ",       92, 68, 50, 110 },
	{"Julian.  ",       93, 68, 50, 105 },
	{"Caine.  ",        94, 68, 50, 95 },
	{"Bleys.  ",        95, 68, 50, 115 },
	{"Fiona.  ",        96, 68, 50, 110 },
	{"Eric.  ",         97, 68, 50, 135 },
	{"Rinaldo.  ",      98, 68, 50, 90 },
	{"Merlin.  ",       99, 68, 50, 105 },
	{"Martin.  ",       100, 68, 50, 80 },
#endif



#ifdef JP
	{"ͤλҶΤΰͤǤ",      85, 70, 71, 45},
	{"γǤ",         	 100, 70, 71, 55},

	{"ʤϥդΤ", 50, 69, 70, 60 },
	{"ʤϥդѻΤ", 80, 69, 70, 75 },
	{"ʤϥդε²", 100,  69, 70, 95 },
#else
	{"You are one of several children of a Dark Elven ",      85, 69, 70, 45},
	{"You are the only child of a Dark Elven ",          100, 69, 70, 55},

	{"Warrior.  ", 50, 70, 71, 60 },
	{"Warlock.  ", 80, 70, 71, 75 },
	{"Noble.  ", 100, 70, 71, 95 },
#endif


#ifdef JP
	{"ʤϹƷ", 100, 71, 72, 50},
#else
	{"You have black eyes, ", 100, 71, 72, 50},
#endif


#ifdef JP
	{"ʤ餫",                        70, 72, 73, 50},
	{"Ǥä",                            90, 72, 73, 50},
	{"뤷",                          100, 72, 73, 50},

	{"ȱƤȤƤŤȩ򤷤Ƥޤ", 100, 73, 0, 50 },
#else
	{"straight ",                        70, 72, 73, 50},
	{"wavy ",                            90, 72, 73, 50},
	{"curly ",                          100, 72, 73, 50},

	{"black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif


#ifdef JP
	{"ʤƤϥǤ̩ˤƤޤ", 25, 74, 20, 25},
	{"ʤƤϥǤ̩ˤƤޤ", 100, 74, 20, 25},
#else
	{"Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25},
	{"Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25},
#endif


#ifdef JP
	{"ʤƤϵ֥㥤ȤǤ", 10, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ", 12, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ", 20, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ", 23, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 25, 75, 20, 70},
	{"ʤƤϵ֥㥤ȤǤ",  60, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ",  70, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ",  80, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ",  90, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 100, 75, 20, 70},
#else
	{"Your mother was a Hill Giant.  ", 10, 75, 20, 50},
	{"Your mother was a Fire Giant.  ", 12, 75, 20, 55},
	{"Your mother was a Frost Giant.  ", 20, 75, 20, 60},
	{"Your mother was a Cloud Giant.  ", 23, 75, 20, 65},
	{"Your mother was a Storm Giant.  ", 25, 75, 20, 70},
	{"Your father was a Hill Giant.  ",  60, 75, 20, 50},
	{"Your father was a Fire Giant.  ",  70, 75, 20, 55},
	{"Your father was a Frost Giant.  ",  80, 75, 20, 60},
	{"Your father was a Cloud Giant.  ",  90, 75, 20, 65},
	{"Your father was a Storm Giant.  ", 100, 75, 20, 70},
#endif


#ifdef JP
	{"ʤƤ̾Τ̥Ǥ", 75, 76, 20, 50 },
	{"ʤƤϥƥߥǤ",        80, 76, 20, 100 },
	{"ʤƤϥΥǤ",     85, 76, 20, 100 },
	{"ʤƤϥΥǤ",      90, 76, 20, 100 },
	{"ʤƤϥꥦǤ",         95, 76, 20, 100 },
	{"ʤƤϥϥڥꥪǤ",      98, 76, 20, 125 },
	{"ʤƤϥΥǤ",       100, 76, 20, 150 },
#else
	{"Your father was an unknown Titan.  ", 75, 76, 20, 50 },
	{"Your mother was Themis.  ",        80, 76, 20, 100 },
	{"Your mother was Mnemosyne.  ",     85, 76, 20, 100 },
	{"Your father was Okeanoas.  ",      90, 76, 20, 100 },
	{"Your father was Crius.  ",         95, 76, 20, 100 },
	{"Your father was Hyperion.  ",      98, 76, 20, 125 },
	{"Your father was Kronos.  ",       100, 76, 20, 150 },
#endif


#ifdef JP
	{"ʤ̾Τ̥ץλ¹Ǥ", 90, 77, 109, 50 },
	{"ʤϥݥե⥹λҶǤ", 98, 77, 109, 80 },
	{"ʤϥΥλҶǤ", 100, 77, 109, 135 },
#else
	{"You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
	{"You are Polyphemos's child.  ", 98, 77, 109, 80 },
	{"You are Uranos's child.  ", 100, 77, 109, 135 },
#endif


#ifdef JP
	{"ͤλҶΤΰͤǤ", 100, 79, 80, 50 },

	{"ʤϥ֥饦󡦥", 		50, 78, 79, 50 },
	{"ʤϥ֥롼", 		75, 78, 79, 50 },
	{"ʤϥޥ", 		95, 78, 79, 85 },
	{"ʤϥβإܥɡ٤", 100, 78, 79, 120 },
#else
	{"You are one of several children of ", 100, 78, 79, 50 },

	{"a Brown Yeek. ", 50, 79, 80, 50 },
	{"a Blue Yeek.  ", 75, 79, 80, 50 },
	{"a Master Yeek.  ", 95, 79, 80, 85 },
	{"Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif


#ifdef JP
	{"ʤĤƷ",    25, 80, 81, 50 },
	{"ʤϸƷ",    50, 80, 81, 50 },
	{"ʤϾʹƷ",    75, 80, 81, 50 },
	{"ʤϹƷ",    100, 80, 81, 50 },

	{"ȱΤʤƬ",        20, 81, 65, 50 },
	{"ûȱ",        40, 81, 65, 50 },
	{"Ĺȱ",        60, 81, 65, 50 },
	{"ǳ褦֤ȱ",        80, 81, 65, 50 },
	{"Τʤȱ",        100, 81, 65, 50 },
#else
	{"You have pale eyes, ",    25, 80, 81, 50 },
	{"You have glowing eyes, ",    50, 80, 81, 50 },
	{"You have tiny black eyes, ",    75, 80, 81, 50 },
	{"You have shining black eyes, ",    100, 80, 81, 50 },

	{"no hair at all, ",        20, 81, 65, 50 },
	{"short black hair, ",        40, 81, 65, 50 },
	{"long black hair, ",        60, 81, 65, 50 },
	{"bright red hair, ",        80, 81, 65, 50 },
	{"colourless albino hair, ",        100, 81, 65, 50 },
#endif


#ifdef JP
	{"βͤλҶΤΰͤǤ ", 100, 83, 80, 50 },

	{"ʤϥ⡼롦ܥ",   	40, 82, 83, 50 },
	{"ʤϥܥ",         		75, 82, 83, 55 },
	{"ʤϥ顼ܥ",   		95, 82, 83, 65 },
	{"ʤϥܥɤβإ६å",   100, 82, 83, 100 },
#else
	{"You are one of several children of ", 100, 82, 83, 50 },

	{"a Small Kobold.  ",   40, 83, 80, 50 },
	{"a Kobold.  ",         75, 83, 80, 55 },
	{"a Large Kobold.  ",   95, 83, 80, 65 },
	{"Mughash, the Kobold Lord.  ",     100, 83, 80, 100 },
#endif


#ifdef JP
	{"ʤϽ饳βͤλҶΤΰͤǤ"
	, 100, 84, 85, 50 },

	{"ʤ֤ȩ", 40, 85, 86, 50 },
	{"ʤϹȩ", 90, 85, 86, 50 },
	{"ʤϲȩ", 100, 85, 86, 50 },

	{"ܤ򤷤Ƥޤ", 100, 86, 0, 50 },
#else
	{"You are one of several children of a Klackon hive queen.  "
	, 100, 84, 85, 50 },

	{"You have red skin, ", 40, 85, 86, 50 },
	{"You have black skin, ", 90, 85, 86, 50 },
	{"You have yellow skin, ", 100, 85, 86, 50 },

	{"and black eyes.", 100, 86, 0, 50 },
#endif


#ifdef JP
	{"βͤλҶΤΰͤǤ", 100, 88, 18, 89 },

	{"ʤϥˡ٥󥰤", 30,	87, 88, 20 },
	{"ʤϥˡ٥󥰤±", 50, 	87, 88, 40 },
	{"ʤϥˡ٥󥰤결", 70, 	87, 88, 60 },
	{"ʤϥˡ٥󥰤ι", 90, 	87, 88, 75 },
	{"ʤϥˡ٥󥰤Υ㡼ޥ", 95,87, 88, 100 },
	{"ʤϥˡ٥󥰤βإߡ", 100,87, 88, 100 },/*nuke me*/
#else
	{"You are one of several children of ", 100, 87, 88, 89 },

	{"a Nibelung Slave.  ", 30, 88, 18, 20 },
	{"a Nibelung Thief.  ", 50, 88, 18, 40 },
	{"a Nibelung Smith.  ", 70, 88, 18, 60 },
	{"a Nibelung Miner.  ", 90, 88, 18, 75 },
	{"a Nibelung Shaman.  ", 95, 88, 18, 100 },
	{"Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif

#ifdef JP
	{"ʤϥɥ饳˥", 100, 89, 90, 50 },

	{"ĹҤǤ", 30, 135, 91, 55 },
	{"ҤǤ", 50, 135, 91, 50 },
	{"ܻҤǤ", 55, 135, 91, 50 },
	{"θɻǤ", 60, 135, 91, 45 },
	{"δͤλҶΤΰͤǤ", 85, 135, 91, 50 },
	{"ΰγǤ", 100, 135, 91, 55 },

	{"", 10, 90, 135, 20 },
	{"±", 21, 90, 135, 30 },
	{"", 26, 90, 135, 45 },
	{"ʼ", 42, 90, 135, 45 },
	{"", 73, 90, 135, 50 },
	{"", 78, 90, 135, 50 },
	{"", 85, 90, 135, 55 },
	{"Ų", 89, 90, 135, 60 },
	{"η", 94, 90, 135, 65 },
	{"ѻ", 97, 90, 135, 70 },
	{"ؼ", 99, 90, 135, 80 },
	{"²", 100, 90, 135, 100 },

	{"ʤ", 100, 91, 136, 50 },

	{"ϹȩƳʢ򤷤Ƥޤ", 11, 136, 0, 50 },
	{"֥󥺿ȩƼʢ򤷤Ƥޤ", 16, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 24, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 26, 136, 0, 60 },
	{"Ĥȩƿ忧ʢ򤷤Ƥޤ", 32, 136, 0, 50 },
	{"ȩǤ", 33, 136, 0, 70 },
	{"㿧㿧ȩ򤷤Ƥޤ", 37, 136, 0, 45 },
	{"ȩʢ򤷤Ƥޤ", 41, 136, 0, 50 },
	{"翧ȩʢ򤷤Ƥޤ", 48, 136, 0, 50 },
	{"пȩƲʢ򤷤Ƥޤ", 65, 136, 0, 50 },
	{"ппȩ򤷤Ƥޤ", 75, 136, 0, 50 },
	{"֤֤ȩ򤷤Ƥޤ", 88, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 94, 136, 0, 50 },
	{"᤯°Ūȩ򤷤Ƥޤ", 100, 136, 0, 55},
#else
	{"You are ", 100, 89, 135, 50 },

	{"the oldest child of a Draconian ", 30, 135, 90, 55 },
	{"the youngest child of a Draconian ", 50, 135, 90, 50 },
	{"the adopted child of a Draconian ", 55, 135, 90, 50 },
	{"an orphaned child of a Draconian ", 60, 135, 90, 45 },
	{"one of several children of a Draconian ", 85, 135, 90, 50 },
	{"the only child of a Draconian ", 100, 135, 90, 55 },

	{"Beggar.  ", 10, 90, 91, 20 },
	{"Thief.  ", 21, 90, 91, 30 },
	{"Sailor.  ", 26, 90, 91, 45 },
	{"Mercenary.  ", 42, 90, 91, 45 },
	{"Warrior.  ", 73, 90, 91, 50 },
	{"Merchant.  ", 78, 90, 91, 50 },
	{"Artisan.  ", 85, 90, 91, 55 },
	{"Healer.  ", 89, 90, 91, 60 },
	{"Priest.  ", 94, 90, 91, 65 },
	{"Mage.  ", 97, 90, 91, 70 },
	{"Scholar.  ", 99, 90, 91, 80 },
	{"Noble.  ", 100, 90, 91, 100 },

	{"You have ", 100, 91, 136, 50 },

	{"charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
	{"bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
	{"golden wings, and golden skin.", 24, 136, 0, 50 },
	{"white wings, and white skin.", 26, 136, 0, 60 },
	{"blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
	{"multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
	{"brown wings, and brown skin.", 37, 136, 0, 45 },
	{"black wings, black skin, and a white belly.", 41, 136, 0, 50 },
	{"lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
	{"green wings, green skin and yellow belly.", 65, 136, 0, 50 },
	{"green wings, and green skin.", 75, 136, 0, 50 },
	{"red wings, and red skin.", 88, 136, 0, 50 },
	{"black wings, and black skin.", 94, 136, 0, 50 },
	{"metallic skin, and shining wings.", 100, 136, 0, 55},
#endif



#ifdef JP
	{"ʤϰʤĹϷǾ̣⤫ǤʤӤǥޥ㥯Ȥޤޤʤϥ̥̥뤷ȩȵܤ򤷤Ƥơ", 100, 92, 93, 80 },
	{"μ˻ܤο꤬Ƥޤ", 20, 93, 0, 45 },
	{"μ˻ܤο꤬Ƥޤ", 80, 93, 0, 50 },
	{"μ˸ܤο꤬Ƥޤ", 100, 93, 0, 55 },
#else
	{"You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
	{"three tentacles around your mouth.", 20, 93, 0, 45 },
	{"four tentacles around your mouth.", 80, 93, 0, 50 },
	{"five tentacles around your mouth.", 100, 93, 0, 55 },
#endif


#ifdef JP
	{"ʤ", 100, 94, 95, 50 },

	{"ʤϹʪǤ", 30, 95, 96, 20 },
	{"鰭Ǥ", 60, 95, 96, 50 },
	{"鰭Ǥ", 90, 95, 96, 75 },
	{"ⲦǤ", 100, 95, 96, 99 },

	{"ʤ֤ȩ", 50, 96, 97, 50 },
	{"ʤ㿧ȩ", 100, 96, 97, 50},

	{"֤ǳƷ򤷤ƤơޤȲȻɤƤޤ", 40, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤȲ礬Ƥޤ", 70, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤƤޤ", 100, 97, 0, 50 },
#else
	{"You ancestor was ", 100, 94, 95, 50 },

	{"a mindless demonic spawn.  ", 30, 95, 96, 20 },
	{"a minor demon.  ", 60, 95, 96, 50 },
	{"a major demon.  ", 90, 95, 96, 75 },
	{"a demon lord.  ", 100, 95, 96, 99 },

	{"You have red skin, ", 50, 96, 97, 50 },
	{"You have brown skin, ", 100, 96, 97, 50},

	{"claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
	{"claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
	{"claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif


#ifdef JP
	{"ʤϥХѤˤä", 40,	98, 99, 50 },
	{"ʤˡȤˤä", 65, 	98, 99, 50 },
	{"ʤϣѻդˤä",	     90,	98, 99, 50},
	{"ʤηˤä", 100,	98, 99, 60},

	{"臘", 10, 99, 100, 65 },
	{"",		 100,  99, 100, 50 },

	{"Ǵڤ", 40, 100, 101, 50 },
	{"Ф", 80, 100, 101, 50 },
	{"ڤ", 85, 100, 101, 40 },
	{"Ŵ", 99, 100, 101, 50 },
	{"⤫", 100, 100, 101, 100},

	{"Фޤ", 100,101, 0, 50 },
#else
	{"You were shaped from ", 100, 98, 99, 50 },

	{"clay ", 40, 99, 100, 50 },
	{"stone ", 80, 99, 100, 50 },
	{"wood ", 85, 99, 100, 40 },
	{"iron ", 99, 99, 100, 50 },
	{"pure gold ", 100, 99, 100, 100},

	{"by a Kabbalist", 40, 100, 101, 50 },
	{"by a Wizard", 65, 100, 101, 50 },
	{"by an Alchemist", 90, 100, 101, 50},
	{"by a Priest", 100, 100, 101, 60},

	{" to fight evil.", 10, 101, 0, 65 },
	{".", 100, 101, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 102, 103, 50 },

	{"ѻΤˤФޤ", 30, 103, 104, 50 },
	{"ˡμ¸ˤФޤ", 50, 103, 104, 50 },
	{"ٰηˤФޤ", 70, 103, 104, 50 },
	{"Ȥηˤ߽Фޤ", 75, 103, 104, 50 },
	{"ޤޤ", 85, 103, 104, 50 },
	{"ޤޤ", 95, 103, 104, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 103, 104, 50 },

	{"ʤ", 100, 104, 105, 50 },
	{"Ť줿ǽƤơ", 40, 105, 106, 50 },
	{"äǽƤơ", 60, 105, 106, 50 },
	{"줿㿧ǽƤơ", 80, 105, 106, 50 },
	{"򤯵ǽƤơ", 100, 105, 106, 50 },

	{"ܤ򤷤Ƥޤ", 30, 106, 0, 50 },
	{"ϹιФǳܤ򤷤Ƥޤ", 50, 106, 0, 50 },
	{"ݤϤäݤǤ", 100, 106, 0, 50 },
#else
	{"You were created by ", 100, 102, 103, 50 },

	{"a Necromancer.  ", 30, 103, 104, 50 },
	{"a magical experiment.  ", 50, 103, 104, 50 },
	{"an Evil Priest.  ", 70, 103, 104, 50 },
	{"a pact with the demons.  ", 75, 103, 104, 50 },
	{"a restless spirit.  ", 85, 103, 104, 50 },
	{"a curse.  ", 95, 103, 104, 30 },
	{"an oath.  ", 100, 103, 104, 50 },

	{"You have ", 100, 104, 105, 50 },
	{"dirty, dry bones, ", 40, 105, 106, 50 },
	{"rotten black bones, ", 60, 105, 106, 50 },
	{"filthy, brown bones, ", 80, 105, 106, 50 },
	{"shining white bones, ", 100, 105, 106, 50 },

	{"and glowing eyes.", 30, 106, 0, 50 },
	{"and eyes which burn with hellfire.", 50, 106, 0, 50 },
	{"and empty eyesockets.", 100, 106, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 107, 108, 50 },

	{"ѻΤˤ߽Фޤ", 30, 108, 62, 50 },
	{"ˡȤˤ߽Фޤ", 50, 108, 62, 50 },
	{"ޤޤ",60, 108, 62, 50 },
	{"ٰηˤ߽Фޤ", 70, 108, 62, 50 },
	{"Ȥηˤ߽Фޤ", 80, 108, 62, 50 },
	{"ޤޤ", 95, 108, 62, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 108, 62, 50 },

	{"ʤϰų쿧Ʒ",               20, 109, 110, 50},
	{"ʤϳ쿧Ʒ",                    60, 109, 110, 50},
	{"ʤ㿧Ʒ",                    70, 109, 110, 50},
	{"ʤпƷ",                    80, 109, 110, 50},
	{"ʤĤƷ",                     90, 109, 110, 50},
	{"ʤøĿƷ",               100, 109, 110, 50}, /*tansei.cc.u-tokyoͳ*/

	{"ʤ餫",                        70, 110, 111, 50},
	{"Ǥä",                            90, 110, 111, 50},
	{"뤷",                          100, 110, 111, 50},

	{"ȱ",                         30, 111, 112, 50},
	{"㿧ȱ",                         70, 111, 112, 50},
	{"㿧ȱ",                        80, 111, 112, 50},
	{"֤ȱ",                       90, 111, 112, 50},
	{"ȱ",                        100, 111, 112, 50},

	{"ƤȤƤŤȩ򤷤Ƥޤ",              10, 112, 0, 50},
	{"ưŤȩ򤷤Ƥޤ",                   30, 112, 0, 50},
	{"ʿŪȩο򤷤Ƥޤ",               80, 112, 0, 50},
	{"Ʒ쿧Τȩ򤷤Ƥޤ",                   90, 112, 0, 50},
	{"ƤȤƤ쿧Τȩ򤷤Ƥޤ",             100, 112, 0, 50},
#else
	{"You were created by ", 100, 107, 108, 50 },

	{"a Necromancer.  ", 30, 108, 62, 50 },
	{"a Wizard.  ", 50, 108, 62, 50 },
	{"a restless spirit.  ",60, 108, 62, 50 },
	{"an Evil Priest.  ", 70, 108, 62, 50 },
	{"a pact with the demons.  ", 80, 108, 62, 50 },
	{"a curse.  ", 95, 108, 62, 30 },
	{"an oath.  ", 100, 108, 62, 50 },

	{"You have a dark brown eye, ",               20, 109, 110, 50},
	{"You have a brown eye, ",                    60, 109, 110, 50},
	{"You have a hazel eye, ",                    70, 109, 110, 50},
	{"You have a green eye, ",                    80, 109, 110, 50},
	{"You have a blue eye, ",                     90, 109, 110, 50},
	{"You have a blue-gray eye, ",               100, 109, 110, 50},

	{"straight ",                        70, 110, 111, 50},
	{"wavy ",                            90, 110, 111, 50},
	{"curly ",                          100, 110, 111, 50},

	{"black hair, ",                         30, 111, 112, 50},
	{"brown hair, ",                         70, 111, 112, 50},
	{"auburn hair, ",                        80, 111, 112, 50},
	{"red hair, ",                       90, 111, 112, 50},
	{"blond hair, ",                        100, 111, 112, 50},

	{"and a very dark complexion.",              10, 112, 0, 50},
	{"and a dark complexion.",                   30, 112, 0, 50},
	{"and an average complexion.",               80, 112, 0, 50},
	{"and a fair complexion.",                   90, 112, 0, 50},
	{"and a very fair complexion.",             100, 112, 0, 50},
#endif


#ifdef JP
	{"ʤäΤʤ椫ᴤޤ", 20, 113, 114, 50 },
	{"ʤɴǤʥХѥɤα¿ȤʤäƤޤޤ", 40, 113, 114, 50 },
	{"ʤϥХѥϥ󥿡Ǥα¿ȤʤäƤޤޤ", 60, 113, 114, 50 },
	{"ʤϻѻΤǤ", 80, 113, 114, 50 },
	{"ʤ϶ʵ²Ǥ", 95, 113, 114, 50 },
	{"ʤ϶ǻǦǤ", 100, 113, 114, 50 },
#else
	{"You arose from an unmarked grave.  ", 20, 113, 114, 50 },
	{"In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
	{"In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
	{"In life you were a Necromancer.  ", 80, 113, 114, 50 },
	{"In life you were a powerful noble.  ", 95, 113, 114, 50 },
	{"In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 114, 115, 50 },

	{"ȱ", 25, 115, 116, 50 },
	{"Ĥ줿֥饦ȱ", 50, 115, 116, 50 },
	{"ȱ", 75, 115, 116, 50 },
	{"ȱΤʤƬ", 100, 115, 116, 50 },
#else
	{"You have ", 100, 114, 115, 50 },

	{"jet-black hair, ", 25, 115, 116, 50 },
	{"matted brown hair, ", 50, 115, 116, 50 },
	{"white hair, ", 75, 115, 116, 50 },
	{"a hairless head, ", 100, 115, 116, 50 },
#endif


#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 116, 117, 50 },
	{"ƷΤʤܡ", 50, 116, 117, 50 },
	{"˽ʲƷ", 75, 116, 117, 50 },
	{"ä֤Ʒ", 100, 116, 117, 50 },

	{"ƻͤΤ褦Ĥ᤿ȩ򤷤Ƥޤ", 100, 117, 0, 50 },
#else
	{"eyes like red coals, ", 25, 116, 117, 50 },
	{"blank white eyes, ", 50, 116, 117, 50 },
	{"feral yellow eyes, ", 75, 116, 117, 50 },
	{"bloodshot red eyes, ", 100, 116, 117, 50 },

	{"and a deathly pale complexion.", 100, 117, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 118, 119, 50 },

	{"ѻΤˤФޤ", 30, 119, 134, 50 },
	{"ˡμ¸ˤФޤ", 50, 119, 134, 50 },
	{"ٰηˤФޤ", 70, 119, 134, 50 },
	{"Ȥηˤ߽Фޤ", 75, 119, 134, 50 },
	{"ޤޤ", 85, 119, 134, 50 },
	{"ޤޤ", 95, 119, 134, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 119, 134, 50 },
#else
	{"You were created by ", 100, 118, 119, 50 },

	{"a Necromancer.  ", 30, 119, 134, 50 },
	{"a magical experiment.  ", 50, 119, 134, 50 },
	{"an Evil Priest.  ", 70, 119, 134, 50 },
	{"a pact with the demons.  ", 75, 119, 134, 50 },
	{"a restless spirit.  ", 85, 119, 134, 50 },
	{"a curse.  ", 95, 119, 134, 30 },
	{"an oath.  ", 100, 119, 134, 50 },
#endif


#ifdef JP
	{"ȱ", 25, 120, 121, 50 },
	{"Ĥ줿֥饦ȱ", 50, 120, 121, 50 },
	{"ȱ", 75, 120, 121, 50 },
	{"ȱΤʤƬ", 100, 120, 121, 50 },
#else
	{"jet-black hair, ", 25, 120, 121, 50 },
	{"matted brown hair, ", 50, 120, 121, 50 },
	{"white hair, ", 75, 120, 121, 50 },
	{"a hairless head, ", 100, 120, 121, 50 },
#endif


#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 121, 122, 50 },
	{"ƷΤʤܡ", 50, 121, 122, 50 },
	{"˽ʲƷ", 75, 121, 122, 50 },
	{"ä֤Ʒ", 100, 121, 122, 50 },
#else
	{"eyes like red coals, ", 25, 121, 122, 50 },
	{"blank white eyes, ", 50, 121, 122, 50 },
	{"feral yellow eyes, ", 75, 121, 122, 50 },
	{"bloodshot red eyes, ", 100, 121, 122, 50 },
#endif


#ifdef JP
	{"ƻͤΤ褦ڿȩ򤷤Ƥޤ", 100, 122, 123, 50 },
	{"ʤμˤԵ̣пΥ餬äƤޤ", 100, 123, 0, 50 },
#else
	{" and a deathly gray complexion. ", 100, 122, 123, 50 },
	{"An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif


#ifdef JP
	{"ʤξƤ", 100, 124, 125, 50 },

	{"ԥǤ", 20, 125, 126, 35 },
	{"˥Ǥ", 30, 125, 126, 25 },
	{"Ǥ", 75, 125, 126, 50 },
	{"Ǥ", 90, 125, 126, 75 },
	{"ε²Ǥ", 100, 125, 126, 85 }, /*nuke me ʤΤۤ*/
#else
	{"Your parents were ", 100, 124, 125, 50 },

	{"pixies.  ", 20, 125, 126, 35 },
	{"nixies.  ", 30, 125, 126, 25 },
	{"wood sprites.  ", 75, 125, 126, 50 },
	{"wood spirits.  ", 90, 125, 126, 75 },
	{"noble faerie folk.  ", 100, 125, 126, 85 },
#endif


#ifdef JP
	{"ʤ˥饤ȥ֥롼αƤơ", 100, 126, 127, 50 },

	{"ʤ餫ʶȱ",                        80, 127, 128, 50},
	{"Ǥäȱ",                            100, 127, 128, 50},

	{"ĤƷȤȩ򤷤Ƥޤ", 100, 128, 0, 50},
#else
	{"You have light blue wings attached to your back, ", 100, 126, 127, 50 },

	{"straight blond hair, ",                        80, 127, 128, 50},
	{"wavy blond hair, ",                            100, 127, 128, 50},

	{"blue eyes, and a very fair complexion.", 100, 128, 0, 50},
#endif


#ifdef JP
	{"ʤˡμ¸ˤ߽Фޤ", 30, 129, 130, 40},
	{"ʤϻҶ塢򤫤ˤ륹ƬͤùǤޤޤ",
	50, 129, 130, 50 }, /*nuke me*/
	{"륫ⲦͷӤǤʤ夲ޤ",
	60, 129, 130, 60 },
	{"ʤˡˤݤ蘆줿ưʪȿʹ֤λҶǤ", 75, 129, 130, 50},
	{"ʤϸ⤪ޤʪŪʳݤ碌ˤޤޤ", 100, 129, 130, 30},
#else
	{"You were produced by a magical experiment.  ", 30, 129, 130, 40},
	{"In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
	50, 129, 130, 50 },
	{"A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
	60, 129, 130, 60 },
	{"You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50},
	{"You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30},
#endif



#ifdef JP
	{"ʤп",              60, 130, 131, 50},
	{"ʤϹĻ",                    85, 130, 131, 50},
	{"ʤϥ󥸿ǭ",            99, 130, 131, 50},
	{"ʤǳ褦ʰ",          100, 130, 131, 55},
#else
	{"You have green reptilian eyes, ",              60, 130, 131, 50},
	{"You have the black eyes of a bird, ",              85, 130, 131, 50},
	{"You have the orange eyes of a cat, ",               99, 130, 131, 50},
	{"You have the fiery eyes of a demon, ",             100, 130, 131, 55},
#endif


#ifdef JP

	{"ȱΤʤƬ",                 10, 131, 133, 50},
	{"򤷤Ƥơ",                     33, 131, 132, 50},
	{"򤷤Ƥơߤܤ餷",             66, 131, 132, 50},
	{"򤷤ƤơƤä",                100, 131, 132, 50},
#else
	{"no hair at all, ",                 10, 131, 133, 50 },
	{"dirty ",                           33, 131, 132, 50},
	{"mangy ",                           66, 131, 132, 50},
	{"oily ",                           100, 131, 132, 50},
#endif


#ifdef JP

	{"㿧",                    33, 132, 133, 50},
	{"",                    66, 132, 133, 50},
	{"",                     100, 132, 133, 50},
#else
	{"brown fur, ",                    33, 132, 133, 50},
	{"gray fur, ",                    66, 132, 133, 50},
	{"albino fur, ",                  100, 132, 133, 50},
#endif


#ifdef JP
        {"Ӥޤ",      50, 133, 0, 50 },
        {"ʹ֤­Ƥޤ",  75, 133, 0, 50 },
        {"Ļ­Ƥޤ",    85, 133, 0, 50 },
        {"­Ƥޤ",90, 133, 0, 50 },
        {"­Ƥޤ",    95, 133, 0, 50 },
        {"ǭ­Ƥޤ",    97, 133, 0, 50 },
        {"­Ƥޤ",   100, 133, 0, 50 },

        {"ʤ", 100, 134, 120, 50 },
#else
	{"and the hooves of a goat.",      50, 133, 0, 50 },
	{"and human feet.",        75, 133, 0, 50 },
	{"and bird's feet.",       85, 133, 0, 50 },
	{"and reptilian feet.",    90, 133, 0, 50 },
	{"and bovine feet.",       95, 133, 0, 50 },
	{"and feline feet.",       97, 133, 0, 50 },
	{"and canine feet.",       100, 133, 0, 50 },

	{"You have ", 100, 134, 120, 50 },
#endif


#ifdef JP
	{"λҤǤ", 25, 138, 139, 40},
	{"ޤ褦ҤǤ", 50, 138, 139, 50},
	{"ͣλҤǤ", 75, 138, 139, 60},
	{"ƤҤǤ", 100, 138, 139, 70},
#else
	{"You are the lost offspring of ", 25, 137, 138, 40},
	{"You are the wandering offspring of ", 50, 137, 138, 50},
	{"You are the only offspring of ", 75, 137, 138, 60},
	{"You are the beloved offspring of ", 100, 137, 138, 70},
#endif


#ifdef JP
	{"ʤ̾Τ̥Ȥ", 10, 137, 138, 35},
	{"ʤϸȤʥȤ", 35, 137, 138, 50},
	{"ʤϥȤΰĤΰ", 55, 137, 138, 60},
	{"ʤ˱ɤƤ륨ȤμҲΥ꡼", 70, 137, 138, 70},
	{"ʤϥȤοĹ", 81, 137, 138, 80},
	{"ʤºɤƤ륨ȤθԤ", 91, 137, 138, 90},
	{"ʤϺǤɲˤʤȽ", 96, 137, 138, 100},
	{"ʤϥե󥴥󤽤οͤ", 100, 137, 138, 110},
#else
	{"an Ent whose name you have no recollection of.  ", 10, 138, 139, 35},
	{"a solitary Ent.  ", 35, 138, 139, 50},
	{"a member of a farflung Entish band.  ", 55, 138, 139, 60},
	{"a leader of a prosperous community of Ents.  ", 70, 138, 139, 70},
	{"an Entish Forestwarden.  ", 81, 138, 139, 80},
	{"a respected Entish sage.  ", 91, 138, 139, 90},
	{"an Entwife whose memory men cherish.  ", 96, 138, 139, 100},
	{"Fangorn himself.  ", 100, 138, 139, 110},
#endif

#ifdef JP
	{"ʤ", 100, 139, 140, 50},
#else
	{"You have ", 100, 139, 140, 50},
#endif

#ifdef JP
	{"ܤλؤ", 5, 140, 141, 50},
	{"ܤλؤ", 20, 140, 141, 50},
	{"ܤλؤ", 40, 140, 141, 50},
	{"ϻܤλؤ", 60, 140, 141, 50},
	{"ܤλؤ", 80, 140, 141, 50},
	{"Ȭܤλؤ", 95, 140, 141, 50},
	{"ܤλؤ", 100, 140, 141, 50},
#else
	{"three fingers and toes, and are covered in ", 5, 140, 141, 50},
	{"four fingers and toes, and are covered in ", 20, 140, 141, 50},
	{"five fingers and toes, and are covered in ", 40, 140, 141, 50},
	{"six fingers and toes, and are covered in ", 60, 140, 141, 50},
	{"seven fingers and toes, and are covered in ", 80, 140, 141, 50},
	{"eight fingers and toes, and are covered in ", 95, 140, 141, 50},
	{"nine fingers and toes, and are covered in ", 100, 140, 141, 50},
#endif
#ifdef JP
	{"㿧ھȩʤƤޤ", 10, 141, 0, 50},
	{"㿧ιӤȩʤƤޤ", 20, 141, 0, 50},
	{"Τʤ餫ȩʤƤޤ", 30, 141, 0, 50},
	{"꡼ȩʤƤޤ", 40, 141, 0, 50},
	{"ݤʤ줿ȩ򤷤Ƥޤ", 50, 141, 0, 50},
	{"֥饦ȩʤƤޤ", 60, 141, 0, 50},
	{"ѡ֥饦ΥѥѥȩʤƤޤ", 70, 141, 0, 50},
	{"祳졼ȿ˭ȩʤƤޤ", 80, 141, 0, 50},
	{"ھȩʤƤޤ", 90, 141, 0, 50},
	{"ۤȤɤҤӤȩʤƤޤ", 100, 141, 0, 50},
#else
	{"scaly brown skin.", 10, 141, 0, 50},
	{"rough brown skin.", 20, 141, 0, 50},
	{"smooth grey skin.", 30, 141, 0, 50},
	{"dark green skin.", 40, 141, 0, 50},
	{"mossy skin.", 50, 141, 0, 50},
	{"deep brown skin.", 60, 141, 0, 50},
	{"pale brown, flaky skin.", 70, 141, 0, 50},
	{"rich chocolate-colored skin.", 80, 141, 0, 50},
	{"ridged black skin.", 90, 141, 0, 50},
	{"thick, almost corky skin.", 100, 141, 0, 50},
#endif

#ifdef JP
	{"ʤŷμͤǤ", 100, 142, 143, 80},
	{"ʤϰǤܤˤϤƤޤ", 100, 143, 144, 80},
	{"Ū뤲ޤǤϵ٤ळȤϵޤ", 100, 144, 0, 80},
#else
	{"You are of the blessed host of heaven.", 100, 142, 143, 80},
	{"You have been sent to earth to eradicate the wicked, ", 100, 143, 144, 80},
	{"and shall not rest until you have succeeded.", 100, 144, 0, 80},
#endif

#ifdef JP
	{"ʤϹμ줿ҤǤ", 100, 145, 146, 20},
	{"ʤϥ졼ǡεޤˤäޤޤ", 100, 146, 147, 20},
	{"ʤε򤦤äƤޤ", 100, 147, 0, 20},
#else
	{"You are of the cursed spawn of hell. ", 100, 145, 146, 20},
	{"You have been cast out by the whim of the greater demons, ", 100, 146, 147, 20},
	{"and now seek revenge.", 100, 147, 0, 20},
#endif



#ifdef JP
	{"ʤΤʤ",  5, 148, 149, 25},
	{"ʤκ", 20, 148, 149, 35},
	{"ʤΤ", 40, 148, 149, 45},
	{"ʤϥ󥸥㡼", 50, 148, 149, 50},
	{"ʤϽ񵭤", 70, 148, 149, 65},
	{"ʤ", 83, 148, 149, 75},
	{"ʤϣѻդ", 93, 148, 149, 90},
	{"ʤϵ²ν", 98, 148, 149, 110},
	{"ʤϽ", 100, 148, 149, 140},
#else
	{"whose identity you are uncertain of.",  5, 149, 8, 25},
	{"Captive.  ", 20, 149, 150, 35},
	{"Fighter.  ", 40, 149, 150, 45},
	{"Ranger.  ", 50, 149, 150, 50},
	{"Scribe.  ", 70, 149, 150, 65},
	{"Witch.  ", 83, 149, 150, 75},
	{"Alchemist.  ", 93, 149, 150, 90},
	{"Lady.  ", 98, 149, 150, 110},
	{"Queen.  ", 100, 149, 150, 140},
#endif
#ifdef JP
	{"ƥե꡼λǤ", 10, 149, 150, 35},
	{"ƥե꡼δͤλҶΤΰͤǤ", 30, 149, 150, 45},
	{"ƥե꡼ҤǤ", 55, 149, 150, 50},
	{"ƥե꡼ĹҤǤ", 80, 149, 150, 55},
	{"ƥե꡼ΰγǤ", 100, 149, 150, 60},
#else
	{"You are the bastard child of a Shadow-Fairy ", 10, 148, 149, 35},
	{"You are one of several children of a Shadow-Fairy ", 30, 148, 149, 45},
	{"You are the second child of a Shadow-Fairy ", 55, 148, 149, 50},
	{"You are the first child of a Shadow-Fairy ", 80, 148, 149, 55},
	{"You are the only child of a Shadow-Fairy ", 100, 148, 149, 60},
#endif


#ifdef JP
	{"ʤϹƷ", 10, 150, 151, 50},
	{"ʤϿ֥饦Ʒ", 25, 50, 151, 50},
	{"ʤϥ֥饦Ʒ", 60, 150, 151, 50},
	{"ʤøƷ", 70, 150, 151, 50},
	{"ʤϥ꡼Ʒ", 80, 150, 151, 50},
	{"ʤĤƷ", 90, 150, 151, 50},
	{"ʤϥ֥롼쥤Ʒ", 100, 150, 151, 50},
#else
	{"You have black eyes, straight ", 10, 150, 151, 50},
	{"You have dark brown eyes, straight ", 25, 50, 151, 50},
	{"You have brown eyes, straight ", 60, 150, 151, 50},
	{"You have hazel eyes, straight ", 70, 150, 151, 50},
	{"You have green eyes, straight ", 80, 150, 151, 50},
	{"You have blue eyes, straight ", 90, 150, 151, 50},
	{"You have blue-gray eyes, straight ", 100, 150, 151, 50},
#endif

#ifdef JP
	{"졼ȱ", 30, 152, 153, 50},
	{"ȱ", 70, 152, 153, 50},
	{"ѡ륤ȱ", 80, 152, 153, 50},
	{"򤬤äȱ", 90, 152, 153, 50},
	{"ѡ֥饦ȱ", 100, 152, 153, 50},
#else
	{"grey hair ", 30, 151, 152, 50},
	{"pure white hair ", 70, 151, 152, 50},
	{"pale yellow hair ", 80, 151, 152, 50},
	{"grey-white hair ", 90, 151, 152, 50},
	{"pale brown hair ", 100, 151, 152, 50},
#endif

#ifdef JP
	{"鷺˸ˤ뤯餤Τʤ餫", 30, 151, 152, 50},
	{"ӤޤϤ餤Τʤ餫", 60, 151, 152, 55},
	{"ޤǤʤ餫", 90, 151, 152, 60},
	{"Ƭ­ޤǵΤ褦ˤʤ餫", 100, 151, 152, 75},
#else
	{"that barely covers your shoulders, ", 30, 152, 153, 50},
	{"that reaches to your arms, ", 60, 152, 153, 55},
	{"that flows down to your waist, ", 90, 152, 153, 60},
	{"that forms a shining waterfall from head to foot, ", 100, 152, 153, 75},
#endif

#ifdef JP
	{"Ʃ̤褦ȩ򤷤Ƥޤ", 20, 153, 0, 50},
	{"ߥ륯ȩ򤷤Ƥޤ", 35, 153, 0, 50},
	{"ȩ򤷤Ƥޤ", 50, 153, 0, 50},
	{"ȩ򤷤Ƥޤ", 85, 153, 0, 50},
	{"ȩ򤷤Ƥޤ", 100, 153, 0, 50},
#else
	{"and an extremely fair complexion.", 20, 153, 0, 50},
	{"and a milky complexion.", 35, 153, 0, 50},
	{"and a pearly complexion.", 50, 153, 0, 50},
	{"and a pale complexion.", 85, 153, 0, 50},
	{"and an utterly white complexion.", 100, 153, 0, 50},
#endif

#ifdef JP
	{"ʤϥեȤ˾äꤹ뤭̾ΥǤʤӤǤ", 65, 154, 0, 55},
	{"ʤ̾ΥãˤƤѥѥǤʤӤпǤ", 95, 154, 0, 65},
	{"ʤϤȤƤȥ饯ǤʤӤϥȥΤ褦ʲȹμͤǤ", 100, 154, 0, 80},
#else
	{"You are a normal Kutar.  You have orange colored fur.", 65, 154, 0, 55},
	{"You are a father Kutar, the patriarch of many normal Kutars.  You have green colored fur.", 95, 154, 0, 65},
	{"You are a very rare type of Kutar, famed for the yellow and black stripes on your body.", 100, 154, 0, 80},
#endif

#ifdef JP
	{"ʤϤץȤλʤȤ", 10, 155, 156, 50},
	{"ʤϻҶ򶵰餹뤿", 30, 155, 156, 60},
	{"ʤϿȤβä򤹤뤿", 50, 155, 156, 70},
	{"ʤ˴ʤäҶοȤ", 60, 155, 156, 10},
	{"ʤƮѥɥɤȤ", 90, 155, 156, 20},
	{"ʤΤƻȤ", 100, 155, 156, 10},

	{"ζäʳؼԤˤäƺޤ", 20, 156, 157, 10},
	{"ȤθǺޤ", 50, 156, 157, 80},
	{"ʿ¤ꤦʳؼԤˤäƺޤ", 85, 156, 157, 50},
	{"ͤŷ;ǯˤäƺޤ", 90, 156, 157, 30},
	{"22äޤ", 100, 156, 157, 100},

	{"ͥΤ褦ʷ򤷤", 15, 157, 158, 40},
	{"̤Τ褦ʷ򤷤", 30, 157, 158, 30},
	{"Τ褦ʷ򤷤", 45, 157, 158, 20},
	{"ʹ֤Τ褦ʷ򤷤", 70, 157, 158, 60},
	{"ɥդΤ褦ʷ򤷤", 80, 157, 158, 70},
	{"ۥӥåȤΤ褦ʷ򤷤", 90, 157, 158, 70},
	{"դΤ褦ʷ򤷤", 100, 157, 158,  80},

	{"ޤϥͥߤˤƤʤʤäƤޤ", 5, 158, 0, 20},
	{"ȺԤϼĥƤޤȤƤ⤽ϸޤ", 20, 158, 0, 30},
	{"ޤ", 85, 158, 0, 50},
	{"ơܿͤϼʬΤȤʪȿƤޤ", 95, 158, 0, 50},
	{"ơˤ褯ǤƤΤʪȸʬĤޤ", 100, 158, 0, 100},
#else
	{"You were created by a mad scientist ", 20, 155, 156, 10},
	{"You were created in a corporate laboratory ", 50, 155, 156, 80},
	{"You were created by a peace-loving scientist ", 85, 155, 156, 50},
	{"You were created by a boy genius ", 90, 155, 156, 30},
	{"You have come from the twenty-second century ", 100, 155, 156, 100},

	{"as a project prototype. ", 10, 156, 157, 50},
	{"to educate children. ", 30, 157, 157, 60},
	{"to look after someone. ", 50, 156, 157, 70},
	{"as a substitute for a dead child. ", 60, 156, 157, 10},
	{"as a combat trooper. ", 90, 156, 157, 20},
	{"as a tool for conquest of the world. ", 100, 156, 157, 10},


	{"You have a cat-like appearance", 15, 157, 158, 40},
	{"You have a dog-like appearance", 30, 157, 158, 30},
	{"You have a Kutar-like appearance", 45, 157, 158, 20},
	{"You have a human-like appearance", 70, 157, 158, 60},
	{"You have a dwarf-like appearance", 80, 157, 158, 70},
	{"You have a hobbit-like appearance", 90, 157, 158, 70},
	{"You have a elf-like appearance", 100, 157, 158,  80},

	{", but your ears have been eaten by mice, and no trace of them remains.", 5, 158, 0, 20},
	{"... at least your creator thinks so.  Most people disagree.", 20, 158, 0, 30},
	{".", 85, 158, 0, 50},
	{", and you firmly believe that you are a real one.", 95, 158, 0, 50},
	{", and you are almost indistinguishable from a real one.", 100, 158, 0, 100},
#endif
};

static cptr race_jouhou[MAX_RACES] =
{
#ifdef JP
"ʹ֤ϴܤȤʤ륭饯Ǥ¾Ƥμ²Ͽʹ֤Ӥޤʹ֤ϤɤʿȤ˽ȤǤɤοȤǤʿŪˤʤޤʹ֤ϼ̿ûᡢ٥徺¾Τɤʼ²᤯ʤ뷹ޤޤ̤ʽϻäƤޤ",
  
"ϡեդϿʹ֤긭ǤϤޤõ, , ˡɸ, ̩ư, ͷ, ˡƻѤǤ鷺ͥƤޤμ갷ϤդǤϤޤ󡣥ϡեդϤɤοȤ˽ȤǤޤĤϤޤ",
  
"դϿʹ֤ɤˡȤˤʤޤƮ϶ǤϿʹ֤ϡեդƬɤ⤤äƤޤդõ, , γ, ̩ư, ͷ, ˡƻѤͥƤޤΰդǤϤޤޤĤФäƤޤ",
  
"ۥӥåȡޤϥϡե󥰤ϵݤڳĹˡɸͥƤޤޤõ, , γ, Ʊ̩ưǤȤƤɤǽϤ򼨤ޤΤᡢͥ줿±Ȥʤ뤳ȤǤޤʤǦӤμԡפȸƤФ뤳Ȥ򹥤ߤޤˡۥӥåȤϿʹ֤ڤϼǡΤȤƤϤƤǥǤϤʤɤֳϤäƤꡢưʪΥ줿꤫鸫Ĥ뤳ȤǤޤۥӥåȤϴѤ򲼤뤳Ȥޤ",
  
"Ρϥɥդ꾮ǤۥӥåȤ礭²ǤϥۥӥåƱɽƶΤ褦ʲȤ˽ǤޤΡϤȤƤɤˡɸõ, , γ, ̩ưǤͥƤޤϿʹ֤㤤ϤäƤƮ϶ǤΡϤʤɤֳϤäƤꡢưʪΥ줿꤫鸫Ĥ뤳ȤǤޤΡޤĤФäƤޤ",
  
"ɥդϴǤʹפǤꡢΤǤϿʹ֤ˤٶդǤǽޤĹ̿椨˸Ǥɤˡɸõ, γ, Ʈ, ͷǤͥƤޤϰ礭ʷäƤޤɥդα̩ư˾Ū˰ǤϷ褷ܤˤϤʤޤ",
  
"ϡեϤ褤ΤˤʤޤˡϴԤǤޤϥɥդƱ餤̩ưޤõ, γФҤɤǤϡեϽŹǤ㤤ʪǤϤ⤤ۤ׵ᤵ줬Ǥϲ˽ळȤ򹥤िᡢϡեϰŰǤФƤޤ",
  
"ϡեȥϿʤۤɶ¾ʬμ²礭ʣȣФޤԱˤȤƤ򤫤Ǥõ, , γ, ̩ưϰγϥϡե̤򤹤ۤɽǤϡեȥϤ뤳Ȥޤ󡣥٥뤬夬ȡϺǽϤˤ졢ΤʤФپòǽϤޤ",
  
"Х饤Ȥ¿ΥɥХơ줿蘆ˤԻμ²Ǥγ, Ʈ, ͷͥƤꡢ¾̤Ǥ⤫ʤƤޤ¾夢Τ򸫤ƤƤꡢʤΤϤۤȤɤʤᡢĹ¾Τɤμ²٤ΤǤϤȤƤ⥿դǴ趯ǤꡢѵϤ뤳ȤϤޤ󡣤ޤ򤹤˼ǽϤޤ",
  
"ϥդλϤޤ꤫¸ߤԻμ²ǤƤΥ˽ãƤꡢŪ˿͵ޤ - ï⤬ΤȤ򹥤ƤޤϥդϸʤΤ򸫤뤳ȤǤ̤ΥƱ͸ФäƤޤˤȤä̤ΤΤΤϤۤȤɤʤи뤳ȤѤ˺Ǥ",
  
"ڿͤ褿趯ʼ²ǤϷ㤷襤ηܤǶƤޤƮοǤ϶Τ餺ϡեȥ⤹˶˽ƮäƤޤȤؤӤޤڿͤˡ򵿤äƤꡢΤˡƻȤȤϤʤѤʤȤȤʤäƤޤ",
  
"ϡեϥϡե˻ƤޤǤϤޤ礭ٰǶ򤫤ǤΤȤƤɬפʻƻäƤꡢޤˡȤˤʤ뤳ȤǤޤɡϥᥤ˴طꡢ٥뤬ʬ˾夬ä餫櫤Υ롼򥻥åȤ륹ؤ֤ΤǤϡեΤ褦ˡϰŰǤФϡեȥƱͤϤ뤳ȤϤޤ",
  
"Ⱦͤ϶ΤǤʸ򾧤ۤǤϤޤϤ褤ƮǽϤޤʳΤȤ϶ǤθҤФޤޤϡեϡեȥƱϤ򲼤뤳Ȥޤ",
  
"ʥȿʹ֤λ¹Ǥꡢζʪ¾ΤۤƤμ²Ϥ뤫˾äƤޤ¿²ˤߤ褦̥ŪüǽϤϻäƤޤ󤬡礭ʣȣФϤäƤޤꤢޤȾϤΥäƤޤε礵椨櫤β䤳ä⤯ȤϺǤˡ򰦤ϡФäƤޤ",
  
"ܤǤϤޤץ¿Ĥܤʪʾ˸뤳ȤǤޤץ϶ΤǤŪǤȤϤäȸޤ٤Сϡեȥϥ󥵥˸ȤȤϸޤǤ⤢ޤ󡣥ץƮ, ͷͥƤޤ¾ʬΥ϶ǤץϲФäƤޤ",
  
"ϺǤⰥʪΰĤǤꡢ¤Υ󥹥ǤäƤդʥʤŰŪǤΤ᤻ۤŪˤ϶ޤ󤬡ϤʤŪǤ餫ʪǤƮ϶Ǥ¾ʬǤͥƤޤϡ֤ȤȤ˻ؤƤ٥뤬ʬ˾夬дȱ֤Ĥ褦ˤʤޤ",
  
"åϴȾŪκʪǤϤФ餷ΤˤʤޤŪǽϤϤҤɤ¤ƤޤõʬΥ򤽤ˤʤޤåϷ褷ƺ𤵤뤳Ȥʤ٥뤬夬뤴Ȥ®ʤޤ",
  
"ܥɤϼ夤֥μ²ǤǤä򹥤ߡ̵¤˶뤵ޤˤꤲǽϤȤˤĤ뤳ȤǤޤܥɤϤΤˤʤޤ¾Υϸ¤߰ǤޤĤǤФäƤޤ",
  
"졢Ƥ²ǤΥ򤽤ĤʤʤޤƶｻԤǤϡŰǤǺޤ뤳ȤϤޤ󤷡ޤĤäƤˡΥƥФϹΤᡢˤˡΥܡʥå̤äƤޤ",
  
"ǤΡƶ˽²ǤդˡμФĹäƤޤդˡƻ򤦤ޤȤȤǤ¾¿μ²ñ˼ʸ򾧤ǽäƤޤαԤФˤäơϥϥƱ͸ʤΤߤǽϤؤӤޤϤ٥٥뤬夬äȤǤդϰŰǤФäƤޤ",
  
"ɥ饴Τ褦äʹַ²Ǥϥ٥뤬夬ˤĤ졢Ǥؤˤޤɥ饳˥ͥ줿ǽͤäƥ򳫻ϤǤΥ򤦤ޤʤޤǡϴñȤϴ䡢̵ӱۤ뤳ȤǤޤ",
  
"̩οŪʸ²ǤʸϤβŤ⤷ޤ󡣤ŪϷ褷줿ΤǤϤޤ󤬡ǽȸϥޥɥե쥢¾Τɤʼ²⶯ϤˡȤˤޤޥɥե쥢ǽȸϲ뤳Ȥʤ٥뤬夬иʤΤߤǽϡƥѥǽϤޤ",
  
"ϹäƤŪʪǤ¾μ²ӷƤޤοȤ򤫤ʤꤦޤʤȤǤޤפޤĤФäƤꡢ٥뤬夬иʤΤ򸫤ǽϤޤ",
  
"ťΤ褦̿ΤʤĤ졢̿᤭ޤ줿͹ŪʪǤˤϻ׹ͤȤΤۤȤɤʤΤˡ˰¸뿦ȤǤΩǤΤȤƤѤ˥դǤǤʤΤ򸫤뤳ȤǤΤ餺Ǥ٥뤬夬С̿ϵۼĤ褦ˤʤޤ̾οʪϤۤȤɱܤݼǤޤ󤬡òˤϻ֤ޤޤδʿΤΤᡢAC˥ܡʥ뤳ȤǤ˷褷Ƶ䤵뤳Ȥޤ",
  
"ȥˤ2ĤΥפ¸ߤޤ̤ΥפȡåȸƤФʸȤȥǤǥåɤǤϡǤ̿ϵۼۤɬפϤޤʪΤγФΤ˴ѤƤʤᡢʤʪ٤ޤιϤȤäҤΤ褦ʤΤ٥뤬夬䵤Фޤ俩ʪλĸ̤ϥȥΰߡ¸ߤޤ󤬡ˤ̲᤹뤳ȤʤϤȯޤ俩ʪΤγܤ̤ȴƤޤܤۼ뤳ȤϤǤޤ",
  
"ӤϥǥåɤǤꡢ̿ϵۼȥΤ褦˥٥뤬夬䵤ޤޤǤʤΤ򸫤뤳ȤǤޤʥȥȤϰ㤤ڤ빶ˤϼ夤ǤϹФäƤޤΤ褦ˡϿʪۤȤɱܤݼǤޤ󤬡òۼ٤Ǥ",
  
"ϤʥǥåɤΰǤ۷쵴ϡڷɤǰƤӵ򤷤Ƥޤǥåɤˤ줺̿Ϥۼ뤳ȤʤϹФäƤޤޤ䵤ǤФƤޤʷդ˾˵Ƥꡢ϶᤯ˤʪդۤȤˤäƤΤޤζϤʪϿʼäƤޤ۸ʤˤǤ̣ޤˤ⡢۷쵴ϤοΤְŹθפΥФƤޤŰǤ궯ϤˤΤǤ",
  
"ͩ϶ϤʥǥåɤΰǤԵ̣пθޤƤޤȾʪŪ¸ߤǤϡɤ̤ȴ뤳ȤǤޤΤȤˤɤ̩٤ˤäƽĤƤޤޤ¾ΥǥåƱ̿͡Ϥۼ뤳ȤʤʤΤ򸫤뤳ȤǤǤ䵤ФϹФäƤޤ٥뤬ʬ˾夬ϥƥѥޤͩۤˡȤˤʤ뤳ȤǤޤοŪϼǤ",
  
"˾ǤϾ櫤Ϸӱۤ뤳ȤǤޤѹߡФäƤޤŪˤϤäȤϼʼ²ΰĤǤˡ̤ѤʺǽäƤꡢ˽ˡȤˤʤ뤳ȤǤޤ٥ǤϤ®֤ȤǤ褦ˤʤޤ",
  
"μ²ϥˤäƤĤ줿ŪǷ¸ߤǤΩ²ǤϤʤʹַ²Ͽʹ֤ˤäĤ줿¸ߡ⤷Ͽʹ֤Ƚäΰ̴Τ褦ʸۼǤƤνÿͤϥսƤꡢΤẮȲФƤޤʥ륹ϤޤФ̤äƤޤÿͤϺ٤򹥤ߡ򤵤ĤޤÿͤѰۤ򵯤䤹äƤޤ餬Ĥ줿ȤѰۤޤθ塢٥뤬夬뤴Ȥ˰㤦Ѱۤǽޤ",
  
"Ȥ˶Ǥε礵椨櫤β䤳ä⤯Ȥ϶ǤĹˤĤϤѵϤ夬ޤѤϲäƤޤˤ礭ʷꡢˤä̾礭ʥ᡼Ƥޤޤ",
  
"ŷȤξ̼Ǥ륢륳ϡƤΥ˽ãƤꡢƸ˿͵ޤܤ˸ʤΤ򸫤뤳ȤǤ櫤Ϸӱۤ뤳ȤǤޤĹ٤Ȥ⤢ޤ",
  
"ξ̼ǤХϡŪǡޤդǤ⤢ޤϿ򿮤褦ȤϤץ꡼ȤˤƤޤ󡣱Ϲ̿ϵۼؤäƤꡢ٥뤬夬иʤΤ򸫤ǽϤޤޤϹбΥ֥쥹ǤȤǤޤϤۤȤɤεǽͥƤޤŤ⤯Ȥ϶Ǥ",
  
"ɥʥ¿ΥɥХơ줿蘆ˤԻμ²Ǥγ, Ʈ, ͷͥƤꡢ¾̤Ǥ⤫ʤƤޤ¿ΤΤ򸫤ƤƤꡢʤΤϤޤʤᡢĹϤ٤ǤϤȤƤ⥿դǴ趯ǤꡢѵϤ뤳ȤϤޤ",
  
"ƥե꡼Ͽʹ֤礭²ǡ櫤Ϸӱۤ뤳ȤǤޤˤä̾礭ʥ᡼ƤޤޤŪˤϼǤˡ̤Ǥͥ줿ǽϤäƤޤˤϤФ餷Ĺ꤬Ĥꡢ󥹥ȿ򤫤褦ʶϤʥƥƤ󥹥ܤ餻뤳Ȥޤ󡣤ξǤⱣ̩ưǽϤꡢޤʬȤʤˤäȿ򤫤äƤˤϸ̤ޤ",
  
"ȤƤ̵ɽʪǤϳ襤餷ᡢ̥Ϥ⤤ǤϺ𤷤ޤ󡣤ʤʤ顢𤷤Ƥ⥯ȤƤ뤿ѤʤǤ⡢ΥȤƤ볰Ũ˸ĤˤǤϤʤõγǽϤϰǤϥ٥뤬夬Ȳ˿ӤAC夲뵻ФޤӤƤ֤ˡɸǽϤ㤯ʤäƤޤޤ",
  
"ɥɤϵοΤĿ͹Ū¸ߤǤˡ򤦤ޤȤȤϤǤޤ󤬡ΤȤƤͥƤޤ¾μ²Τ褦˷иͤĹȤȤϤޤ󡣿Τ˿ȤˤĤˤäĹޤءߥåȡĹ˱ƶޤǤΤ餺ǡ̿Ϥۤ뤳Ȥޤ󡣤ޤΤʤΤAC˥ܡʥޤΤΤȤŻҲϩȤ߹ޤƤ뤿ᡢŷˤä̾礭ʥ᡼Ƥޤޤ"

#else

"The human is the base character. All other races are compared to them. Humans can choose any class and are average at everything. Humans tend to go up levels faster than most other races because of their shorter life spans. No racial adjustments or intrinsics occur to characters choosing human.",

"Half-elves tend to be smarter and faster than humans, but not as strong. Half-elves are slightly better at searching, disarming, saving throws, stealth, bows, and magic, but they are not as good at hand weapons. Half-elves may choose any class and do not receive any intrinsic abilities.",

"Elves are better magicians then humans, but not as good at fighting. They tend to be smarter and faster than either humans or half-elves and also have better wisdom. Elves are better at searching, disarming, perception, stealth, bows, and magic, but they are not as good at hand weapons. They resist light effects intrinsically.",

"Hobbits, or Halflings, are very good at bows, throwing, and have good saving throws. They also are very good at searching, disarming, perception, and stealth; so they make excellent rogues, but prefer to be called burglars. They are much weaker than humans, and no good at melee fighting. Halflings have fair infravision, so they can detect warm creatures at a distance. They have their dexterity sustained.",

"Gnomes are smaller than dwarves but larger than Halflings. They, like the hobbits, live in the earth in burrow-like homes. Gnomes make excellent mages, and have very good saving throws. They are good at searching, disarming, perception, and stealth. They have lower strength than humans so they are not very good at fighting with hand weapons. Gnomes have fair infra-vision, so they can detect warm-blooded creatures at a distance. Gnomes are intrinsically protected against paralysis.",

"Dwarves are the headstrong miners and fighters of legend. Dwarves tend to be stronger and tougher but slower and less intelligent than humans. Because they are so headstrong and are somewhat wise, they resist spells which are cast on them.  They are very good at searching, perception, fighting, and bows. Dwarves  have a miserable stealth. They can never be blinded.",

"Half-orcs make excellent warriors, but are terrible at magic. They are as bad as dwarves at stealth, and horrible at searching, disarming, and perception. Half-orcs are quite ugly, and tend to pay more for goods in town. Because of their preference to living underground to on the surface, half-orcs resist darkness attacks.",

"Half-Trolls are incredibly strong, and have more hit points than most other races. They are also very stupid and slow. They are bad at searching, disarming, perception, and stealth. They are so ugly that a Half-Orc grimaces in their presence. They also happen to be fun to run... Half-trolls always have their strength sustained. At higher levels, Half-Trolls regenerate wounds automatically, and if he or her is warrior slowly.",

"The Amberites are a reputedly immortal race, who are endowed with numerous advantages in addition to their longevity. They are very tough and their constitution cannot be reduced, and their ability to heal wounds far surpasses that of any other race. Having seen virtually everything, very little is new to them, and they gain levels much slower than the other races.",

"High-elves are a race of immortal beings dating from the beginning of time. They are masters of all skills, and are strong and intelligent, although their wisdom is sometimes suspect. High-elves begin their lives able to see the unseen, and resist light effects just like regular elves. However, there are few things that they have not seen already, and experience is very hard for them to gain.",

"Barbarians are hardy men of the north. They are fierce in combat, and their wrath is feared throughout the world. Combat is their life: they feel no fear, and they learn to enter battle frenzy at will even sooner than half-trolls. Barbarians are, however, suspicious of magic, which makes magic devices fairly hard for them to use. ",

"Half-Ogres are like Half-Orcs, only more so. They are big, bad, and stupid. For warriors, they have all the necessary attributes, and they can even become wizards: after all, they are related to Ogre Magi, from whom they have learned the skill of setting trapped runes once their level is high enough. Like Half-Orcs, they resist darkness, and like Half-Trolls, they have their strength sustained.",

"Half-Giants limited intelligence makes it difficult for them to become full spellcasters, but with their huge strength they make excellent warriors. Their thick skin makes them resistant to shards, and like Half-Ogres and Half-Trolls, they have their strength sustained.",

"Half-mortal descendants of the mighty titans, these immensely powerful creatures put almost any other race to shame. They may lack the fascinating special powers of certain other races, but their enhanced attributes more than make up for that. They learn to estimate the strengths of their foes, and their love for law and order makes them resistant to the effects of Chaos.",

"With but one eye, a Cyclops can see more than many with two eyes. They are headstrong, and loud noises bother them very little. They are not quite qualified for the magic using professions, but as a certain Mr. Ulysses can testify, their accuracy with thrown rocks can be deadly...",

"Yeeks are among the most pathetic creatures. Fortunately, their horrible screams can scare away less confident foes, and their skin becomes more and more resistant to acid, as they gain experience. But having said that, even a mediocre monster can wipe the proverbial floor with an unwary Yeek.",

"Klackons are bizarre semi-intelligent ant-like insectoid creatures. They make great fighters, but their mental abilities are severely limited. Obedient and well-ordered, they can never be confused. They are also very nimble, and become faster as they advance levels. They are also very acidic, inherently resisting acid, and capable of spitting acid at higher levels. ",

"Kobolds are a weak goblin race. They love poisoned weapons, and can learn to throw poisoned darts (of which they carry an unlimited supply). They are also inherently resistant to poison, although they are not one of the more powerful races.",

"The hated and persecuted race of nocturnal dwarves, these cave-dwellers are not much bothered by darkness. Their natural inclination to magical items has made them immune to effects which could drain away magical energy.",

"Another dark, cave-dwelling race, likewise unhampered by darkness attacks, the Dark Elves have a long tradition and knowledge of magic. They have an inherent magic missile attack available to them at a low level. With their keen sight, they also learn to see invisible things as their relatives High-Elves do, but at a higher level.",

"A humanoid race with dragon-like attributes. As they advance levels, they gain new elemental resistances (up to Poison Resistance), and they also have a breath weapon, which becomes more powerful with experience. The exact type of the breath weapon depends on the Draconian's class and level. With their wings, they can easily escape any pit trap unharmed.",

"A secretive and mysterious ancient race. Their civilization may well be older than any other on our planet, and their intelligence and wisdom are naturally sustained, and are so great that they enable Mind Flayers to become more powerful spellcasters than any other race, even if their physical attributes are a good deal less admirable. As they advance levels, they gain the powers of See Invisible and Telepathy.",

"A demon-creature from the nether-world, naturally resistant to fire attacks, and capable of learning fire bolt and fire ball attacks. They are little loved by other races, but can perform fairly well in most professions. As they advance levels, they gain the powers of See Invisible.",

"A Golem is an artificial creature, built from a lifeless raw material like clay, and awakened to life. They are nearly mindless, making them useless for professions which rely on magic, but as warriors they are very tough. They are resistant to poison, they can see invisible things, and move freely. At higher levels, they also become resistant to attacks which threaten to drain away their life force. Golems gain very little nutrition from ordinary food. Golems also gain a natural armor class bonus from their tough body.",

"There are two types of skeletons: the ordinary, warrior-like skeletons, and the spell-using skeletons, which are also called liches. As undead beings, skeletons need to worry very little about poison or attacks that can drain life. They do not really use eyes for perceiving things, and are thus not fooled by invisibility.  Their bones are resistant to sharp shrapnel, and they will quickly become resistant to cold. Although the magical effects of these will affect the skeleton even without entering the skeleton's (non-existent) belly, the potion or food itself will fall through the skeleton's jaws, giving no nutritional benefit.",

"Much like Skeletons, Zombies too are undead horrors: they are resistant to life-draining attacks, and can learn to restore their life-force. Like skeletons, they become resistant to cold-based attacks (actually earlier than skeletons), resist poison and can see invisible. While still vulnerable to cuts (unlike skeletons), Zombies are resistant to Nether. Like Golems, they gain very little nutrition from the food of mortals.",

"One of the mightier undead creatures, the Vampire is an awe-inspiring sight. Yet this dread creature has a serious weakness: the bright rays of sun are its bane, and it will need to flee the surface to the deep recesses of earth until the sun finally sets. Darkness, on the other hand, only makes the Vampire stronger. As undead, the Vampire has a firm hold on its life force, and resists nether attacks. The Vampire also resists cold and poison based attacks. It is, however, susceptible to its perpetual hunger for fresh blood, which can only be satiated by sucking the blood from a nearby monster.",

"Another powerful undead creature: the Spectre is a ghastly apparition, surrounded by an unearthly green glow. They exist only partially on our plane of existence: half-corporeal, they can pass through walls, although the density of the wall will hurt them in the process of doing this. As undead, they have a firm hold on their life force, see invisible, and resist poison and cold. They also resist nether. At higher levels they develop telepathic abilities. Spectres make superb spellcasters, but their physical form is very weak.",

"One of the several fairy races, Sprites are very small. They have tiny wings and can fly over traps that may open up beneath them. They enjoy sunlight intensely, and need worry little about light based attacks. Although physically among the weakest races, Sprites are very talented in magic, and can become highly skilled wizards. Sprites have the special power of spraying Sleeping Dust, and at higher levels they learn to fly faster.",

 "This race is a blasphemous abomination produced by Chaos. It is not an independent race but rather a humanoid creature, most often a human, twisted by the Chaos, or a nightmarish crossbreed of a human and a beast. All Beastmen are accustomed to Chaos so much that they are untroubled by confusion and sound, although raw logrus can still have effects on them. Beastmen revel in chaos, as it twists them more and more. Beastmen are subject to mutations: when they have been created, they receive a random mutation. After that, every time they advance a level they have a small chance of gaining yet another mutation.",

"The Ents are a powerful race dating from the beginning of the world, oldest of all animals or plants who inhabit Arda. Spirits of the land, they were summoned to guard the forests of Middle-earth. Being much like trees they are very slow but strong, and very susceptible to fire. As the Shepherds of the Trees, they have the innate ability to cause trees to rise about them for protection.",

"Archons are a higher class of angels. They are good at all skills, and are strong, wise, and are a favorite with any people. They are able to see the unseen, and their wings allow them to safely fly over traps and other dangerous places. However, belonging to a higher plane as they do, the experiences of this world do not leave a strong impression on them and they gain levels slowly.",

"Balrogs are a higher class of demons. They are strong, intelligent and tough. They do not believe in gods, and are not suitable for priest at all. Balrog are resistant to fire and nether, and have a firm hold on their life force. They also eventually learn to see invisible things. They are good at almost all skills except stealth.",

"Dunedain are a race of hardy men from the West. This elder race surpasses human abilities in every field, especially constitution. However, being men of the world, very little is new to them, and levels are very hard for them to gain. Their constitution cannot be reduced. ",

"Shadow Fairies are one of the several fairy races. They have wings, and can fly over traps that may open up beneath them. Shadow Fairies must beware of sunlight, as they are vulnerable to bright light. They are physically weak, but have advantages in using magic and are amazingly stealthy. Shadow Fairies have a wonderful advantage in that they never aggravate monsters (If their equipment normally aggravates monsters, they only suffer a penalty to stealth, but if they aggravate by their personality itself, the advantage will be lost).",

"A Kutar is an expressionless animal-like living creature. The word 'kuta' means 'absentmindedly' or 'vacantly'. Their absentmindedness hurts their searching and perception skills, but renders them incapable of being confused.  Their unearthly calmness and serenity make them among the most stealthy of any race.  Kutars, although expressionless, are beautiful and so have a high charisma.  Members of this race can learn to expand their body horizontally.  This increases armour class, but renders them vulnerable to magical attacks.",

"An android is a artificial creation with a body of machinery. They are poor at spell casting, but they make excellent warriors. They don't acquire experience like other races, but rather gain in power as they attach new equipment to their frame. Rings, amulets, and lights do not influence growth. Androids are resistant to poison, can move freely, and are immune to life-draining attacks. Moreover, because of their hard metallic bodies, they get a bonus to AC. Androids have electronic circuits throughout their body and must beware of electric shocks."

#endif
};

static cptr class_jouhou[MAX_CLASS] =
{
#ifdef JP
"Τϡľ̤ΤۤȤɤڤáڤ뤳Ȥǲ褹륭饯ǤѤˡƻäˤʤ뤳Ȥ⤢ޤԱˤ⡢٥ʥƥ¿餬ϰϤۤƤޤ",
  
"ᥤˡȤǤꡢεΤˤäӤʤФʤޤΤΤ褦ˡñڤޤ뤳Ȥƻ򳫤Ȥ˾ޤ󡣼ʸ˲äơᥤϽˤʤˡƻ֤٤Ǥ¾βڤ˴ñ˥ޥǤޤˡɬפǽͤǽǤ",
  
"ץ꡼ȤϹ⵮ϤȤȤǰ饯ǤϼȤοΤ˥󥸥õ⤷ˤ줿ʤ顢बĤ뽡αɸȤʤޤץ꡼ȤϿ£ʪȤǼ뤿ᡢɤؤ֤Τʬ֤ȤϤǤޤ󡣥ץ꡼ȤˡƻλȤ褯ΤäƤޤᥤۤɤޤϻȤޤ󡣿ϤΤĤߴ򹥤ߡʡƤʤϤΤĤʴФ˽졢ƮǽϤƤޤޤˡɬפǽͤϸǤ",
  
"±ϤѤȴȤ򹥤७饯ǤοʤȤˤƮƻڤ곫ȤǤޤ±櫤ɥ򸫤ĤǽϤͥ졢櫤β丰˽ãƤޤ±Ϲ⤤̩ưΥ󥹥ηΤФ򵯤Ȥʤ̤ȴꡢǦӴä⤹뤳ȤǤޤˡɬפǽͤǽǤ",
  
"󥸥㡼Τȥᥤ碌褦ʿȤǡȤβμ̤ʴط夲ƤޤϤΤǤꡢݤΤ褦ʱΥ򹪤Ȥ뿦ȤǤ󥸥㡼Ϥ褤̩ư褤γС褤õ褤ˡɸˡƻλѤˤĹƤޤˡɬפǽͤǽǤ",
  
"ѥǥΤȥץ꡼Ȥ碌ȤǤѥǥϤȤƤ褤ΤǤΥ򰷤ΤդǤϤޤ󡣥ѥǥˤ¿ǽϤ礱Ƥޤ̩ư, γ, õ, ˡƻѤǤοȤȤˤäˡɸϤǤˡɬפǽͤϸǤ",
  
"ˡΤϤ̾Τ̣̤οȤǤꡢΤȥᥤλ򤢤碌ޤƱȼԤǤ󥸥㡼ˡȴΥòƤˡΤϤɤǤ֤ˤʤȤƤޤΤȤƤ̤ΥᥤȤʪˤʤʤۤͥƤޤºݤˤˡǤƮǤοȤˤϵڤФΤȥᥤ֤˰֤褦ʿȤǤˡɬפǽͤǽǤ",
  
"٤Τ϶٤ⲦλȤȤƶ¸ߤǤ٤ΤϥѥȥȤʤ밭٥뤬夬٤󽷤뤳ȤޤϼŤƤ줿ꡢѲꡢǽͤ夲Ƥ뤫⤷ޤ󤷡˲ʪãиꡢǽͤåΤޤ󡣤⤷ñˤ̵뤹⤷ޤ󡣥Ⲧ̵ͽ¬ΤĤʤ¸ߤǤ󽷤μϥѥȥȤʤ밭ȶ˰¸ޤʰ㤦ϰۤʤ󽷤ͿޤˡˡɬפǽͤǽǤ",
  
"Τ¾οȤȤۤʤ뿦ȤǤ¾οƱɶȤޤޡ륢ĤηѤǤ뤿ᡢɶʤǤ궯Ϥ¸ߤȤʤޤ٥ǤϡɬפȤˤĤ뤿ᤢɶɬפޤ⤷ޤ˽ŤɶƤޤȡνѤ˿˸Ȥʤޤ٥뤬夬ȡϿϤʹˡؤӡɸǽϤ徺ޤˡɬפǽͤϸǤ",
  
"ĶǽϼԤˡΤˤϤȤͣοȤǤϤĶǽϼäΤΤǡñĶŪʤΤ¾ͤۤΤޤ͡ǤϤϤηˤäƳȯΤʤΤǡĶǽϼԤϤȤΤ˼ʸɬפȤޤ󡣻ȤϤñ˥饯Υ٥ˤäƷޤޤĶǽϤɬפǽͤϸǤ",
  
"ϥᥤϰĤΰòΰ̾ΥᥤϤ뤫˿ؤᥤǤĤΰòǡϼ餬򤷤ΰμʸ򾧤ݤξͣС٥롢Ψʲäޤ̿ΰǤϥץ꡼ȤۤɤޤϤʤʤȤˤդ٤ǤˡɬפǽͤǽǤ",
  
"ѸҤϴѸΤˤˤäƤޤƮϤ㤯ϤʼʸȤȤǤʤᡢǤ̤ƤΤȤȸޤˡɬפǽͤǽǤ",
  
"ΤޤͻդƮϤϤޤʬüǽϤȤȤǤޤ󡣤ʬܤˤ꤬üǽϤȤä硢ǽϤƱǽϤ򤽤äꤽΤޤ޻ȤȤǤޤΤޤͤɬפǽϤϴŪ˴ѤǤޤͤüǽϤ˴ط¾ǽϤɬפǤ",
  
"ûȤѶΥ󥸥˽ʪȿ̤碌ޤϺǤ⤦ޤ󥹥ꤳʤȤǤʤŤꤷ󥹥ʬμ­Τ褦˻ȤޤˡɬפǽϤ̥ϤǤ",
  
"ڥޥƤˡˤԤǤʬˤͥ줿ˡȤǤꡢˡΤ٤Ƥμʸؽμ֤ʤȤʤȤǤޤȿ̡ΤȤƤϺǡɤ­˰ޤѻդξ㳰ǤȤƤϻȤʪˤʤʤǤ礦٤Ƥˡ򤦤ޤʤФʤʤᡢ˾ԸʿȤȸޤˡɬפǽϤǽǤ",
  
"㡼ˡȤȤϤǤޤ󤬡ɤʿȤ⹪ߤ˵ݤ䥹󥰤Ȥʤޤ̤ƤɬפȤΤϳΤǤФ饹ѤƤäꡢ٥뤬夬ȥ󥹥ι䤬餯äꤹ뵻ѤȤˤĤޤޤΤ٤Ʊ̩ưγСõˡƻλѤʤɤˤͥƤꡢȤȤˤˡƻ뤳ȤǤޤ",
  
"ƻѻդϾˡåɤȤäˡΥƥफϤळȤˤäˡȤޤˡΥƥȯ뤳Ȥ¾οȤϤ뤫˽פˤʤޤƮϤϹ⤯ϤʤǤζޤˡɬפǽϤǽǤ",
  
"ͷͤϤӤӤΤΤȤǤޤ¿βΤ̤ˡȰۤʤꡢΤΤäƤַ³Ƹ̤ȯޤƱ2ĤβΤΤȤǤʤȤ⤢ޤ볦Τ˱ƶڤܤΤ¿Ȥħ⤢ޤŪǽϤϼǡñڤޤ뤳Ȥƻ򳫤ȤϤǤޤˡɬפǽϤ̥ϤǤ",
  
"ƻդϲˡΤۤȤɤȤȤǤƮϤ⽽ʬˤޤ٥뤬夬ȶϤǽϡϢ³פȤˤĤ뤳ȤǤޤˡФ륹ԡɤ٤ˡȤʤΤǡᥤۤɤˤˡˤ뤳ȤǤޤˡƻѤˡɸϤǤʳεǽ϶ǤˡɬפǽϤǽǤ",
  
"ѲȤΤ˼ƮϤꡢ͡ʵȤȤǤޤMPϥ٥˰¸Ƿޤꡢ礤򤿤뤳ȤˤꡢͤۤMP䤹ȤǤޤΤƱ͡٥ˡΥƥΰϰϤۤƤꡢ櫤βõǽϤ⤤ȤϤޤɬλѤɬפǽϤϸǤ",
  
"ѻդϡֵפȤãͤǤΤƱ͡ɶ臘Ȥ򹥤ߡɶʤǤ궯Ϥ¸ߤȤʤޤΤۤɤƮǽϤϤޤ󤬡ΤƱͤˡȤˡֵפϤޤĤȤ䡢Ťɶ뤳ȤϡֵפϤλѤ˸ޤˡѤɬפǽϤϸǤ",
  
"ƻդͥ줿ˡȤǤꡢεΤˤäӤʤФʤޤ󡣥ᥤ¾ˡȤȤΰ㤤ˡγФǡƻդϥ󥹥ˡθ̤뤳ȤǤˡФޤФ뤿ˤϡ֥顼˥󥰡פξ֤ˤʤäƤʤȤޤˡɬפǽϤǽǤ",
  
"ʼϤ˾ȴ륨꡼ΤǤˡϻȤޤ󤬡Ͼ夫ΰŪʹϤؤˡ⤤ưϤͷդȤƤޤ٥뤬夬СΥ󥹥ˤޤ̵ʤ뤳ȤǤޤϸʤΤ˸ؤˡƻˤϤޤȤϤޤ",
  
"Τܤ궸ä򿶤뤦٤ΤǤǹǽϤؤꡢݤФ٥뤬夬Фζ٤Τμʸķ֤ȤǤޤʤ臘Ȥ䡢Τ줿ϤŤȤǤĤε(ȿˡ֤Ǥ)ȤȤǤޤʪˡƻȤȤǤ櫤β䱣̩ưõˡɸ桢ƻεǽ˴ؤƤ˾ŪǤҤ鲥äƻ򳫤ޤ󡣥Х饤Ȥͩ˾䤹Ǥʤ㤯ޤ",

"դɶʬǶ뤳ȤǤޤṳ̈ɶ񤫤ṳ̈θȤʤ륨å󥹤Ф̤ɶ˥å󥹤ղä뤳ȤˤäƤṳ̈ղäǤޤ٤ƮǽϤޤˡϰڻѤǤ̩ˡɸεǽ㤯ʤޤ",

"ȤϡϤι줿ФơޤȤƹԤʤȤǤˡȤޤȤ϶ξǼϤȯξǤᤤƥݡȤǽȤʤޤˡζϡ٥ˤäư٤Ǥ¤ޤˡɬפǽϤǽǤ",

"ǦԤϰŰǤ඲٤ŻԤǤꡢ˹ư԰դĤ©κߤޤޤǤ魯ǦѤȤˤĤޤ櫤ɥ򸫤ĤǽϤͥ졢櫤β丰˽ãƤޤ򹥤ߡŤư¤졢ޤ褦ȤϤޤ󡣷ʤС٥뤬夬ˤĤ®Ť˹ưǤޤǦԤ϶ݤĹǤۤȤɸʤʤꡢƩʤΤ򸫤뤳ȸ뤳ȤǤ褦ˤʤޤǦѤɬפǽϤϴѤǤ"

#else

"A Warrior is a hack-and-slash character, who solves most of his problems by cutting them to pieces, but will occasionally fall back on the help of a magical device. Unfortunately, many high-level devices may be forever beyond their use.",

"A Mage is a spell caster that must live by his wits as he cannot hope to simply hack his way through the dungeon like a warrior. In addition to his spellbooks, a mage should carry a range of magical devices to help him in his endeavors which he can master far more easily than anyone else. A mage's prime statistic is Intelligence as this determines his spell casting ability. ",

"A Priest is a character devoted to serving a higher power. They explore the dungeon in the service of their God. Since Priests receive new prayers as gifts from their patron deity, they cannot choose which ones they will learn. Priests are familiar with magical devices which they believe act as foci for divine intervention in the natural order of things. A priest wielding an edged weapon will be so uncomfortable with it that his fighting ability. A Priest's primary stat is Wisdom since this determine his success at praying to his deity. ",

"A Rogue is a character that prefers to live by his cunning, but is capable of fighting his way out of a tight spot. Rogues are good at locating hidden traps and doors and are the masters of disarming traps and picking locks. A rogue has a high stealth allowing him to sneak around many creatures without having to fight, or to get in a telling first blow. A rogue may also backstab a fleeing monster. Intelligence determines a Rogue's spell casting ability.",

"A Ranger is a combination of a warrior and a mage who has developed a special affinity for the natural world around him. He is a good fighter and also good about a missile weapon such as a bow. A ranger has a good stealth, good perception, good searching, a good saving throw and is good with magical devices. Intelligence determines a Ranger's spell casting ability.",

"A Paladin is a combination of a warrior and a priest. Paladins are very good fighters, but not very good at missile weapons. A paladin lacks much in the way of abilities. He is poor at stealth, perception, searching, and magical devices but has a decent saving throw due to his divine alliance. Wisdom determines a Paradin's success at praying to his deity.",

"A Warrior-Mage is precisely what the name suggests: a cross between the warrior and mage classes. While their brothers, the rangers, specialize in Nature magic and survival skills, true Warrior-Mages attempt to reach the best of both worlds. As warriors they are much superior to the usual Mage class. Intelligence determines a Warrior-Mage's spell casting ability.",

"Chaos Warriors are the feared servants of the terrible Demon Lords of Chaos. Every Chaos Warrior has a Patron Demon and, when gaining a level, may receive a reward from his Patron. He might be healed or polymorphed, his stats could be increased, or he might be rewarded with an awesome weapon. On the other hand, the Patrons might surround him with monsters, drain his stats or wreck his equipment or they might simply ignore him. The Demon Lords of Chaos are chaotic and unpredictable indeed. The exact type of reward depends on both the Patron Demon (different Demons give different rewards) and chance.",

"The Monk character class is very different from all other classes. Their training in martial arts makes them much more powerful with no armor or weapons. To gain the resistances necessary for survival a monk may need to wear some kind of armor, but if the armor he wears is too heavy, it will severely disturb his martial arts maneuvers. As the monk advances levels, new, powerful forms of attack become available. Their defensive capabilities increase likewise, but if armour is being worn, this effect decreases. Wisdom determines a Monk's spell casting ability.",

"The Mindcrafter is a unique class that uses the powers of the mind instead of magic. These powers are unique to Mindcrafters, and vary from simple extrasensory powers to mental domination of others. Since these powers are developed by the practice of certain disciplines, a Mindcrafter requires no spellbooks to use them. The available powers are simply determined by the character's level. Wisdom determines a Mindcrafter's ability to use mind powers,",

"High-mages are mages who specialize in one particular field of magic and learn it very well - much better than the ordinary mage. For the price of giving up a second realm of magic, they gain substantial benefits in the mana costs, minimum levels, and failure rates in the spells of the realm of their specialty. A high mage's prime statistic is intelligence as this determines his spell casting ability. ",

"Tourists have visited this world for the purpose of sightseeing. Their fighting skills is bad, and they cannot cast powerful spells. They are the most difficult class to win the game with. Intelligence determines a tourist's spell casting ability.",

"Imitators have enough fighting skills to survive, but rely on their ability to imitate monster spells.  When monsters in line of sight use spells, they are added to a temporary spell list which the imitator can choose among.  Spells should be imitated quickly, because timing and situation are everything.  An imitator can only repeat a spell once each time he observes it.  Dexterity determines general imitation ability, but a stat related to the specific action is often also taken into account.",

"Beastmasters are in tune with the minds of the creatures of the world of Hengband. They are very good at riding, and have enough fighting ability. They use monsters which summoned or dominated by him as his hands and feet. Beastmasters can cast trump magic, and very good at summoning spell, but they can not summon non-living creatures. Charisma determines a Beastmaster's spell casting ability.",

"Sorcerers are the all-around best magicians, being able to cast any spell from most magic realms without having to learn it. On the downside, they are the worst fighters in the dungeon, being unable to use any weapon but a Wizardstaff.",

"Archers are to bows what warriors are to melee. They are the best class around with any bow, crossbow, or sling. They need a lot of ammunition, but will learn how to make it from junk found in the dungeon. An archer is better than a warrior at stealth, perception, searching and magical devices.",

"Magic-Eaters can absorb the energy of wands, staffs, and rods, and can then use these magics as if they were carrying all of these absorbed devices. They are middling-poor at fighting. A Magic-Eater's prime statistic is intelligence.",

"Bards are something like traditional musicians. Their magical attacks are sound-based, and last as long as the Bard has mana. Although a bard cannot sing two or more songs at the same time, he or she does have the advantage that many songs affect all areas in sight. A bard's prime statistic is charisma.",

"Red-Mages can use almost all spells from lower rank spellbooks of most realms without having to learn it. At higher level, they develop the powerful ability \"Double Magic\". However, they have large penalties in the mana costs, minimum levels, and failure rates of spells, and they cannot use any spells from higher rank spellbooks. They are not bad at using magical devices and magic resistance, and are decent fighter, but are bad at other skills. A red-mage's prime statistic is intelligence.",

"Samurai, masters of the art of the blade, are the next strongest fighters after Warriors. Their spellpoints do not depend on level, but depend solely on wisdom, and they can use the technique Concentration to temporarily increase SP beyond its usual maximum value. Samurai are not good at most other skills, and many magical devices may be too difficult for them to use. Wisdom determines a Samurai's ability to use the special combat techniques available to him.",

"A ForceTrainer is a master of the spiritual Force. They prefer fighting with neither weapon nor armor. They are not as good fighters as are Monks, but they can use both magic and the spiritual Force. Wielding weapons or wearing heavy armor disturbs use of the Force. Wisdom is a ForceTrainer's primary stat.",

"A Blue-Mage is a spell caster that must live by his wits, as he cannot hope to simply hack his way through the dungeon like a warrior. A major difference between the Mage and the Blue-Mage is the method of learning spells: Blue-Mages may learn spells from monsters by activating his Learning ability. A Blue-Mage's prime statistic is Intelligence as this determines his spell casting ability. ",

"Cavalry ride on horses into battle. Although they cannot cast spells, they are proud of their overwhelming offensive strength on horseback. They are good at shooting. At high levels, they learn to forcibly saddle and tame wild monsters. Since they take pride in the body and the soul, they don't use magical devices well.",

"A Berserker is a fearful fighter indeed, immune to fear and paralysis. At high levels, Berserkers can reflect bolt spells with their tough flesh. Furthermore, they can fight without weapons, can remove cursed equipment by force, and can even use their special combat techniques when surrounded by an anti-magic barrier. Berserkers, however, cannot use any magical devices or read any scrolls, and are hopeless at all non-combat skills. Since Berserker Amberite or Spectres are quite easy to *win* with, their scores are lowered.",

"A Weaponsmith can improve weapons and armors for him or herself. They can extract the essences of special effects from weapons or armors which have various special abilities, and can add these essences to another weapon or armor. They are good at fighting, but cannot cast spells, and are poor at skills such as stealth or magic defense.",

"Mirror-Masters are spell casters; like other mages, they must live by their wits. They can create magical mirrors, and employ them in the casting of Mirror-Magic spells. A Mirror-Master standing on a mirror has greater ability and, for example, can perform quick teleports. The maximum number of Magical Mirrors which can be controlled simultaneously depends on the level. Intelligence determines a Mirror-Master's spell casting ability.",

"A Ninja is a fearful assassin lurking in darkness.  He or she can navigate effectively with no light source, catch enemies unawares, and kill with a single blow. Ninjas can use Ninjutsu, and are good at locating hidden traps and doors, disarming traps and picking locks. Since heavy armors, heavy weapons, or shields will restrict their motion greatly, they prefer light clothes, and become faster and more stealthy as they gain levels. A Ninja knows no fear and, at high level, becomes almost immune to poison and able to see invisible things. Dexterity determines a Ninja's ability to use Ninjutsu."
#endif
};


static cptr seikaku_jouhou[MAX_SEIKAKU] =
{
#ifdef JP
"դĤϡäɮ٤ʬʤʤǤ뵻ǽʿŪˤʤޤ",

"餸ޤϡŪǽϤ䵻ǽ徺ޤˡ˴طǽϤ䵻ǽꡢΤΥơޤ",

"ΤϡŪǽϤϲޤǽˡ˴ط뵻ǽϾ徺ᥤΥơޤ",

"碌Τϡ򿮶ĤǽϤ⤯ʤޤŪˤʿŪǽϤץ꡼Ȥ˶ᤤơȤʤޤ",

"ФäϡɤΥŪޤʤޤŪǽϤ㤯ʤޤ",

"Τ餺ϡƮϡˡǽϤξ徺ޤˡɸ桢ȣФȤäǽϤϰʤޤ",

"ʿʪϾƤӡեޤƤϤ뤬ʰɤϵͦȤʿѰʾäȤ䤹⤢롣ײŪԤФäοǤޤפǡΰ϶ꡣ",

"ʤޤΤϡ륹뤬㤯äƤ⤦ޤޤ",

"ϡ륹򤦤ޤʤȤǤޤοͤʤ᤿ʤƤΥ󥹥ܤ餻뤳ȤˤʤǤ礦ʤϽ֤ȤǤޤ",

"åޥϡǽͤϤʤޤΤɤŨ뤯餤㤤ˤ⤫餺ɤʤȤ򤷤ƤʤޤäƤޤޤʤ֤ȤǤޤ",

"ޤŤ褤ϡäʪˤȤ꤯࿵Ťʤǡ¾ʤ٤ƹ⤤ѵϤ뤳ȤǤޤʬưΤ϶ǡ¿εǽ㤯ʤäƤޤޤ",

"ޤϡ鿴ԤѤʤǤǽϤ⤯ʤäƤޤʤȤоԤˤʤ뤳ȤưפǤƤˤʤޤ",

#else

"\"Ordinary\" is a personality with no special skills or talents, with unmodified stats and skills.",

"\"Mighty\" raises your physical stats and skills, but reduces stats and skills which influence magic. It makes your stats suitable for a warrior. ",

"\"Shrewd\" reduces your physical stats, and raises your intelligence and magical skills. It makes your stats suitable for a mage.",

"\"Pious\" deepens your faith in your God. It makes your physical ability average, and your stats suitable for priest. ",

"\"Nimble\" renders you highly skilled comparatively well, but reduces your physical ability. ",

"\"Fearless\" raises both your melee and magical ability. Stats such as magic defense and constitution are reduced. ",

"\"Combat\" gives you comparatively high melee and shooting abilities, and average constitution. Other skills such as stealth, magic defence, and magical devices are weakened. All \"Combat\" people have great respect for the legendary \"Combat Echizen\".\n\
(See \"Death Crimson\" / Ecole Software Corp.)",

"A \"Lazy\" person has no good stats and can do no action well.",

"\"Sexy\" rises all of your abilities, but your haughty attitude will aggravate all monsters. Only females can choose this personality.",

"A \"Lucky\" man has poor stats, equivalent to a \"Lazy\" person. Mysteriously, however, he can do all things well. Only males can choose this personality.",

"A \"Patient\" person does things carefully. Patient people have high constitution, and high resilience, but poor abilities in most other skills.",

"\"munchkin\" is a personality for beginners. It raises all your stats and skills. With this personality, you can win the game easily, but gain little honor in doing so."
#endif
};

static cptr realm_jouhou[VALID_REALM] =
{
#ifdef JP
"̿ϡ֤褤ˡǤϼŤɸäƤޤʸ⤤ĤäƤޤϰα줿й뤿ˤ褯Ȥޤ",

"ѤϡmetaΰǤꡢΤꡢѤμʸ伫ȤǽϤʸʤɤʼʸޤޤƤޤľܹѤμʸϻäƤޤ",

"ˡϻѼԤǤΥޥˤޤˤɸ桢õΡŤȹʸޤޤƤޤޤ̿ʳΰǺǹμżʸ⤳ΰˤޤ",

"ˡ椬ǡͽ¬ΤǤʤˡ⤢ޤŪǤꡢμʸǤǤⶲ٤˲ʼǤμʸ򾧤ΤϥʼФŨ伫ʬȤѰۤ褦׵ᤷޤ",

"ѤǤŹˡۤɼٰʥƥ꡼Ϥޤ󡣤μʸŪؤ֤ΤǤ٥ˤʤȽѼԤʪȥǥåɤͳǽϤͿޤǰʤȤˡäȤ⶯ϤʼʸϤοޤȤƽѼԼȤηɬפȤӾˤФнѼԤĤޤ",

"ȥפˡϥƥݡȷϤμʸ줿ΤäƤꡢν¾ʪ򾤴뤿ˤȤ뤿ᡢʸꤹ줿ΤƱͤ˻äƤޤˡˤäƤβʪ̤ξظƤФΤ򤹤櫓ǤϤʤ⤷ʸ˼ԤȤʪŨȤʤޤ",

"ѤˡϡƤΰ褫ͭѤʼʸ褦Ȥ¿ΰǤɬפʡƻŪʸäƤƤ٥ζϤʼʸϻäƤޤ󡣷̤ȤơƤμʸϳ㤤뤳ȤǤޤޤ¾ΰ¸ߤƱͤʼʸ٥롢㥳ȤǾ뤳ȤǤޤ",

"ˡϡʬƻ򶯲뤿ˡޤޤƤޤˡˤäƼʬȤƮϤ˹뤳ȤǤޤľܹ⤹褦ʼʸϴޤޤƤޤ",

"ˡϰŹƱ˼ٰʥƥ꡼Ǥ͡ʹˡͥ졢ޤΤȤγǽϤ뤳ȤǤޤ٥μʸϰ򼫺ߤꡢʬȤΤⰭⲽ뤳ȤǤޤ",

"νϡΤˤäƸ̤ȯˡǤˡƱ͡Ȥä˸̤ΤΤȡΤ³뤳Ȥˤäƻ³Ƹ̤ȯΤޤԤξϡMP³¤̤ȯ뤳ȤǤޤƱ˲ΤΤ1ĤȤ¤⤢ޤ",

"ݤνϡ͡ƮεˤĤƽ񤫤ƤޤܤϵФȤɤɬפޤٳФϻȤΤܤɬפϤޤ󡣵ȤȤˤɬƤʤФޤ"

#else

"Life is 'good' magic; it relies mostly on healing and protective spells. It does have a few attack spells as well, but these are mostly used for harming and banishing foul minions of evil. ",

"Sorcery is a `meta` realm, including enchantment and general spells. It provides superb protection spells, spells to enhance your odds in combat and, most importantly, a vast selection of spells for gathering information. However, Sorcery has one weakness: it has no spells to deal direct damage to your enemies.",

"Nature magic makes you master of elements; it provides protection, detection, curing and attack spells. Nature also has a spell of Herbal Healing, which is the only powerful healing spell outside the realm of Life magic.",

"There are few types of magic more unpredictable and difficult to control than Chaos magic. Chaos is the very element of unmaking, and the Chaos spells are the most terrible weapons of destruction imaginable. The caster can also call on the primal forces of Chaos to induce mutations in his/her opponents and even him/herself.",

"There is no fouler nor more evil category of spells than the necromantic spells of Death Magic. These spells are relatively hard to learn, but at higher levels the spells give the caster power over living and the (un)dead, but the most powerful spells need his / her own blood as the focus, often hurting the caster in the process of casting.",

"Trump magic has, indeed, an admirable selection of teleportation spells. Since the Trump gateways can also be used to summon other creatures, Trump magic has an equally impressive selection of summoning spells. However, not all monsters appreciate being drawn to another place by Trump user.",

"Arcane magic is a general purpose realm of magic. It attempts to encompass all 'useful' spells from all realms. This is the downside of Arcane magic: while Arcane does have all the necessary 'tool' spells for a dungeon delver, it has no ultra-powerful high level spells. As a consequence, all Arcane spellbooks can be bought in town. It should also be noted that the 'specialized' realms usually offer the same spell at a lower level and cost. ",

"Craft magic can strengthen the caster or equipments. These spells greatly improve the caster's fighting ability, but spells that hurts opponents directly is not exist.",

"Demon is a very evil realm, same as Death. It provides various attack spells and devilish detection spells. at higher levels, Demon magic provides ability to dominate demons, and to polymorph yourself into a demon.",

"Music magic shows various effects as sing song. There is two type of song; the one which shows effects instantly and the other one shows effect continuously until SP runs out. But the latter type has a limit; only one song can be sing at the same time.",

"The books of Kendo describes various combat technique. it need to read the books when one studys the techniques, but it doesn't need to take around the books to use the techniques after one momorizes it. It need a weapon wielded to use the techniques."
#endif
};


/*
 * Current stats
 */
static s16b stat_use[6];

/*
 * Autoroll limit
 */
static s16b stat_limit[6];

static s16b chara_limit[6];

/*
 * Autoroll matches
 */
static s32b stat_match[6];

/*
 * Autoroll round
 */
static s32b auto_round;


static void birth_quit(void)
{
	remove_loc();
	quit(NULL);
}

/*
 * Choose from one of the available magical realms
 */
static byte choose_realm(s32b choices, int *count)
{
	int picks[VALID_REALM] = {0};
	int k, i;
	byte auto_select = REALM_NONE;
	int n = 0;
	char c;
	char p2 = ')';
	char buf[80];

	/* Count the choices */
	if (choices & CH_LIFE)
	{
		(*count)++;
		auto_select = REALM_LIFE;
	}
	if (choices & CH_SORCERY)
	{
		(*count)++;
		auto_select = REALM_SORCERY;
	}
	if (choices & CH_NATURE)
	{
		(*count)++;
		auto_select = REALM_NATURE;
	}
	if (choices & CH_CHAOS)
	{
		(*count)++;
		auto_select = REALM_CHAOS;
	}
	if (choices & CH_DEATH)
	{
		(*count)++;
		auto_select = REALM_DEATH;
	}
	if (choices & CH_TRUMP)
	{
		(*count)++;
		auto_select = REALM_TRUMP;
	}
	if (choices & CH_ARCANE)
	{
		(*count)++;
		auto_select = REALM_ARCANE;
	}
	if (choices & CH_ENCHANT)
	{
		(*count)++;
		auto_select = REALM_ENCHANT;
	}
	if (choices & CH_DAEMON)
	{
		(*count)++;
		auto_select = REALM_DAEMON;
	}
	if (choices & CH_MUSIC)
	{
		(*count)++;
		auto_select = REALM_MUSIC;
	}
	if (choices & CH_HISSATSU)
	{
		(*count)++;
		auto_select = REALM_HISSATSU;
	}

	clear_from(14);

	/* Auto-select the realm */
	if ((*count) < 2) return auto_select;

	if (p_ptr->pclass == CLASS_PRIEST)
	{
		if (p_ptr->realm1 == REALM_LIFE)
		{
			choices &= ~(CH_DEATH | CH_DAEMON);
		}
		else if ((p_ptr->realm1 == REALM_DEATH) || (p_ptr->realm1 == REALM_DAEMON))
		{
			choices &= ~(CH_LIFE);
		}
	}

	/* Extra info */
#ifdef JP
	Term_putstr(5, 14, -1, TERM_WHITE,
		    "ˡΰˤꤢʤʸΥפޤޤ");
#else
	Term_putstr(5, 14, -1, TERM_WHITE,
		    "The realm of magic will determine which spells you can learn.");
#endif

#ifdef JP
	Term_putstr(5, 15, -1, TERM_WHITE,
		    "̿ѤɸѤΡȰŹ˲ŪʼʸǤ");
#else
        Term_putstr(5, 15, -1, TERM_WHITE,
		    "Life and Sorcery are protective, Chaos and Death are destructive.");
#endif

#ifdef JP
	Term_putstr(5, 16, -1, TERM_WHITE,
		    "Ϲɸξμʸޤߤޤ");
#else
	Term_putstr(5, 16, -1, TERM_WHITE,
		    "Nature has both defensive and offensive spells.");
#endif

	for (i = 0; i<16; i++)
	{
		if (choices & (1 << i) && p_ptr->realm1 != i+1)
		{
			put_str(format("%c%c %s", I2A(n), p2, realm_names[i+1]),
				19 + (n/5), 2 + 15 * (n%5));
			picks[n++] = i+1;
		}
	}

	/* Get a realm */
	while (1)	{
#ifdef JP
sprintf(buf, "ΰǲ(%c-%c) '*'ǥࡢ'='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a realm (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 18, 2);
		c = inkey();
		if (c == 'Q')
		{
			birth_quit();
		}
		if (c == 'S') return 255;
		if (c == '*')
		{
			k = rand_int(n);
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n)) break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
			do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
//			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}


	/* Clean up */
	clear_from(19);

	return (picks[k]);
}


/*
 * Choose the magical realms
 */
static bool get_player_realms(void)
{
        int i, count;
#ifdef USE_SCRIPT
	int result = get_player_realms_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Select the first realm */
	while (1)
	{
		unsigned char temp[80*8];
		cptr t;

                p_ptr->realm1 = REALM_NONE;
		count = 0;
		p_ptr->realm1 = choose_realm(realm_choices1[p_ptr->pclass], &count);

                if (255 == p_ptr->realm1) return FALSE;
		if (!p_ptr->realm1) break;
		clear_from(17);

		roff_to_buf(realm_jouhou[technic2magic(p_ptr->realm1)-1], 78, temp);
		t = temp;
		for (i = 0; i< 6; i++)
		{
			if(t[0] == 0)
				break; 
			else
			{
				prt(t, 18+i, 1);
				t += strlen(t) + 1;
			}
		}

		if (count < 2)
		{
#ifdef JP
			prt("򲡤Ƥ", 0, 0);
#else
			prt("Hit any key.", 0, 0);
#endif
			(void)inkey();
			prt("", 0, 0);
			break;
                }
else
#ifdef JP
                if (get_check("Ǥ")) break;
#else
                if (get_check("Are you sure? ")) break;
#endif
	}

	if (p_ptr->realm1)
	{
		/* Print the realm */
#ifdef JP
put_str("ˡ        :", 6, 1);
#else
put_str("Magic       :", 6, 1);
#endif

		c_put_str(TERM_L_BLUE, realm_names[p_ptr->realm1], 6, 15);

		/* Select the second realm */
		while (1)
		{
			unsigned char temp[80*8];
			cptr t;

			count = 0;
			p_ptr->realm2 = choose_realm(realm_choices2[p_ptr->pclass], &count);

			if (255 == p_ptr->realm2) return FALSE;
			if (!p_ptr->realm2) break;
			clear_from(17);
			
			roff_to_buf(realm_jouhou[technic2magic(p_ptr->realm2)-1], 78, temp);
			t = temp;
			for (i = 0; i< 6; i++)
			{
				if(t[0] == 0)
					break; 
				else
				{
					prt(t, 18+i, 1);
					t += strlen(t) + 1;
				}
			}

			if (count < 2)
			{
#ifdef JP
				prt("򲡤Ƥ", 0, 0);
#else
				prt("Hit any key.", 0, 0);
#endif
				(void)inkey();
				prt("", 0, 0);
				break;
			}
#ifdef JP
			else if (get_check("Ǥ")) break;
#else
                        else if (get_check("Are you sure? ")) break;
#endif
		}
		if (p_ptr->realm2)
		{
			/* Print the realm */
			c_put_str(TERM_L_BLUE, realm_names[p_ptr->realm2], 7, 15);
		}
	}

	return (TRUE);
}


/*
 * Save the current data for later
 */
static void save_prev_data(void)
{
	int i;


	/*** Save the current data ***/

	/* Save the data */
	prev.age = p_ptr->age;
	prev.wt = p_ptr->wt;
	prev.ht = p_ptr->ht;
	prev.sc = p_ptr->sc;
	prev.au = p_ptr->au;

	/* Save the stats */
	for (i = 0; i < 6; i++)
	{
		prev.stat[i] = p_ptr->stat_max[i];
	}

	for(i = 0; i < 50; i++)
	{
		prev.hp[i] = player_hp[i];
	}

	prev.chaos_patron = p_ptr->chaos_patron;

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(prev.history[i], history[i]);
	}
}


/*
 * Load the previous data
 */
static void load_prev_data(void)
{
	int i;

	birther	temp;


	/*** Save the current data ***/

	/* Save the data */
	temp.age = p_ptr->age;
	temp.wt = p_ptr->wt;
	temp.ht = p_ptr->ht;
	temp.sc = p_ptr->sc;
	temp.au = p_ptr->au;

	/* Save the stats */
	for (i = 0; i < 6; i++)
	{
		temp.stat[i] = p_ptr->stat_max[i];
	}

	/* Save the hp */
	for (i = 0; i < 50; i++)
	{
		temp.hp[i] = player_hp[i];
	}

	temp.chaos_patron = p_ptr->chaos_patron;

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(temp.history[i], history[i]);
	}


	/*** Load the previous data ***/

	/* Load the data */
	p_ptr->age = prev.age;
	p_ptr->wt = prev.wt;
	p_ptr->ht = prev.ht;
	p_ptr->sc = prev.sc;
	p_ptr->au = prev.au;

	/* Load the stats */
	for (i = 0; i < 6; i++)
	{
		p_ptr->stat_max[i] = prev.stat[i];
		p_ptr->stat_cur[i] = prev.stat[i];
	}

	/* Load the hp */
	for (i = 0; i < 50; i++)
	{
		player_hp[i] = prev.hp[i];
	}
	p_ptr->mhp = player_hp[0];
	p_ptr->chp = player_hp[0];

	p_ptr->chaos_patron = prev.chaos_patron;

	/* Load the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], prev.history[i]);
	}


	/*** Save the current data ***/

	/* Save the data */
	prev.age = temp.age;
	prev.wt = temp.wt;
	prev.ht = temp.ht;
	prev.sc = temp.sc;
	prev.au = temp.au;

	/* Save the stats */
	for (i = 0; i < 6; i++)
	{
		prev.stat[i] = temp.stat[i];
	}

	/* Save the hp */
	for (i = 0; i < 50; i++)
	{
		prev.hp[i] = temp.hp[i];
	}

	prev.chaos_patron = temp.chaos_patron;

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(prev.history[i], temp.history[i]);
	}
}




/*
 * Returns adjusted stat -JK-  Algorithm by -JWT-
 *
 * auto_roll is boolean and states maximum changes should be used rather
 * than random ones to allow specification of higher values to wait for
 */
static int adjust_stat(int value, int amount, int auto_roll)
{
	int i;

	/* Negative amounts */
	if (amount < 0)
	{
		/* Apply penalty */
		for (i = 0; i < (0 - amount); i++)
		{
			if (value >= 18+10)
			{
				value -= 10;
			}
			else if (value > 18)
			{
				value = 18;
			}
			else if (value > 3)
			{
				value--;
			}
		}
	}

	/* Positive amounts */
	else if (amount > 0)
	{
		/* Apply reward */
		for (i = 0; i < amount; i++)
		{
			if (value < 18)
			{
				value++;
			}
			else
			{
				value += 10;
			}
		}
	}

	/* Return the result */
	return (value);
}




/*
 * Roll for a characters stats
 *
 * For efficiency, we include a chunk of "calc_bonuses()".
 */
static void get_stats(void)
{
	int		i, j;

	int		bonus;

	int		dice[18];


	/* Roll and verify some stats */
	while (TRUE)
	{
		/* Roll some dice */
		for (j = i = 0; i < 18; i++)
		{
			/* Roll the dice */
			dice[i] = randint(3 + i % 3);

			/* Collect the maximum */
			j += dice[i];
		}

		/* Verify totals */
		if ((j > 42) && (j < 57)) break;
		/* 57 was 54... I hate 'magic numbers' :< TY */
	}

	/* Acquire the stats */
	for (i = 0; i < 6; i++)
	{
		/* Extract 5 + 1d3 + 1d4 + 1d5 */
		j = 5 + dice[3*i] + dice[3*i+1] + dice[3*i+2];

		/* Save that value */
		p_ptr->stat_max[i] = j;

		/* Obtain a "bonus" for "race" and "class" and "seikaku"*/
		bonus = rp_ptr->r_adj[i] + cp_ptr->c_adj[i] + ap_ptr->a_adj[i];

		/* Start fully healed */
		p_ptr->stat_cur[i] = p_ptr->stat_max[i];

		/* Efficiency -- Apply the racial/class bonuses */
		stat_use[i] = modify_stat_value(p_ptr->stat_max[i], bonus);
	}
}

void get_max_stats(void)
{
	int		i, j;

	int		dice[6];

	/* Roll and verify some stats */
	while (TRUE)
	{
		/* Roll some dice */
		for (j = i = 0; i < 6; i++)
		{
			/* Roll the dice */
			dice[i] = randint(7);

			/* Collect the maximum */
			j += dice[i];
		}

		/* Verify totals */
		if (j == 24) break;
	}

	/* Acquire the stats */
	for (i = 0; i < 6; i++)
	{
		j = 18 + 60 + dice[i]*10;

		/* Save that value */
		p_ptr->stat_max_max[i] = j;
		if (p_ptr->stat_max[i] > j)
			p_ptr->stat_max[i] = j;
		if (p_ptr->stat_cur[i] > j)
			p_ptr->stat_cur[i] = j;
	}
	p_ptr->knowledge &= ~(KNOW_STAT);
}


/*
 * Roll for some info that the auto-roller ignores
 */
static void get_extra(void)
{
	int		i, j, min_value, max_value;

	/* Level one */
	p_ptr->max_plv = p_ptr->lev = 1;

	/* Experience factor */
	if (p_ptr->prace == RACE_ANDROID) p_ptr->expfact = rp_ptr->r_exp;
	else p_ptr->expfact = rp_ptr->r_exp + cp_ptr->c_exp;

	if (((p_ptr->pclass == CLASS_MONK) || (p_ptr->pclass == CLASS_FORCETRAINER) || (p_ptr->pclass == CLASS_NINJA)) && ((p_ptr->prace == RACE_KLACKON) || (p_ptr->prace == RACE_SPRITE)))
		p_ptr->expfact -= 15;

	/* Initialize arena and rewards information -KMW- */
	p_ptr->arena_number = 0;
	p_ptr->inside_arena = 0;
	p_ptr->inside_quest = 0;
	p_ptr->leftbldg = FALSE;
	for (i = 0; i < MAX_MANE; i++)
	{
		mane_spell[i] = -1;
		mane_dam[i] = 0;
	}
	mane_num = 0;
	p_ptr->exit_bldg = TRUE; /* only used for arena now -KMW- */

	p_ptr->start_race = p_ptr->prace;
	p_ptr->old_race1 = 0L;
	p_ptr->old_race2 = 0L;
	p_ptr->old_realm = 0;

	for (i = 0; i < 64; i++)
	{
		if (p_ptr->pclass == CLASS_SORCERER) spell_exp[i] = 1600;
		else if (p_ptr->pclass == CLASS_RED_MAGE) spell_exp[i] = 1200;
		else spell_exp[i] = 0;
	}

	for (i = 0; i < 5; i++)
		for (j = 0; j < 64; j++)
			weapon_exp[i][j] = weapon_exp_settei[p_ptr->pclass][i][j][0];
	if(p_ptr->pseikaku == SEIKAKU_SEXY)
	{
		weapon_exp[TV_HAFTED-TV_BOW][SV_WHIP] = 4000;
		weapon_exp_settei[p_ptr->pclass][TV_HAFTED-TV_BOW][SV_WHIP][1] = 8000;
	}

	for (i = 0; i < 10; i++)
		skill_exp[i] = skill_exp_settei[p_ptr->pclass][i][0];

	/* Reset rewards */
	for (i = 0; i < MAX_BACT; i++)
	{
		p_ptr->rewards[i] = 0;
	}

	p_ptr->today_mon = 0;

	/* Hitdice */
	if (p_ptr->pclass == CLASS_SORCERER)
		p_ptr->hitdie = rp_ptr->r_mhp/2 + cp_ptr->c_mhp + ap_ptr->a_mhp;
	else
		p_ptr->hitdie = rp_ptr->r_mhp + cp_ptr->c_mhp + ap_ptr->a_mhp;

	/* Minimum hitpoints at highest level */
	min_value = ((PY_MAX_LEVEL+2) * (p_ptr->hitdie + 1)) * 3 / 8;
	min_value += p_ptr->hitdie;

	/* Maximum hitpoints at highest level */
	max_value = ((PY_MAX_LEVEL+2) * (p_ptr->hitdie + 1)) * 5 / 8;
	max_value += p_ptr->hitdie;

	/* Roll out the hitpoints */
	while (TRUE)
	{
		/* Pre-calculate level 1 hitdice */
		player_hp[0] = p_ptr->hitdie;

		for (i = 1; i < 4; i++)
		{
			j = randint(p_ptr->hitdie);
			player_hp[0] += j;
		}

		/* Roll the hitpoint values */
		for (i = 1; i < PY_MAX_LEVEL; i++)
		{
			j = randint(p_ptr->hitdie);
			player_hp[i] = player_hp[i - 1] + j;
		}

		/* XXX Could also require acceptable "mid-level" hitpoints */

		/* Require "valid" hitpoints at highest level */
		if (player_hp[PY_MAX_LEVEL - 1] < min_value) continue;
		if (player_hp[PY_MAX_LEVEL - 1] > max_value) continue;

		/* Acceptable */
		break;
	}

	/* Initial hitpoints */
	p_ptr->mhp = player_hp[0];
}


/*
 * Get the racial history, and social class, using the "history charts".
 */
static void get_history(void)
{
	int i, n, chart, roll, social_class;

	char *s, *t;

	char buf[240];

	/* Clear the previous history strings */
	for (i = 0; i < 4; i++) history[i][0] = '\0';

	/* Clear the history text */
	buf[0] = '\0';

	/* Initial social class */
	social_class = randint(4);

	/* Starting place */
	switch (p_ptr->prace)
	{
		case RACE_AMBERITE:
		{
			chart = 67;
			break;
		}
		case RACE_HUMAN:
		case RACE_BARBARIAN:
		case RACE_DUNADAN:
		{
			chart = 1;
			break;
		}
		case RACE_HALF_ELF:
		{
			chart = 4;
			break;
		}
		case RACE_ELF:
		case RACE_HIGH_ELF:
		{
			chart = 7;
			break;
		}
		case RACE_HOBBIT:
		{
			chart = 10;
			break;
		}
		case RACE_GNOME:
		{
			chart = 13;
			break;
		}
		case RACE_DWARF:
		{
			chart = 16;
			break;
		}
		case RACE_HALF_ORC:
		{
			chart = 19;
			break;
		}
		case RACE_HALF_TROLL:
		{
			chart = 22;
			break;
		}
		case RACE_DARK_ELF:
		{
			chart = 69;
			break;
		}
		case RACE_HALF_OGRE:
		{
			chart = 74;
			break;
		}
		case RACE_HALF_GIANT:
		{
			chart = 75;
			break;
		}
		case RACE_HALF_TITAN:
		{
			chart = 76;
			break;
		}
		case RACE_CYCLOPS:
		{
			chart = 77;
			break;
		}
		case RACE_YEEK:
		{
			chart = 78;
			break;
		}
		case RACE_KOBOLD:
		{
			chart = 82;
			break;
		}
		case RACE_KLACKON:
		{
			chart = 84;
			break;
		}
		case RACE_NIBELUNG:
		{
			chart = 87;
			break;
		}
		case RACE_DRACONIAN:
		{
			chart = 89;
			break;
		}
		case RACE_MIND_FLAYER:
		{
			chart = 92;
			break;
		}
		case RACE_IMP:
		{
			chart = 94;
			break;
		}
		case RACE_GOLEM:
		{
			chart = 98;
			break;
		}
		case RACE_SKELETON:
		{
			chart = 102;
			break;
		}
		case RACE_ZOMBIE:
		{
			chart = 107;
			break;
		}
		case RACE_VAMPIRE:
		{
			chart = 113;
			break;
		}
		case RACE_SPECTRE:
		{
			chart = 118;
			break;
		}
		case RACE_SPRITE:
		{
			chart = 124;
			break;
		}
		case RACE_BEASTMAN:
		{
			chart = 129;
			break;
		}
		case RACE_ENT:
		{
			chart = 137;
			break;
		}
		case RACE_ANGEL:
		{
			chart = 142;
			break;
		}
		case RACE_DEMON:
		{
			chart = 145;
			break;
		}
		case RACE_S_FAIRY:
		{
			chart = 148;
			break;
		}
		case RACE_KUTA:
		{
			chart = 154;
			break;
		}
		case RACE_ANDROID:
		{
			chart = 155;
			break;
		}
		default:
		{
			chart = 0;
			break;
		}
	}


	/* Process the history */
	while (chart)
	{
		/* Start over */
		i = 0;

		/* Roll for nobility */
		roll = randint(100);


		/* Access the proper entry in the table */
		while ((chart != bg[i].chart) || (roll > bg[i].roll)) i++;

		/* Acquire the textual history */
		(void)strcat(buf, bg[i].info);

		/* Add in the social class */
		social_class += (int)(bg[i].bonus) - 50;

		/* Enter the next chart */
		chart = bg[i].next;
	}



	/* Verify social class */
	if (social_class > 100) social_class = 100;
	else if (social_class < 1) social_class = 1;

	/* Save the social class */
	p_ptr->sc = social_class;


	/* Skip leading spaces */
	for (s = buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* Kill trailing spaces */

	while ((n > 0) && (s[n-1] == ' ')) s[--n] = '\0';

       {
        unsigned char temp[64*4];
        roff_to_buf(s, 60, temp);
        t = temp;
        for(i=0 ; i<4 ; i++){
             if(t[0]==0)break; 
             else {strcpy(history[i], t);t += strlen(t)+1;}
             }
       }
}


/*
 * Computes character's age, height, and weight
 * by henkma
 */
static void get_ahw(void)
{
  int h_percent; /* ĹʿѤˤ٤ƤɤΤ餤㤦. */


  /* Calculate the age */
  p_ptr->age = rp_ptr->b_age + randint(rp_ptr->m_age);
  
  /* Calculate the height/weight for males */
  if (p_ptr->psex == SEX_MALE)
	{
	  p_ptr->ht = randnor(rp_ptr->m_b_ht, rp_ptr->m_m_ht);
	  h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->m_b_ht);
	  p_ptr->wt = randnor((int)(rp_ptr->m_b_wt) * h_percent /100
						  , (int)(rp_ptr->m_m_wt) * h_percent / 300 );
	}
  
  /* Calculate the height/weight for females */
  else if (p_ptr->psex == SEX_FEMALE)
	{
	  p_ptr->ht = randnor(rp_ptr->f_b_ht, rp_ptr->f_m_ht);
	  h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->f_b_ht);
	  p_ptr->wt = randnor((int)(rp_ptr->f_b_wt) * h_percent /100
						  , (int)(rp_ptr->f_m_wt) * h_percent / 300 );
	}
}

/*
 * Get the player's starting money
 */
static void get_money(void)
{
	int i, gold;

	/* Social Class determines starting gold */
	gold = (p_ptr->sc * 6) + randint(100) + 300;
	if (p_ptr->pclass == CLASS_TOURIST)
	  gold += 2000;

	/* Process the stats */
	for (i = 0; i < 6; i++)
	{
		/* Mega-Hack -- reduce gold for high stats */
		if (stat_use[i] >= 18 + 50) gold -= 300;
		else if (stat_use[i] >= 18 + 20) gold -= 200;
		else if (stat_use[i] > 18) gold -= 150;
		else gold -= (stat_use[i] - 8) * 10;
	}

	/* Minimum 100 gold */
	if (gold < 100) gold = 100;

	if (p_ptr->pseikaku == SEIKAKU_NAMAKE)
		gold /= 2;
	else if (p_ptr->pseikaku == SEIKAKU_MUNCHKIN)
		gold = 10000000;
	if (p_ptr->prace == RACE_ANDROID) gold /= 5;

	/* Save the gold */
	p_ptr->au = gold;
}



/*
 * Display stat values, subset of "put_stats()"
 *
 * See 'display_player()' for screen layout constraints.
 */
static void birth_put_stats(void)
{
	int i, p;
	int col;
	byte attr;
	char buf[80];


	if (autoroller)
	{
		col = 42;
		/* Put the stats (and percents) */
		for (i = 0; i < 6; i++)
		{
			/* Put the stat */
			cnv_stat(stat_use[i], buf);
			c_put_str(TERM_L_GREEN, buf, 3+i, col+24);

			/* Put the percent */
			if (stat_match[i])
			{
				p = 1000L * stat_match[i] / auto_round;
				attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
				sprintf(buf, "%3d.%d%%", p/10, p%10);
				c_put_str(attr, buf, 3+i, col+13);
			}

			/* Never happened */
			else
			{
#ifdef JP
				c_put_str(TERM_RED, "(ʤ)", 3+i, col+13);
#else
				c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif

			}
		}
	}
}


/*
 * Clear all the global "character" data
 */
static void player_wipe(void)
{
	int i;


	/* Hack -- zero the struct */
	(void)WIPE(p_ptr, player_type);

	/* Wipe the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], "");
	}

	/* Wipe the quests */
	for (i = 0; i < max_quests; i++)
	{
		quest[i].status = QUEST_STATUS_UNTAKEN;

		quest[i].cur_num = 0;
		quest[i].max_num = 0;
		quest[i].type = 0;
		quest[i].level = 0;
		quest[i].r_idx = 0;
		quest[i].complev = 0;
	}

	/* No weight */
	p_ptr->total_weight = 0;

	/* No items */
	inven_cnt = 0;
	equip_cnt = 0;

	/* Clear the inventory */
	for (i = 0; i < INVEN_TOTAL; i++)
	{
		object_wipe(&inventory[i]);
	}


	/* Start with no artifacts made yet */
	for (i = 0; i < max_a_idx; i++)
	{
		artifact_type *a_ptr = &a_info[i];
		a_ptr->cur_num = 0;
	}

	/* Reset the objects */
	k_info_reset();

	/* Reset the "monsters" */
	for (i = 1; i < max_r_idx; i++)
	{
		monster_race *r_ptr = &r_info[i];

		/* Hack -- Reset the counter */
		r_ptr->cur_num = 0;

		/* Hack -- Reset the max counter */
		r_ptr->max_num = 100;

		/* Hack -- Reset the max counter */
		if (r_ptr->flags1 & RF1_UNIQUE) r_ptr->max_num = 1;
		if (r_ptr->flags7 & RF7_UNIQUE_7) r_ptr->max_num = 5;

		/* Clear player kills */
		r_ptr->r_pkills = 0;
	}


	/* Hack -- Well fed player */
	p_ptr->food = PY_FOOD_FULL - 1;


	/* Wipe the spells */
	if (p_ptr->pclass == CLASS_SORCERER)
	{
		spell_learned1 = spell_learned2 = 0xffffffffL;
		spell_worked1 = spell_worked2 = 0xffffffffL;
	}
	else
	{
		spell_learned1 = spell_learned2 = 0L;
		spell_worked1 = spell_worked2 = 0L;
	}
	spell_forgotten1 = spell_forgotten2 = 0L;
	for (i = 0; i < 64; i++) spell_order[i] = 99;
	p_ptr->learned_spells = 0;
	p_ptr->add_spells = 0;
	p_ptr->knowledge = 0;

	/* Clean the mutation count */
	mutant_regenerate_mod = 100;

	/* Clear "cheat" options */
	cheat_peek = FALSE;
	cheat_hear = FALSE;
	cheat_room = FALSE;
	cheat_xtra = FALSE;
	cheat_know = FALSE;
	cheat_live = FALSE;

	/* Assume no winning game */
	total_winner = FALSE;

	world_player = FALSE;

	/* Assume no panic save */
	panic_save = 0;

	/* Assume no cheating */
	noscore = 0;

	/* Not waiting to report score */
	wait_report_score = FALSE;

	/* Default pet command settings */
	p_ptr->pet_follow_distance = PET_FOLLOW_DIST;
	p_ptr->pet_extra_flags = (PF_TELEPORT | PF_ATTACK_SPELL | PF_SUMMON_SPELL);

        /* Wipe the recall depths */
        for (i = 0; i < max_d_idx; i++)
        {
		max_dlv[i] = 0;
        }

	p_ptr->visit = 1;

        /* Reset wild_mode to FALSE */
        p_ptr->wild_mode = FALSE;

	for (i = 0; i < 108; i++)
	{
		p_ptr->magic_num1[i] = 0;
		p_ptr->magic_num2[i] = 0;
	}
}


/*
 * Each player starts out with a few items, given as tval/sval pairs.
 * In addition, he always has some food and a few torches.
 */
static byte player_init[MAX_CLASS][3][2] =
{
	{
		/* Warrior */
		{ TV_RING, SV_RING_RES_FEAR }, /* Warriors need it! */
		{ TV_HARD_ARMOR, SV_CHAIN_MAIL },
		{ TV_SWORD, SV_BROAD_SWORD }
	},

	{
		/* Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_DEATH_BOOK, 0 }, /* Hack: for realm2 book */
		{ TV_SWORD, SV_DAGGER }
	},

	{
		/* Priest */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for Life / Death book */
		{ TV_DEATH_BOOK, 0 }, /* Hack: for realm2 book */
		{ TV_HAFTED, SV_MACE }
	},

	{
		/* Rogue */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_DAGGER }
	},

	{
		/* Ranger */
		{ TV_NATURE_BOOK, 0 },
		{ TV_DEATH_BOOK, 0 },		/* Hack: for realm2 book */
		{ TV_SWORD, SV_DAGGER }
	},

	{
		/* Paladin */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_SCROLL, SV_SCROLL_PROTECTION_FROM_EVIL },
		{ TV_SWORD, SV_BROAD_SWORD }
	},

	{
		/* Warrior-Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_DEATH_BOOK, 0 }, /* Hack: for realm2 book */
		{ TV_SWORD, SV_SHORT_SWORD }
	},

	{
		/* Chaos Warrior */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: For realm1 book */
		{ TV_HARD_ARMOR, SV_METAL_SCALE_MAIL },
		{ TV_SWORD, SV_BROAD_SWORD }
	},

	{
		/* Monk */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_POTION, SV_POTION_HEROISM }
	},

	{
		/* Mindcrafter */
		{ TV_POTION, SV_POTION_SPEED },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_SMALL_SWORD }
	},

	{
		/* High Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_RING, SV_RING_SUSTAIN_INT},
		{ TV_SWORD, SV_DAGGER }
	},

	{
		/* Tourist */
		{ TV_FOOD, SV_FOOD_JERKY},
		{ TV_SCROLL, SV_SCROLL_MAPPING },
		{ TV_BOW, SV_SLING}
	},

	{
		/* Imitator */
		{ TV_POTION, SV_POTION_SPEED },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_SHORT_SWORD}
	},

	{
		/* Beastmaster */
		{ TV_TRUMP_BOOK, 0 },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_POLEARM, SV_SPEAR}
	},

	{
		/* Sorcerer */
		{ TV_HAFTED, SV_WIZSTAFF }, /* Hack: for realm1 book */
		{ TV_RING, SV_RING_SUSTAIN_INT},
		{ TV_WAND, SV_WAND_MAGIC_MISSILE }
	},

	{
		/* Archer */
		{ TV_BOW, SV_LONG_BOW },
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL},
		{ TV_SWORD, SV_SHORT_SWORD },
	},

	{
		/* Magic eater */
		{ TV_WAND, SV_WAND_MAGIC_MISSILE },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR},
		{ TV_SWORD, SV_SHORT_SWORD },
	},

	{
		/* Harper */
		{ TV_MUSIC_BOOK, 0 },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR},
		{ TV_SWORD, SV_SHORT_SWORD },
	},

	{
		/* Red Mage */
		{ TV_ARCANE_BOOK, 0 },
		{ TV_SOFT_ARMOR, SV_HARD_LEATHER_ARMOR},
		{ TV_SWORD, SV_SHORT_SWORD },
	},

	{
		/* Samurai */
		{ TV_HISSATSU_BOOK, 0 },
		{ TV_HARD_ARMOR, SV_CHAIN_MAIL },
		{ TV_SWORD, SV_BROAD_SWORD }
	},

	{
		/* ForceTrainer */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_POTION, SV_POTION_RESTORE_MANA }
	},

	{
		/* Blue Mage */
		{ TV_SOFT_ARMOR, SV_ROBE },
		{ TV_WAND, SV_WAND_MAGIC_MISSILE },
		{ TV_SWORD, SV_DAGGER }
	},

	{
		/* Kihei */
		{ TV_BOW, SV_SHORT_BOW },
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL},
		{ TV_POLEARM, SV_BROAD_SPEAR}
	},

	{
		/* Berserker */
		{ TV_POTION, SV_POTION_HEALING },
		{ TV_HARD_ARMOR, SV_AUGMENTED_CHAIN_MAIL },
		{ TV_POLEARM, SV_BROAD_AXE }
	},

	{
		/* Kaji */
		{ TV_RING, SV_RING_RES_FEAR }, /* Warriors need it! */
		{ TV_HARD_ARMOR, SV_CHAIN_MAIL },
		{ TV_POLEARM, SV_BROAD_AXE }
	},
	{
		/* Mirror-Master */
		{ TV_POTION, SV_POTION_SPEED },
		{ TV_RING, SV_RING_SUSTAIN_INT},
		{ TV_SWORD, SV_DAGGER }
	},
	{
		/* Ninja */
		{ TV_POTION, SV_POTION_SPEED },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_DAGGER }
	},
};


/*
 * Init players with some belongings
 *
 * Having an item makes the player "aware" of its purpose.
 */
void player_outfit(void)
{
	int i, tv, sv;

	object_type	forge;
	object_type	*q_ptr;


#ifdef USE_SCRIPT
	if (player_outfit_callback()) return;
#endif /* USE_SCRIPT */

	/* Get local object */
	q_ptr = &forge;

	/* Give the player some food */
	switch (p_ptr->prace)
	{
		case RACE_GOLEM:
		case RACE_SKELETON:
		case RACE_ZOMBIE:
		case RACE_VAMPIRE:
		case RACE_SPECTRE:
		case RACE_ENT:
		case RACE_DEMON:
		case RACE_ANDROID:
		{
			if (p_ptr->pclass == CLASS_BERSERKER) break;
			/* Scrolls of satisfy hunger */
			object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_SATISFY_HUNGER));
			q_ptr->number = (byte)rand_range(2, 5);
			object_aware(q_ptr);
			object_known(q_ptr);

			/* These objects are "storebought" */
//			q_ptr->ident |= IDENT_STOREB;

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);

			break;
		}
		default:
		{
			/* Food rations */
			object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_RATION));
			q_ptr->number = (byte)rand_range(3, 7);
			object_aware(q_ptr);
			object_known(q_ptr);

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);
		}
	}

	/* Get local object */
	q_ptr = &forge;

	if (p_ptr->prace == RACE_VAMPIRE)
	{
		/* Hack -- Give the player scrolls of DARKNESS! */
		object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_DARKNESS));

		q_ptr->number = (byte)rand_range(2, 5);

		object_aware(q_ptr);
		object_known(q_ptr);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass != CLASS_NINJA)
	{
		/* Hack -- Give the player some torches */
		object_prep(q_ptr, lookup_kind(TV_LITE, SV_LITE_TORCH));
		q_ptr->number = (byte)rand_range(3, 7);
		q_ptr->xtra4 = rand_range(3, 7) * 500;
		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
	q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}

	/* Get local object */
	q_ptr = &forge;

	if ((p_ptr->pclass == CLASS_RANGER) || (p_ptr->pclass == CLASS_CAVALRY))
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_ARROW, SV_AMMO_NORMAL));
		q_ptr->number = (byte)rand_range(15, 20);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	if (p_ptr->pclass == CLASS_RANGER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_BOW, SV_SHORT_BOW));

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_ARCHER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_ARROW, SV_AMMO_NORMAL));
		q_ptr->number = (byte)rand_range(15, 20);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_HIGH_MAGE)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_WAND, SV_WAND_MAGIC_MISSILE));
		q_ptr->number = 1;
		q_ptr->pval = (byte)rand_range(25, 30);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_SORCERER)
	{
		for (i = TV_LIFE_BOOK; i <= TV_LIFE_BOOK+MAX_MAGIC-1; i++)
		{
			/* Hack -- Give the player some arrows */
			object_prep(q_ptr, lookup_kind(i, 0));
			q_ptr->number = 1;

			/* These objects are "storebought" */
//			q_ptr->ident |= IDENT_STOREB;

			object_aware(q_ptr);
			object_known(q_ptr);

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);
		}
	}
	else if (p_ptr->pclass == CLASS_TOURIST)
	{
		if (p_ptr->pseikaku != SEIKAKU_SEXY)
		{
			/* Hack -- Give the player some arrows */
			object_prep(q_ptr, lookup_kind(TV_SHOT, SV_AMMO_LIGHT));
			q_ptr->number = (byte)rand_range(15, 20);

			/* These objects are "storebought" */
//			q_ptr->ident |= IDENT_STOREB;

			object_aware(q_ptr);
			object_known(q_ptr);

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);
		}

		object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_BISCUIT));
		q_ptr->number = (byte)rand_range(2, 4);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);

		object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_WAYBREAD));
		q_ptr->number = (byte)rand_range(2, 4);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);

		object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_JERKY));
		q_ptr->number = (byte)rand_range(1, 3);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);

		object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_PINT_OF_ALE));
		q_ptr->number = (byte)rand_range(2, 4);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);

		object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_PINT_OF_WINE));
		q_ptr->number = (byte)rand_range(2, 4);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_NINJA)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_SPIKE, 0));
		q_ptr->number = (byte)rand_range(15, 20);

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}

	if(p_ptr->pseikaku == SEIKAKU_SEXY)
	{
		player_init[p_ptr->pclass][2][0] = TV_HAFTED;
		player_init[p_ptr->pclass][2][1] = SV_WHIP;
	}

	/* Hack -- Give the player three useful objects */
	for (i = 0; i < 3; i++)
	{
		/* Look up standard equipment */
		tv = player_init[p_ptr->pclass][i][0];
		sv = player_init[p_ptr->pclass][i][1];

		if ((p_ptr->prace == RACE_ANDROID) && ((tv == TV_SOFT_ARMOR) || (tv == TV_HARD_ARMOR))) continue;
		/* Hack to initialize spellbooks */
		if (tv == TV_SORCERY_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm1 - 1;
		else if (tv == TV_DEATH_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm2 - 1;

		else if (tv == TV_RING && sv == SV_RING_RES_FEAR &&
		    p_ptr->prace == RACE_BARBARIAN)
			/* Barbarians do not need a ring of resist fear */
			sv = SV_RING_SUSTAIN_STR;

		else if (tv == TV_RING && sv == SV_RING_SUSTAIN_INT &&
		    p_ptr->prace == RACE_MIND_FLAYER)
		  {
			tv = TV_POTION;
			sv = SV_POTION_RESTORE_MANA;
		  }

		/* Get local object */
		q_ptr = &forge;

		/* Hack -- Give the player an object */
		object_prep(q_ptr, lookup_kind(tv, sv));

		/* Assassins begin the game with a poisoned dagger */
		if ((tv == TV_SWORD || tv == TV_HAFTED) && (p_ptr->pclass == CLASS_ROGUE &&
			p_ptr->realm1 == REALM_DEATH)) /* Only assassins get a poisoned weapon */
		{
			q_ptr->name2 = EGO_BRAND_POIS;
		}

		/* These objects are "storebought" */
//		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
}


/*
 * Player race
 */
static bool get_player_race(void)
{
	int     k, n;
	cptr    str;
	char    c;
	char    p2 = ')';
	char    buf[80];


#ifdef USE_SCRIPT
	int result = get_player_race_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Extra info */
	Term_putstr(5, 14, -1, TERM_WHITE,
#ifdef JP
"Լ²դˤäƥ饯ŷŪʻܡʥѲޤ");
#else
		"Your 'race' determines various intrinsic factors and bonuses.");
#endif

	hack_mutation = FALSE;

	/* Dump races */
	for (n = 0; n < MAX_RACES; n++)
	{
		/* Analyze */
		p_ptr->prace = n;
		rp_ptr = &race_info[p_ptr->prace];
		str = rp_ptr->title;

		/* Display */

		if (n < RACE_SPECTRE)
#ifdef JP
sprintf(buf, "%c%c%s", I2A(n), p2, str);
#else
			sprintf(buf, "%c%c %s", I2A(n), p2, str);
#endif

		else
#ifdef JP
			sprintf(buf, "%d%c%s", (n - RACE_SPECTRE), p2, str); /* HACK */
#else
			sprintf(buf, "%d%c %s", (n - RACE_SPECTRE), p2, str); /* HACK */
#endif

		put_str(buf, 16 + (n/5), 1 + 16 * (n%5));

	}

	/* Choose */
	while (1)
	{
#ifdef JP
sprintf(buf, "²ǲ (%c-9) '*'ǥ, '='ǽץ: ", I2A(0));
#else
		sprintf(buf, "Choose a race (%c-9), * for random, or = for options: ", I2A(0));
#endif

		put_str(buf, 15, 2);
		c = inkey();
		if (c == 'Q')
		{
			birth_quit();
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			k = rand_int(MAX_RACES);
			break;
		}
		if (c == '{')
		{
			k = RACE_VAMPIRE;
			break;
		}
		else if (c == '0')
		{
			k = RACE_SPECTRE;
			break;
		}
		else if (c == '1')
		{
			k = RACE_SPRITE;
			break;
		}
		else if (c == '2')
		{
			k = RACE_BEASTMAN;
			break;
		}
		else if (c == '3')
		{
			k = RACE_ENT;
			break;
		}
		else if (c == '4')
		{
			k = RACE_ANGEL;
			break;
		}
		else if (c == '5')
		{
			k = RACE_DEMON;
			break;
		}
		else if (c == '6')
		{
			k = RACE_DUNADAN;
			break;
		}
		else if (c == '7')
		{
			k = RACE_S_FAIRY;
			break;
		}
		else if (c == '8')
		{
			k = RACE_KUTA;
			break;
		}
		else if (c == '9')
		{
			k = RACE_ANDROID;
			break;
		}
		else
		{
			k = (islower(c) ? A2I(c) : -1);
			if ((k >= 0) && (k < n)) break;
			if (c == '?') do_cmd_help();
			else if (c == '=')
			{
				screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
				do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

				screen_load();
			}
			else bell();
		}
	}

	/* Set race */
	p_ptr->prace = k;

	/* Give beastman a mutation at character birth */
	if (p_ptr->prace == RACE_BEASTMAN)
		hack_mutation = TRUE;

	rp_ptr = &race_info[p_ptr->prace];
	str = rp_ptr->title;

	/* Display */
	c_put_str(TERM_L_BLUE, str, 4, 15);

	/* Success */
	return TRUE;
}


/*
 * Player class
 */
static bool get_player_class(void)
{
        int     k, n;
	char    c;
	char    p2 = ')';
	char    buf[80];
	cptr    str;


#ifdef USE_SCRIPT
	int result = get_player_class_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Extra info */
	clear_from(13);
	Term_putstr(5, 14, -1, TERM_WHITE,
#ifdef JP
"Կȡդˤäƥ饯ŷŪǽϤܡʥѲޤ");
#else
		"Your 'class' determines various intrinsic abilities and bonuses.");
#endif

	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
    "()ǰϤޤ줿Ϥμ²ˤϻʤȤǤ");
#else
	    "Any entries in parentheses should only be used by advanced players.");
#endif


	/* Dump classes */
	for (n = 0; n < MAX_CLASS_CHOICE; n++)
	{
		cptr mod = "";
		char select = I2A(n);

		/* Analyze */
		p_ptr->pclass = n;
		cp_ptr = &class_info[p_ptr->pclass];
		mp_ptr = &magic_info[p_ptr->pclass];

		str = cp_ptr->title;

		if (n >= CLASS_NINJA)
			select = '0'+n-CLASS_NINJA;

		if (!(rp_ptr->choice & (1L << n)))
#ifdef JP
sprintf(buf, "%c%c(%s)%s", select, p2, str, mod);
#else
			sprintf(buf, "%c%c (%s)%s", select, p2, str, mod);
#endif

		else
			/* Display */
#ifdef JP
sprintf(buf, "%c%c%s%s", select, p2, str, mod);
#else
			sprintf(buf, "%c%c %s%s", select, p2, str, mod);
#endif


		put_str(buf, 17 + (n/4), 2 + 19 * (n%4));
	}

	/* Get a class */
	while (1)
	{
#ifdef JP
sprintf(buf, "Ȥǲ (%c-%c) '*'ǥࡢ'='ǽץ: ", I2A(0), '0'+n-CLASS_NINJA);
#else
		sprintf(buf, "Choose a class (%c-%c), * for random, or = for options: ", I2A(0), '0'+n-CLASS_NINJA);
#endif

		put_str(buf, 16, 2);
		c = inkey();
		if (c == 'Q')
		{
			birth_quit();
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			k = rand_int(n);
			break;
		}
		if (c == '0')
		{
			k = CLASS_NINJA;
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n)) break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
			do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set class */
	p_ptr->pclass = k;
	cp_ptr = &class_info[p_ptr->pclass];
	mp_ptr = &magic_info[p_ptr->pclass];
	str = cp_ptr->title;


	/* Display */
#ifdef JP
	c_put_str(TERM_L_BLUE, str, 5, 15);
#else
	c_put_str(TERM_L_BLUE, cp_ptr->title, 5, 15);
#endif

	return TRUE;
}


/*
 * Player seikaku
 */
static bool get_player_seikaku(void)
{
	int     k, n;
	char    c;
	char    p2 = ')';
	char    buf[80];
	char    tmp[64];
	cptr    str;


#ifdef USE_SCRIPT
	int result = get_player_seikaku_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Extra info */
	clear_from(14);
#ifdef JP
	Term_putstr(5, 14, -1, TERM_WHITE,
"ʡդˤäƥ饯ǽϤܡʥѲޤ        ");
#else
	Term_putstr(5, 14, -1, TERM_WHITE,
		"Your personality determines various intrinsic abilities and bonuses.");
#endif

	/* Dump seikakus */
	for (n = 0; n < MAX_SEIKAKU; n++)
	{
		cptr mod = "";

		if(seikaku_info[n].sex && (seikaku_info[n].sex != (p_ptr->psex+1))) continue;

		/* Analyze */
		p_ptr->pseikaku = n;
		ap_ptr = &seikaku_info[p_ptr->pseikaku];
		str = ap_ptr->title;

		/* Display */
#ifdef JP
		sprintf(buf, "%c%c%s%s", I2A(n), p2, str, mod);
#else
		sprintf(buf, "%c%c %s%s", I2A(n), p2, str, mod);
#endif
		put_str(buf, 17 + (n/4), 2 + 18 * (n%4));
	}

	/* Get a seikaku */
	while (1)
	{
#ifdef JP
sprintf(buf, "ʤǲ (%c-%c) '*'ǥࡢ'='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a personality (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 16, 2);
		c = inkey();
		if (c == 'Q')
		{
			birth_quit();
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			do
			{
				k = rand_int(n);
			}
			while(seikaku_info[k].sex && (seikaku_info[k].sex != (p_ptr->psex+1)));
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n))
			if((seikaku_info[k].sex == 0) || (seikaku_info[k].sex == (p_ptr->psex+1)))
				break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
			do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set seikaku */
	p_ptr->pseikaku = k;
	ap_ptr = &seikaku_info[p_ptr->pseikaku];
#ifdef JP
	strcpy(tmp, ap_ptr->title);
	if(ap_ptr->no == 1)
	strcat(tmp,"");
#else
	strcpy(tmp, ap_ptr->title);
	strcat(tmp," ");
#endif
	strcat(tmp,player_name);


	/* Display */
	c_put_str(TERM_L_BLUE, tmp, 1, 34);

	return TRUE;
}


/*
 * Helper function for 'player_birth()'
 *
 * The delay may be reduced, but is recommended to keep players
 * from continuously rolling up characters, which can be VERY
 * expensive CPU wise.  And it cuts down on player stupidity.
 */
static bool player_birth_aux(void)
{
	int i, j, k, m, n, v;

	int mode = 0;

	bool flag = FALSE;
	bool prev = FALSE;

	cptr str;

	char c;

#if 0
	char p1 = '(';
#endif

	char p2 = ')';
	char b1 = '[';
	char b2 = ']';

	char buf[80];
	char inp[80];

#ifdef USE_SCRIPT
	int result;
#endif /* USE_SCRIPT */


	/*** Intro ***/

	/* Clear screen */
	Term_clear();

	/* Title everything */
#ifdef JP
put_str("̾  :", 1,26);
#else
		put_str("Name  :", 1,26);
#endif

#ifdef JP
put_str("        :", 3, 1);
#else
	put_str("Sex         :", 3, 1);
#endif

#ifdef JP
put_str("²        :", 4, 1);
#else
	put_str("Race        :", 4, 1);
#endif

#ifdef JP
put_str("        :", 5, 1);
#else
	put_str("Class       :", 5, 1);
#endif


	/* Dump the default name */
	c_put_str(TERM_L_BLUE, player_name, 1, 34);


	/*** Instructions ***/

	/* Display some helpful information */
#ifdef JP
	Term_putstr(9,  9, -1, TERM_WHITE,
		"ʲμƲɽƤ椫");
	Term_putstr(9, 10, -1, TERM_WHITE,
		"ǲ 'Q' 򲡤ȥλ'S'  ");
	Term_putstr(9, 11, -1, TERM_WHITE,
		"Ƚᤫľ'?' 򲡤ȥإפɽޤ");
	Term_putstr(9, 12, -1, TERM_WHITE,
		"'Q'  'S' ʸϤƲ                       ");
#else
	Term_putstr(5,  9, -1, TERM_WHITE,
		"Please answer the following questions.  Most of the questions");
	Term_putstr(5, 10, -1, TERM_WHITE,
		"display a set of standard answers, and many will also accept");
	Term_putstr(5, 11, -1, TERM_WHITE,
		"some special responses, including 'Q' to quit, 'S' to restart,");
	Term_putstr(5, 12, -1, TERM_WHITE,
		"and '?' for help.  Note that 'Q' and 'S' must be capitalized.");
#endif


#ifdef USE_SCRIPT
	/*
	 * Ask for the world
	 */
	result = get_world_callback();

	if (result == -1)
		/* Restart */
		return FALSE;

	/* Clean up */
	clear_from(15);
#endif /* USE_SCRIPT */

	/*** Player sex ***/

	/* Extra info */
#ifdef JP
	Term_putstr(9, 14, -1, TERM_WHITE,
		"̡դΰ㤤ϥۤȤɱƶڤܤޤ");
#else
	Term_putstr(5, 14, -1, TERM_WHITE,
		"Your 'sex' does not have any significant gameplay effects.");
#endif


	/* Prompt for "Sex" */
	for (n = 0; n < MAX_SEXES; n++)
	{
		/* Analyze */
		p_ptr->psex = n;
		sp_ptr = &sex_info[p_ptr->psex];
		str = sp_ptr->title;


		/* Display */
#ifdef JP
sprintf(buf, "%c%c%s", I2A(n), p2, str);
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, str);
#endif

		put_str(buf, 17 + (n/5), 2 + 15 * (n%5));
	}

	/* Choose */
	while (1)
	{
#ifdef JP
sprintf(buf, "̤ǲ (%c-%c) '*'ǥ, '='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a sex (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 16, 2);
		c = inkey();
		if (c == 'Q')
		{
			birth_quit();
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			k = rand_int(MAX_SEXES);
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n)) break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
			do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set sex */
	p_ptr->psex = k;
	sp_ptr = &sex_info[p_ptr->psex];
	str = sp_ptr->title;


	/* Display */
	c_put_str(TERM_L_BLUE, str, 3, 15);

	/* Clean up */
	clear_from(15);

	while(1)
	{
		unsigned char temp[80*9];
		cptr t;

		/* Choose the players race */
		if (!get_player_race()) return FALSE;

		clear_from(14);

		roff_to_buf(race_jouhou[p_ptr->prace], 78, temp);
		t = temp;

		for (i = 0; i< 9; i++)
		{
			if(t[0] == 0)
				break; 
			else
			{
				prt(t, 15+i, 1);
				t += strlen(t) + 1;
			}
		}
#ifdef JP
		if (get_check("Ǥ")) break;
#else
		if (get_check("Are you sure? ")) break;
#endif
		clear_from(15);
		c_put_str(TERM_WHITE, "              ", 4, 15);
	}

	/* Clean up */
	clear_from(15);

	/* Choose the players class */
	while(1)
	{
		unsigned char temp[80*9];
		cptr t;

		/* Choose the players race */
		if (!get_player_class()) return FALSE;

		clear_from(14);
		roff_to_buf(class_jouhou[p_ptr->pclass], 78, temp);
		t = temp;

		for (i = 0; i< 9; i++)
		{
			if(t[0] == 0)
				break; 
			else
			{
				prt(t, 15+i, 1);
				t += strlen(t) + 1;
			}
		}

#ifdef JP
		if (get_check("Ǥ")) break;
#else
		if (get_check("Are you sure? ")) break;
#endif
		c_put_str(TERM_WHITE, "              ", 5, 15);
	}

	/* Choose the magic realms */
	if (!get_player_realms()) return FALSE;

	/* Choose the players seikaku */
	while(1)
	{
		unsigned char temp[80*8];
		cptr t;

		/* Choose the players race */
		if (!get_player_seikaku()) return FALSE;

		clear_from(15);
		roff_to_buf(seikaku_jouhou[p_ptr->pseikaku], 78, temp);
		t = temp;

		for (i = 0; i< 6; i++)
		{
			if(t[0] == 0)
				break; 
			else
			{
				prt(t, 16+i, 1);
				t += strlen(t) + 1;
			}
		}
#ifdef JP
		if (get_check("Ǥ")) break;
#else
		if (get_check("Are you sure? ")) break;
#endif
		c_put_str(TERM_L_BLUE, player_name, 1, 34);
		prt("", 1, 34+strlen(player_name));
	}

	/* Clean up */
	clear_from(15);

	screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
	do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

	screen_load();

#ifdef ALLOW_AUTOROLLER

	/*** Autoroll ***/

	if (autoroller || autochara)
	{
		/* Clear fields */
		auto_round = 0L;
	}

	/* Initialize */
	if (autoroller)
	{
		int mval[6];

		/* Clean up */
		clear_from(12);

		/* Prompt for the minimum stats */
#ifdef JP
		put_str("ǽͤκǾͤϤƲ: ", 14, 2);
#else
		put_str("Enter minimum attribute for: ", 14, 2);
#endif


		/* Output the maximum stats */
		for (i = 0; i < 6; i++)
		{
			/* Reset the "success" counter */
			stat_match[i] = 0;

			/* Race/Class bonus */
			j = rp_ptr->r_adj[i] + cp_ptr->c_adj[i] + ap_ptr->a_adj[i];

			/* Obtain the "maximal" stat */
			m = adjust_stat(17, j, TRUE);

			/* Save the maximum */
			mval[i] = m;

			/* Extract a textual format */
			/* cnv_stat(m, inp); */

			/* Above 18 */
			if (m > 18)
			{
#ifdef JP
				sprintf(inp, "( 18/%02d):", (m - 18));
#else
				sprintf(inp, "(Max of 18/%02d):", (m - 18));
#endif

			}

			/* From 3 to 18 */
			else
			{
#ifdef JP
				sprintf(inp, "( %2d):", m);
#else
				sprintf(inp, "(Max of %2d):", m);
#endif

			}

			/* Prepare a prompt */
			sprintf(buf, "%-5s%-20s", stat_names[i], inp);

			/* Dump the prompt */
			put_str(buf, 16 + i, 5);
		}

		/* Input the minimum stats */
		for (i = 0; i < 6; i++)
		{
			/* Get a minimum stat */
			while (TRUE)
			{
				char *s;

				/* Move the cursor */
				put_str("", 16 + i, 30);

				/* Default */
				strcpy(inp, "");

				/* Get a response (or escape) */
				if (!askfor_aux(inp, 8)) inp[0] = '\0';

				/* Hack -- add a fake slash */
				strcat(inp, "/");

				/* Hack -- look for the "slash" */
				s = strchr(inp, '/');

				/* Hack -- Nuke the slash */
				*s++ = '\0';

				/* Hack -- Extract an input */
				v = atoi(inp) + atoi(s);

				/* Break on valid input */
				if (v <= mval[i]) break;
			}

			/* Save the minimum stat */
			stat_limit[i] = (v > 0) ? v : 0;
		}
	}

	if (autochara)
	{
		int mval[6];
		int max_percent, min_percent;

		/* Clean up */
		clear_from(10);

		/* Prompt for the minimum stats */
#ifdef JP
		put_str("γ/ϰ̤κǾ/ͤϤƲ: ", 13, 2);
#else
		put_str("Enter minimum attribute for: ", 13, 2);
#endif
#ifdef JP
		put_str("( : ĹνŤκ/Ǿͤ꤮ͤ˽иΨ㤯ʤޤ)", 14, 2);
#else
		put_str("Caution: Values near minimum or maximum is extremery rare.", 14, 2);
#endif

		if (p_ptr->psex == SEX_MALE)
		{
			max_percent = (int)(rp_ptr->m_b_ht+rp_ptr->m_m_ht*4-1) * 100 / (int)(rp_ptr->m_b_ht);
			min_percent = (int)(rp_ptr->m_b_ht-rp_ptr->m_m_ht*4+1) * 100 / (int)(rp_ptr->m_b_ht);
		}
		else
		{
			max_percent = (int)(rp_ptr->f_b_ht+rp_ptr->f_m_ht*4-1) * 100 / (int)(rp_ptr->f_b_ht);
			min_percent = (int)(rp_ptr->f_b_ht-rp_ptr->f_m_ht*4+1) * 100 / (int)(rp_ptr->f_b_ht);
		}

		/* Output the maximum stats */
		for (i = 0; i < 6; i++)
		{
			/* Obtain the "maximal" stat */
			switch (i)
			{
				case 0: if (p_ptr->psex == SEX_MALE) m = rp_ptr->m_b_ht-rp_ptr->m_m_ht*4+1; else m = rp_ptr->f_b_ht-rp_ptr->f_m_ht*4+1; break;
				case 1: if (p_ptr->psex == SEX_MALE) m = rp_ptr->m_b_ht+rp_ptr->m_m_ht*4-1; else m = rp_ptr->f_b_ht+rp_ptr->f_m_ht*4-1; break;
				case 2: if (p_ptr->psex == SEX_MALE) m = (rp_ptr->m_b_wt * min_percent / 100) - (rp_ptr->m_m_wt * min_percent / 75) +1; else m = (rp_ptr->f_b_wt * min_percent / 100) - (rp_ptr->f_m_wt * min_percent / 75) +1; break;
				case 3: if (p_ptr->psex == SEX_MALE) m = (rp_ptr->m_b_wt * max_percent / 100) + (rp_ptr->m_m_wt * max_percent / 75) -1; else m = (rp_ptr->f_b_wt * max_percent / 100) + (rp_ptr->f_m_wt * max_percent / 75) -1; break;
				case 4: m = 1;break;
				case 5: m = 100;break;
				default: m = 1;break;
			}

			/* Save the maximum */
			mval[i] = m;

			/* Extract a textual format */
			/* cnv_stat(m, inp); */

			if (i % 2)
			{
#ifdef JP
				sprintf(inp, " (%3d ʲ):", m);
#else
				sprintf(inp, "(Max of %3d):", m);
#endif
			}

			else
			{
#ifdef JP
				sprintf(inp, "Ǿ (%3d ʾ):", m);
#else
				sprintf(inp, "(Min of %3d):", m);
#endif

			}

			/* Prepare a prompt */
#ifdef JP
			sprintf(buf, "%-13s%-20s", (i < 2 ? "Ĺ()" : i < 4 ? "ν(ݥ)" : "ϰ"), inp);
#else
			sprintf(buf, "%-13s%-20s", (i < 2 ? "height" : i < 4 ? "wight" : "social class"), inp);
#endif

			/* Dump the prompt */
			put_str(buf, 16 + i, 5);
		}

		/* Input the minimum stats */
		for (i = 0; i < 6; i++)
		{
			/* Get a minimum stat */
			while (TRUE)
			{
				/* Move the cursor */
				put_str("", 16 + i, 37);

				/* Default */
				strcpy(inp, "");

				/* Get a response (or escape) */
				if (!askfor_aux(inp, 4)) strcpy(inp, format("%d",mval[i]));
				if (inp[0] == '\0') strcpy(inp, format("%d",mval[i]));

				/* Hack -- Extract an input */
				v = atoi(inp);

				/* Break on valid input */
				if (i % 2)
				{
					if ((v <= mval[i]) && (v >= mval[i-1])) break;
				}
				else
				{
					if ((v >= mval[i]) && (v <= mval[i+1])) break;
				}
			}

			/* Save the minimum stat */
			chara_limit[i] = (v > 0) ? v : 0;
		}
	}

#endif /* ALLOW_AUTOROLLER */

	/* Clean up */
	clear_from(10);

	/*** User enters number of quests ***/
	/* Heino Vander Sanden and Jimmy De Laet */

	/* Extra info */
	Term_putstr(5, 14, -1, TERM_WHITE,
#ifdef JP
"ɬܤΥ(٥ڤӺ٤Υڥ)˲äơɲäΥȤ");
#else
		"You can enter the number of quests you'd like to perform in addition");
#endif

	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
"ꤹ뤳Ȥޤ");
#else
		"to the two obligatory ones ( Oberon and the Serpent of Chaos )");
#endif

	Term_putstr(5, 17, -1, TERM_WHITE,
#ifdef JP
"ɲåȤԤʤʤ '0'ϤƲ");
#else
		"In case you do not want any additional quests, just enter 0");
#endif
	Term_putstr(5, 18, -1, TERM_WHITE,
#ifdef JP
	"˷ꤹˤ'*'ϤƲ");
#else
	"If you want a random number of random quests, just enter *");
#endif


	/* Ask the number of additional quests */
	while (TRUE)
	{

#ifdef JP
put_str(format("ɲåȤο (%uʲ) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1), 20, 2);
#else
		put_str(format("Number of additional quests? (<%u) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 2), 20, 2);
#endif


		/* Get a the number of additional quest */
		while (TRUE)
		{
			/* Move the cursor */
			put_str("", 20, 37);

			/* Default */
			strcpy(inp, "10");

			/* Get a response (or escape) */
			if (!askfor_aux(inp, 2)) inp[0] = '\0';

			/* Check for random number of quests */
			if (inp[0] == '*')
			{
				/* 0 to 49 random quests */
				v = rand_int(11);
			}
			else
			{
				v = atoi(inp);
			}

			/* Break on valid input */
			if ((v <= MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1) && (v >= 0)) break;
		}
		break;
	}

	/* Clear */
	clear_from(15);

	/* Init the random quests */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = MIN_RANDOM_QUEST;

	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);

	p_ptr->inside_quest = 0;

	/* Prepare allocation table */
	get_mon_num_prep(monster_quest, NULL);

	/* Generate quests */
	for (i = MIN_RANDOM_QUEST + v - 1; i >= MIN_RANDOM_QUEST; i--)
	{
		quest_type      *q_ptr = &quest[i];
		monster_race    *r_ptr;
		monster_race    *quest_r_ptr;
		int             r_idx;

		q_ptr->status = QUEST_STATUS_TAKEN;

		while (1)
		{
			/*
			 * Random monster 5 - 10 levels out of depth
			 * (depending on level)
			 */
			r_idx = get_mon_num(q_ptr->level + 5 + randint(q_ptr->level / 10));
			r_ptr = &r_info[r_idx];

			if(!(r_ptr->flags1 & RF1_UNIQUE)) continue;

			if(r_ptr->flags6 & RF6_SPECIAL) continue;

			if(r_ptr->flags7 & RF7_FRIENDLY) continue;

			if(r_ptr->flags7 & RF7_AQUATIC) continue;

			if(!(r_ptr->flags8 & RF8_DUNGEON)) continue;

			/*
			 * Accept monsters that are 2 - 6 levels
			 * out of depth depending on the quest level
			 */
			if (r_ptr->level > (q_ptr->level + (q_ptr->level / 20))) break;
		}

		q_ptr->r_idx = r_idx;
		quest_r_ptr = &r_info[q_ptr->r_idx];

		/* Mark uniques */
		quest_r_ptr->flags1 |= RF1_QUESTOR;

		q_ptr->max_num = 1;
	}

	/* Init the two main quests (Oberon + Serpent) */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = QUEST_OBERON;

	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);

	quest[QUEST_OBERON].status = QUEST_STATUS_TAKEN;

	p_ptr->inside_quest = QUEST_SERPENT;

	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);

	quest[QUEST_SERPENT].status = QUEST_STATUS_TAKEN;
	p_ptr->inside_quest = 0;

	/* Clear */
	clear_from(14);


	/*** Generate ***/

	/* Roll */
	while (TRUE)
	{
		int col;

		col = 42;

		if (autoroller || autochara)
		{
			Term_clear();

			/* Label count */
#ifdef JP
			put_str(" :", 10, col+13);
#else
			put_str("Round:", 10, col+13);
#endif


			/* Indicate the state */
#ifdef JP
			put_str("(ESC)", 12, col+13);
#else
			put_str("(Hit ESC to stop)", 12, col+13);
#endif
		}

		/* Otherwise just get a character */
		else
		{
			/* Get a new character */
			get_stats();

			/* Roll for age/height/weight */
			get_ahw();

			/* Roll for social class */
			get_history();
		}

		/* Feedback */
		if (autoroller)
		{
			/* Label */
#ifdef JP
			put_str("Ǿ", 2, col+5);
#else
			put_str(" Limit", 2, col+5);
#endif


			/* Label */
#ifdef JP
			put_str("Ψ", 2, col+13);
#else
			put_str("  Freq", 2, col+13);
#endif


			/* Label */
#ifdef JP
			put_str("", 2, col+24);
#else
			put_str("  Roll", 2, col+24);
#endif


			/* Put the minimal stats */
			for (i = 0; i < 6; i++)
			{
				/* Label stats */
				put_str(stat_names[i], 3+i, col);

				/* Put the stat */
				cnv_stat(stat_limit[i], buf);
				c_put_str(TERM_L_BLUE, buf, 3+i, col+5);
			}
		}

		/* Auto-roll */
		while (autoroller || autochara)
		{
			bool accept = TRUE;

			/* Get a new character */
			get_stats();

			/* Advance the round */
			auto_round++;

			/* Hack -- Prevent overflow */
			if (auto_round >= 1000000L)
			{
				auto_round = 1;

				if (autoroller)
				{
					for (i = 0; i < 6; i++)
					{
						stat_match[i] = 0;
					}
				}
			}

			if (autoroller)
			{
				/* Check and count acceptable stats */
				for (i = 0; i < 6; i++)
				{
					/* This stat is okay */
					if (stat_use[i] >= stat_limit[i])
					{
						stat_match[i]++;
					}

					/* This stat is not okay */
					else
					{
						accept = FALSE;
					}
				}
			}

			/* Break if "happy" */
			if (accept)
			{
				/* Roll for age/height/weight */
				get_ahw();

				/* Roll for social class */
				get_history();

				if (autochara)
				{
					if ((p_ptr->ht < chara_limit[0]) || (p_ptr->ht > chara_limit[1])) accept = FALSE;
					if ((p_ptr->wt < chara_limit[2]) || (p_ptr->wt > chara_limit[3])) accept = FALSE;
					if ((p_ptr->sc < chara_limit[4]) || (p_ptr->sc > chara_limit[5])) accept = FALSE;
				}
				if (accept) break;
			}

			/* Take note every x rolls */
			flag = (!(auto_round % AUTOROLLER_STEP));

			/* Update display occasionally */
			if (flag)
			{
				/* Dump data */
				birth_put_stats();

				/* Dump round */
				put_str(format("%10ld", auto_round), 10, col+20);

#ifdef AUTOROLLER_DELAY
				/* Delay 1/10 second */
				if (flag) Term_xtra(TERM_XTRA_DELAY, 100);
#endif

				/* Make sure they see everything */
				Term_fresh();

				/* Do not wait for a key */
				inkey_scan = TRUE;

				/* Check for a keypress */
				if (inkey())
				{
					/* Roll for age/height/weight */
					get_ahw();

	       				/* Roll for social class */
					get_history();

					break;
				}
			}
		}

		if (autoroller || autochara) sound(SOUND_LEVEL);

		/* Flush input */
		flush();


		/*** Display ***/

		/* Mode */
		mode = 0;

		/* Roll for base hitpoints */
		get_extra();

		/* Roll for gold */
		get_money();

		/* Hack -- get a chaos patron even if you are not a chaos warrior */
		p_ptr->chaos_patron = (s16b)rand_int(MAX_PATRON);

		p_ptr->muta1 = 0;
		p_ptr->muta2 = 0;
		p_ptr->muta3 = 0;

		/* Input loop */
		while (TRUE)
		{
			/* Calculate the bonuses and hitpoints */
			p_ptr->update |= (PU_BONUS | PU_HP);

			/* Update stuff */
			update_stuff();

			/* Fully healed */
			p_ptr->chp = p_ptr->mhp;

			/* Fully rested */
			p_ptr->csp = p_ptr->msp;

			/* Display the player */
			display_player(mode);

			/* Prepare a prompt (must squeeze everything in) */
			Term_gotoxy(2, 23);
			Term_addch(TERM_WHITE, b1);
#ifdef JP
Term_addstr(-1, TERM_WHITE, "'r'Ǽο");
#else
			Term_addstr(-1, TERM_WHITE, "'r' to reroll");
#endif

#ifdef JP
if (prev) Term_addstr(-1, TERM_WHITE, ", 'p'ο");
#else
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p' for prev");
#endif

#ifdef JP
if (mode) Term_addstr(-1, TERM_WHITE, ", 'h' Ǥ¾ξ");
#else
			if (mode) Term_addstr(-1, TERM_WHITE, ", 'h' for Misc.");
#endif

#ifdef JP
else Term_addstr(-1, TERM_WHITE, ", 'h' Ωɽ");
#else
			else Term_addstr(-1, TERM_WHITE, ", 'h' for History");
#endif

#ifdef JP
Term_addstr(-1, TERM_WHITE, ", ESCǤοͤ˷");
#else
			Term_addstr(-1, TERM_WHITE, ", or ESC to accept");
#endif

			Term_addch(TERM_WHITE, b2);

			/* Prompt and get a command */
			c = inkey();

			/* Quit */
			if (c == 'Q')
			{
				birth_quit();
			}

			/* Start over */
			if (c == 'S') return (FALSE);

			/* Escape accepts the roll */
			if (c == ESCAPE) break;

			/* Reroll this character */
			if ((c == ' ') || (c == 'r')) break;

			/* Previous character */
			if (prev && (c == 'p'))
			{
				load_prev_data();
				continue;
			}

			/* Toggle the display */
			if ((c == 'H') || (c == 'h'))
			{
				mode = ((mode != 0) ? 0 : 1);
				continue;
			}

			/* Help */
			if (c == '?')
			{
				do_cmd_help();
				continue;
			}
			else if (c == '=')
			{
				screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
				do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif

				screen_load();
				continue;
			}

			/* Warning */
#ifdef JP
			bell();
#else
			bell();
#endif

		}

		/* Are we done? */
		if (c == ESCAPE) break;

		/* Save this for the "previous" character */
		save_prev_data();

		/* Note that a previous roll exists */
		prev = TRUE;
	}

	/* Clear prompt */
	clear_from(23);

	get_max_stats();

	/*** Finish up ***/

	/* Get a name, recolor it, prepare savefile */

	get_name();

	get_virtues();

        /* Set the recall dungeon accordingly */
        if (vanilla_town)
        {
		dungeon_type = 0;
		p_ptr->recall_dungeon = DUNGEON_ANGBAND;
        }
        else
        {
                dungeon_type = 0;
		p_ptr->recall_dungeon = DUNGEON_GALGALS;
        }

	/* Prompt for it */
#ifdef JP
	prt("[ 'Q' , 'S' ǽᤫ, ESC ǥ೫ ]", 23, 14);
#else
	prt("['Q' to suicide, 'S' to start over, or ESC to continue]", 23, 10);
#endif


	/* Get a key */
	c = inkey();

	/* Quit */
	if (c == 'Q')
	{
		birth_quit();
	}

	/* Start over */
	if (c == 'S') return (FALSE);

	/* Accept */
	return (TRUE);
}


/*
 * Create a new character.
 *
 * Note that we may be called with "junk" leftover in the various
 * fields, so we must be sure to clear them first.
 */
void player_birth(void)
{
	int i, j;
	char buf[80];

	playtime = 0;

	/* Reset turn */
	dungeon_turn = 1;

	/* Create a new character */
	while (1)
	{
		/* Wipe the player */
		player_wipe();

		/* Roll up a new character */
		if (player_birth_aux()) break;
	}


	/* Hack -- enter the world */
	if ((p_ptr->prace == RACE_VAMPIRE) ||
	    (p_ptr->prace == RACE_SKELETON) ||
	    (p_ptr->prace == RACE_ZOMBIE) ||
	    (p_ptr->prace == RACE_SPECTRE))
	{
		/* Undead start just after midnight */
		turn = (60L * TOWN_DAWN) / 4 + 1;
	}
	else
	{
		turn = 1;
	}

	/* Note player birth in the message recall */
	message_add(" ");
	message_add("  ");
	message_add("====================");
	message_add(" ");
	message_add("  ");

#ifdef JP
	do_cmd_write_nikki(NIKKI_GAMESTART, 1, "-------- ೫ --------");
#else
	do_cmd_write_nikki(NIKKI_GAMESTART, 1, "-------- Start New Game --------");
#endif
	do_cmd_write_nikki(NIKKI_HIGAWARI, 0, NULL);

#ifdef JP
	sprintf(buf,"                            ̤%s򤷤", sex_info[p_ptr->psex].title);
#else
	sprintf(buf,"                            choose %s personality.", sex_info[p_ptr->psex].title);
#endif
	do_cmd_write_nikki(NIKKI_BUNSHOU, 1, buf);

#ifdef JP
	sprintf(buf,"                            ²%s򤷤", race_info[p_ptr->prace].title);
#else
	sprintf(buf,"                            choose %s race.", race_info[p_ptr->prace].title);
#endif
	do_cmd_write_nikki(NIKKI_BUNSHOU, 1, buf);

#ifdef JP
	sprintf(buf,"                            Ȥ%s򤷤", class_info[p_ptr->pclass].title);
#else
	sprintf(buf,"                            choose %s class.", class_info[p_ptr->pclass].title);
#endif
	do_cmd_write_nikki(NIKKI_BUNSHOU, 1, buf);

	if (p_ptr->realm1)
	{
#ifdef JP
		sprintf(buf,"                            ˡΰ%s%s򤷤",realm_names[p_ptr->realm1], p_ptr->realm2 ? format("%s",realm_names[p_ptr->realm2]) : "");
#else
		sprintf(buf,"                            choose %s%s realm.",realm_names[p_ptr->realm1], p_ptr->realm2 ? format(" realm and %s",realm_names[p_ptr->realm2]) : "");
#endif
		do_cmd_write_nikki(NIKKI_BUNSHOU, 1, buf);
	}

#ifdef JP
	sprintf(buf,"                            ʤ%s򤷤", seikaku_info[p_ptr->pseikaku].title);
#else
	sprintf(buf,"                            choose %s.", seikaku_info[p_ptr->pseikaku].title);
#endif
	do_cmd_write_nikki(NIKKI_BUNSHOU, 1, buf);

	/* Init the shops */
	for (i = 1; i < max_towns; i++)
	{
		for (j = 0; j < MAX_STORES; j++)
		{
			/* Initialize */
			store_init(i, j);
		}
	}

	/* Generate the random seeds for the wilderness */
	seed_wilderness();

	/* Set the message window flag as default */
	if (!window_flag[1])
		window_flag[1] |= PW_MESSAGE;

	/* Set the inv/equip window flag as default */
	if (!window_flag[2])
		window_flag[2] |= PW_INVEN;
}


void dump_yourself(FILE *fff)
{
	unsigned char temp[80*8];
	int i;
	cptr t;

	if (!fff) return;

	roff_to_buf(race_jouhou[p_ptr->prace], 78, temp);
	fprintf(fff, "\n\n");
#ifdef JP
	fprintf(fff, "²: %s\n", race_info[p_ptr->prace].title);
#else
	fprintf(fff, "Race: %s\n", race_info[p_ptr->prace].title);
#endif
	t = temp;
	for (i = 0; i < 8; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(class_jouhou[p_ptr->pclass], 78, temp);
	fprintf(fff, "\n");
#ifdef JP
	fprintf(fff, ": %s\n", class_info[p_ptr->pclass].title);
#else
	fprintf(fff, "Class: %s\n", class_info[p_ptr->pclass].title);
#endif
	t = temp;
	for (i = 0; i < 8; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(seikaku_jouhou[p_ptr->pseikaku], 78, temp);
	fprintf(fff, "\n");
#ifdef JP
	fprintf(fff, ": %s\n", seikaku_info[p_ptr->pseikaku].title);
#else
	fprintf(fff, "Pesonality: %s\n", seikaku_info[p_ptr->pseikaku].title);
#endif
	t = temp;
	for (i = 0; i < 6; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	fprintf(fff, "\n");
	if (p_ptr->realm1)
	{
		roff_to_buf(realm_jouhou[technic2magic(p_ptr->realm1)-1], 78, temp);
#ifdef JP
		fprintf(fff, "ˡ: %s\n", realm_names[p_ptr->realm1]);
#else
		fprintf(fff, "Realm: %s\n", realm_names[p_ptr->realm1]);
#endif
		t = temp;
		for (i = 0; i < 6; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
	fprintf(fff, "\n");
	if (p_ptr->realm2)
	{
		roff_to_buf(realm_jouhou[technic2magic(p_ptr->realm2)-1], 78, temp);
#ifdef JP
		fprintf(fff, "ˡ: %s\n", realm_names[p_ptr->realm2]);
#else
		fprintf(fff, "Realm: %s\n", realm_names[p_ptr->realm2]);
#endif
		t = temp;
		for (i = 0; i < 6; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
}

