/* File: tables.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: Angband Tables */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra 1/4-mana-points per level
 */
byte adj_mag_mana[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	2       /* 9 */,
	3       /* 10 */,
	4       /* 11 */,
	5       /* 12 */,
	5       /* 13 */,
	6       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	11      /* 18/10-18/19 */,
	11      /* 18/20-18/29 */,
	12      /* 18/30-18/39 */,
	12      /* 18/40-18/49 */,
	13      /* 18/50-18/59 */,
	14      /* 18/60-18/69 */,
	15      /* 18/70-18/79 */,
	16      /* 18/80-18/89 */,
	17      /* 18/90-18/99 */,
	18      /* 18/100-18/109 */,
	19      /* 18/110-18/119 */,
	20      /* 18/120-18/129 */,
	21      /* 18/130-18/139 */,
	22      /* 18/140-18/149 */,
	23      /* 18/150-18/159 */,
	24      /* 18/160-18/169 */,
	25      /* 18/170-18/179 */,
	26      /* 18/180-18/189 */,
	27      /* 18/190-18/199 */,
	28      /* 18/200-18/209 */,
	29      /* 18/210-18/219 */,
	30      /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2    /*  3 */,
	128 + -2    /*  4 */,
	128 + -1    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 0     /* 15 */,
	128 + 1     /* 16 */,
	128 + 2     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 3     /* 18/20-18/29 */,
	128 + 3     /* 18/30-18/39 */,
	128 + 3     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 4     /* 18/70-18/79 */,
	128 + 5     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 10    /* 18/140-18/149 */,
	128 + 11    /* 18/150-18/159 */,
	128 + 12    /* 18/160-18/169 */,
	128 + 13    /* 18/170-18/179 */,
	128 + 14    /* 18/180-18/189 */,
	128 + 15    /* 18/190-18/199 */,
	128 + 16    /* 18/200-18/209 */,
	128 + 18    /* 18/210-18/219 */,
	128 + 20    /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -2        /* 5 */,
	128 + -1        /* 6 */,
	128 + -1        /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 1 /* 16 */,
	128 + 2 /* 17 */,
	128 + 3 /* 18/00-18/09 */,
	128 + 3 /* 18/10-18/19 */,
	128 + 3 /* 18/20-18/29 */,
	128 + 3 /* 18/30-18/39 */,
	128 + 3 /* 18/40-18/49 */,
	128 + 4 /* 18/50-18/59 */,
	128 + 4 /* 18/60-18/69 */,
	128 + 4 /* 18/70-18/79 */,
	128 + 4 /* 18/80-18/89 */,
	128 + 5 /* 18/90-18/99 */,
	128 + 6 /* 18/100-18/109 */,
	128 + 7 /* 18/110-18/119 */,
	128 + 8 /* 18/120-18/129 */,
	128 + 9 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -1        /* 5 */,
	128 + -1        /* 6 */,
	128 + 0 /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 0 /* 16 */,
	128 + 0 /* 17 */,
	128 + 1 /* 18/00-18/09 */,
	128 + 1 /* 18/10-18/19 */,
	128 + 1 /* 18/20-18/29 */,
	128 + 1 /* 18/30-18/39 */,
	128 + 1 /* 18/40-18/49 */,
	128 + 1 /* 18/50-18/59 */,
	128 + 1 /* 18/60-18/69 */,
	128 + 2 /* 18/70-18/79 */,
	128 + 3 /* 18/80-18/89 */,
	128 + 4 /* 18/90-18/99 */,
	128 + 5 /* 18/100-18/109 */,
	128 + 6 /* 18/110-18/119 */,
	128 + 7 /* 18/120-18/129 */,
	128 + 8 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	10      /* 3 */,
	11      /* 4 */,
	12      /* 5 */,
	13      /* 6 */,
	14      /* 7 */,
	15      /* 8 */,
	16      /* 9 */,
	17      /* 10 */,
	18      /* 11 */,
	19      /* 12 */,
	20      /* 13 */,
	21      /* 14 */,
	22      /* 15 */,
	23      /* 16 */,
	24      /* 17 */,
	25      /* 18/00-18/09 */,
	26      /* 18/10-18/19 */,
	27      /* 18/20-18/29 */,
	28      /* 18/30-18/39 */,
	29      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	9       /* 8 */,
	10      /* 9 */,
	11      /* 10 */,
	12      /* 11 */,
	13      /* 12 */,
	14      /* 13 */,
	15      /* 14 */,
	16      /* 15 */,
	17      /* 16 */,
	18      /* 17 */,
	19      /* 18/00-18/09 */,
	20      /* 18/10-18/19 */,
	21      /* 18/20-18/29 */,
	22      /* 18/30-18/39 */,
	23      /* 18/40-18/49 */,
	24      /* 18/50-18/59 */,
	25      /* 18/60-18/69 */,
	26      /* 18/70-18/79 */,
	27      /* 18/80-18/89 */,
	28      /* 18/90-18/99 */,
	30      /* 18/100-18/109 */,
	31      /* 18/110-18/119 */,
	32      /* 18/120-18/129 */,
	33      /* 18/130-18/139 */,
	34      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	37      /* 18/160-18/169 */,
	40      /* 18/170-18/179 */,
	44      /* 18/180-18/189 */,
	48      /* 18/190-18/199 */,
	50     /* 18/200-18/209 */,
	50     /* 18/210-18/219 */,
	50     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	9      /* 18/140-18/149 */,
	9      /* 18/150-18/159 */,
	10      /* 18/160-18/169 */,
	10      /* 18/170-18/179 */,
	11      /* 18/180-18/189 */,
	11      /* 18/190-18/199 */,
	12      /* 18/200-18/209 */,
	12      /* 18/210-18/219 */,
	13      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra 1/4-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -8        /* 3 */,
	128 + -6        /* 4 */,
	128 + -4        /* 5 */,
	128 + -2        /* 6 */,
	128 + -1 /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 1 /* 14 */,
	128 + 1 /* 15 */,
	128 + 2 /* 16 */,
	128 + 3 /* 17 */,
	128 + 4 /* 18/00-18/09 */,
	128 + 5 /* 18/10-18/19 */,
	128 + 6 /* 18/20-18/29 */,
	128 + 7 /* 18/30-18/39 */,
	128 + 8 /* 18/40-18/49 */,
	128 + 9 /* 18/50-18/59 */,
	128 + 10  /* 18/60-18/69 */,
	128 + 11 /* 18/70-18/79 */,
	128 + 12 /* 18/80-18/89 */,
	128 + 14 /* 18/90-18/99 */,
	128 + 17         /* 18/100-18/109 */,
	128 + 20        /* 18/110-18/119 */,
	128 + 23        /* 18/120-18/129 */,
	128 + 26        /* 18/130-18/139 */,
	128 + 29        /* 18/140-18/149 */,
	128 + 32        /* 18/150-18/159 */,
	128 + 35        /* 18/160-18/169 */,
	128 + 38        /* 18/170-18/179 */,
	128 + 40        /* 18/180-18/189 */,
	128 + 42        /* 18/190-18/199 */,
	128 + 44        /* 18/200-18/209 */,
	128 + 46        /* 18/210-18/219 */,
	128 + 48        /* 18/220+ */
};


/*
 * Stat Table (CHR) -- charm
 */
byte adj_chr_chm[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	18      /* 18/40-18/49 */,
	21      /* 18/50-18/59 */,
	24      /* 18/60-18/69 */,
	28      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	36      /* 18/90-18/99 */,
	39      /* 18/100-18/109 */,
	42      /* 18/110-18/119 */,
	45      /* 18/120-18/129 */,
	49      /* 18/130-18/139 */,
	53      /* 18/140-18/149 */,
	57      /* 18/150-18/159 */,
	61      /* 18/160-18/169 */,
	65      /* 18/170-18/179 */,
	69      /* 18/180-18/189 */,
	73      /* 18/190-18/199 */,
	77      /* 18/200-18/209 */,
	81      /* 18/210-18/219 */,
	85      /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * Warrior       num = 6; mul = 5; div = MAX(70, weapon_weight);
 * Berserker     num = 6; mul = 7; div = MAX(70, weapon_weight);
 * Mage          num = 3; mul = 2; div = MAX(100, weapon_weight);
 * Priest        num = 5; mul = 3; div = MAX(100, weapon_weight);
 * Mindcrafter   num = 5; mul = 3; div = MAX(100, weapon_weight);
 * Rogue         num = 5; mul = 3; div = MAX(40, weapon_weight);
 * Ranger        num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Paladin       num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Kaji          num = 5; mul = 5; div = MAX(150, weapon_weight);
 * Warrior-Mage  num = 5; mul = 3; div = MAX(70, weapon_weight);
 * Chaos Warrior num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Monk          num = 5; mul = 3; div = MAX(60, weapon_weight);
 * Tourist       num = 4; mul = 3; div = MAX(100, weapon_weight);
 * Imitator      num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Beastmaster   num = 5; mul = 3; div = MAX(70, weapon_weight);
 * Sorcerer      num = 1; mul = 1; div = MAX(1, weapon_weight);
 * Archer        num = 4; mul = 2; div = MAX(70, weapon_weight);
 * Magic eater   num = 4; mul = 2; div = MAX(70, weapon_weight);
 * ForceTrainer  num = 4; mul = 2; div = MAX(60, weapon_weight);
 * Mirror Master num = 3; mul = 3; div = MAX(100, weapon_weight);
 * Ninja         num = 4; mul = 1; div = MAX(20, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div".
 * Increase P by 1 if you wield a weapon two-handed.
 * Decrease P by 1 if you are a Ninja.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/*      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */
	/*      3   10   15  /10  /40  /60  /80 /100 /120 /140 /160 /180  */
/* 0 */{	1,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   4 },
/* 1 */{	1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4 },
/* 2 */{	1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3 */{	1,   1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4 */{	1,   1,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 6 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 7 */{	1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 8 */{	1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6 },
/* 9 */{	1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10*/{	2,   2,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/*11+*/{	2,   2,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6 },

};


arena_type arena_info[MAX_ARENA_MONS + 2] =
{
	{ MON_NOBORTA,       0,         0                             },
	{ MON_MORI_TROLL,    0,         0                             },
	{ MON_TIGER,         0,         0                             },
	{ MON_DRUID,         0,         0                             },
	{ MON_HILL_GIANT,    TV_POTION, SV_POTION_SPEED               },
	{ MON_WERERAT,       0,         0                             },
	{ MON_ORC_CAPTAIN,   0,         0                             },
	{ MON_BERSERKER,     0,         0                             },
	{ MON_STONE_GIANT,   0,         0                             },
	{ MON_D_ELF_LORD,    TV_POTION, SV_POTION_HEALING             },
	{ MON_IRON_GOLEM,    0,         0                             },
	{ MON_C_CRAWLER,     0,         0                             },
	{ MON_XICLOTLAN,     0,         0                             },
	{ MON_TROLL_PRIEST,  0,         0                             },
	{ MON_ANGEL,         TV_ROD,    SV_ROD_STONE_TO_MUD           },
	{ MON_SPIRIT_NAGA,   0,         0                             },
	{ MON_BASILISK,      0,         0                             },
	{ MON_MITHRIL_GOLEM, 0,         0                             },
	{ MON_SHADOW_DRAKE,  0,         0                             },
	{ MON_OGRE_SHAMAN,   TV_SCROLL, SV_SCROLL_ACQUIREMENT         },
	{ MON_BICLOPS,       0,         0                             },
	{ MON_ETHER_DRAKE,   TV_SCROLL, SV_SCROLL_RUNE_OF_PROTECTION  },
	{ MON_HALFLING_S,    0,         0                             },
	{ MON_ELDER_THING,   TV_ROD,    SV_ROD_DRAIN_LIFE             },
	{ MON_M_MH_DRAGON,   0,         0                             },
	{ MON_ETTIN,         TV_SCROLL, SV_SCROLL_STAR_ENCHANT_WEAPON },
	{ MON_VAMPIRE_LORD,  0,         0                             },
	{ MON_BARNEY,        TV_SCROLL, SV_SCROLL_GENOCIDE            },
	{ MON_GROO,          0,         0                             },
	{ MON_D_ELF_SORC,    TV_WAND,   SV_WAND_STRIKING              },
	{ MON_IRON_LICH,     0,         0                             },
	{ MON_G_TITAN,       TV_POTION, SV_POTION_STAR_ENLIGHTENMENT  },
	{ MON_G_BALROG,      0,         0                             },
	{ MON_NIGHTWALKER,   TV_ROD,    SV_ROD_IDENTIFY               },
	{ MON_SHAMBLER,      TV_STAFF,  SV_STAFF_HOLINESS             },
	{ MON_BLACK_REAVER,  TV_SCROLL, SV_SCROLL_STAR_ACQUIREMENT    },
	{ MON_FENGHUANG,     TV_STAFF,  SV_STAFF_THE_MAGI             },
	{ MON_WYRM_POWER,    TV_ROD,    SV_ROD_HEALING                },
	{ 0,                 0,         0                             }, /* Victory prizing */
	{ MON_HAGURE,        TV_SCROLL, SV_SCROLL_ARTIFACT            },
};


/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
/*
   Raistlin  dragonlance  powerful wizard 
   Rincewind the Chicken  Terry Pratchett  Discworld оʪ 嵭Υѥǥ
 */

#ifdef JP
		{ "եɥ꡼ʥӥ",       200,    170,  108,   5,  15,  RACE_HOBBIT},
/*                { "¼ԥ饹ȥ",       200,    175,  108,   4,  12,  RACE_HUMAN},  */
		{ "¼ԥ󥹥",       200,    175,  108,   4,  12,  RACE_HUMAN}, 
		{ "ؤ㤤륿",             300,    170,  107,   5,  15,  RACE_GNOME},
		{ "ϥ󥵥ʥ饤=",      300,    165,  107,   6,  18,  RACE_ELF},
#else
		{ "Bilbo the Friendly",         200,    170, 108,  5, 15, RACE_HOBBIT},
/*		{ "Raistlin the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN}, */
		{ "Rincewind the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",          300,    170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",         300,    165, 107,  6, 18, RACE_ELF},
#endif

#ifdef JP
{ "ڤʥեޥ",         250,    170, 108,  5, 15, RACE_HOBBIT},
#else
		{ "Falilmawen the Friendly",         250,    170, 108,  5, 15, RACE_HOBBIT},
#endif
#ifdef JP
{ "¼ԥ",       500,    175, 108,  4, 12, RACE_HUMAN},
#else
		{ "Voirin the Cowardly",       500,    175, 108,  4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "ӤΥ饷ʥ",          750,    170, 107,  5, 15, RACE_BEASTMAN},
#else
		{ "Erashnak the Midget",          750,    170, 107,  5, 15, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ϥ󥵥ʥå",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
#else
		{ "Grug the Comely",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
#endif
#ifdef JP
{ "ʥեӥ",         250,    170, 108,  5, 15, RACE_HUMAN},
#else
		{ "Forovir the Cheap",         250,    170, 108,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ϼΥꥹ",       500,    175, 108,  4, 12, RACE_HUMAN},
#else
		{ "Ellis the Fool",       500,    175, 108,  4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "ʢڥΥեС",          750,    170, 107,  5, 15, RACE_VAMPIRE},
#else
		{ "Filbert the Hungry",          750,    170, 107,  5, 15, RACE_VAMPIRE},
#endif
#ifdef JP
{ "ʡ롦",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
#else
		{ "Fthnargl Psathiggua",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
#endif
#ifdef JP
{ "Ĺभ",         250,    170, 108,  5, 15, RACE_SPECTRE},
#else
		{ "Eloise Long-Dead",         250,    170, 108,  5, 15, RACE_SPECTRE},
#endif
#ifdef JP
{ "ΥޤΥեǥ",       500,    175, 108,  4, 12, RACE_ZOMBIE},
#else
		{ "Fundi the Slow",       500,    175, 108,  4, 12, RACE_ZOMBIE},
#endif
#ifdef JP
{ "󥵥",          750,    170, 107,  5, 15, RACE_SKELETON},
#else
		{ "Granthus",          750,    170, 107,  5, 15, RACE_SKELETON},
#endif
#ifdef JP
{ "ǫʥå",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
#else
		{ "Lorax the Suave",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
#endif
#ifdef JP
{ "֥å",         250,    170, 108,  5, 15, RACE_HALF_ORC},
#else
		{ "Butch",         250,    170, 108,  5, 15, RACE_HALF_ORC},
#endif
#ifdef JP
{ "٥쥹",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
#else
		{ "Elbereth the Beautiful",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "쥹",          750,    170, 107,  5, 15, RACE_GNOME},
#else
		{ "Sarleth the Sneaky",          750,    170, 107,  5, 15, RACE_GNOME},
#endif
#ifdef JP
{ "ʡå",        1000,    165, 107,  6, 18, RACE_DWARF},
#else
		{ "Narlock",        1000,    165, 107,  6, 18, RACE_DWARF},
#endif
#ifdef JP
{ "ӤΥإͥå",         250,    170, 108,  5, 15, RACE_GNOME},
#else
		{ "Haneka the Small",         250,    170, 108,  5, 15, RACE_GNOME},
#endif
#ifdef JP
{ "",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
#else
		{ "Loirin the Mad",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
#endif
#ifdef JP
{ "©Υ",          750,    170, 107,  5, 15, RACE_DRACONIAN},
#else
		{ "Wuto Poisonbreath",          750,    170, 107,  5, 15, RACE_DRACONIAN},
#endif
#ifdef JP
{ "Ǥ֤ä祢饡",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
#else
		{ "Araaka the Rotund",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
#endif
#ifdef JP
{ "ǽʥס",         250,    170, 108,  5, 15, RACE_BEASTMAN},
#else
		{ "Poogor the Dumb",         250,    170, 108,  5, 15, RACE_BEASTMAN},
#endif
#ifdef JP
{ "եեꥢ",       500,    175, 108,  4, 12, RACE_ELF},
#else
		{ "Felorfiliand",       500,    175, 108,  4, 12, RACE_ELF},
#endif
#ifdef JP
{ "ǯޥ",          750,    170, 107,  5, 15, RACE_GNOME},
#else
		{ "Maroka the Aged",          750,    170, 107,  5, 15, RACE_GNOME},
#endif
#ifdef JP
{ " ͦʥ",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
#else
		{ "Sasin the Bold",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
#endif
#ifdef JP
{ "ļ˼ԥӥޡ",         250,    170, 108,  5, 15, RACE_HUMAN},
#else
		{ "Abiemar the Peasant",         250,    170, 108,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "˳ʥϡ",       500,    175, 108,  4, 12, RACE_HALF_ORC},
#else
		{ "Hurk the Poor",       500,    175, 108,  4, 12, RACE_HALF_ORC},
#endif
#ifdef JP
{ "ߤʥ",          750,    170, 107,  5, 15, RACE_ZOMBIE},
#else
		{ "Soalin the Wretched",          750,    170, 107,  5, 15, RACE_ZOMBIE},
#endif
#ifdef JP
{ "Ǥʥ",        1000,    165, 107,  6, 18, RACE_ELF},
#else
		{ "Merulla the Humble",        1000,    165, 107,  6, 18, RACE_ELF},
#endif
	},
	{
		/* Armoury - 28 unique names */
#ifdef JP
		{ "=",      5000,   210,  115,   5,   7,  RACE_HALF_ORC},
		{ "Ǽԥ=",  10000,  190,  111,   4,   9,  RACE_HUMAN},
		{ "ԥǥ",                 25000,  200,  112,   4,  10,  RACE_DUNADAN},
		{ "결Υ",   30000,  200,  112,   4,   5,  RACE_DWARF},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif

#ifdef JP
{ "=",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Kon-Dar the Ugly",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif
#ifdef JP
{ "Ǽԥ=",          15000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Darg-Low the Grim",          15000,  190, 111,  4,  9, RACE_HUMAN},
#endif
#ifdef JP
{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#else
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#endif
#ifdef JP
	{ "ɥ饴󥹥",          30000,  200, 112,  4,  5, RACE_ELF},
#else
	{ "Elo Dragonscale",          30000,  200, 112,  4,  5, RACE_ELF},
#endif
#ifdef JP
{ "ǥꥫȥ",           10000,   210, 115,  5,  7, RACE_SPRITE},
#else
		{ "Delicatus",           10000,   210, 115,  5,  7, RACE_SPRITE},
#endif
#ifdef JP
{ "ʥ롼",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
#else
		{ "Gruce the Huge",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
#endif
#ifdef JP
{ "˥ॹ",            25000,  200, 112,  4, 10, RACE_GOLEM},
#else
		{ "Animus",            25000,  200, 112,  4, 10, RACE_GOLEM},
#endif
#ifdef JP
	{ "ޥ",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
#else
	{ "Malvus",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
#endif
#ifdef JP
{ "饯",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
#else
		{ "Selaxis",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ǥ",          5000,  190, 111,  4,  9, RACE_SPECTRE},
#else
		{ "Deathchill",          5000,  190, 111,  4,  9, RACE_SPECTRE},
#endif
#ifdef JP
{ "ʥɥꥪ",            25000,  200, 112,  4, 10, RACE_SPECTRE},
#else
		{ "Drios the Faint",            25000,  200, 112,  4, 10, RACE_SPECTRE},
#endif
#ifdef JP
	{ "䤿Хå",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
#else
	{ "Bathric the Cold",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
#endif
#ifdef JP
{ "󥸥",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
#else
		{ "Vengella the Cruel",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
#endif
#ifdef JP
{ "ԥ",          15000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Wyrana the Mighty",          15000,  190, 111,  4,  9, RACE_HUMAN},
#endif
#ifdef JP
{ "襸",            25000,  200, 112,  4, 10, RACE_DWARF},
#else
		{ "Yojo II",            25000,  200, 112,  4, 10, RACE_DWARF},
#endif
#ifdef JP
	{ "ͥʥ顼",          30000,  200, 112,  4,  5, RACE_AMBERITE},
#else
	{ "Ranalar the Sweet",          30000,  200, 112,  4,  5, RACE_AMBERITE},
#endif
#ifdef JP
{ "ԾΥۥХ",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Horbag the Unclean",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif
#ifdef JP
{ "ƥѥΥ",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
#else
		{ "Elelen the Telepath",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
#endif
#ifdef JP
{ "ɥꥢ",            25000,  200, 112,  4, 10, RACE_SPRITE},
#else
		{ "Isedrelias",            25000,  200, 112,  4, 10, RACE_SPRITE},
#endif
#ifdef JP
	{ "ܥʡ",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
#else
	{ "Vegnar One-eye",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
#endif
#ifdef JP
{ "٤Υǥå",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Rodish the Chaotic",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
#endif
#ifdef JP
{ "إ",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
#else
		{ "Hesin Swordmaster",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
#endif
#ifdef JP
{ "벰Υ٥ꥹ",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
#else
		{ "Elvererith the Cheat",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "פΥ",          30000,  200, 112,  4,  5, RACE_IMP},
#else
	{ "Zzathath the Imp",          30000,  200, 112,  4,  5, RACE_IMP},
#endif
#ifdef JP
{ "=",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif
#ifdef JP
{ "Ǽԥ=",          10000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
#endif
#ifdef JP
{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#else
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#endif
#ifdef JP
{ "결Υ",          30000,  200, 112,  4,  5, RACE_DWARF},
#else
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif
	},
	{
		/* Weapon Smith - 28 unique names */
#ifdef JP
		{ "Ǧʤ륢Υ",        5000,   210,  115,   6,   6,  RACE_HALF_TROLL},
		{ "ûΥ", 10000,  185,  110,   5,   9,  RACE_HALF_ELF},
		{ "åޥΥǥ", 25000,  190,  115,   5,   7,  RACE_HOBBIT},
		{ "εΥ饤", 30000,  195,  112,   4,   8,  RACE_DWARF},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif

#ifdef JP
{ "ԥɥ塼",      10000,   210, 115,  6,  6, RACE_HUMAN},
#else
		{ "Drew the Skilled",      10000,   210, 115,  6,  6, RACE_HUMAN},
#endif
#ifdef JP
{"ζλҥå",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
#else
		{"Orrax Dragonson",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
#endif
#ifdef JP
{ "µΥ󥹥å",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Anthrax Disease-Carrier",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ԥ륳",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Arkhoth the Stout",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
#ifdef JP
{ "ԤΥꥢ",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
#else
		{ "Sarlyas the Rotten",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
#endif
#ifdef JP
{"Υȥ",        15000,  185, 110,  5,  9, RACE_SKELETON},
#else
		{"Tuethic Bare-Bones",        15000,  185, 110,  5,  9, RACE_SKELETON},
#endif
#ifdef JP
{ "ӥꥪ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Bilious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ե",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
#else
		{ "Fasgul",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ѥǥΥեꥹ",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
#else
		{ "Ellefris the Paladin",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
#endif
#ifdef JP
{"'ȥ'",        15000,  185, 110,  5,  9, RACE_KLACKON},
#else
		{"K'trrik'k",        15000,  185, 110,  5,  9, RACE_KLACKON},
#endif
#ifdef JP
{ "ͧɥ",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
#else
		{ "Drocus Spiderfriend",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
#endif
#ifdef JP
{ "ͻΥե󥰥",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Fungus Giant-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
#ifdef JP
{ "ǥ",      10000,   210, 115,  6,  6, RACE_ELF},
#else
		{ "Delantha",      10000,   210, 115,  6,  6, RACE_ELF},
#endif
#ifdef JP
{"󥸥㡼Υӥ",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
#else
		{"Solvistani the Ranger",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
#endif
#ifdef JP
{ "ΥޤΥ",         25000,  190, 115,  5,  7, RACE_GOLEM},
#else
		{ "Xoril the Slow",         25000,  190, 115,  5,  7, RACE_GOLEM},
#endif
#ifdef JP
{ "󡦥եå",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
#else
		{ "Aeon Flux",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
#endif
#ifdef JP
{ "ԥʥɥå",      10000,   210, 115,  6,  6, RACE_HOBBIT},
#else
		{ "Nadoc the Strong",      10000,   210, 115,  6,  6, RACE_HOBBIT},
#endif
#ifdef JP
{"⥰",        15000,  185, 110,  5,  9, RACE_KOBOLD},
#else
		{"Eramog the Weak",        15000,  185, 110,  5,  9, RACE_KOBOLD},
#endif
#ifdef JP
{ "ʥꥹ",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
#else
		{ "Eowilith the Fair",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
#endif
#ifdef JP
{ "ХΥҥ奤⥰",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
#else
		{ "Huimog Balrog-Slayer",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
#endif
#ifdef JP
{ "ԡ",      5000,   210, 115,  6,  6, RACE_HUMAN},
#else
		{ "Peadus the Cruel",      5000,   210, 115,  6,  6, RACE_HUMAN},
#endif
#ifdef JP
{ "⥰ 쥤䡼",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
#else
		{ "Vamog Slayer",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
#endif
#ifdef JP
{ "աʥ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Hooshnak the Vicious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ƮХ",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
#else
		{ "Balenn War-Dancer",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
#endif
#ifdef JP
{ " Ǧʤ륢Υ",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
#endif
#ifdef JP
{ "ûΥ",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
#else
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
#endif
#ifdef JP
{ "ӡȥޥǥ",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
#endif
#ifdef JP
{ "εΥ饤",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
	},
	{
		/* Temple - 22 unique names */
#ifdef JP
		{ "Ǥʥ롼ɥ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "ѥǥΥʡ",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "Ф줷ȥ",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "ʤ륵饹ȥ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#else
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ɥ륤ɤΥϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#else
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#endif
#ifdef JP
{ "եʥ",          30000,  185, 109,  5, 15, RACE_YEEK},
#else
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif
#ifdef JP
{ "ꥭå",         10000,   175, 109,  6, 15, RACE_KLACKON},
#else
		{ "Krikkik",         10000,   175, 109,  6, 15, RACE_KLACKON},
#endif
#ifdef JP
{ "Ӥԥ",         15000,  185, 110,  5, 23, RACE_ELF},
#else
		{ "Morival the Wild",         15000,  185, 110,  5, 23, RACE_ELF},
#endif
#ifdef JP
{ "Ťۥå",           25000,  180, 107,  6, 20, RACE_IMP},
#else
		{ "Hoshak the Dark",           25000,  180, 107,  6, 20, RACE_IMP},
#endif
#ifdef JP
{ "ԥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Atal the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "٥˥å",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "Ibenidd the Chaste",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ǥ",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
#else
		{ "Eridish",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
#endif
#ifdef JP
{ "ѻեɥ",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
#else
		{ "Vrudush the Shaman",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
#endif
#ifdef JP
{ "Υϥ",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
#else
		{ "Haob the Berserker",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
#endif
#ifdef JP
{ "㤭ץ롼ǥ",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
#else
		{ "Proogdish the Youthfull",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
#endif
#ifdef JP
{ "磻",         15000,  185, 110,  5, 23, RACE_YEEK},
#else
		{ "Lumwise the Mad",         15000,  185, 110,  5, 23, RACE_YEEK},
#endif
#ifdef JP
{ "ͭԥ",           25000,  180, 107,  6, 20, RACE_KOBOLD},
#else
		{ "Muirt the Virtuous",           25000,  180, 107,  6, 20, RACE_KOBOLD},
#endif
#ifdef JP
{ "ɥС",          30000,  185, 109,  5, 15, RACE_SPECTRE},
#else
		{ "Dardobard the Weak",          30000,  185, 109,  5, 15, RACE_SPECTRE},
#endif
#ifdef JP
{ "Ǥʥ롼ɥ",          5000,   175, 109,  6, 15, RACE_DWARF},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
#endif
#ifdef JP
{ "ѥǥΥʡ",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
#else
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
#endif
#ifdef JP
{ "Ф줷ȥ",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ʤ륵饹ȥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif
#ifdef JP
{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#else
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ɥ륤 ϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#else
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#endif
#ifdef JP
{ "եʥ",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#else
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif
	},
	{
		/* Alchemist - 26 unique names */
#ifdef JP
		{ "ؼԥޥ",             10000,  190,  111,   5,   8,  RACE_HALF_ELF},
		{ "Υ",   10000,  190,  110,   6,   8,  RACE_HOBBIT},
		{ "ߥߥ",              15000,  200,  116,   6,   9,  RACE_GNOME},
		{ "ϼ奸=ե",                   15000,  220,  111,   4,   9,  RACE_ELF},/*FIRST*/
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif

#ifdef JP
	{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
#else
	{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
#endif
#ifdef JP
	{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
	{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
#ifdef JP
{ "ѿեͥ饹",         10000,  190, 111,  5,  8, RACE_DWARF},
#else
		{ "Fanelath the Cautious",         10000,  190, 111,  5,  8, RACE_DWARF},
#endif
#ifdef JP
{ "Υ󥷡",         10000,  190, 110,  6,  8, RACE_HUMAN},
#else
		{ "Runcie the Insane",         10000,  190, 110,  6,  8, RACE_HUMAN},
#endif
#ifdef JP
	{ "֥",           15000,  200, 116,  6,  9, RACE_GNOME},
#else
	{ "Grumbleworth",           15000,  200, 116,  6,  9, RACE_GNOME},
#endif
#ifdef JP
	{ "եå",       15000,  220, 111,  4,  9, RACE_SPRITE},
#else
	{ "Flitter",       15000,  220, 111,  4,  9, RACE_SPRITE},
#endif
#ifdef JP
{ "륹",         10000,  190, 111,  5,  8, RACE_HUMAN},
#else
		{ "Xarillus",         10000,  190, 111,  5,  8, RACE_HUMAN},
#endif
#ifdef JP
{ "ŤС",         10000,  190, 110,  6,  8, RACE_DWARF},
#else
		{ "Egbert the Old",         10000,  190, 110,  6,  8, RACE_DWARF},
#endif
#ifdef JP
	{ "ؤ⤭ɥ",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
#else
	{ "Valindra the Proud",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
#endif
#ifdef JP
	{ "ϣѻե",       15000,  220, 111,  4,  9, RACE_HUMAN},
#else
	{ "Taen the Alchemist",       15000,  220, 111,  4,  9, RACE_HUMAN},
#endif
#ifdef JP
{ "",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
#else
		{ "Cayd the Sweet",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
#endif
#ifdef JP
{ "Ťեꥢ",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
#else
		{ "Fulir the Dark",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
#endif
#ifdef JP
	{ "Ǥʥɥ",           15000,  200, 116,  6,  9, RACE_DWARF},
#else
	{ "Domli the Humble",           15000,  200, 116,  6,  9, RACE_DWARF},
#endif
#ifdef JP
	{ "λҥ䥡å",       15000,  220, 111,  4,  9, RACE_IMP},
#else
	{ "Yaarjukka Demonspawn",       15000,  220, 111,  4,  9, RACE_IMP},
#endif
#ifdef JP
{ "եɡ",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
#else
		{ "Gelaraldor the Herbmaster",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ԥ",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
#else
		{ "Olelaldan the Wise",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
#endif
#ifdef JP
	{ "ǥ˥ȤΥե",           15000,  200, 116,  6,  9, RACE_IMP},
#else
	{ "Fthoglo the Demonicist",           15000,  200, 116,  6,  9, RACE_IMP},
#endif
#ifdef JP
	{ "ϣѻեɥꥢ",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
#else
	{ "Dridash the Alchemist",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
#endif
#ifdef JP
{ "ԥͥꥢ",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
#else
		{ "Nelir the Strong",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
#endif
#ifdef JP
{ "ɸꥰʥ",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
#else
		{ "Lignus the Pungent",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
#endif
#ifdef JP
	{ "ƥ",           15000,  200, 116,  6,  9, RACE_HOBBIT},
#else
	{ "Tilba",           15000,  200, 116,  6,  9, RACE_HOBBIT},
#endif
#ifdef JP
	{ "ߥɥå",       15000,  220, 111,  4,  9, RACE_HUMAN},
#else
	{ "Myrildric the Wealthy",       15000,  220, 111,  4,  9, RACE_HUMAN},
#endif
#ifdef JP
{ "ʳؼԥޥ",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
#endif
#ifdef JP
{ "Υ",         10000,  190, 110,  6,  8, RACE_HOBBIT},
#else
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
#endif
#ifdef JP
{ "ߥߥ",           15000,  200, 116,  6,  9, RACE_GNOME},
#else
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
#endif
#ifdef JP
{ "ϣѻե=ե",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
#ifdef JP
	{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
#else
	{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
#endif
#ifdef JP
	{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
	{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
	},
	{
		/* Magic Shop - 23 unique names */
#ifdef JP
		{ "顼Υ=ѥ",       20000,  200,  110,   7,   8,  RACE_HALF_ELF},
		{ "ʤ֥ӥ",         20000,  215,  113,   6,  10,  RACE_GNOME},
		{ "ˡȤ",     30000,  200,  110,   7,  10,  RACE_HUMAN},
		{ "Ȥ㥯",30000,      175,  110,   5,  11,  RACE_HIGH_ELF},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
	{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
	{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif
#ifdef JP
	{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
	{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif
#ifdef JP
	{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
	{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
#else
	{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
#endif
#ifdef JP
{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
#ifdef JP
	{ "²Υ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#else
	{ "Kaza the Noble",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#endif
#ifdef JP
	{ "Ťե",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
	{ "Fazzil the Dark",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "ʤ륱ɡ",        15000,  200, 110,  7,  8, RACE_DWARF},
#else
	{ "Keldorn the Grand",        15000,  200, 110,  7,  8, RACE_DWARF},
#endif
#ifdef JP
{ "ե󥹥ץ",         20000,  215, 113,  6, 10, RACE_HOBBIT},
#else
		{ "Philanthropus",         20000,  215, 113,  6, 10, RACE_HOBBIT},
#endif
#ifdef JP
	{ "Υʡ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
	{ "Agnar the Enchantress",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif
#ifdef JP
	{ "ѻեӥꥢ",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
#else
	{ "Buliance the Necromancer",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
#endif
#ifdef JP
	{ "ϥᥤΥ饯",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
#else
	{ "Vuirak the High-Mage",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ηüԥޥǥå",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
#else
		{ "Madish the Smart",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
#endif
#ifdef JP
	{ "ե֥ܡ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#else
	{ "Falebrimbor",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#endif
#ifdef JP
	{ "ե=",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
	{ "Felil-Gand the Subtle",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "ѻե쥴",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#else
	{ "Thalegord the Shaman",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#endif
#ifdef JP
{ "ȥȥ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Cthoaloth the Mystic",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
#ifdef JP
	{ "ѻե٥",       30000,  200, 110,  7, 10, RACE_SKELETON},
#else
	{ "Ibeli the Illusionist",       30000,  200, 110,  7, 10, RACE_SKELETON},
#endif
#ifdef JP
	{ "ѻեإȡ",       30000,  175, 110,  5, 11, RACE_YEEK},
#else
	{ "Heto the Necromancer",       30000,  175, 110,  5, 11, RACE_YEEK},
#endif
#ifdef JP
{ "ѻե=ѥ",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif
#ifdef JP
{ "ʤ֥ӥ",         20000,  215, 113,  6, 10, RACE_GNOME},
#else
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
#endif
#ifdef JP
{ "ˡȤ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif
#ifdef JP
{ "ѻե㥯",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
	{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif
#ifdef JP
	{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
	{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif
#ifdef JP
	{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
	{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif
#ifdef JP
	{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
#else
	{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
#endif
#ifdef JP
{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
	},
	{
		/* Black Market - 32 unique names */
#ifdef JP
		{ "꡼=",            20000,  250,  150,  10,   5,  RACE_HALF_TROLL},
		{ "֥Υҥȡ",       20000,  250,  150,  10,   5,  RACE_HALF_ORC},
		{ "ե󥮿ͥ",           30000,  250,  150,  10,   5,  RACE_HUMAN},
		{ "ʤ(?)ȥå",                     30000,  250,  150,  10,   5,  RACE_ELF},
#else
		{ "Gary Gygaz",                 20000,  250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Quark the Ferengi",          30000,  250, 150, 10,  5, RACE_DWARF},
		{ "Topi the Fair(?)",           30000,  250, 150, 10,  5, RACE_HUMAN},
#endif

#ifdef JP
{ "ͥå",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
#else
		{ "Vhassa the Dead",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
#endif
#ifdef JP
{ "΢ڤԥ",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Kyn the Treacherous",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif
#ifdef JP
{ "֥ܥ˥",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#else
		{ "Bubonicus",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ץ饤",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#else
		{ "Corpselight",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#endif
#ifdef JP
{ "˵ѥå",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Parrish the Bloodthirsty",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif
#ifdef JP
{ "",          20000,  250, 150, 10,  5, RACE_SKELETON},
#else
		{ "Vile",          20000,  250, 150, 10,  5, RACE_SKELETON},
#endif
#ifdef JP
{ "Υץƥ",          30000,  250, 150, 10,  5, RACE_SKELETON},
#else
		{ "Prentice the Trusted",          30000,  250, 150, 10,  5, RACE_SKELETON},
#endif
#ifdef JP
{ "ʹֻΥꥨ",           30000,  250, 150, 10,  5, RACE_IMP},
#else
		{ "Griella Humanslayer",           30000,  250, 150, 10,  5, RACE_IMP},
#endif
#ifdef JP
{ "󥸥",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Angel",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif
#ifdef JP
{ "Ĥեĥ",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
#else
		{ "Flotsam the Bloated",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ˡ",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Nieval",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif
#ifdef JP
{ "뤤ʥ",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#else
		{ "Anastasia the Luminous",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#endif
#ifdef JP
{ "ѻեƥ", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
#else
		{ "Charity the Necromancer", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
#endif
#ifdef JP
{ "ܥΥץʥ",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
#else
		{ "Pugnacious the Pugilist",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
#endif
#ifdef JP
{ "ʥեåȥ",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#else
		{ "Footsore the Lucky",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#endif
#ifdef JP
{ "ؤΥɥꥢ",           30000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Sidria Lighfingered",           30000,  250, 150, 10,  5, RACE_HUMAN},
#endif
#ifdef JP
{ "ʻեꥢ",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
#else
		{ "Riatho the Juggler",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
#endif
#ifdef JP
{ "꤯Υʥå",          20000,  250, 150, 10,  5, RACE_GNOME},
#else
		{ "Janaaka the Shifty",          20000,  250, 150, 10,  5, RACE_GNOME},
#endif
#ifdef JP
{ "ޥ",          30000,  250, 150, 10,  5, RACE_GNOME},
#else
		{ "Cina the Rogue",          30000,  250, 150, 10,  5, RACE_GNOME},
#endif
#ifdef JP
{ "ޥ˥å",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
#else
		{ "Arunikki Greatclaw",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
#endif
#ifdef JP
{ "˳㥨",                 20000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Chaeand the Poor",                 20000,  250, 150, 10,  5, RACE_HUMAN},
#endif
#ifdef JP
{ "±եɡ",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
#else
		{ "Afardorf the Brigand",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
#endif
#ifdef JP
{ "ߥ饶",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
#else
		{ "Lathaxl the Greedy",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
#endif
#ifdef JP
{ "ե쥦",           30000,  250, 150, 10,  5, RACE_SPRITE},
#else
		{ "Falarewyn",           30000,  250, 150, 10,  5, RACE_SPRITE},
#endif
#ifdef JP
{ "路",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
#else
		{ "Vosur the Wrinkled",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
#endif
#ifdef JP
{ "ϥ󥵥ʥ饪",          20000,  250, 150, 10,  5, RACE_AMBERITE},
#else
		{ "Araord the Handsome",          20000,  250, 150, 10,  5, RACE_AMBERITE},
#endif
#ifdef JP
{ "餱ɥե",          30000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Theradfrid the Loser",          30000,  250, 150, 10,  5, RACE_HUMAN},
#endif
#ifdef JP
{ "­Υ롼",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#else
		{ "One-Legged Eroolo",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#endif
	},
	{
		/* Home */
#ifdef JP
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
#else
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
#endif

	},

	{
		/* Bookstore - 21 unique names */
#ifdef JP
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
#endif

#ifdef JP
{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "ȻΥ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#else
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#endif
#ifdef JP
{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
#else
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
#endif
#ifdef JP
{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif
#ifdef JP
{ "", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Shallowgrave", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ǥޥ", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
#else
		{ "Death Mask", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ؼԤΥ", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
#else
		{ "Asuunu the Learned", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
#endif
#ifdef JP
{ "ͤΥץ", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
#else
		{ "Prirand the Dead", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ŴΥʡ", 25000, 120, 110, 7, 19, RACE_GOLEM},
#else
		{ "Ronar the Iron", 25000, 120, 110, 7, 19, RACE_GOLEM},
#endif
#ifdef JP
{ "=ߥ", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Galil-Gamir", 30000, 140, 105, 6, 12, RACE_ELF},
#endif
#ifdef JP
{ "ܿХ", 15000, 175, 108, 4, 12, RACE_KOBOLD},
#else
		{ "Rorbag Book-Eater", 15000, 175, 108, 4, 12, RACE_KOBOLD},
#endif
#ifdef JP
{ "ꥢꥭ", 20000, 120, 105, 6, 16, RACE_KLACKON},
#else
		{ "Kiriarikirk", 20000, 120, 105, 6, 16, RACE_KLACKON},
#endif
#ifdef JP
{ "Ťʤ", 25000, 120, 110, 7, 19, RACE_DWARF},
#else
		{ "Rilin the Quiet", 25000, 120, 110, 7, 19, RACE_DWARF},
#endif
#ifdef JP
{ "ԥ", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
#else
		{ "Isung the Lord", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
#else
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
#endif
#ifdef JP
{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
#endif
#ifdef JP
{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "Ȼ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif
#ifdef JP
{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif
#ifdef JP
{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif
#ifdef JP
{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#else
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#endif
#ifdef JP
{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
#else
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
#endif
#ifdef JP
{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif
	},

	{
		/* Museum */
#ifdef JP
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
#else
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
#endif

	},

};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,/*10*/
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,/*20*/
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,/*30*/
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,/*40*/
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,/*50*/
	5000000L
};


s32b player_exp_a[PY_MAX_LEVEL] =
{
	20,
	50,
	100,
	170,
	280,
	430,
	650,
	950,
	1400,/*10*/
	1850,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10400,
	12500,/*20*/
	17500,
	25000,
	35000,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,/*30*/
	450000L,
	550000L,
	650000L,
	800000L,
	950000L,
	1100000L,
	1250000L,
	1400000L,
	1550000L,
	1700000L,/*40*/
	1900000L,
	2100000L,
	2300000L,
	2550000L,
	2800000L,
	3050000L,
	3300000L,
	3700000L,
	4100000L,
	4500000L,/*50*/
	5000000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"",
#endif
		"Female",
		"Queen"
	},
	{
#ifdef JP
		"",
		"",
#endif
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      hitdie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices
 */
player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
#endif
		"Human",

		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0x7FFFFFF,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Elf",

		{ -1,  1,  1,  1, -1,  1 },
		2,  3,  2,  1, 6,  11, -1,  5,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0x677E7FF,
	},
	{
#ifdef JP
		"",
#endif
		"Elf",

		{ -1,  2,  0,  1, -2,  2 },
		5,  6,  4,  2, 8,  12, -5, 15,
		8,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0x677E75B,

	},
	{
#ifdef JP
		"ۥӥå",
#endif
		"Hobbit",

		{ -2,  1,  1,  3,  2,  1 },
		15, 12, 10, 5, 12,  15, -10, 20,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x76FFC0B,
	},
	{
#ifdef JP
		"Ρ",
#endif
		"Gnome",

		{ -1,  2,  0,  2,  1, -1 },
		10, 8, 7,  3, 6,  13, -8, 12,
		8,  120,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x767D60F,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Dwarf",

		{  2, -2,  2, -2,  2, -1 },
		2,  7,  6,  -1,  7,  10, 15,  0,
		11,  125,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x1890005,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Orc",

		{  2, -1,  0,  0,  1, -2 },
		-3, -3, -2,  -1,  0, 7, 12, -5,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x5D8818D,
	},
	{
#ifdef JP
		"ϡեȥ",
#endif
		"Half-Troll",

		{ 4, -4, -1, -3,  3, -3 },
		-5, -8, -5, -2,  -1, 5, 20, -10,
		12,  125,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x0880005,
	},
	{
#ifdef JP
		"Х饤",
#endif
		"Amberite",

		{  1,  2,  2,  2,  3,  2 },
		4,  5,  3,  2, 3, 13, 15, 10,
		10,  225,
		50, 50,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x7FFF7FF,
	},
	{
#ifdef JP
		"ϥ",
#endif
		"High-Elf",

		{  1,  3,  -1,  3,  1,  3 },
		4,  13, 12,  4,  3, 14, 10, 25,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x777E75B,
	},
	{
#ifdef JP
		"ڿ",
#endif
		"Barbarian",

		{ 3, -2,  -1,  1,  2, 0 },
		-2, -10, 2,  -1,  1, 7, 12, 10,
		11, 120,
		14, 8,
		82, 5, 200, 20,
		78,  6, 190, 15,
		0,
		0x5C0A09D,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Ogre",

		{ 3, -2, 0, -1, 3, -2 },
		-3, -5, -3, -2, -1, 5, 20, 0,
		12,  145,
		40, 10,
		92, 10, 255, 60,
		80,  8, 235, 60,
		3,
		0x0A80407,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Giant",

		{ 4, -2, -2, -2, 3, -2 },
		-6, -8, -3, -2, -1, 5, 25, 5,
		13, 160,
		40, 10,
		100,10, 255, 65,
		80, 10, 240, 64,
		3,
		0x0880011,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Titan",

		{ 5, 1, 2, -2, 3, 1 },
		-5, 5, 1, -2, 1, 8, 25, 0,
		14, 255,
		100,30,
		111, 11, 255, 86,
		99, 11, 250, 86,
		0,
		0x23D4727,
	},
	{
#ifdef JP
		"ץ",
#endif
		"Cyclops",

		{ 4, -3, -2, -3, 4, -3 },
		-4, -5, -3, -2, -2, 5, 20, 12,
		13, 150,
		50, 24,
		92, 10, 255, 60,
		80,  8, 235, 60,
		1,
		0x0888005,
	},
	{
#ifdef JP
		"",
#endif
		"Yeek",

		{ -2, 1, 1, 1, -2, -4 },
		2, 4, 6, 3, 5, 15, -5, -5,
		7, 100,
		14, 3,
		50,  3, 90,  6,
		50,  3, 75,  3,
		2,
		0x667360F,
	},
	{
#ifdef JP
		"å",
#endif
		"Klackon",

		{ 2, -1, -1, 1, 2, -1 },
		10, 5, 3, 0, -1, 10, 5, 5,
		12, 190,
		20, 3,
		60,  3, 80,  4,
		54,  3, 70,  4,
		2,
		0x04D8011,
	},
	{
#ifdef JP
		"ܥ",
#endif
		"Kobold",

		{ 1, -1, 0, 1, 0, -2 },
		-2, -3, -1, -1, 1, 8, 10, -8,
		9, 125,
		11,  3,
		60,  1, 130,  5,
		55,  1, 100,  5,
		3,
		0x444A009,
	},
	{
#ifdef JP
		"ˡ٥",
#endif
		"Nibelung",

		{ 1, -1, 2, 0, 2, -2 },
		3, 5, 6, 1, 5, 10, 9, 0,
		11, 170,
		40, 12,
		43,  3, 92,  6,
		40,  3, 78,  3,
		5,
		0x569040F,
	},
	{
#ifdef JP
		"",
#endif
		"Dark-Elf",

		{ -1, 3, 2, 2, -2, 1 },
		5, 10, 12, 3, 8, 12, -5, 10,
		9, 150,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		5,
		0x677C7DF,
	},
	{
#ifdef JP
		"ɥ饳˥",
#endif
		"Draconian",

		{ 2, 1, 1, 1, 2, -1 },
		-2, 5, 2, 0, 1, 10, 5, 5,
		11, 220,
		75, 33,
		76,  1, 160,  5,
		72,  1, 130,  5,
		2,
		0x7FFE757,
	},
	{
#ifdef JP
		"ޥɥե쥢",
#endif
		"Mindflayer",

		{ -3, 4, 4, 0, -2, -3 },
		10, 15, 9, 2, 5, 12, -10, -5,
		9, 140,
		100, 25,
		68,  6, 142, 15,
		63,  6, 112, 10,
		4,
		0x2334746,
	},
	{
#ifdef JP
		"",
#endif
		"Imp",

		{ 0, -1, -1, 1, 2, -1 },
		-3, 2, -1, 1, -1, 10, 5, -5,
		10, 115,
		13,  4,
		68,  1, 150,  5,
		64,  1, 120,  5,
		3,
		0x6B537CB,
	},
	{
#ifdef JP
		"",
#endif
		"Golem",

		{ 4, -5, -5, -2, 4, -2 },
		-5, -5, 6, -1, -1, 8, 20, 0,
		12, 200,
		1, 100,
		66,  1, 200,  6,
		62,  1, 180,  6,
		4,
		0x0800001,
	},
	{
#ifdef JP
		"",
#endif
		"Skeleton",

		{ 0, 1, -2, 0, 1, -2 },
		-5, 0, 3, -1, -1, 8, 10, 0,
		10, 145,
		100, 35,
		72,  6, 50, 5,
		66,  4, 50, 5,
		2,
		0x234070F,
	},
	{
#ifdef JP
		"",
#endif
		"Zombie",

		{ 2, -6, -6, 1, 4, -3 },
		-5, -5, 5, -1, -1, 5, 15, 0,
		13, 150,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		2,
		0x0800001,
	},
	{
#ifdef JP
		"۷쵴",
#endif
		"Vampire",

		{ 3, 3, -1, -1, 1, 2 },
		4, 8, 6, 4, 1, 8, 5, 0,
		11, 200,
		100, 30,
		72,  6, 180, 25,
		66,  4, 150, 20,
		5,
		0x67DC7FF,
	},
	{
#ifdef JP
		"ͩ",
#endif
		"Spectre",

		{ -5, 4, -1, 2, 0, -3 },
		10, 15, 12, 5, 5, 14, -15, -5,
		7, 210,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		5,
		0x631474A,
	},
	{
#ifdef JP
		"",
#endif
		"Sprite",

		{ -4, 3, 3, 3, -2, 2 },
		10, 8, 6, 4, 10, 10, -12, 0,
		7, 145,
		50, 25,
		32,  2, 75,  2,
		29,  2, 65,  2,
		4,
		0x623F65E,
	},
	{
#ifdef JP
		"ÿ",  
#endif
		"Beastman",

		{ 2, -2, -1, -1, 2, -2 },
		-5, -2, -1, -1, -1, 5, 12, 5,
		11, 140,
		14, 6,
		65,  6, 150, 20,
		61,  6, 120, 15,
		0,
		0x57887CF,
	},
	{
#ifdef JP
		"",
#endif
		"Ent",
		{ 2,  0,  2, -3,  2,  0 },
		 -5,  2,  5,  -1, 0, 9,  15, -5,
		 12, 140,
		120,  60,
		111, 11, 255, 50,
		99, 11, 250, 45,
		  0,
		0x0010005,
	},
	{
#ifdef JP
		"륳",
#endif
		"Archon",

		{  2,  0,  4,  1,  2,  3 },
		0,  12,  8,  2, 2, 11, 10, 10,
		11,  235,
		150, 150,
		82, 5, 190, 20,
		78,  6, 180, 15,
		3,
		0x779F777,
	},
	{
#ifdef JP
		"Х",
		"Balrog",
#else
		"Balrog",
#endif

		{  4,  2,  -10,  2,  3,  -5 },
		-3,  12, 15,  -2,  1, 8, 20, 0,
		12,  250,
		255, 255,
		100,10, 255, 65,
		80, 10, 240, 64,
		5,
		0x7EDC4DB,
	},
	{
#ifdef JP
		"ɥʥ",
#endif
		"Dunadan",

		{  1,  2,  2,  2,  3,  2 },
		4,  5,  3,  2, 3, 13, 15, 10,
		10,  180,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x7FFF7FF,
	},
	{
#ifdef JP
		"ƥե꡼",
#endif
		"Shadow-Fairy",
		{-2,  2,  2,  1, -1,  0 },
		  7,  8,  0,  6, 12, 15, -10, -5,
		  7, 120,
		200, 100,
		 80,  8, 90, 20,
		 73,  8, 80, 15,
		  4,
		0x633C7DF,
	},
	{
#ifdef JP
		"",
#endif
		"Kutar",

		{  0,  -1,  -1,  1,  2,  3 },
		-2,  5,  5,  5,  -2,  6,  0,  -5,
		11,  140,
		14,  6,
		48,  6, 150, 25,
		44,  4, 130, 20,
		0,
		0x418B7AD,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Android",

		{ 4, -5, -5, 0, 4, -2 },
		0, -5, 0, -2, 3, 14, 20, 10,
		13, 200,
		1, 100,
		72, 12, 240, 64,
		66, 12, 220, 64,
		0,
		0x0800001,
	},
};


/*
 * Player Classes
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *      HD, Exp, pet_upkeep_div
 */
player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"",
#endif
		"Warrior",

		{ 4, -2, -2, 2, 2, -1},
		25, 18, 31, 1,  14, 2, 70, 55,
		12, 7,  10, 0,  0,  0,  30, 30,
		9,  0, 40
	},

	{
#ifdef JP
		"ᥤ",
#endif
		"Mage",

		{-4, 3, 0, 1, -2, 1},
		30, 40, 38, 3,  16, 20, 34, 20,
		7,  15, 11,  0,  0,  0,  6, 7,
		0, 30, 30
	},

	{
#ifdef JP
		"ץ꡼",
#endif
		"Priest",

		{-1, -3, 3, -1, 0, 2},
		25, 35, 40, 2,  16, 8, 48, 35,
		7,  11, 12, 0,  0,  0, 13, 11,
		2, 20, 35
	},

	{
#ifdef JP
		"±",
#endif
		"Rogue",

		{ 2, 1, -2, 3, 1, -1},
		45, 37, 36, 5, 32, 24, 60, 66,
		15, 12, 10, 0,  0,  0, 21, 18,
		6, 25, 40
	},

	{
#ifdef JP
		"󥸥㡼",
#endif
		"Ranger",

		{ 2, 2, 0, 1, 1, 1},
		30, 37, 36, 3,  24, 16, 56, 72,
		8,  11, 10, 0,  0,  0,  18, 28,
		4, 40, 35
	},

	{
#ifdef JP
		"ѥǥ",
#endif
		"Paladin",

		{ 3, -3, 1, 0, 2, 2},
		20, 24, 34, 1,  12, 2, 68, 40,
		7,  10, 11, 0,  0,  0,  21, 18,
		6, 35, 40
	},

	{
#ifdef JP
		"ˡ",
#endif
		"Warrior-Mage",

		{ 2, 2, 0, 1, 0, 1},
		30, 35, 36, 2,  18, 16, 50, 25,
		7,  10, 10, 0,  0,  0,  15, 11,
		4, 40, 35
	},

	{
#ifdef JP
		"٤",
#endif
		"Chaos-Warrior",

		{ 2, 1, -1, 0, 2, -2},
		20, 25, 34, 1,  14, 12, 65, 40,
		7,  11, 10, 0,  0,  0,  20, 17,
		6, 25, 40
	},

	{
#ifdef JP
		"",
#endif
		"Monk",

		{ 2, -1, 1, 3, 2, 1},
		45, 34, 36, 5, 32, 24, 64, 60,
		15, 11, 10, 0,  0,  0, 18, 18,
		6, 30, 35
	},

	{
#ifdef JP
		"Ķǽϼ",
#endif
		"Mindcrafter",

		{-1, 0, 3, -1, -1, 2},   /* note: spell stat is Wis */
		30, 33, 38, 3,  22, 16, 50, 40,
		10, 11, 10, 0,   0,  0, 14, 18,
		2, 25, 35
	},

	{
#ifdef JP
		"ϥ=ᥤ",
#endif
		"High-Mage",

		{-4, 4, 0, 0, -2, 1},
		30, 40, 38, 3,  16, 20, 34, 20,
		7,  15, 11,  0,  0,  0,  6, 7,
		0, 30, 25
	},

	{
#ifdef JP
		"Ѹ",
#endif
		"Tourist",
		{ -1, -1, -1, -1, -1, -1},
		15, 18, 28, 1, 12, 2, 40, 20,
		5, 7, 9, 0,  0,  0,  11, 11,
		0, -30, 40
	},

	{
#ifdef JP
		"Τޤͻ",
#endif
		"Imitator",
		{ 0, 1, -1, 2, 0, 1},
		25, 30, 36, 2,  18, 16, 60, 50,
		7,  10,  10, 0,  0,  0,  18, 20,
		5, 10, 20
	},

	{
#ifdef JP
		"ûȤ",
#endif
		"BeastMaster",
		{ 1, -1, -1, 1, 0, 2},
		20, 25, 32, 2,  18, 16, 52, 63,
		7,  10, 10, 0,  0,  0,  14, 25,
		3, 20, 10
	},

	{
#ifdef JP
		"ڥޥ",
#endif
		"Sorcerer",

		{-5, 6, -2, 2, 0, -2},
		30, 48, 75, 2,  12, 22,  0, 0,
		 7, 18, 13, 0,  0,  0,  0, 0,
		4, 60, 25
	},

	{
#ifdef JP
		"㡼",
#endif
		"Archer",

		{ 2, -1, -1, 2, 1, 0},
		38, 24, 35, 4,  24, 16, 56, 82,
		12, 10, 10, 0,  0,  0,  18, 36,
		6, 10, 40
	},

	{
#ifdef JP
		"ƻѻ",
#endif
		"Magic-Eater",

		{-1, 2, 1, 2, -2, 1},
		25, 42, 36, 2,  20, 16, 48, 35,
		7,  16, 10,  0,  0,  0, 13, 11,
		3, 30, 30
	},

	{
#ifdef JP
		"ͷ",
#endif
		"Bard",              /* Note : spell stat is Charisma */
		{-2, 1, 2, -1, -2, 4},
		20, 33, 34, -5, 16, 20, 34, 20,
		8,  13, 11, 0,  0,  0,  10, 8,
		2, 40, 25
	},

	{
#ifdef JP
		"ƻ",
#endif
		"Red-Mage",

		{ 2, 2, -1, 1, 0, -1},
		20, 34, 34, 1,  16, 10, 56, 25,
		7,  11, 11, 0,  0,  0,  18, 11,
		4, 40, 40
	},

	{
#ifdef JP
		"Ѳ",
#endif
		"Samurai",

		{ 3, -2, 1, 2, 1, 0},
		25, 18, 32, 2,  16, 6, 70, 40,
		12, 7,  10, 0,  0,  0,  23, 18,
		6,  30, 40
	},

	{
#ifdef JP
		"ѻ",
#endif
		"ForceTrainer",

		{ 0, -1, 3, 2, 1, 1},
		30, 34, 38, 4, 32, 24, 50, 40,
		10, 11, 11, 0,  0,  0, 14, 15,
		2, 35, 40
	},

	{
#ifdef JP
		"ƻ",
#endif
		"Blue-Mage",

		{-4, 4, -1, 1, -2, -1},
		30, 40, 36, 3,  20, 16, 40, 25,
		7,  16, 11,  0,  0,  0,  6, 7,
		2, 30, 35
	},

	{
#ifdef JP
		"ʼ",
#endif
		"Cavalry",
		{ 2, -2, -2, 2, 2, 0},
		20, 18, 32, 1,  16, 10, 60, 66,
		10,  7, 10, 0,  0,  0,  22, 26,
		5, 20, 35
	},

	{
#ifdef JP
		"",
#endif
		"Berserker",

		{ 8, -20, -20, 4, 4, -5},
		-100, -1000, -200, -100,  -100, -100, 120, -2000,
		0, 0,  0, 0,  0,  0,  50, 0,
		11,  60, 255
	},

	{
#ifdef JP
		"",
#endif
		"Weaponsmith",

		{ 3, -1, -1, 1, 0, -1},
		30, 28, 28, 1,  20, 10, 60, 45,
		10, 10,  10, 0,  0,  0,  21, 15,
		6,  30, 40
	},
	{
#ifdef JP
		"Ȥ",
#endif
		"Mirror-Master",

		{ -2,  3, 1, -1, -2, 1},
		30, 33, 40, 3, 14, 16, 34,30,
		10, 11, 12, 0,  0,  0,  6,10,
		2,  30, 30
	},
	{
#ifdef JP
		"Ǧ",
#endif
		"Ninja",

		{ 0,  -1, -1, 3, 2, -1},
		45, 24, 36, 8, 48, 32, 70,66,
		15, 10, 10, 0,  0,  0, 25,18,
		2,  20, 40
	},
};

player_seikaku seikaku_info[MAX_SEIKAKU] =
{
	{
#ifdef JP
		"դĤ",
#endif
		"Ordinary",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  0,  0,  0,
		0, 1, 0
	},

	{
#ifdef JP
		"餸ޤ",
#endif
		"Mighty",
		{  2,  -2,  -1,  0,  1,  0 },
		-5,  -5,  -3,  -1,  -2,  -2,  10,  0,
		1, 1, 0
	},

	{
#ifdef JP
		"",
#endif
		"Shrewd",
		{  -2,  2,  0,  1,  -1,  -1 },
		3,  8,  2,  0,  -2,  5,  -8,  -5,
		-1, 1, 0
	},

	{
#ifdef JP
		"碌",
#endif
		"Pious",
		{  0,  -1,  2,  -1,  0,  1 },
		-5,  2,  4,  -1,  3,  -2,  -3,  -6,
		0, 1, 0
	},

	{
#ifdef JP
		"Фä",
#endif
		"Nimble",
		{  -1,  1,  -1,  2,  -1,  -1 },
		7,  2,  -1,  1,  5,  5,  0,  10,
		0, 0, 0
	},

	{
#ifdef JP
		"Τ餺",
#endif
		"Fearless",
		{  2,  1,  1,  -1,  -1,  0 },
		-5,  5,  -2,  0,  2,  -2,  10,  10,
		-1, 1, 0
	},

	{
#ifdef JP
		"Хå",
#endif
		"Combat",
		{  1,  -1,  -2,  2,  0,  1 },
		-2,  -3,  -3,  0,  -1,  2,  5,  5,
		0, 0, 0
	},

	{
#ifdef JP
		"ʤޤ",
#endif
		"Lazy",
		{  -2,  -2,  -2,  -2,  -2,  -2 },
		-5,  -5,  -3,  -1,  -4,  -2,  -8,  -8,
		-1, 1, 0
	},

	{
#ifdef JP
		"",
#endif
		"Sexy",
		{  1,  1,  1,  1,  1,  3 },
		10,  5,  3,  0,  4,  2,  10,  10,
		0, 1, 1
	},

	{
#ifdef JP
		"åޥ",
#endif
		"Lucky",
		{  -2,  -2,  -2,  -2,  -2,  2 },
		10,  7,  3,  2, 10,  8,  15,  15,
		0, 1, 2
	},

	{
#ifdef JP
		"ޤŤ褤",
#endif
		"Patient",
		{  -1,  -1,  1,  -2,  2,  0 },
		-5,  -3,  3,  1,  0,  -3,  -6,  -6,
		1, 0, 0
	},

	{
#ifdef JP
		"",
#endif
		"Munchkin",
		{ 10,  10,  10,  10,  10,  10 },
		 20, 40, 30, 10, 40, 40,  80, 80,
		 15, 1, 0
	},
};



player_race mimic_info[] =
{
	{
#ifdef JP
		"[ɸ]",
#endif
		"Default",

		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		0,
		0x000000,
	},
	{
#ifdef JP
		"[]",
#endif
		"[Demon]",

		{  5,  3,  2,  3,  4,  -6 },
		-5,  18, 20, -2,  3,  10, 40, 20,
		12,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		5,
		0x000003,
	},
	{
#ifdef JP
		"[Ⲧ]",
#endif
		"[Demon lord]",

		{  20,  20,  20,  20,  20,  20 },
		20,  20, 25, -2,  3,  10, 70, 40,
		14,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		20,
		0x000003,
	},
	{
#ifdef JP
		"[۷쵴]",
#endif
		"[Vampire]",

		{ 4, 4, 1, 1, 2, 3 },
		6, 12, 8, 6, 2, 12, 30, 20,
		11,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		5,
		0x000005,
	},
};



magic_type technic_info[NUM_TECHNIC][32] =
{
	{
		/* Music */
		{ 1,  1,  10,   2},
		{ 2,  1,  10,   2},
		{ 3,  2,  20,   3},
		{ 4,  2,  20,   4},
		{ 5,  2,  20,   6},
		{ 7,  4,  30,   8},
		{ 9,  3,  30,   10},
		{ 10, 2,  30,   12},

		{ 12,  3,   40,   20},
		{ 15, 16,  42,   35},
		{ 17, 18,  40,   25},
		{ 18,  2,  45,   30},
		{ 23,  8,  50,   38},
		{ 28, 30,  50,   41},
		{ 33, 35,  60,   42},
		{ 38, 35,  70,   46},

		{ 10,  4,  20,   13},
		{ 22,  5,  30,   26},
		{ 23,  3,  35,   27},
		{ 26,  28,  37,   29},
		{ 32,  37,  41,   36},
		{ 33,  22,  43,   40},
		{ 37,  35,  46,   42},
		{ 45,  60,  50,   56},

		{ 23,  18,  20,   23},
		{ 30,  30,  30,   26},
		{ 33,  65,  41,   30},
		{ 37,  35,  43,   35},
		{ 40,  30,  46,   50},
		{ 42,  75,  50,   68},
		{ 45,  58,  62,   73},
		{ 49,  48,  70,  200}
	},

	{
		/* Hissatsu */
		{ 1,   15,   0,   0},
		{ 3,   10,   0,   0},
		{ 6,   15,   0,   0},
		{ 9,    8,   0,   0},
		{ 10,  12,   0,   0},
		{ 12,  25,   0,   0},
		{ 14,   7,   0,   0},
		{ 17,  20,   0,   0},

		{ 19,  10,   0,   0},
		{ 22,  20,   0,   0},
		{ 24,  30,   0,   0},
		{ 25,  10,   0,   0},
		{ 27,  15,   0,   0},
		{ 29,  45,   0,   0},
		{ 32,  70,   0,   0},
		{ 35,  50,   0,   0},

		{ 18,  40,   0,   0},
		{ 22,  22,   0,   0},
		{ 24,  30,   0,   0},
		{ 26,  35,   0,   0},
		{ 30,  30,   0,   0},
		{ 32,  60,   0,   0},
		{ 36,  40,   0,   0},
		{ 39,  80,   0,   0},

		{ 26,  20,   0,   0},
		{ 29,  40,   0,   0},
		{ 31,  35,   0,   0},
		{ 36,  80,   0,   0},
		{ 39, 100,   0,   0},
		{ 42, 110,   0,   0},
		{ 45, 130,   0,   0},
		{ 50, 255,   0,   0}
	},
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[4]=
{
	0x000000ff,
	0x0000ff00,
	0x00ff0000,
	0xff000000
};


s32b realm_choices1[MAX_CLASS] =
{
	(CH_NONE),				/* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Mage */
	(CH_LIFE | CH_DEATH | CH_DAEMON |
	 CH_CRUSADE),                              /* Priest */
	(CH_SORCERY | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT),               /* Rogue */
	(CH_NATURE),                            /* Ranger */
	(CH_CRUSADE | CH_DEATH),                   /* Paladin */
	(CH_ARCANE),                            /* Warrior-Mage */
	(CH_CHAOS | CH_DAEMON),                 /* Chaos-Warrior */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT),                           /* Monk */
	(CH_NONE),                              /* Mindcrafter */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* High-Mage */
	(CH_ARCANE),                            /* Tourist */
	(CH_NONE),                              /* Imitation */
	(CH_TRUMP),                             /* Beastmaster */
	(CH_NONE),                              /* Sorcerer */
	(CH_NONE),                              /* Archer */
	(CH_NONE),                              /* Magic eater */
	(CH_MUSIC),                             /* Harper */
	(CH_NONE),                              /* Red Mage */
	(CH_HISSATSU),                          /* Samurai */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT | CH_CRUSADE),                 /* ForceTrainer */
	(CH_NONE),                              /* Blue Mage */
	(CH_NONE),				/* Kihei */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Kaji */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
};


s32b realm_choices2[MAX_CLASS] =
{
	(CH_NONE),                              /* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Mage */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Priest */
	(CH_NONE),                              /* Rogue */
	(CH_SORCERY | CH_CHAOS | CH_DEATH |
	 CH_TRUMP | CH_ARCANE | CH_DAEMON),     /* Ranger */
	(CH_NONE),                              /* Paladin */
	(CH_LIFE | CH_NATURE | CH_CHAOS |
	 CH_DEATH | CH_TRUMP | CH_ARCANE |
	 CH_SORCERY | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Warrior-Mage */
	(CH_NONE),                              /* Chaos-Warrior */
	(CH_NONE),                              /* Monk */
	(CH_NONE),                              /* Mindcrafter */
	(CH_NONE),                              /* High-Mage */
	(CH_NONE),                              /* Tourist */
	(CH_NONE),                              /* Imitation */
	(CH_NONE),                              /* Beastmanster */
	(CH_NONE),                              /* Sorcerer */
	(CH_NONE),                              /* Archer */
	(CH_NONE),                              /* Magic eater */
	(CH_NONE),                              /* Harper */
	(CH_NONE),                              /* Red Mage */
	(CH_NONE),                              /* Samurai */
	(CH_NONE),                              /* ForceTrainer */
	(CH_NONE),                              /* Blue Mage */
	(CH_NONE),				/* Kihei */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Kaji */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
};


#ifdef JP
cptr realm_names[] =
{
	"ˡʤ",
	"̿",
	"",
	"",
	"",
	"Ź",
	"ȥ",
	"",
	"",
	"",
	"˼",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	""
};
#endif

#ifdef JP
cptr E_realm_names[]
#else
cptr realm_names[]
#endif
= {
	"none",
	"Life",
	"Sorcery",
	"Nature",
	"Chaos",
	"Death",
	"Trump",
	"Arcane",
	"Craft",
	"Daemon",
	"Crusade",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"Music",
	"Kendo",
	"unknown"
};

/*
 * Names of the spells (mage spells then priest spells)
 */
#ifdef JP
cptr spell_names[VALID_REALM][32] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
"ڽμ",
"ʡ",
"ڽ",
"ξ",
" & ⴶ",
"Žμ",
"",
"ʢ­",

"",
"Ž",
"̿μ",
"ǮѴ",
"մ",
"ѥ˥åǥå",
"ϲ",
"볦",

		/* Rare Life Spellbooks */
"**",
"ռ",
"ǥå໶",
"ι",
"̿",
"Ԥξ",
"¤κ",
"볦",

"Ӳ",
"",
"ǥåɾ",
"Τ",
"",
"*ϲ*",
"ʤӥ",
"ˤ"
	},

	/*** Sorcery Spells ***/

	{
		/* Common Sorcery Spellbooks */
"󥹥",
"硼ȡƥݡ",
"櫤ⴶ",
"饤ȡꥢ",
"ѥ˥å󥹥",
"ƥݡ",
"꡼ס󥹥",
"ϽŶ",

"ˡϿ",
"",
"󥹥",
"ե꡼",
"ƥݡȡ󥹥",
"ԡ",
"",
"",

		/* Rare Sorcery Spellbooks */
"ʪΤȺ",
"㡼ࡦ󥹥",
"",
"ư",
"ʬ",
"ƥݡȡ٥",
"Ԥμʸ",
"",

"Ĵ",
"ȯΥ롼",
"ǰư",
"Τ",
"̥λλ",
"ϣ",
"ʪ",
"̵ε"

	},

	/*** Nature Spells ***/

	{
		/* Common Nature Spellbooks */
"󥹥",
"",
"櫤ⴶ",
"",
"θ",
"ưʪ",
"Ķؤ",
"Ǽ",

"ϲ",
"ܥ",
"γ",
"եܥ",
"۸",
"­",
"ưʪ",
"",

		/* Rare Nature Spellbooks */
"",
"ȩв",
"",
"¤",
"ưʪͧ",
"",
"Ф",
"忩ɻ",

"Ͽ",
"ޥ",
"֥ꥶ",
"",
"Ĭ",
"۸",
"ο",
"ζ"

	},

	/*** Chaos Spells ***/

	{
		/* Common Chaos Spellbooks */
"ޥåߥ",
"ȥå/ɥ˲",
"",
"μ",
"",
"եܥ",
"Ϥη",
"ƥݡ",

"",
"ܥ",
"˥å֡",
"Ǥ",
"եܡ",
"ƥݡȡ",
"˲θ",
"륹ȯư",

		/* Rare Chaos Spellbooks */
"¾",
"Ϣ",
"",
"ʬ",
"",
"ޥåå",
"٤ο",
"⾤",

"ϸ",
"ή",
"ΰ",
"پ",
"",
"Ϥ",
"륹Υ֥쥹",
"̵"

	},

	/*** Death Spells ***/

	{
		/* Common Death Spellbooks */
"̵̿",
"",
"ٰ",
"",
"̲",
"",
"",
"ǥåɽ°",

"ȥԡε",
"Ϲ",
"٤",
"󥹥",
"Ǥο",
"۷ɥ쥤",
"ȿν",
"",

		/* Rare Death Spellbooks */
"β",
"",
"Ź",
"",
"۷ο",
"۷",
"θ",
"Ź",

"θ",
"Ծ",
"Ԥ",
"۷쵴Ѳ",
"̿",
"",
"Ϲι",
"ͩβ"

	},

	/*** Trump Spells ***/

	{
		/* Common Trump Spellbooks */
"硼ȡƥݡ",
"Υ",
"åե",
"եꥻå",
"ƥݡ",
"ΤΥ",
"ƥݡȡ󥹥",
"ưʪΥ",

"ưΥ",
"ߥΥ",
"",
"ԡɡ󥹥",
"ƥݡȡ٥",
"",
"Ԥμʸ",
"ʪ",

		/* Rare Trump Spellbooks */
"ָ򴹤Υ",
"ǥåɤΥ",
"Υ",
"󥹥Υ",
"ϥɤΥ",
"ȥפο",
"ʹ֥ȥ",
"СǡΥ",

"ͽΥ",
"μΥ",
"󥹥",
"ɥ饴Υ",
"ФΥ",
"ǡΥ",
"ϹΥ",
"ɥ饴Υ"

	},

	/*** Arcane Spells (_only_ common spells) ***/

	{
"ŷ",
"ˡλܾ",
"Ʃδ",
"󥹥",
"硼ȡƥݡ",
"饤ȡꥢ",
"櫤 ˲",
"ڽμ",

"櫤 ",
"ǳ",
"",
"ˡ ",
"ƥശ",
"",
"",
"Ѳ",

"",
"ѻ",
"Žμ",
"ƥݡ",
"",
"ϲ",
"",
"ʢ­",

"Ʃǧ",
"󥿥뾤",
"ƥݡȡ٥",
"ƥݡȡ󥹥",
"Ǥε",
"",
"Ԥμʸ",
"Τ",

	},

	/*** Craft Spells ***/

	{
		/* Common Craft Spellbooks */
"ֳ",
"϶",
"ʢ­",
"䵤",
"Ѳб",
"ε",
"ŷ",
"ѻ",

"Ʃǧ",
"",
"",
"β",
"ʬ",
"мٰ볦",
"",
"ˡ",

		/* Rare Craft Spellbooks */
"ƥѥ",
"ȩв",
"",
"ԡ",
"ȴ",
"᤭",
"¤",
"ˡγ",

"̵ϲ",
"ʴ",
"ʤμ",
"ﶯ",
"ɶ񶯲",
"°Ϳ",
"ʹ֥ȥ",
"°ؤȱ",

	},

	/*** Daemon Spells ***/

	{
		/* Common Daemon Spellbooks */
"ޥåߥ",
"̵̿",
"٤ʤʡ",
"Ѳб",
"",
"Ϲ",
"λ",
"Ϲα",

"ǡ",
"ӥ",
"Ϲ",
"ץ饺ޡܥ",
"եܡ",
"ο",
"Ϲ",
"ǡ󾤴",

		/* Rare Daemon Spellbooks */
"",
"Υ",
"ϴή",
"ץ饺޵",
"Ѳ",
"Ϲư",
"Хʭ",
"Ǥμ",

"ε",
"Ǥ",
"αߴ",
"ڥå",
"졼ǡ󾤴",
"Ϲ",
"μ",
"ⲦѲ",

	},

	/*** Crusade Spells ***/

	{
		/* Common Crusade Spellbooks */
"Ĩȳ",
"ٰ¸ߴ",
"ݽ",
"Ұ",
"",
"",
"",
"ξ",

"ٰФ",
"ʤ",
"ʧ",
"",
"Ʃǧ",
"мٰ볦",
"ۤ",
"ʤ",

		/* Rare Crusade Spellbooks */
"줿ƻ",
"",
"ʤ륪",
"ǥå&໶",
"ٰ໶",
"ʤ",
"С",
"ŷȾ",

"ε",
"໶",
"ٰ",
"ϥޥɥ",
"ܤˤܤ",
"ܤ",
"",
"",

	},

	/*** Music Spells ***/

	/* 
	   Song : , Note : , Pattern : Χ, 
	   Ballad : (ضʢֱפ?), Chant : , */
	{
		/******* Apprentice Handbook *******/
		"ߤβ",	/*"Song of Holding"*/
		"ʡβ",	/*"Song of Blessing"*/
		"β",	/*"Wracking Note"*/
		"ۯ۰Χ",	/*"Stun Pattern"*/
		"̿ή",	/*"Flow of Life"*/
		"ۤβ",	/*"Song of the Sun"*/
		"ݤβ",
		"襤β",	/*"Heroic Ballad"*/

		/******* Minstrel's Music *******/
		"Ūγ",	/*"Clairaudience"*/
		"β",
		"μβ",	/*"Song of Lore"*/
		"ۤβ",
		"ƤΧ",	/*"Illusion Pattern"*/
		"Ǥζ",	/*"Doomcall"*/
		"եꥨβ",	/*"Firiel's Song"*/
		"ι",	/*"Fellowship Chant"*/

		/******* Harps of Rivendell *******/
		"ʬ",
		"",
		"ۥӥåȤΥǥ",
		"Ĥ",
		"໶β",
		"ޥδŸ",
		"β",
		"⤦Ĥ",

		/******* Lays of Beleriand *******/
		"˲Χ",
		"ڤβ",
		"β",
		"ͺλ",
		"ʤν",
		"β",
		"",
		"ե󥴥եĩ",
	},

	/*** Hissatsuwaza ***/

	{
		"ӹ",
		"޷¤",
		"֡",
		"",
		"",
		"ߤǤ",
		"󥿡",
		"ʧȴ",

		"ڥĥ",
		"",
		"",
		"ᾢ",
		"˴",
		"",
		"޽ͤ",
		"¤",

		"Τƿ",
		"޻",
		"",
		"ή",
		"̷",
		"",
		"ͺ",
		"̵л",

		"۷쵴β",
		"",
		"ɴͻ¤",
		"ŷζ",
		"Ťη",
		"",
		"ıǦ",
		"ʢ",
	},
};

#else

cptr spell_names[VALID_REALM][32] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
		"Cure Light Wounds",
		"Bless",
		"Cause Light Wounds",
		"Call Light",
		"Detect Doors & Traps",
		"Cure Medium Wounds",
		"Cure Poison",   
		"Satisfy Hunger",

		"Remove Curse",
		"Cause Medium Wounds",
		"Cure Critical Wounds",
		"Resist Heat and Cold",
		"Sense Surroundings",
		"Turn Undead",
		"Healing",
		"Glyph of Warding",

		/* Rare Life Spellbooks */
		"Dispel Curse",
		"Perception",
		"Dispel Undead",
		"Day of the Dove",
		"Cause Critical Wounds",
		"Word of Recall",
		"Alter Reality",
		"Warding True",

		"Sterilization",
		"Detection",
		"Annihilate Undead",
		"Clairvoyance",
		"Restoration",
		"Healing True",
		"Holy Vision",
		"Ultimate Resistance",
	},

	/*** Sorcery Spells ***/

	{
		/* Common Sorcery Spellbooks */
		"Detect Monsters",
		"Phase Door",
		"Detect Doors and Traps",
		"Light Area",
		"Confuse Monster",
		"Teleport",
		"Sleep Monster",
		"Recharging",

		"Magic Mapping",
		"Identify",
		"Slow Monster",
		"Mass Sleep",
		"Teleport Away",
		"Haste Self",
		"Detection True",
		"Identify True",

		/* Rare Sorcery Spellbooks */
		"Detect items and Treasure",
		"Charm Monster",
		"Sense Minds",
		"Teleport to town",
		"Self Knowledge",
		"Teleport Level",
		"Word of Recall",
		"Dimension Door",

		"Probing",
		"Explosive Rune",
		"Telekinesis",
		"Clairvoyance",
		"Charm monsters",
		"Alchemy",
		"Banishment",
		"Globe of Invulnerability",
	},

	/*** Nature Spells ***/

	{
		/* Common Nature Spellbooks */
		"Detect Creatures",
		"Lightning",
		"Detect Doors and Traps",
		"Produce Food",
		"Daylight",
		"Animal Taming",
		"Resist Environment",
		"Cure Wounds & Poison",

		"Stone to Mud",
		"Frost Bolt",
		"Nature Awareness",
		"Fire Bolt",
		"Ray of Sunlight",
		"Entangle",
		"Summon Animal",
		"Herbal Healing",

		/* Rare Nature Spellbooks */
		"Stair Building",
		"Stone Skin",
		"Resistance True",
		"Forest Creation",
		"Animal Friendship",
		"Stone Tell",
		"Wall of Stone",
		"Protect from Corrosion",

		"Earthquake",
		"Cyclone",
		"Blizzard",
		"Lightning Storm",
		"Whirlpool",
		"Call Sunlight",
		"Elemental Branding",
		"Nature's Wrath",
	},

	/*** Chaos Spells ***/

	{
		/* Common Chaos Spellbooks */
		"Magic Missile",
		"Trap / Door Destruction",
		"Flash of Light",
		"Touch of Confusion",
		"Mana Burst",
		"Fire Bolt",
		"Fist of Force",
		"Teleport Self",

		"Wonder",
		"Chaos Bolt",
		"Sonic Boom",
		"Doom Bolt",
		"Fire Ball",
		"Teleport Other",
		"Word of Destruction",
		"Invoke Logrus",

		/* Rare Chaos Spellbooks */
		"Polymorph Other",
		"Chain Lightning",
		"Arcane Binding",
		"Disintegrate",
		"Alter Reality",
		"Magic Rocket",
		"Chaos Branding",
		"Summon Demon",

		"Beam of Gravity",
		"Meteor Swarm",
		"Flame Strike",
		"Call Chaos",
		"Polymorph Self",
		"Mana Storm",
		"Breathe Logrus",
		"Call the Void",
	},

	/*** Death Spells ***/

	{
		/* Common Death Spellbooks */
		"Detect Unlife",
		"Malediction",
		"Detect Evil",
		"Stinking Cloud",
		"Black Sleep",
		"Resist Poison",
		"Horrify",
		"Enslave Undead",

		"Orb of Entropy",
		"Nether Bolt",
		"Cloud kill",
		"Genocide One",
		"Poison Branding",
		"Vampiric Drain",
		"Animate dead",
		"Genocide",

		/* Rare Death Spellbooks */
		"Berserk",
		"Invoke Spirits",
		"Dark Bolt",
		"Battle Frenzy",
		"Vampiric Branding",
		"Vampirism True",
		"Nether Wave",
		"Darkness Storm",

		"Death Ray",
		"Raise the Dead",
		"Esoteria",
		"Polymorph Vampire",
		"Restore Life",
		"Mass Genocide",
		"Hellfire",
		"Wraithform",
	},

	/*** Trump Spells ***/

	{
		/* Common Trump Spellbooks */
		"Phase Door",
		"Trump Spiders",
		"Shuffle",
		"Reset Recall",
		"Teleport",
		"Trump Spying",
		"Teleport Away",
		"Trump Animals",

		"Trump Reach",
		"Trump Kamikaze",
		"Phantasmal Servant",
		"Haste Monster",
		"Teleport Level",
		"Dimension Door",
		"Word of Recall",
		"Banish",

		/* Rare Trump Spellbooks */
		"Swap Position",
		"Trump Undead",
		"Trump Reptiles",
		"Trump Monsters",
		"Trump Hounds",
		"Trump Branding",
		"Living Trump",
		"Trump Cyberdemon",

		"Trump Divination",
		"Trump Lore",
		"Heal Monster",
		"Trump Dragon",
		"Trump Meteor",
		"Trump Demon",
		"Trump Greater Undead",
		"Trump Ancient Dragon",
	},

	/*** Arcane Spells (_only_ common spells) ***/

	{
		"Zap",
		"Wizard Lock",
		"Detect Invisibility",
		"Detect Monsters",
		"Blink",
		"Light Area",
		"Trap & Door Destruction",
		"Cure Light Wounds",

		"Detect Doors & Traps",
		"Phlogiston",
		"Detect Treasure",
		"Detect Enchantment",
		"Detect Objects",
		"Cure Poison",
		"Resist Cold",
		"Resist Fire",

		"Resist Lightning",
		"Resist Acid",
		"Cure Medium Wounds",
		"Teleport",
		"Identify",
		"Stone to Mud",
		"Ray of Light",
		"Satisfy Hunger",

		"See Invisible",
		"Conjure Elemental",
		"Teleport Level",
		"Teleport Away",
		"Elemental Ball",
		"Detection",
		"Word of Recall",
		"Clairvoyance",
	},

	/*** Craft Spells ***/

	{
		/* Common Craft Spellbooks */
		"Infravision",
		"Regeneration",
		"Satisfy Hunger",
		"Resist Cold",
		"Resist Fire",
		"Heroism",
		"Resist Lightning",
		"Resist Acid",

		"See Invisibility",
		"Remove Curse",
		"Resist Poison",
		"Berserk",
		"Self Knowledge",
		"Protection from Evil",
		"Cure",
		"Mana Branding",

		/* Rare Craft Spellbooks */
		"Telepathy",
		"Stone Skin",
		"Resistance",
		"Haste Self",
		"Walk through Wall",
		"Polish Shield",
		"Create Golem",
		"Magical armor",

		"Remove Enchantment",
		"Remove All Curse",
		"Knowledge True", /* "Total Knowledge", */
		"Enchant Weapon",
		"Enchant Armor",
		"Brand Weapon",
		"Living Trump",
		"Immunity",
	},

	/*** Daemon Spells ***/

	{
		/* Common Daemon Spellbooks */
		"Magic Missile",
		"Detect Unlife",
		"Evil Bless",
		"Resist Fire",
		"Horrify",
		"Nether Bolt",
		"Summon Manes",
		"Hellish Flame",

		"Dominate Demon",
		"Vision",
		"Resist Nether",
		"Plasma bolt",
		"Fire Ball",
		"Fire Branding",
		"Nether Ball",
		"Summon Demon",

		/* Rare Daemon Spellbooks */
		"Devilish Eye",
		"Devil Cloak",
		"The Flow of Lava",
		"Plasma Ball",
		"Polymorph Demon",
		"Nather Wave",
		"Kiss of Succubus",
		"Doom Hand",

		"Raise the Morale",
		"Immortal Body",
		"Insanity Circle",
		"Explode Pets",
		"Summon Greater Demon",
		"Nether Storm",
		"Bloody Curse",
		"Polymorph Demonlord",
	},

	/*** Crusade Spells ***/

	{
		/* Common Crusade Spellbooks */
		"Punishment",
		"Detect Evil",
		"Remove Fear",
		"Scare Monster",
		"Sanctuary",
		"Portal",
		"Star Dust",
		"Purify",

		"Scatter Evil",
		"Holy Orb",
		"Exorcism",
		"Remove Curse",
		"Sense Unseen",
		"Protection from Evil",
		"Judgment Thunder",
		"Holy Word",

		/* Rare Crusade Spellbooks */
		"Unbarring Ways",
		"Arrest",
		"Holy Aura",
		"Dispel Undead & Demons",
		"Dispel Evil",
		"Holy Blade",
		"Star Burst",
		"Summon Angel",

		"Heroism",
		"Dispel Curse",
		"Banish Evil",
		"Armageddon",
		"An Eye for an Eye",
		"Wrath of the God",
		"Divine Intervention",
		"Crusade",
	},

	/*** Music Spells ***/

	{
		/******* Apprentice Handbook *******/
		"Song of Holding",
		"Song of Blessing",
		"Wrecking Note",
		"Stun Pattern",
		"Flow of Life",
		"Song of the Sun",
		"Song of Fear", /* ݤβ */
		"Heroic Ballad",

		/******* Minstrel's Music *******/
		"Clairaudience",
		"Soul Shriek", /* β */
		"Song of Lore",
		"Hiding Tune", /* "ۤβ", */
		"Illusion Pattern",
		"Doomcall",
		"Firiel's Song",
		"Fellowship Chant", /* "ι" */

		/******* Harps of Rivendell *******/
		"Sound of disintegration", /* ʬ */
		"Finrod's Resistance", /*  */
		"Hobbit Melodies", /* ۥӥåȤΥǥ */
		"World Contortion", /* Ĥ */
		"Dispelling chant", /* ໶β */
		"The Voice of Saruman", /* ޥδŸ */
		"Song of the Tempest", /* β */
		"Ambarkanta", /* ⤦Ĥ */

		/******* Lays of Beleriand *******/
		"Wrecking Pattern", /* ˲Χ */
		"Stationary Shriek", /* ڤβ */
		"Endurance", /* β */
		"The Hero's Poem", /* ͺλ */
		"Relief of Yavanna", /* "ʤν" */
		"Goddess' rebirth", /* "β" */
		"Wizardry of Sauron", /* "", */
		"Fingolfin's Challenge", /* "ե󥴥եĩ", */
	},

	/*** Hissatsuwaza ***/
	{
		"Tobi-Izuna",
		"3-Way Attack",
		"Boomerang",
		"Burning Strike",
		"Detect Ferocity",
		"Strike to Stun",
		"Counter",
		"Harainuke",

		"Serpent's Tongue",
		"Zammaken",
		"Wind Blast",
		"Judge",
		"Rock Smash",
		"Midare-Setsugekka",
		"Spot Aiming",
		"Majingiri",

		"Desperate Attack",
		"Lightning Eagle",
		"Rush Attack",
		"Bloody Maelstrom",
		"Earthquake Blow",
		"Crack",
		"War Cry",
		"Musou-Sandan",

		"Vampire's Fang",
		"Moon Dazzling",
		"Hundred Slaughter",
		"Dragonic Flash",
		"Twin Slash",
		"Kofuku-Zettousei",
		"Keiun-Kininken",
		"Harakiri",
	},
};
#endif

/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
int chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_ALARM),
	(CHEST_ALARM),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_SCATTER),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_ALARM),
	(CHEST_SCATTER),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_E_SUMMON),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_BIRD_STORM),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_BIRD_STORM),
	(CHEST_EXPLODE | CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_H_SUMMON),        /* 45 == best small steel */
	0,
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM | CHEST_ALARM),
	(CHEST_H_SUMMON | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_H_SUMMON | CHEST_SCATTER | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL | CHEST_EXPLODE),  /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
#ifdef JP
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},

	/* Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Priest */
	{
		"",                 /* */
		"",             /*żԡΡȼΡ */
		"",
		"",                 /* */
		"ƻ",               /*ʺɾİƻ */
		"һ",               /*޶ */
		"",               /*ʶ綵ʶ */
		"׻",                 /*׻ʡʺ */
		"׻Ĺ",               /*׻ʡ׻Ĺ */
		"",
	},

	/* Rogues */
	{
		/* "Ĥ",*/                     /*Ĥ˷ϲ */
		"",
		"ɤϤ",                     /*ɤť */
		"",                         /*ť */
		"ť",                       /*ťť */
		"ڥƥ",                     /*̡ڥƥա */
		"",
		"ϥ",
		"ޥ",
		"",						/* Ż */
		"ɥޥ",
	},

	/* Rangers */
	{
		"Ȥ",
		"",
		"͸",                         /*͸ĥꡢ廡ʼ */
		"",
		"׼",
		"Ƴ",
		"õ",                       /*ԡõ */
		"",
		"Ƭ",
		"",
	},

	/* Paladins */
	{
		"ͦ",                 /*ˡ͡ԡͦʿ */
		"һ",
		"ݸ",
		"ɱҼ",
		"Ҽ",
		"",
		"ŵ",
		"",
		"",
		"Ĺ",
	},

	/* Warrior-Mage */
	{
		"",
		"",			/*ա */
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"Ѥαͺ", /* Mage-Hero */
		"˼",
		/* "", */
		"Ʈѻ",
		"ɥ",
	},

	/* Chaos Warrior */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"٤αͺ",
		"٤˼",
		"٤θ",
		"٤β",
	},

	/* Monk */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* Mindcrafter */
	{
		"",
		"",
		"",
		"ã",
		"ۻ",
		"ѻ",
		"å",
		"˥å",
		"Ķǽϼ",
		"ޥɥޥ",
	},

	/* High Mage; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Tourist */
	{
		"סϺ",
		"Ѹ",
		"ͷιԼ",
		"",
		"ιԼ",
		"ϲ", /* "ι", */
		"ҳ",
		"õ",
		"",
		"ڥ󥫡",
	},

	/* Imitator */
	{
		"줫",
		"ޤ",
		"ޤޤ",
		"ܤܤ",
		"",
		"ޤޤ",
		"ʤʤ",
		"",
		"Ȥ",
		"餤",
	},

	/* Beastmaster */
	{
		"Ȥ",
		"إӻȤ",
		"Ȥ",
		"ϵȤ",
		"ȥȤ",
		"Ȥ",
		"ҥɥȤ",
		"ϥɻȤ",
		"ࡼޥȤ",
		"ɥ饴Ȥ",
	},

	/* Sorcerer; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Archer */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},

	/* Magic eater */
	{
		"̵Τʤ",
		"",
		"ѻ",
		"ѻ",
		"ѻ",
		"",
		"ã",
		"ã",
		"ƻ",
		"ƤΤ",
	},

	/* Harper */
	{
		"",	/*"Apprentice"*/
		"ʲ",	/*"Songsmith"*/
		"ͷ",	/*"Bard"*/
		"ѥ˥",	/*"Companion"*/
		"",	/*"Minstrel"*/
		"è׻",	/*"Harper"*/
		"¤",	/*"Loreweaver"*/
		"ο",	/*"Muse"*/
		"̴¤",	/*"Dreamweaver"*/
		"ޥ",	/*"Master Harper"*/
	},

	/* Red Mage; same as Warrior-Mage */
	{
		"",
		"",			/*ա */
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"Ѥαͺ", /* Mage-Hero */
		"˼",
		/* "", */
		"Ʈѻ",
		"ɥ",
	},

	/* Samurai */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* ForceTrainer; same as Monk(?) */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* Blue Mage; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Kihei */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},

	/* Berserker */
	{
		"С",
		"С",
		"С",
		"ܤθ",
		"ܤθ",
		"ܤθ",
		"ܤβ",
		"ܤβ",
		"ܤβ",
		"ܤβ",
	},

	/* Kaji */
	{
		"Ƽä",
		"Ŵä",
		"ݤä",
		"ä",
		"εä",
		"ä",
		"ä",
		"ä",
		"ä",
		"ä",
	},

	/* Mirror Master */
	{
		"򸫤",
		"᤭",
		"",
		"ѻ",
		"Ƴ",
		"θ",
		"β",
		"ι",
		"β",
		"եΡ벦",
	},
	/* Ninja */
	{
		"",
		"ż",
		"ã",
		"ûȤ",
		"ڤ",
		"",
		"ο",
		"Ǥΰ",
		"Ż",
		"Ĺ",
	},
};

#else
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
	},

	/* Rogues */
	{
		"Cutpurse",
		"Robber",
		"Burglar",
		"Filcher",
		"Sharper",
		"Low Thief",
		"High Thief",
		"Master Thief",
		"Assassin",
		"Guildmaster",
	},

	/* Rangers */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladins */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Warrior-Mage */
	{
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
	},

	/* Chaos Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Chaos Hero",
		"Chaos Baron",
		"Chaos Duke",
		"Chaos Lord",
	},

	/* Monk */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* Mindcrafter */
	{
		"Trainee",
		"Acolyte",
		"Adept",
		"Immaculate",
		"Contemplator",
		"Mentalist",
		"Psychic",
		"Psionicist",
		"Esper",
		"Mindmaster",
	},

	/* High Mage; same as Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Tourist */
	{
		"Rambler",
		"Sightseer",
		"Excursionist",
		"Peregrinator",
		"Traveler",
		"Journeyer",
		"Voyager",
		"Explorer",
		"Adventurer",
		"Spelunker",
	},

	/* Imitator */
	{
		"Yet",
		"Lacks",
		"Still more",
		"So so",
		"All right",
		"Not bad",
		"Considerable",
		"Go go",
		"Sizable",
		"Great man",
	},

	/* BeastMaster */
	{
		"Newt Master",
		"Snake Master",
		"Spider Master",
		"Wolf Master",
		"Tiger Master",
		"Beetle Master",
		"Hydra Master",
		"Hound Master",
		"Mumak Master",
		"Dragon Master",
	},

	/* Sorcerer */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Archer */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Magic eater */
	{
		"Apprentice",
		"Beginner",
		"Jagguler",
		"Skilled",
		"Conjurer",
		"Magician",
		"Master",
		"Master",
		"Wizard",
		"Almighty",
	},

	/* Harper */
	{
		"Apprentice",	/*"Apprentice"*/
		"Songsmith",	/*"Songsmith"*/
		"Bard",	/*"Bard"*/
		"Companion",	/*"Companion"*/
		"Minstrel",	/*"Minstrel"*/
		"Harper",	/*"Harper"*/
		"Loreweaver",	/*"Loreweaver"*/
		"Muse",	/*"Muse"*/
		"Dreamweaver",	/*"Dreamweaver"*/
		"Master Harper",	/*"Master Harper"*/
	},

	/* Red Mage */
	{
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
	},

	/* Samurai */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* ForceTrainer */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* Blue Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Berserker */
	{
		    "Berserker",
		    "Berserker",
		    "Berserker",
		    "Rage Prince",
		    "Rage Prince",
		    "Rage Prince",
		    "Rage King",
		    "Rage King",
		    "Rage King",
		    "God of Rage",
	},

	/* Kaji */
	{
		"Copper smith",
		"Iron smith",
		"Steel smith",
		"Silver smith",
		"Dragon smith",
		"Spirit smith",
		"Magic smith",
		"Soul smith",
		"God smith",
		"AlmightySmith",
	},

	/* Mirror Master */
	{
		"Mirrorstarer",
		"Mirrorpolisher",
		"Mirrormaker",
		"Mirrormagician",
		"Guru of Mirror ",
		"Mirror Mage",
		"Mirror King",
		"Mirror Emperror",
		"Avatar of Mirror",
		"Ruffnor King",
	},

	/* Ninja */
	{
		"Trainee",
		"Myrmidon",
		"Initiate",
		"Knifer",
		"Bladesman",
		"Hashishin",
		"Black Dagger",
		"Shadowstrike",
		"Assassinator",
		"Death Lord",
	},
};
#endif

monster_power monster_powers[MAX_MONSPELLS] =
{
/* level,  smana,  %fail,  manedam,  %manefail,  use_stat, name */
#ifdef JP
{  1,   1,  10,    0,  15, A_CON,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 40,  35,  85,    0,  40, A_INT,  "Ͼõ"},
{ 35,  30,  80,  800,  70, A_STR,  "å"},
{  5,   1,  20,   18,  15, A_DEX,  "ͷ"},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 20,  15,  55, 1600,  95, A_CON,  "Υ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "ŷΥ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "Υ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "䵤Υ֥쥹"},
{ 20,  15,  55,  800,  95, A_CON,  "ǤΥ֥쥹"},
{ 20,  15,  70,  550,  95, A_CON,  "ϹΥ֥쥹"},
{ 20,  16,  70,  400,  95, A_CON,  "Υ֥쥹"},
{ 20,  16,  70,  400,  95, A_CON,  "ŹΥ֥쥹"},
{ 20,  20,  70,  450,  95, A_CON,  "Υ֥쥹"},
{ 20,  20,  70,  450,  95, A_CON,  "첻Υ֥쥹"},
{ 20,  20,  70,  600,  95, A_CON,  "Υ֥쥹"},
{ 20,  16,  70,  500,  95, A_CON,  "Υ֥쥹"},
{ 30,  25,  80,  250,  95, A_CON,  "̺Υ֥쥹"},
{ 35,  18,  80,  150,  95, A_CON,  "ֵžΥ֥쥹"},
{ 30,  25,  80,  200,  95, A_CON,  "ߤΥ֥쥹"},
{ 30,  28,  90,  200,  95, A_CON,  "ϤΥ֥쥹"},
{ 20,  15,  70,  500,  95, A_CON,  "ҤΥ֥쥹"},
{ 35,  15,  80,  150,  95, A_CON,  "ץ饺ޤΥ֥쥹"},
{ 30,  18,  70,  200,  95, A_CON,  "եΥ֥쥹"},
{ 30,  28,  80,  250,  95, A_CON,  "ϤΥ֥쥹"},
{ 25,  20,  95,  320,  80, A_INT,  "ǽ"},
{ 25,  15,  70,  800,  95, A_CON,  "ѴʪΥ֥쥹"},
{ 30,  32,  85,  400,  80, A_INT,  "륹"},
{ 35,  40,  95,  150,  95, A_CON,  "ʬΥ֥쥹"},
{ 18,  13,  55,  630,  80, A_INT,  "åɡܡ"},
{ 14,  10,  45,  316,  60, A_INT,  "ܡ"},
{ 20,  14,  60,  720,  80, A_INT,  "եܡ"},
{ 15,  11,  50,  320,  60, A_INT,  "ܡ"},
{  5,   3,  40,   48,  20, A_INT,  ""},
{ 25,  18,  70,  350,  80, A_INT,  "Ϲ"},
{ 30,  22,  75,  350,  80, A_INT,  "ܡ"},
{ 44,  45,  85,  550,  95, A_INT,  "Ϥ"},
{ 40,  42,  90,  550,  95, A_INT,  "Ź"},
{ 10,   5,  50,    0,  25, A_INT,  "ϵۼ"},
{ 25,  10,  60,    0,  30, A_INT,  ""},
{ 30,  14,  65,    0,  30, A_INT,  "Ǿ"},
{  3,   1,  25,   24,  20, A_INT,  "ڽ"},
{ 12,   2,  35,   64,  25, A_INT,  "Ž"},
{ 22,   6,  50,  150,  30, A_INT,  "̿"},
{ 32,  10,  70,  225,  35, A_INT,  "빦ͤ"},
{ 13,   7,  40,  178,  40, A_INT,  "åɡܥ"},
{ 10,   5,  35,  130,  35, A_INT,  "ܥ"},
{ 15,   9,  50,  210,  45, A_INT,  "եܥ"},
{ 12,   6,  35,  162,  40, A_INT,  "ܥ"},
{ 40,  42,  90,  550,  95, A_INT,  "С"},
{ 25,  17,  60,  255,  60, A_INT,  "Ϲ"},
{ 25,  20,  65,  250,  60, A_INT,  "ܥ"},
{ 25,  24,  90,  400,  80, A_INT,  "Ϥ"},
{ 25,  20,  80,  216,  60, A_INT,  "ץ饺ޡܥ"},
{ 25,  16,  60,  186,  60, A_INT,  "˴"},
{  3,   1,  25,   12,  20, A_INT,  "ޥåߥ"},
{  5,   3,  35,    0,  20, A_INT,  ""},
{ 10,   5,  40,    0,  20, A_INT,  ""},
{ 10,   5,  40,    0,  20, A_INT,  "ѥ˥å󥹥"},
{ 10,   5,  40,    0,  20, A_INT,  "󥹥"},
{ 10,   5,  40,    0,  20, A_INT,  "꡼ס󥹥"},
{ 20,  10,  70,    0,  40, A_INT,  "ԡ"},
{ 45, 120,  95,    0,  60, A_INT,  "Ǥμ"},
{ 20,  15,  70,    0,  20, A_WIS,  "ϲ"},
{ 45,  65,  80,    0,  60, A_INT,  "̵ε"},
{  5,   1,  30,    0,  20, A_INT,  "硼ȡƥݡ"},
{ 15,   8,  40,    0,  30, A_INT,  "ƥݡ"},
{ 40, 999,  99,    0,  80, A_INT,  ""},
{  1,   0,   0,    0,  15, A_INT,  ""},
{ 15,   8,  50,    0,  30, A_INT,  "褻"},
{ 20,  13,  80,    0,  30, A_INT,  "ƥݡȡ"},
{ 30,  40,  95,    0,  40, A_INT,  "ƥݡȡ٥"},
{ 35,  30,  80,  350,  70, A_INT,  "η"},
{  5,   1,  20,    0,  15, A_INT,  "Ű"},
{  5,   1,  20,    0,  15, A_DEX,  "ȥå¤"},
{ 15,   3,  40,    0,  30, A_INT,  "Ӽ"},
{ 30,  30,  70,    0,  40, A_INT,  ""},
{ 40,  70,  85,    0,  45, A_INT,  "緳Ƥ"},
{ 45,  90,  90,    0,  50, A_INT,  "Сǡξ"},
{ 25,  20,  65,    0,  30, A_INT,  "󥹥ξ"},
{ 35,  30,  75,    0,  40, A_INT,  "ʣΥ󥹥ξ"},
{ 25,  25,  65,    0,  25, A_INT,  "ξ"},
{ 25,  20,  60,    0,  25, A_INT,  "ξ"},
{ 35,  26,  75,    0,  40, A_INT,  "ϥɤξ"},
{ 30,  23,  70,    0,  35, A_INT,  "ҥɥξ"},
{ 40,  50,  85,    0,  40, A_INT,  "ŷȤξ"},
{ 35,  50,  80,    0,  35, A_INT,  "ǡξ"},
{ 30,  30,  75,    0,  35, A_INT,  "ǥåɤξ"},
{ 39,  70,  80,    0,  40, A_INT,  "ɥ饴ξ"},
{ 43,  85,  85,    0,  45, A_INT,  "饢ǥåɤξ"},
{ 46,  90,  85,    0,  45, A_INT,  "ɥ饴ξ"},
{ 48, 120,  90,    0,  50, A_INT,  "Сβ²ξ"},
{ 50, 150,  95,    0,  50, A_INT,  "ˡ󥹥ξ"},
#else
{  1,   1,  10,    0,  15, A_CON,  "shriek"},
{ 10,   4,  35,   89,  40, A_INT,  "something"},
{ 40,  35,  85,    0,  40, A_INT,  "dispel-magic"},
{ 35,  30,  80,  800,  70, A_STR,  "rocket"},
{  2,   1,  15,   10,  15, A_DEX,  "arrow"},
{  5,   2,  20,   18,  20, A_DEX,  "arrows"},
{ 12,   3,  25,   30,  25, A_DEX,  "missile"},
{ 16,   4,  30,   42,  30, A_DEX,  "missiles"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath acid"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath lightning"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath fire"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath cold"},
{ 20,  15,  55,  800,  95, A_CON,  "breath poison"},
{ 20,  15,  70,  550,  95, A_CON,  "breath nether"},
{ 20,  16,  70,  400,  95, A_CON,  "breath light"},
{ 20,  16,  70,  400,  95, A_CON,  "breath dark"},
{ 20,  20,  70,  450,  95, A_CON,  "breath confusion"},
{ 20,  20,  70,  450,  95, A_CON,  "breath sound"},
{ 20,  20,  70,  600,  95, A_CON,  "breath chaos"},
{ 20,  16,  70,  500,  95, A_CON,  "breath disenchantment"},
{ 30,  25,  80,  250,  95, A_CON,  "breath nexus"},
{ 35,  18,  80,  150,  95, A_CON,  "breath time"},
{ 30,  25,  80,  200,  95, A_CON,  "breath inertia"},
{ 30,  28,  90,  200,  95, A_CON,  "breath gravity"},
{ 20,  15,  70,  500,  95, A_CON,  "breath shards"},
{ 35,  15,  80,  150,  95, A_CON,  "breath plasma"},
{ 30,  18,  70,  200,  95, A_CON,  "breath force"},
{ 30,  28,  80,  250,  95, A_CON,  "breath mana"},
{ 25,  20,  95,  320,  80, A_INT,  "nuke ball"},
{ 25,  15,  70,  800,  95, A_CON,  "breath nuke"},
{ 30,  32,  85,  400,  80, A_INT,  "raw Logrus"},
{ 35,  40,  95,  150,  95, A_CON,  "breath disintegrate"},
{ 18,  13,  55,  630,  80, A_INT,  "acid ball"},
{ 14,  10,  45,  316,  60, A_INT,  "lightning ball"},
{ 20,  14,  60,  720,  80, A_INT,  "fire ball"},
{ 15,  11,  50,  320,  60, A_INT,  "frost ball"},
{  5,   3,  40,   48,  20, A_INT,  "stinking cloud"},
{ 25,  18,  70,  350,  80, A_INT,  "nether ball"},
{ 30,  22,  75,  350,  80, A_INT,  "water ball"},
{ 44,  45,  85,  550,  95, A_INT,  "mana storm"},
{ 40,  42,  90,  550,  95, A_INT,  "darkness storm"},
{ 10,   5,  50,    0,  25, A_INT,  "drain mana"},
{ 25,  10,  60,    0,  30, A_INT,  "mind blast"},
{ 30,  14,  65,    0,  30, A_INT,  "brain smash"},
{  3,   1,  25,   24,  20, A_INT,  "cause light wounds"},
{ 12,   2,  35,   64,  25, A_INT,  "cause serious wounds"},
{ 22,   6,  50,  150,  30, A_INT,  "cause critical wounds"},
{ 32,  10,  70,  225,  35, A_INT,  "cause mortal wounds"},
{ 13,   7,  40,  178,  40, A_INT,  "acid bolt"},
{ 10,   5,  35,  130,  35, A_INT,  "lightning bolt"},
{ 15,   9,  50,  210,  45, A_INT,  "fire bolt"},
{ 12,   6,  35,  162,  40, A_INT,  "frost bolt"},
{ 40,  42,  90,  550,  95, A_INT,  "starburst"},
{ 25,  17,  60,  255,  60, A_INT,  "nether bolt"},
{ 25,  20,  65,  250,  60, A_INT,  "water bolt"},
{ 25,  24,  90,  400,  80, A_INT,  "mana bolt"},
{ 25,  20,  80,  216,  60, A_INT,  "plasma bolt"},
{ 25,  16,  60,  186,  60, A_INT,  "ice bolt"},
{  3,   1,  25,   12,  20, A_INT,  "magic missile"},
{  5,   3,  35,    0,  20, A_INT,  "scare"},
{ 10,   5,  40,    0,  20, A_INT,  "blind"},
{ 10,   5,  40,    0,  20, A_INT,  "confuse"},
{ 10,   5,  40,    0,  20, A_INT,  "slow"},
{ 10,   5,  40,    0,  20, A_INT,  "sleep"},
{ 20,  10,  70,    0,  40, A_INT,  "speed"},
{ 45, 120,  95,    0,  60, A_INT,  "the Hand of Doom"},
{ 20,  15,  70,    0,  20, A_WIS,  "heal-self"},
{ 45,  65,  80,    0,  60, A_INT,  "make invulnerable"},
{  5,   1,  30,    0,  20, A_INT,  "blink-self"},
{ 15,   8,  40,    0,  30, A_INT,  "teleport-self"},
{ 40, 999,  99,    0,  80, A_INT,  "The world"},
{  1,   0,   0,    0,  15, A_INT,  "something"},
{ 15,   8,  50,    0,  30, A_INT,  "teleport to"},
{ 20,  13,  80,    0,  30, A_INT,  "teleport away"},
{ 30,  40,  95,    0,  40, A_INT,  "teleport level"},
{ 35,  30,  80,  350,  70, A_INT,  "psycho-spear"},
{  5,   1,  20,    0,  15, A_INT,  "create darkness"},
{  5,   1,  20,    0,  15, A_DEX,  "create traps"},
{ 15,   3,  40,    0,  30, A_INT,  "cause amnesia"},
{ 30,  30,  70,    0,  40, A_INT,  "raise dead"},
{ 40,  70,  85,    0,  45, A_INT,  "summon aid"},
{ 45,  90,  90,    0,  50, A_INT,  "summon Cyberdemons"},
{ 25,  20,  65,    0,  30, A_INT,  "summon a monster"},
{ 35,  30,  75,    0,  40, A_INT,  "summon monsters"},
{ 25,  25,  65,    0,  25, A_INT,  "summon ants"},
{ 25,  20,  60,    0,  25, A_INT,  "summon spiders"},
{ 35,  26,  75,    0,  40, A_INT,  "summon hounds"},
{ 30,  23,  70,    0,  35, A_INT,  "summon hydras"},
{ 40,  50,  85,    0,  40, A_INT,  "summon an angel"},
{ 35,  50,  80,    0,  35, A_INT,  "summon a daemon"},
{ 30,  30,  75,    0,  35, A_INT,  "summon an undead"},
{ 39,  70,  80,    0,  40, A_INT,  "summon a dragon"},
{ 43,  85,  85,    0,  45, A_INT,  "summon Greater Undead"},
{ 46,  90,  85,    0,  45, A_INT,  "summon Ancient Dragon"},
{ 48, 120,  90,    0,  50, A_INT,  "summon Lords of Amber"},
{ 50, 150,  95,    0,  50, A_INT,  "summon Unique Monsters"},
#endif

};


cptr monster_powers_short[MAX_MONSPELLS] = {
#ifdef JP

	"", "", "Ͼõ", "å", "ͷ", "", "", "",
	"", "ŷ", "б", "䵤", "", "Ϲ", "", "Ź",
	"", "첻", "", "", "̺", "ֵž", "", "",
	"", "ץ饺", "ե", "", "ǽ", "Ѵʪ", "륹", "ʬ",

	"", "ŷ", "б", "䵤", "", "Ϲ", "", "Ϥ",
	"Ź", "ϵۼ", "", "Ǿ", "ڽ", "Ž", "̿", "빦ͤ",
	"", "ŷ", "б", "䵤", "С", "Ϲ", "", "Ϥ",
	"ץ饺", "˴", "ޥåߥ", "", "", "", "®", "̲",

	"®", "Ǥμ", "ϲ", "̵ε", "硼ȥƥݡ", "ƥݡ", "ߤ", "",
	"褻", "ƥݡȥ", "ƥݡȥ٥", "η", "Ű", "ȥå¤", "Ӽ", "",
	"緳", "Сǡ", "󥹥", "ʣΥ󥹥", "", "", "ϥ", "ҥɥ",
	"ŷ", "", "ǥå", "ɥ饴", "饢ǥå", "ɥ饴", "Сβ²", "ˡ"

#else

	"Shriek", "Something", "Dispel-magic", "Rocket", "Arrow", "Arrows", "Missile", "Missiles",
	"Acid", "Lightning", "Fire", "Cold", "Poison", "Nether", "Light", "Dark",
	"Confusion", "Sound", "Chaos", "Disenchantment", "Nexus", "Time", "Inertia", "Gravity",
	"Shards", "Plasma", "Force", "Mana", "Nuke", "Nuke", "Logrus", "Disintergrate",

	"Acid", "Lightning", "Fire", "Frost", "Stinking Cloud", "Nether", "Water", "Mana storm",
	"Darkness storm", "Drain mana", "Mind blast", "Brain smash", "Cause Light Wound", "Cause Serious Wound", "Cause Critical Wound", "Cause Mortal Wound",
	"Acid", "Lightning", "Fire", "Frost", "Starburst", "Nether", "Water", "Mana",
	"Plasm", "Ice", "Magic missile", "Scare", "Blind", "Confuse", "Slow", "Sleep",

	"Speed", "Hand of doom", "Heal-self", "Invulnerable", "Blink", "Teleport", "The world", "Something",
	"Teleport to", "Teleport away", "Teleport level", "Psycho-spear", "Create darkness", "Create traps", "Amnesia", "Raise dead",
	"Aid", "Cyberdeamons", "A monster", "Monsters", "Ants", "Spiders", "Hounds", "Hydras",
	"Angel", "Daemon", "Undead", "Dragon", "Greater Undead", "Ancient Dragon", "Lords of Amber", "Unique monsters"

#endif
};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
#ifdef JP
	"",
	"",
	"ĳ",
	"",
	"",
	"",
	"",
	"ῧ",
	"",
	"ĳ",
	"",
	"",
	"뤤",
	"뤤",
	"뤤",
	"ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif

};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
#ifdef JP
	" :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR : ", "INT : ", "WIS : ", "DEX : ", "CON : ", "CHR : "
#endif

};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
#ifdef JP
	"x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str : ", "Int : ", "Wis : ", "Dex : ", "Con : ", "Chr : "
#endif

};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
	"ʪ/",
#else
	"Display inven/equip",
#endif

#ifdef JP
	"/ʪ",
#else
	"Display equip/inven",
#endif

#ifdef JP
	"ʸ",
#else
	"Display spell list",
#endif

#ifdef JP
	"饯",
#else
	"Display character",
#endif

	NULL,
	NULL,
#ifdef JP
	"å",
#else
	"Display messages",
#endif

#ifdef JP
	"󥸥ο",
#else
	"Display overhead view",
#endif

#ifdef JP
	"󥹥λפ",
#else
	"Display monster recall",
#endif

#ifdef JP
	"ƥξܺ",
#else
	"Display object recall",
#endif

#ifdef JP
	"ʬμϤɽ", 
#else
	"Display dungeon view",
#endif

#ifdef JP
	"ǰ",
#else
	"Display snap-shot",
#endif

	NULL,
	NULL,
#ifdef JP
	"ܡå",
#else
	"Display borg messages",
#endif

#ifdef JP
	"ܡơ",
#else
	"Display borg status",
#endif

	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 */
option_type option_info[] =
{
	/*** Input Options ***/

#ifdef JP
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "֤Ѥ" },
#else
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "Rogue-like commands" },
#endif


#ifdef JP
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "˥ƥ򽦤" },
#else
	{ &always_pickup,               FALSE,  1, 0, 5,
	"always_pickup",                "Pick things up by default" },
#endif


#ifdef JP
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",  "ƥ򽦤˳ǧ" },
#else
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "Prompt before picking things up" },
#endif


#ifdef JP
	{ &quick_messages,              TRUE,  1, 0, 1,
     "quick_messages",  "ååѤ" },
#else
	{ &quick_messages,              TRUE,  1, 0, 1,
	"quick_messages",               "Activate quick messages" },
#endif


#ifdef JP
	{ &auto_more,                   FALSE, 1, 2, 6,
	"auto_more",                    "ԤʤϢ³ǥåɽ" },
#else
	{ &auto_more,                   FALSE, 1, 2, 6,
	"auto_more",                    "Automatically clear '-more-' prompts" },
#endif


#ifdef JP
	{ &command_menu,                TRUE,  1, 2, 7,
	"command_menu",                 "˥塼ˤꥳޥͭˤ" },
#else
	{ &command_menu,                TRUE,  1, 2, 7,
	"command_menu",                 "Enable command selection menu" },
#endif


#ifdef JP
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "ΥƥѤȤ˳ǧ" },
#else
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "Prompt for floor item selection" },
#endif


#ifdef JP
	{ &use_old_target,              FALSE, 1, 0, 4,
     "use_old_target",  "˰ΥåȤꤹ" },
#else
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "Use old target by default" },
#endif


#ifdef JP
	{ &always_repeat,               TRUE,  1, 0, 6,
	"always_repeat",                "ޥɼư֤" },
#else
	{ &always_repeat,               TRUE,  1, 0, 6,
	"always_repeat",                "Repeat obvious commands" },
#endif


#ifdef JP
	{ &confirm_destroy,             FALSE, 1, 5, 3,
	"confirm_destroy",              "̵͡פʥƥ˲ǧ" },
#else
	{ &confirm_destroy,             FALSE, 1, 5, 3,
	"confirm_destroy",              "Prompt for destruction of known worthless items" },
#endif


#ifdef JP
	{ &confirm_wear,                TRUE, 1, 5, 4,
	"confirm_wear",                 "줿ʪǧ" },
#else
	{ &confirm_wear,                TRUE, 1, 5, 4,
	"confirm_wear",                 "Confirm to wear/wield known cursed items" },
#endif


#ifdef JP
	{ &confirm_quest,               TRUE, 1, 1, 9,
	"confirm_quest",                "ȤƳʤƨ˳ǧ" },
#else
	{ &confirm_quest,               TRUE, 1, 1, 9,
	"confirm_quest",                "Prompt before exiting a quest level" },
#endif


#ifdef JP
	{ &target_pet,                  FALSE,  1, 2, 5,
	"target_pet",                   "ڥåȤ򥿡åȤˤ" },
#else
	{ &target_pet,                  FALSE,  1, 2, 5,
	"target_pet",                   "Allow targetting pets" },
#endif


#ifdef ALLOW_EASY_OPEN
#ifdef JP
	{ &easy_open,                   TRUE,  1, 5, 7,
	"easy_open",                    "ưŪ˥ɥ򳫤" },
#else
	{ &easy_open,                   TRUE,  1, 5, 7,
	"easy_open",                    "Automatically open doors" },
#endif
#endif /* ALLOW_EASY_OPEN */


#ifdef ALLOW_EASY_DISARM
#ifdef JP
	{ &easy_disarm,                 TRUE,  1, 5, 8,
	"easy_disarm",                  "ưŪ櫤" },
#else
	{ &easy_disarm,                 TRUE,  1, 5, 8,
	"easy_disarm",                  "Automatically disarm traps" },
#endif
#endif /* ALLOW_EASY_DISARM */


#ifdef ALLOW_EASY_FLOOR /* TNB */
#ifdef JP
	{ &easy_floor,                  FALSE, 1, 5, 9,
	"easy_floor",                   "ǽŤʤäƥꥹȤ" },
#else
	{ &easy_floor,                  FALSE, 1, 5, 9,
	"easy_floor",                   "Display floor stacks in a list" },
#endif
#endif /* ALLOW_EASY_FLOOR -- TNB */


#ifdef JP
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "ֻȤ(a)ץޥɤǥƥ򲿤ǤȤ" },
#else
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "Allow unified use command" },
#endif


#ifdef JP
	{ &over_exert,                  FALSE,  1, 0, 29,
	"over_exert",                   "MP­ʤƤˡĩ魯" },
#else
	{ &over_exert,                  FALSE,  1, 0, 29,
	"over_exert",                   "Allow casting spells when short of mana" },
#endif


	/*** Output Options ***/

#ifdef JP
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "󥸥οեȤɽ" },
#else
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "Show dungeon level in feet" },
#endif


#ifdef JP
	{ &show_labels,                 TRUE,  2, 0, 10,
	"show_labels",                  "ɽ" },
#else
	{ &show_labels,                 TRUE,  2, 0, 10,
	"show_labels",                  "Show labels in object listings" },
#endif


#ifdef JP
	{ &show_weights,                TRUE,  2, 0, 11,
	"show_weights",                 "ƥǽ̤ɽ" },
#else
	{ &show_weights,                TRUE,  2, 0, 11,
	"show_weights",                 "Show weights in object listings" },
#endif


#ifdef JP
	{ &show_item_graph,             TRUE,  2, 2, 0,
	"show_item_graph",              "ƥΥܥɽ" },
#else
	{ &show_item_graph,             TRUE,  2, 2, 0,
	"show_item_graph",              "Show items graphics" },
#endif


#ifdef JP
	{ &show_choices,                TRUE,  2, 0, 12,
	"show_choices",                 "ʪ/ɥ򥢥ƥɽ" },
#else
	{ &show_choices,                TRUE,  2, 0, 12,
	"show_choices",                 "Show choices in certain sub-windows" },
#endif


#ifdef JP
	{ &plain_pickup,                FALSE, 2, 6, 6,
	"plain_pickup",                 "ֽäץåά" },
#else
	{ &plain_pickup,                FALSE,99, 6, 6,
	"plain_pickup",                 "Plain pickup messages(japanese only)" },
#endif


#ifdef JP
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "ץ쥤䡼̤ʵɽ"},
#else
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "Use special symbols for the player char"},
#endif


#ifdef JP
	{ &equippy_chars,               TRUE,  2, 1, 12,
	"equippy_chars",                "ơʸɽ" },
#else
	{ &equippy_chars,               TRUE,  2, 1, 12,
	"equippy_chars",                "Display 'equippy' chars" },
#endif


#ifdef JP
	{ &display_mutations,              FALSE, 2, 5, 0,
	"display_mutations",               "'C'ޥɤѰۤɽ" },
#else
	{ &display_mutations,              FALSE, 2, 5, 0,
	"display_mutations",               "Display mutations in 'C'haracter Display" },
#endif


#ifdef JP
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "ƥεҤάˤ" },
#else
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "Plain object descriptions" },
#endif


#ifdef JP
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "˥ץ쥤䡼濴֤(*٤*)" },
#else
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "Center map while walking (*slow*)" },
#endif


#ifdef JP
	{ &center_running,              TRUE,  2, 5, 12,
	"center_running",               "äƤǤ濴֤" },
#else
	{ &center_running,              TRUE,  2, 5, 12,
	"center_running",               "Centering even while running" },
#endif


#ifdef JP
	{ &view_yellow_lite,            TRUE,  2, 1, 28,
	"view_yellow_lite",              "ϰϤ̤ʿɽ" },
#else
	{ &view_yellow_lite,            TRUE,  2, 1, 28,
	"view_yellow_lite",             "Use special colors for torch-lit grids" },
#endif


#ifdef JP
	{ &view_bright_lite,            TRUE,  2, 1, 29,
	"view_bright_lite",             "볦ϰϤ̤ʿɽ" },
#else
	{ &view_bright_lite,            TRUE,  2, 1, 29,
	"view_bright_lite",             "Use special colors for 'viewable' grids" },
#endif


#ifdef JP
	{ &view_granite_lite,           TRUE,  2, 1, 30,
	"view_granite_lite",            "ɤ̤ʿɽ(Ť)" },
#else
	{ &view_granite_lite,           TRUE,  2, 1, 30,
	"view_granite_lite",            "Use special colors for wall grids (slow)" },
#endif


#ifdef JP
	{ &view_special_lite,           TRUE,  2, 1, 31,
	"view_special_lite",            "̤ʿɽ(Ť)" },
#else
	{ &view_special_lite,           TRUE,  2, 1, 31,
	"view_special_lite",            "Use special colors for floor grids (slow)" },
#endif

#ifdef JP
	{ &new_ascii_graphics,          FALSE, 2, 2, 4,
	"new_ascii_graphics",           "ϷŤϤäɽ" },
#else
	{ &new_ascii_graphics,          FALSE, 2, 2, 4,
	"new_ascii_graphics",           "Show a clear contrast between light and dark" },
#endif

#ifdef JP
	{ &display_path,                FALSE, 2, 2, 8,
	"display_path",                 "ˡεפɽ" },
#else
	{ &display_path,                FALSE, 2, 2, 8,
	"display_path",                 "Display actual path before shooting" },
#endif


#ifdef JP
	{ &always_show_list,            TRUE,  2, 4, 0,
	"always_show_list",             "ˤϾ˰ɽ" },
#else
	{ &always_show_list,            TRUE,  2, 4, 0,
	"always_show_list",             "Always show list at first when select items" },
#endif


#ifdef JP
	{ &change_numeral,              TRUE,  2, 4, 5,
	"change_numeral",               "ƥμˤäƿѤ" },
#else
	{ &change_numeral,              TRUE,  99, 4, 5,
	"change_numeral",               "Change a way to counting (japanese only)" },
#endif


	/*** Game-Play ***/

#ifdef JP
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "ʷϵư깥" },
#else
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "Auto-scum for good levels" },
#endif


#ifdef JP
	{ &stack_force_notes,           TRUE,  3, 0, 8,
	"stack_force_notes",            "ۤʤäΥƥޤȤ" },
#else
	{ &stack_force_notes,           TRUE,  3, 0, 8,
	"stack_force_notes",            "Merge inscriptions when stacking" },
#endif


#ifdef JP
	{ &stack_force_costs,           FALSE, 3, 0, 9,
	"stack_force_costs",            "ۤʤɽΥƥޤȤ" },
#else
	{ &stack_force_costs,           FALSE, 3, 0, 9,
	"stack_force_costs",            "Merge discounts when stacking" },
#endif


#ifdef JP
	{ &stack_allow_items,           TRUE,  3, 1, 2,
	"stack_allow_items",            "ƱɶޤȤ" },
#else
	{ &stack_allow_items,           TRUE,  3, 1, 2,
	"stack_allow_items",            "Allow weapons and armor to stack" },
#endif


#ifdef JP
	{ &expand_look,                 TRUE,  3, 1, 4,
	"expand_look",                  "ֲĴ٤ץޥɤĥ" },
#else
	{ &expand_look,                 TRUE,  3, 1, 4,
	"expand_look",                  "Expand the power of the look command" },
#endif


#ifdef JP
	{ &expand_list,                 TRUE,  3, 1, 5,
	"expand_list",                  "ְץޥɤĥ" },
#else
	{ &expand_list,                 TRUE,  3, 1, 5,
	"expand_list",                  "Expand the power of the list commands" },
#endif


#ifdef JP
	{ &view_perma_grids,            TRUE,  3, 1, 6,
	"view_perma_grids",             "뤤ϤΤޤޤˤ" },
#else
	{ &view_perma_grids,            TRUE,  3, 1, 6,
	"view_perma_grids",             "Map remembers all perma-lit grids" },
#endif


#ifdef JP
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "ǾȤ餷ϤΤޤޤˤ" },
#else
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "Map remembers all torch-lit grids" },
#endif


#ifdef JP
	{ &view_unsafe_grids,            FALSE, 3, 1, 8,
	"view_unsafe_grids",             "ȥå״κѤߤǤʤɽ" },
#else
	{ &view_unsafe_grids,            FALSE, 3, 1, 8,
	"view_unsafe_grids",             "Map marked by detect traps" },
#endif


#ifdef JP
	{ &small_levels,                TRUE,  3, 0, 30,
	"small_levels",                 "˾եǽˤ" },
#else
	{ &small_levels,                TRUE,  3, 0, 30,
	"small_levels",                 "Allow unusually small dungeon levels" },
#endif


#ifdef JP
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "˾ե" },
#else
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "Always create unusually small dungeon levels" },
#endif


#ifdef JP
	{ &empty_levels,                TRUE,  3, 0, 31,
	"empty_levels",                 "äݤΡ֥꡼ʡץ٥ǽˤ" },
#else
	{ &empty_levels,                TRUE,  3, 0, 31,
	"empty_levels",                 "Allow empty 'arena' levels" },
#endif


#ifdef JP
	{ &bound_walls_perm,            FALSE,  3, 2, 1,
	"bound_walls_perm",             "󥸥γɤʵ״ˤ" },
#else
	{ &bound_walls_perm,            FALSE,  3, 2, 1,
	"bound_walls_perm",             "Boundary walls become 'permanent wall'" },
#endif


#ifdef JP
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "饯Τ" },
#else
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "Leave last words when your character dies" },
#endif


#ifdef WORLD_SCORE
#ifdef JP
	{ &send_score,                  TRUE,  3, 4, 6,
	"send_score",                   "Ф˥" },
#else
	{ &send_score,                  TRUE,  3, 4, 6,
	"send_score",                   "Send score dump to the world score server" },
#endif
#endif


#ifdef JP
	{ &allow_debug_opts,            FALSE, 3, 6, 11,
	"allow_debug_opts",             "ǥХå/ץĤ" },
#else
	{ &allow_debug_opts,            FALSE, 3, 6, 11,
	"allow_debug_opts",             "Allow use of debug/cheat options" },
#endif




	/*** Disturbance ***/

#ifdef JP
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "ʤ̲᤹" },
#else
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "Run past stairs" },
#endif


#ifdef JP
	{ &find_ignore_doors,           TRUE,  4, 0, 17,
	"find_ignore_doors",            "ɥ̲᤹" },
#else
	{ &find_ignore_doors,           TRUE,  4, 0, 17,
	"find_ignore_doors",            "Run through open doors" },
#endif


#ifdef JP
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "ʤѤФ˺ûΥ̲᤹" },
#else
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "Run past known corners" },
#endif


#ifdef JP
	{ &find_examine,                TRUE,  4, 0, 19,
	"find_examine",                 "ϩŤˤʤ٤ʤѤȲꤷ̲᤹" },
#else
	{ &find_examine,                TRUE,  4, 0, 19,
	"find_examine",                 "Run into potential corners" },
#endif


#ifdef JP
	{ &disturb_move,                FALSE,  4, 0, 20,
	"disturb_move",                 "ɤΥ󥹥ưƤưߤ" },
#else
	{ &disturb_move,                FALSE,  4, 0, 20,
	"disturb_move",                 "Disturb whenever any monster moves" },
#endif


#ifdef JP
	{ &disturb_high,                FALSE,  4, 1, 3,
	"disturb_high",                 "٥ι⤤󥹥ưưߤ"},
#else
	{ &disturb_high,                FALSE,  4, 1, 3,
	"disturb_high",                 "Disturb whenever high-level monster moves" },
#endif


#ifdef JP
	{ &disturb_near,                TRUE,  4, 0, 21,
	"disturb_near",                 "볦Υ󥹥ưưߤ" },
#else
	{ &disturb_near,                TRUE,  4, 0, 21,
	"disturb_near",                 "Disturb whenever viewable monster moves" },
#endif


#ifdef JP
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "볦ΥڥåȤưưߤ" },
#else
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "Disturb when visible pets move" },
#endif


#ifdef JP
	{ &disturb_panel,               TRUE,  4, 0, 22,
	"disturb_panel",                "̥˹ưߤ" },
#else
	{ &disturb_panel,               TRUE,  4, 0, 22,
	"disturb_panel",                "Disturb whenever map panel changes" },
#endif


#ifdef JP
	{ &disturb_state,               TRUE,  4, 0, 23,
	"disturb_state",                "ʬΥơѲ˹ưߤ" },
#else
	{ &disturb_state,               TRUE,  4, 0, 23,
	"disturb_state",                "Disturb whenever player state changes" },
#endif


#ifdef JP
	{ &disturb_minor,               TRUE,  4, 0, 24,
	"disturb_minor",                "٤ʤȤƤưߤ" },
#else
	{ &disturb_minor,               TRUE,  4, 0, 24,
	"disturb_minor",                "Disturb whenever boring things happen" },
#endif


#ifdef JP
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "顼˥ӡײĤ餹" },
#else
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "Audible bell (on errors, etc)" },
#endif


#ifdef JP
	{ &alert_hitpoint,              TRUE, 4, 0, 26,
	"alert_hitpoint",               "ҥåȥݥȤηٹ˥ӡפĤ餹" },
#else
	{ &alert_hitpoint,              TRUE, 4, 0, 26,
	"alert_hitpoint",               "Alert user to critical hitpoints" },
#endif


#ifdef JP
	{ &disturb_trap_detect,         TRUE, 4, 0, 27,
	"disturb_trap_detect",          "ȥå״ϰϳ˽Фľ˹ưߤ" },
#else
	{ &disturb_trap_detect,         TRUE, 4, 0, 27,
	"disturb_trap_detect",          "Disturb when leaving trap detected area"},
#endif

#ifdef JP
	{ &alert_trap_detect,           FALSE, 4, 0, 25,
	"alert_trap_detect",            "ȥå״ϰϳ˽Фľ˷ٹ𤹤" },
#else
	{ &alert_trap_detect,           FALSE, 4, 0, 25,
	"alert_trap_detect",            "Alert when leaving trap detected area"},
#endif


	/*** Efficiency ***/

#ifdef JP
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
     "view_reduce_lite",  "äƤȤȾ¤򸺾" },
#else
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "Reduce lite-radius when running" },
#endif


#ifdef JP
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Ǥϻ򶹤" },
#else
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Reduce view-radius in town" },
#endif


#ifdef JP
	{ &check_abort,                 TRUE,  5, 1, 18,
	"check_abort",                  "Ϣ³ޥɤϥϤǤ" },
#else
	{ &check_abort,                 TRUE,  5, 1, 18,
	"check_abort",                  "Check for user abort while continuous command" },
#endif


#ifdef JP
	{ &flush_failure,               TRUE,  5, 1, 20,
	"flush_failure",                "͡ʥߥȯϤ򥯥ꥢ" },
#else
	{ &flush_failure,               TRUE,  5, 1, 20,
	"flush_failure",                "Flush input on various failures" },
#endif


#ifdef JP
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "㳲ȯϤ򥯥ꥢ" },
#else
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "Flush input whenever disturbed" },
#endif


#ifdef JP
	{ &fresh_before,                TRUE,  5, 1, 23,
	"fresh_before",                 "Ϣ³ޥ˲̤褷³" },
#else
	{ &fresh_before,                TRUE,  5, 1, 23,
	"fresh_before",                 "Flush output while continuous command" },
#endif


#ifdef JP
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "ޥɸ˲̤˺褷³" },
#else
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "Flush output after monster's move" },
#endif


#ifdef JP
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "åθ˲̤褹" },
#else
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "Flush output after every message" },
#endif


#ifdef JP
	{ &compress_savefile,           FALSE, 5, 1, 26,
	"compress_savefile",            "֡եΥå򰵽̤" },
#else
	{ &compress_savefile,           FALSE, 5, 1, 26,
	"compress_savefile",            "Compress messages in savefiles" },
#endif


#ifdef JP
	{ &hilite_player,               FALSE,  5, 1, 27,
	"hilite_player",                "ץ쥤䡼˥碌" },
#else
	{ &hilite_player,               FALSE,  5, 1, 27,
	"hilite_player",                "Hilite the player with the cursor" },
#endif


	/*** Birth Options ***/

#ifdef JP
	{ &manual_haggle,               FALSE, 6, 1, 0,
	"manual_haggle",                "ŹڤĤ򤹤" },
#else
	{ &manual_haggle,               FALSE, 6, 1, 0,
	"manual_haggle",                "Manually haggle in stores" },
#endif


#ifdef JP
	{ &easy_band,                   FALSE, 6, 6, 31,
	"easy_band",                    "鿴Ѵñ⡼(*)" },
#else
	{ &easy_band,                   FALSE, 6, 6, 31,
	"easy_band",                    "Easy Mode (*)" },
#endif


#ifdef JP
	{ &smart_learn,                 TRUE,  6, 1, 14,
	"smart_learn",                  "󥹥ϼԤؽ(*)" },
#else
	{ &smart_learn,                 TRUE,  6, 1, 14,
	"smart_learn",                  "Monsters learn from their mistakes (*)" },
#endif


#ifdef JP
	{ &smart_cheat,                 FALSE, 6, 1, 15,
	"smart_cheat",                  "󥹥ϥץ쥤䡼μߤͤ(*)" },
#else
	{ &smart_cheat,                 FALSE, 6, 1, 15,
	"smart_cheat",                  "Monsters exploit players weaknesses (*)" },
#endif


#ifdef JP
	{ &vanilla_town,                FALSE, 6, 6, 0,
	"vanilla_town",                 "Ĥγ/Ȥȹʤ" },
#else
	{ &vanilla_town,                FALSE, 6, 6, 0,
	"vanilla_town",                 "Use 'vanilla' town without quests and wilderness" },
#endif


#ifdef JP
	{ &lite_town,                   FALSE, 6, 6, 1,
	"lite_town",                    "Ϥʳ/ʤ" },
#else
	{ &lite_town,                   FALSE, 6, 6, 1,
	"lite_town",                    "Use 'lite' town without a wilderness" },
#endif


#ifdef JP
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "ŴѡŹѤʤ(*)" },
#else
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "Stores are permanently closed (*)" },
#endif


#ifdef JP
	{ &ironman_small_levels,        FALSE, 6, 6, 3,
	"ironman_small_levels",         "Ŵѡ˾˾ե(*)" },
#else
	{ &ironman_small_levels,        FALSE, 6, 6, 3,
	"ironman_small_levels",         "Always create unusually small dungeon levels (*)" },
#endif


#ifdef JP
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Ŵѡ˵ԤȾ곬ʤʤ(*)" },
#else
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Disable recall and use of up stairs (*)" },
#endif


#ifdef JP
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Ŵѡ˾˳ʷϵư깥ߤ" },
#else
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Permanently enable the autoscummer" },
#endif


#ifdef JP
       { &ironman_empty_levels,         FALSE, 6, 6, 8,
       "ironman_empty_levels",          "Ŵѡ˾˶äݤΥ꡼ʥ٥(*)" },
#else
	{ &ironman_empty_levels,        FALSE, 6, 6, 8,
	"ironman_empty_levels",         "Always create empty 'arena' levels (*)" },
#endif


#ifdef JP
       { &ironman_rooms,                FALSE, 6, 6, 12,
       "ironman_rooms",                 "Ŵѡ˾̤Ǥʤ(*)" },
#else
	{ &ironman_rooms,               FALSE, 6, 6, 12,
	"ironman_rooms",                "Always generate very unusual rooms (*)" },
#endif


#ifdef JP
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",	        "Ŵѡ˰̴⡼(ԾǤ)(*)" },
#else
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",	        "Nightmare mode(it isn't even remotely fair!)(*)" },
#endif

#ifdef JP
	{ &left_hander,                 FALSE, 6, 6, 13,
	"left_hander",                  "Ǥ" },
#else
	{ &left_hander,                 FALSE, 6, 6, 13,
	"left_hander",                  "Left-Hander" },
#endif


#ifdef JP
	{ &preserve_mode,               TRUE,  6, 6, 14,
	"preserve_mode",                "ΥƥƨƤ(*)" },
#else
	{ &preserve_mode,               TRUE,  6, 6, 14,
	"preserve_mode",                "Preserve artifacts (*)" },
#endif


#ifdef JP
	{ &autoroller,                  TRUE,  6, 6, 15,
	"autoroller",                   "ǽͤ˥ȥ顼(*)" },
#else
	{ &autoroller,                  TRUE,  6, 6, 15,
	"autoroller",                   "Allow use of autoroller for stats (*)" },
#endif


#ifdef JP
	{ &autochara,                   FALSE, 6, 6, 16,
	"autochara",                   "γ/ϰ̤˥ȥ顼" },
#else
	{ &autochara,                   FALSE, 6, 6, 16,
	"autochara",                    "Autoroll for weight, height and social status" },
#endif


#ifdef JP
	{ &powerup_home,                TRUE,  6, 4, 3,
	"powerup_home",                 "椬Ȥĥ(*)" },

#else
	{ &powerup_home,                TRUE,  6, 4, 3,
	"powerup_home",                 "Increase capacity of your home (*)" },
#endif


	/*** Easy Object Auto-Destroyer ***/

#ifdef JP
	{ &destroy_items,               FALSE, 7, 7, 0,
	"destroy_items",                "ƥδʰ׼ư˲Ѥ" },
#else
	{ &destroy_items,               FALSE, 7, 7, 0,
	"destroy_items",                "Use easy auto-destroyer" },
#endif

#ifdef JP
	{ &destroy_feeling,               FALSE, 7, 7, 8,
	"destroy_feeling",                "ʰ״ꤷȤư˲ŬѤ" },
#else
	{ &destroy_feeling,               FALSE, 7, 7, 8,
	"destroy_feeling",                "Apply auto-destroy as sense feeling" },
#endif

#ifdef JP
	{ &destroy_identify,               FALSE, 7, 7, 9,
	"destroy_identify",                "ꤷȤư˲ŬѤ" },
#else
	{ &destroy_identify,               FALSE, 7, 7, 9,
	"destroy_identify",                "Apply auto-destroy as identify an item" },
#endif

#ifdef JP
	{ &leave_worth,                 TRUE, 7, 7, 2,
	"leave_worth",                  "ͤ륢ƥϲʤ" },
#else
	{ &leave_worth,                 TRUE, 7, 7, 2,
	"leave_worth",                  "Auto-destroyer leaves known worthy items" },
#endif

#ifdef JP
	{ &leave_equip,                 FALSE, 7, 7, 3,
	"leave_equip",                  "/ɶϲʤ" },
#else
	{ &leave_equip,                 FALSE, 7, 7, 3,
	"leave_equip",                  "Auto-destroyer leaves weapons and armour" },
#endif

#ifdef JP
	{ &leave_chest,                 TRUE, 7, 7, 7,
	"leave_chest",                  "ƤʤȢϲʤ" },
#else
	{ &leave_chest,                 TRUE, 7, 7, 7,
	"leave_chest",                  "Auto-destroyer leaves closed chests" },
#endif

#ifdef JP
	{ &leave_wanted,                TRUE, 7, 7, 4,
	"leave_wanted",                 "޶λ/ϲʤ" },
#else
	{ &leave_wanted,                TRUE, 7, 7, 4,
	"leave_wanted",                 "Auto-destroyer leaves wanted corpses" },
#endif

#ifdef JP
	{ &leave_corpse,                FALSE, 7, 7, 5,
	"leave_corpse",                 "/ϲʤ" },
#else
	{ &leave_corpse,                FALSE, 7, 7, 5,
	"leave_corpse",                 "Auto-destroyer leaves corpses and skeletons" },
#endif

#ifdef JP
	{ &leave_junk,                  FALSE, 7, 7, 6,
	"leave_junk",                   "餯ϲʤ" },
#else
	{ &leave_junk,                  FALSE, 7, 7, 6,
	"leave_junk",                   "Auto-destroyer leaves junk" },
#endif

#ifdef JP
	{ &leave_special,               TRUE, 7, 7, 1,
	"leave_special",                "²/Ȥ̤ɬפʥƥϲʤ" },
#else
	{ &leave_special,               TRUE, 7, 7, 1,
	"leave_special",                "Auto-destroyer leaves items your race/class needs" },
#endif


	/*** Play-record Options ***/

#ifdef JP
	{ &record_fix_art,              TRUE, 10, 4, 11,
	"record_fix_art",               "ꥢƥեȤϿ" },
#else
	{ &record_fix_art,              TRUE, 10, 4, 11,
	"record_fix_art",               "Record fixed artifacts" },
#endif

#ifdef JP
	{ &record_rand_art,             TRUE, 10, 4, 12,
	"record_rand_art",              "ॢƥեȤϿ" },
#else
	{ &record_rand_art,             TRUE, 10, 4, 12,
	"record_rand_art",              "Record random artifacts" },
#endif

#ifdef JP
	{ &record_destroy_uniq,         TRUE, 10, 4, 13,
	"record_destroy_uniq",          "ˡ󥹥ݤȤϿ" },
#else
	{ &record_destroy_uniq,         TRUE, 10, 4, 13,
	"record_destroy_uniq",          "Record when destroy unique monster" },
#endif

#ifdef JP
	{ &record_fix_quest,            TRUE, 10, 4, 14,
	"record_fix_quest",             "ꥯȤãϿ" },
#else
	{ &record_fix_quest,            TRUE, 10, 4, 14,
	"record_fix_quest",             "Record fixed quests" },
#endif

#ifdef JP
	{ &record_rand_quest,           TRUE, 10, 4, 15,
	"record_rand_quest",            "९ȤãϿ" },
#else
	{ &record_rand_quest,           TRUE, 10, 4, 15,
	"record_rand_quest",            "Record random quests" },
#endif

#ifdef JP
	{ &record_maxdeapth,            TRUE, 10, 4, 16,
	"record_maxdeapth",             "ǿ򹹿Ȥ˵Ͽ" },
#else
	{ &record_maxdeapth,            TRUE, 10, 4, 16,
	"record_maxdeapth",             "Record movements to deepest level" },
#endif

#ifdef JP
	{ &record_stair,                TRUE, 10, 4, 17,
	"record_stair",                 "ΰưϿ" },
#else
	{ &record_stair,                TRUE, 10, 4, 17,
	"record_stair",                 "Record recall and stair movements" },
#endif

#ifdef JP
	{ &record_buy,                  TRUE, 10, 4, 18,
	"record_buy",                   "ƥιϿ" },
#else
	{ &record_buy,                  TRUE, 10, 4, 18,
	"record_buy",                   "Record purchased items" },
#endif

#ifdef JP
	{ &record_sell,                 FALSE, 10, 4, 19,
	"record_sell",                  "ƥѤϿ" },
#else
	{ &record_sell,                 FALSE, 10, 4, 19,
	"record_sell",                  "Record sold items" },
#endif

#ifdef JP
	{ &record_danger,               TRUE, 10, 4, 20,
	"record_danger",                "ԥˤʤäȤϿ" },
#else
	{ &record_danger,               TRUE, 10, 4, 20,
	"record_danger",                "Record hitpoint warning" },
#endif

#ifdef JP
	{ &record_arena,                TRUE, 10, 4, 21,
	"record_arena",                 "꡼ʤǤξϿ" },
#else
	{ &record_arena,                TRUE, 10, 4, 21,
	"record_arena",                 "Record arena victories" },
#endif

#ifdef JP
	{ &record_ident,                TRUE, 10, 4, 22,
	"record_ident",                 "̤ȽΥƥμ̤Ͽ" },
#else
	{ &record_ident,                TRUE, 10, 4, 22,
	"record_ident",                 "Record first identified items" },
#endif

#ifdef JP
	{ &record_named_pet,            FALSE, 10, 4, 23,
	"record_named_pet",             "̾ĤڥåȤξϿ" },
#else
	{ &record_named_pet,            FALSE, 10, 4, 23,
	"record_named_pet",             "Record informations of named pets" },
#endif


	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};


#ifdef JP
cptr chaos_patrons[MAX_PATRON] =
{
	"",
	"ޥ٥",
	"㡼ɥ",
	"ϥϡ",
	"С",

	"ԥ졼",
	"Х",
	"ꥪå",
	"",
	"ʡ",

	"Х",
	"",
	"顼ͥå",
	"ʡ",
	"ƥ",

	""
};
#else
cptr chaos_patrons[MAX_PATRON] =
{
	"Slortar",
	"Mabelode",
	"Chardros",
	"Hionhurn",
	"Xiombarg",

	"Pyaray",
	"Balaan",
	"Arioch",
	"Eequor",
	"Narjhan",

	"Balo",
	"Khorne",
	"Slaanesh",
	"Nurgle",
	"Tzeentch",

	"Khaine"
};
#endif


int chaos_stats[MAX_PATRON] =
{
	A_CON,  /* Slortar */
	A_CON,  /* Mabelode */
	A_STR,  /* Chardros */
	A_STR,  /* Hionhurn */
	A_STR,  /* Xiombarg */

	A_INT,  /* Pyaray */
	A_STR,  /* Balaan */
	A_INT,  /* Arioch */
	A_CON,  /* Eequor */
	A_CHR,  /* Narjhan */

	-1,     /* Balo */
	A_STR,  /* Khorne */
	A_CHR,  /* Slaanesh */
	A_CON,  /* Nurgle */
	A_INT,  /* Tzeentch */

	A_STR,  /* Khaine */
};




int chaos_rewards[MAX_PATRON][20] =
{
	/* Slortar the Old: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP,
		REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Mabelode the Faceless: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_H_SUMMON, REW_SUMMON_M,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_WND,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_ABL, REW_SER_UNDE,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GOOD_OBS
	},

	/* Chardros the Reaper: */
	{
		REW_WRATH, REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_H_SUMMON,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_DESTRUCT, REW_SER_UNDE,
		REW_GENOCIDE, REW_MASS_GEN, REW_MASS_GEN, REW_DISPEL_C, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Hionhurn the Executioner: */
	{
		REW_WRATH, REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_SER_UNDE, REW_DESTRUCT, REW_GENOCIDE,
		REW_MASS_GEN, REW_MASS_GEN, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Xiombarg the Sword-Queen: */
	{
		REW_TY_CURSE, REW_TY_CURSE, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND, REW_POLY_WND,
		REW_GENOCIDE, REW_DISPEL_C, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GAIN_EXP, REW_AUGM_ABL, REW_GOOD_OBS
	},


	/* Pyaray the Tentacled Whisperer of Impossible Secretes: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_SER_DEMO, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_DO_HAVOC, REW_GOOD_OBJ, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balaan the Grim: */
	{
		REW_TY_CURSE, REW_HURT_LOT, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_SUMMON_M, REW_LOSE_EXP, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_SER_UNDE, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_GAIN_EXP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Arioch, Duke of Hell: */
	{
		REW_WRATH, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_EXP, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_MASS_GEN, REW_SER_DEMO, REW_HEAL_FUL, REW_CHAOS_WP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GAIN_EXP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Eequor, Blue Lady of Dismay: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_CURSE_WP, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS, REW_HEAL_FUL, REW_GAIN_EXP,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GOOD_OBS, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Narjhan, Lord of Beggars: */
	{
		REW_WRATH, REW_CURSE_AR, REW_CURSE_WP, REW_CURSE_WP, REW_CURSE_AR,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_WND, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_AUGM_ABL,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balo the Jester: */
	{
		REW_WRATH, REW_SER_DEMO, REW_CURSE_WP, REW_CURSE_AR, REW_LOSE_EXP,
		REW_GAIN_ABL, REW_LOSE_ABL, REW_POLY_WND, REW_POLY_SLF, REW_IGNORE,
		REW_DESTRUCT, REW_MASS_GEN, REW_CHAOS_WP, REW_GREA_OBJ, REW_HURT_LOT,
		REW_AUGM_ABL, REW_RUIN_ABL, REW_H_SUMMON, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Khorne the Bloodgod: */
	{
		REW_WRATH, REW_HURT_LOT, REW_HURT_LOT, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_SER_MONS, REW_SER_DEMO,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Slaanesh: */
	{
		REW_WRATH, REW_PISS_OFF, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_SER_DEMO,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_EXP,
		REW_GAIN_EXP, REW_CHAOS_WP, REW_GAIN_ABL, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Nurgle: */
	{
		REW_WRATH, REW_PISS_OFF, REW_HURT_LOT, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_ABL,
		REW_GAIN_ABL, REW_SER_UNDE, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Tzeentch: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_CHAOS_WP, REW_GREA_OBJ,
		REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP, REW_GAIN_EXP, REW_AUGM_ABL
	},

	/* Khaine: */
	{
		REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_LOSE_ABL, REW_LOSE_EXP,
		REW_IGNORE,   REW_IGNORE,   REW_DISPEL_C, REW_DO_HAVOC, REW_DO_HAVOC,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_EXP, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_SER_MONS, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GOOD_OBS
	}
};

martial_arts ma_blows[MAX_MA] =
{
#ifdef JP
	{ "%s򲥤ä",                          1, 0, 1, 5, 0 },
	{ "%s򽳤ä",                           2, 0, 1, 7, 0 },
	{ "%sͤ򤯤路",                         3, 0, 1, 9, 0 },
	{ "%sɨ򤯤路",             5, 5, 2, 4, MA_KNEE },
	{ "%sɪǤ򤯤路",            7, 5, 1, 12, 0 },
	{ "%sꤷ",                           9, 10, 2, 6, 0 },
	{ "%s򽳤ä",                           11, 10, 3, 6, MA_SLOW },
	{ "%s˥åѡ򤯤路",                       13, 12, 5, 5, 6 },
	{ "%sʽ򤯤路",                    16, 15, 5, 6, 8 },
	{ "%sǭ޷򤯤路",          20, 20, 5, 8, 0 },
	{ "%sķӤ򤯤路",           24, 25, 6, 8, 10 },
	{ "%s޽򤯤路",       28, 25, 7, 9, 0 },
	{ "%s˲󤷽򤯤路",         32, 30, 8, 10, 10 },
	{ "%sŴ򤯤路",          35, 35, 8, 11, 10 },
	{ "%sӤ򤯤路",         39, 35, 8, 12, 12 },
	{ "%s˾ζ򤯤路",         43, 35, 9, 12, 16 },
	{ "%sŷ÷򤯤路",       48, 40, 10, 13, 18 },
#else
	{ "You punch %s.",                          1, 0, 1, 4, 0 },
	{ "You kick %s.",                           2, 0, 1, 6, 0 },
	{ "You strike %s.",                         3, 0, 1, 7, 0 },
	{ "You hit %s with your knee.",             5, 5, 2, 3, MA_KNEE },
	{ "You hit %s with your elbow.",            7, 5, 1, 8, 0 },
	{ "You butt %s.",                           9, 10, 2, 5, 0 },
	{ "You kick %s.",                           11, 10, 3, 4, MA_SLOW },
	{ "You uppercut %s.",                       13, 12, 4, 4, 6 },
	{ "You double-kick %s.",                    16, 15, 5, 4, 8 },
	{ "You hit %s with a Cat's Claw.",          20, 20, 5, 5, 0 },
	{ "You hit %s with a jump kick.",           25, 25, 5, 6, 10 },
	{ "You hit %s with an Eagle's Claw.",       29, 25, 6, 6, 0 },
	{ "You hit %s with a circle kick.",         33, 30, 6, 8, 10 },
	{ "You hit %s with an Iron Fist.",          37, 35, 8, 8, 10 },
	{ "You hit %s with a flying kick.",         41, 35, 8, 10, 12 },
	{ "You hit %s with a Dragon Fist.",         45, 35, 10, 10, 16 },
	{ "You hit %s with a Crushing Blow.",       48, 35, 10, 12, 18 },
#endif

};

int monk_ave_damage[PY_MAX_LEVEL+1][3] =
{
  {0, 0, 0},
  {249, 249, 249},
  {324, 324, 324},
  {382, 438, 382},
  {382, 439, 382},
  {390, 446, 390},
  {394, 473, 394},
  {425, 528, 425},
  {430, 535, 430},
  {505, 560, 435},
  {517, 575, 444},
  {566, 655, 474},
  {585, 713, 486},
  {653, 843, 527},
  {678, 890, 544},
  {703, 973, 558},
  {765, 1096, 596},
  {914, 1146, 614},
  {943, 1240, 629},
  {971, 1276, 643},
  {1018, 1350, 667},
  {1063, 1464, 688},
  {1099, 1515, 705},
  {1128, 1559, 721},
  {1153, 1640, 735},
  {1336, 1720, 757},
  {1387, 1789, 778},
  {1430, 1893, 794},
  {1610, 2199, 863},
  {1666, 2280, 885},
  {1713, 2401, 908},
  {1755, 2465, 925},
  {1909, 2730, 984},
  {2156, 2891, 1009},
  {2218, 2970, 1031},
  {2319, 3107, 1063},
  {2404, 3290, 1098},
  {2477, 3389, 1125},
  {2544, 3483, 1150},
  {2771, 3899, 1228},
  {2844, 3982, 1259},
  {3129, 4064, 1287},
  {3200, 4190, 1313},
  {3554, 4674, 1432},
  {3614, 4738, 1463},
  {3679, 4853, 1485},
  {3741, 4905, 1512},
  {3785, 4943, 1538},
  {4141, 5532, 1652},
  {4442, 5581, 1679},
  {4486, 5636, 1702},
};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʾ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
#endif

};

kamae kamae_shurui[MAX_KAMAE] =
{
#ifdef JP
	{"", 25, ""},
	{"", 30, ""},
	{"ε", 35, ""},
	{"", 40, ""},
#else
	{"Genbu", 25, "(Black Tortoise) "},
	{"Byakko", 30, "(White Tiger) "},
	{"Seiryuu", 35, "(Blue Dragon) "},
	{"Suzaku", 40, "(Red Phoenix) "},
#endif
};

kamae kata_shurui[MAX_KATA] =
{
#ifdef JP
	{"", 25, ""},
	{"", 30, ""},
	{"ߵ", 35, ""},
	{"̵", 40, ""},
#else
	{"Iai", 25, ""},
	{"Huujin", 30, ""},
	{"Kouki", 35, ""},
	{"Musou", 40, ""},
#endif
};

cptr exp_level_str[5]=
#ifdef JP
{"[鿴]", "[]", "[]", "[ѡ]", "[ã]"};
#else
{"[Unskilled]", "[Beginner]", "[Skilled]", "[Expert]", "[Master]"};
#endif

byte conv_terrain2feat[MAX_WILDERNESS] =
{
  FEAT_PERM_EXTRA,
  FEAT_TOWN,
  FEAT_DEEP_WATER,
  FEAT_SHAL_WATER,
  FEAT_SWAMP,
  FEAT_DIRT,
  FEAT_GRASS,
  FEAT_TREES,
  FEAT_DIRT,
  FEAT_SHAL_LAVA,
  FEAT_DEEP_LAVA,
  FEAT_MOUNTAIN
};

/* Weird melee attack types when hallucinating */
#ifdef JP
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"˾ؤ򤫤줿",
	"ʤβ3äƥȸä",
	"ˤФޤ蘆줿",
	"˷ʤᤵ줿",
	"˥ϥʥФ줿",
	"˥ǹ⤵줿",
	"ʤˤ«ǤФ",
	"ʤǥݡ󥰤򤷤",
	"˥١줿",
	"ˡֿιȯű줿",
	"˥áޤ줿",
	"ˤĤäߤ줿",
	"Ϥʤ٤ä",
	"˴ˤ餯񤭤򤵤줿",
	"˼ڶֺѤ򤻤ޤ줿",
	"˥Ȥ᤯줿",
	"Ϥʤμä",
	"夬줿",
	"鰦ι򤵤줿",
	"Ϥʤ500ߤǸۤä",
	"Ϥʤ100̩ˤĤǮä",
	"˥㡼Ĥ",
	"Ϥʤ˵Ĥ",
	"Ϥʤݥꥴ󲽤",
	"˾줿",
	"ϥƥޤμʸ򾧤",
	"ϤʤΥѥ֥å",
	"ϥ饤ɰư",
	"ϾζޥɤϤ˼Ԥ",
	"ϳȻưˤȯͤ",
	"ϥǥ顼ˡ򤷤",
	"˥饤åǹ⤵줿",
	"󽵴ְǥӥǥͤ˸ʤȻ̼򤫤줿",
	"ϥѥץƤ򾧤",
	"ϥѡȥ饮饯ƥޥʥä",
	"ˤ㤬߾åǥϥ줿",
	"˥åȥȥ꡼ॢå򤫤줿",
	"ϤʤĸǤ򤫤ơ123áפȶ",
	"ϡ֤ʤФФФפȤäƶФ",
	"֤󡢥롼٥󥹤γפȸäŤܤĤ",
	"ϸäѶܡ仿桪",
};

/* Note: %s for strfmt() */
cptr silly_attacks2[MAX_SILLY_ATTACK] =
{
	"%s˾ؤ򤫤",
	"%sβ3äƥȸä",
	"%s򤷤Фޤ路",
	"%s˷ʤᤵ",
	"%s˥ϥʥФ",
	"%s򥸥ǹ⤷",
	"%sˤ«ǤФ",
	"%sǥݡ󥰤򤷤",
	"%s˥١",
	"%sˡֿιȯű᤿",
	"%s˥áޤ",
	"%sˤĤäߤ줿",
	"%s٤ä",
	"%sδˤ餯񤭤򤷤",
	"%s˼ڶֺѤ򤻤ޤä",
	"%sΥȤ᤯ä",
	"%sμä",
	"%s夬ä",
	"%s˰ι򤷤",
	"%s500ߤǸۤä",
	"%s100̩ˤĤǮä",
	"˥㡼Ĥ",
	"%s˵Ĥ",
	"%sݥꥴ󲽤",
	"%s򾯤ä",
	"ƥޤμʸ򾧤",
	"%sΥѥ֥å",
	"饤ɰư",
	"ζޥɤϤ˼Ԥ",
	"%s˳Ȼưˤȯͤ",
	"%s˥ǥ顼ˡ򤷤",
	"%s饤åǹ⤷",
	"%s󽵴ְǥӥǥͤ˸ʤȻ̼򤫤",
	"ѥץƤ򾧤",
	"%s˥ѡȥ饮饯ƥޥʥä",
	"%s򤷤㤬߾åǥϥ᤿",
	"%s˥åȥȥ꡼ॢå򤫤",
	"%sĸǤ򤫤ơ123áפȶ",
	"֤ʤФФФפȤäƶФ",
	"֤󡢥롼٥󥹤γפȸäŤܤĤ",
	"äѶܡ仿桪",
};
#else
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests",
	"pusupusu",
};
#endif


/*
 * The table of "symbol info" -- each entry is a string of the form
 * "X:desc" where "X" is the trigger, and "desc" is the "info".
 */
cptr ident_info[] =
{
#ifdef JP
	" :Ű",
	"!:, ",
	"\":ߥå, ",
	"#:(ɥ)/ʪ/",
	"$:(⤫)",
	"%:̮(ϴ䤫б)",
	"&:Ȣ",
	"':ɥ",
	"(:餫ɶ",
	"):",
	"*:ޤ̮ޤϵβʪ",
	"+:Ĥɥ",
	",:ʪ, ФΥ",
	"-:ˡ, å",
	".:",
	"/:Ⱦ(å/ѥ/)",
	"0:ʪۤ",
	"1:߲",
	"2:ɶ񲰤",
	"3:Ź",
	"4:",
	"5:ϣѤŹ",
	"6:ˡŹ",
	"7:֥åޡåȤ",
	"8:椬Ȥ",
	"9:Ź",
	"::",
	";:Ħ/ȯΥ롼",
	"<:곬",
	"=:",
	">:곬",
	"?:ʪ",
	"@:ץ쥤䡼",
	"A:ŷ",
	"B:Ļ",
	"C:",
	"D:ɥ饴/磻",
	"E:󥿥",
	"F:ȥ",
	"G:",
	"H:",
	"I:",
	"J:إ",
	"K:顼ӡȥ",
	"L:å",
	"M:¿",
	"N:ʪ",
	"O:",
	"P:ʹַʪ",
	"Q:륹륰(̮Ǥ)",
	"R:/ξ",
	"S://",
	"T:ȥ",
	"U:ǡ",
	"V:Хѥ",
	"W:磻/쥤/",
	"X://",
	"Y:ƥ",
	"Z:ϥ",
	"[:ޡ",
	"\\:ߴ(ᥤ//)",
	"]:ɶ",
	"^:ȥå",
	"_:",
	"`:ͷĦ",
	"a:",
	"b:",
	"c:५",
	"d:ɥ饴",
	"e:ܶ",
	"f:ͥ",
	"g:",
	"h:ۥӥå//ɥ",
	"i:٥ȥ٥",
	"j:꡼",
	"k:ܥ",
	"l:ʪ",
	"m:",
	"n:ʡ",
	"o:",
	"p:ʹ",
	"q:­",
	"r:ͥ",
	"s:ȥ",
	"t:Įο",
	"u:ǡ",
	"v:ܥƥå",
	"w:ॷ/緲",
	/* "x:unused", */
	"y:",
	"z:/ߥ",
	"{:ƻ(/)",
	"|:(//)",
	"}:ƻ(/ܥ/)",
	"~:/ϴή(Υƥ)",
#else
	" :A dark grid",
	"!:A potion (or oil)",
	"\":An amulet (or necklace)",
	"#:A wall (or secret door) / a plant / a gas",
	"$:Treasure (gold or gems)",
	"%:A vein (magma or quartz)",
	"&:A chest",
	"':An open door",
	"(:Soft armor",
	"):A shield",
	"*:A vein with treasure or a ball monster",
	"+:A closed door",
	",:Food (or mushroom patch)",
	"-:A wand (or rod)",
	".:Floor",
	"/:A polearm (Axe/Pike/etc)",
	"0:Entrance to Museum",
	"1:Entrance to General Store",
	"2:Entrance to Armory",
	"3:Entrance to Weaponsmith",
	"4:Entrance to Temple",
	"5:Entrance to Alchemy shop",
	"6:Entrance to Magic store",
	"7:Entrance to Black Market",
	"8:Entrance to your home",
	"9:Entrance to the bookstore",
	"::Rubble",
	";:A glyph of warding / an explosive rune",
	"<:An up staircase",
	"=:A ring",
	">:A down staircase",
	"?:A scroll",
	"@:You",
	"A:Angel",
	"B:Bird",
	"C:Canine",
	"D:Ancient Dragon/Wyrm",
	"E:Elemental",
	"F:Dragon Fly",
	"G:Ghost",
	"H:Hybrid",
	"I:Insect",
	"J:Snake",
	"K:Killer Beetle",
	"L:Lich",
	"M:Multi-Headed Reptile",
	"N:Mystery Living",
	"O:Ogre",
	"P:Giant Humanoid",
	"Q:Quylthulg (Pulsing Flesh Mound)",
	"R:Reptile/Amphibian",
	"S:Spider/Scorpion/Tick",
	"T:Troll",
	"U:Major Demon",
	"V:Vampire",
	"W:Wight/Wraith/etc",
	"X:Xorn/Xaren/etc",
	"Y:Yeti",
	"Z:Zephyr Hound",
	"[:Hard armor",
	"\\:A hafted weapon (mace/whip/etc)",
	"]:Misc. armor",
	"^:A trap",
	"_:A staff",
	"`:A figurine or statue",
	"a:Ant",
	"b:Bat",
	"c:Centipede",
	"d:Dragon",
	"e:Floating Eye",
	"f:Feline",
	"g:Golem",
	"h:Hobbit/Elf/Dwarf",
	"i:Icky Thing",
	"j:Jelly",
	"k:Kobold",
	"l:Aquatic monster",
	"m:Mold",
	"n:Naga",
	"o:Orc",
	"p:Person/Human",
	"q:Quadruped",
	"r:Rodent",
	"s:Skeleton",
	"t:Townsperson",
	"u:Minor Demon",
	"v:Vortex",
	"w:Worm/Worm-Mass",
	/* "x:unused", */
	"y:Yeek",
	"z:Zombie/Mummy",
	"{:A missile (arrow/bolt/shot)",
	"|:An edged weapon (sword/dagger/etc)",
	"}:A launcher (bow/crossbow/sling)",
	"~:Fluid terrain (or miscellaneous item)",
#endif

	NULL
};


/*
 * The table of monsters' blow effects
 */
mbe_info_type mbe_info[] =
{
	{  0, 0,             }, /* None      */
	{ 60, GF_MISSILE,    }, /* HURT      */
	{  5, GF_POIS,       }, /* POISON    */
	{ 20, GF_DISENCHANT, }, /* UN_BONUS  */
	{ 15, GF_MISSILE,    }, /* UN_POWER  */ /* ToDo: Apply the correct effects */
	{  5, GF_MISSILE,    }, /* EAT_GOLD  */
	{  5, GF_MISSILE,    }, /* EAT_ITEM  */
	{  5, GF_MISSILE,    }, /* EAT_FOOD  */
	{  5, GF_MISSILE,    }, /* EAT_LITE  */
	{  0, GF_ACID,       }, /* ACID      */
	{ 10, GF_ELEC,       }, /* ELEC      */
	{ 10, GF_FIRE,       }, /* FIRE      */
	{ 10, GF_COLD,       }, /* COLD      */
	{  2, GF_MISSILE,    }, /* BLIND     */
	{ 10, GF_CONFUSION,  }, /* CONFUSE   */
	{ 10, GF_MISSILE,    }, /* TERRIFY   */
	{  2, GF_MISSILE,    }, /* PARALYZE  */
	{  0, GF_MISSILE,    }, /* LOSE_STR  */
	{  0, GF_MISSILE,    }, /* LOSE_INT  */
	{  0, GF_MISSILE,    }, /* LOSE_WIS  */
	{  0, GF_MISSILE,    }, /* LOSE_DEX  */
	{  0, GF_MISSILE,    }, /* LOSE_CON  */
	{  0, GF_MISSILE,    }, /* LOSE_CHR  */
	{  2, GF_MISSILE,    }, /* LOSE_ALL  */
	{ 60, GF_ROCKET,     }, /* SHATTER   */
	{  5, GF_MISSILE,    }, /* EXP_10    */
	{  5, GF_MISSILE,    }, /* EXP_20    */
	{  5, GF_MISSILE,    }, /* EXP_40    */
	{  5, GF_MISSILE,    }, /* EXP_80    */
	{  5, GF_POIS,       }, /* DISEASE   */
	{  5, GF_TIME,       }, /* TIME      */
	{  5, GF_MISSILE,    }, /* EXP_VAMP  */
	{  5, GF_MANA,       }, /* DR_MANA   */
	{ 60, GF_MISSILE,    }, /* SUPERHURT */
};
