﻿#include "store/store-owners.h"
#include "player/player-race-types.h"

/*!
 * todo _() でまとめる
 */
const owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
		/*
		  Raistlin は dragonlance の powerful wizard 。
		  Rincewind the Chicken は Terry Pratchett の Discworld の登場人物 上記のパロディ？、
		  { "憶病者ラストリン",       200,    175,  108,   4,  12,  RACE_HUMAN},
		  { "Raistlin the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		*/

#ifdef JP
		{ "フレンドリーなビルボ",       200,    170,  108,   5,  15,  RACE_HOBBIT},
		{ "憶病者リンスウィンド",       200,    175,  108,   4,  12,  RACE_HUMAN},
		{ "背の低いサルタン",             300,    170,  107,   5,  15,  RACE_GNOME},
		{ "ハンサムなライア=エル",      300,    165,  107,   6,  18,  RACE_ELF},
		{ "親切なファリルマウエン",         250,    170, 108,  5, 15, RACE_HOBBIT},
		{ "臆病者ヴォワラン",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "チビのエラシュナク",          750,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "ハンサムなグラッグ",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "ケチなフォロビア",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "馬鹿のエリス",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "腹ペコのフィルバート",          750,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "スナーグル・サシグア",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "長死きエロワーズ",         250,    170, 108,  5, 15, RACE_SPECTRE},
		{ "ノロマのフンディ",       500,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "グランサス",          750,    170, 107,  5, 15, RACE_SKELETON},
		{ "丁寧なロラックス",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "ブッチ",         250,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "美しきエルベレス",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "こそこそサーレス",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "ナーロック",        1000,    165, 107,  6, 18, RACE_DWARF},
		{ "チビのヘイネッカ",         250,    170, 108,  5, 15, RACE_GNOME},
		{ "きちがいロワラン",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "毒息のウート",          750,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "でぶっちょアラァカ",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "低能なプーゴー",         250,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "フェロールフィリアン",       500,    175, 108,  4, 12, RACE_ELF},
		{ "年寄りマロカ",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "勇敢なサシン",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "田舎者アビエマール",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "貧乏なハーク",       500,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "みじめなソアリン",          750,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "質素なメルラ",        1000,    165, 107,  6, 18, RACE_ELF},
#else
		{ "Bilbo the Friendly",         200,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",          300,    170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",         300,    165, 107,  6, 18, RACE_ELF},
		{ "Falilmawen the Friendly",         250,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Voirin the Cowardly",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "Erashnak the Midget",          750,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "Grug the Comely",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "Forovir the Cheap",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "Ellis the Fool",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "Filbert the Hungry",          750,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "Fthnargl Psathiggua",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "Eloise Long-Dead",         250,    170, 108,  5, 15, RACE_SPECTRE},
		{ "Fundi the Slow",       500,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "Granthus",          750,    170, 107,  5, 15, RACE_SKELETON},
		{ "Lorax the Suave",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "Butch",         250,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "Elbereth the Beautiful",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "Sarleth the Sneaky",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "Narlock",        1000,    165, 107,  6, 18, RACE_DWARF},
		{ "Haneka the Small",         250,    170, 108,  5, 15, RACE_GNOME},
		{ "Loirin the Mad",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "Wuto Poisonbreath",          750,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "Araaka the Rotund",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "Poogor the Dumb",         250,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "Felorfiliand",       500,    175, 108,  4, 12, RACE_ELF},
		{ "Maroka the Aged",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "Sasin the Bold",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "Abiemar the Peasant",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "Hurk the Poor",       500,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "Soalin the Wretched",          750,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "Merulla the Humble",        1000,    165, 107,  6, 18, RACE_ELF},
#endif
	},
	{
		/* Armoury - 28 unique names */
#ifdef JP
		{ "醜悪コン=ダー",      5000,   210,  115,   5,   7,  RACE_HALF_ORC},
		{ "頑固者ダーグ=ロウ",  10000,  190,  111,   4,   9,  RACE_HUMAN},
		{ "賢者デカド",                 25000,  200,  112,   4,  10,  RACE_DUNADAN},
		{ "鍛冶屋のウィーランド",   30000,  200,  112,   4,   5,  RACE_DWARF},
		{ "醜悪コン=ダー",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "頑固者ダーグ=ロウ",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ハンサムなデカド",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "エロー・ドラゴンスケイル",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "デリカトス",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "巨大なグルース",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "アニムス",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "マルヴァス",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "セラクシス",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "デス・チル",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "微かなドリオス",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "冷たいバスリック",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "冷酷ヴェンジェラ",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "強者ウィラナ",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ヨジョ二世",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "優しいラナラー",          30000,  200, 112,  4,  5, RACE_AMBERITE},
		{ "不浄のホルバグ",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "テレパスのエレレン",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "イスドリリアス",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "一つ目ヴェグナー",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "混沌のロディッシュ",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "剣豪ヘジン",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "ずる屋のエルベレリス",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "インプのザサス",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "醜悪コン=ダー",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "頑固者ダーグ=ロウ",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ハンサムなデカド",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "鍛冶屋のウィーランド",          30000,  200, 112,  4,  5, RACE_DWARF},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
		{ "Kon-Dar the Ugly",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "Elo Dragonscale",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "Delicatus",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "Gruce the Huge",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "Animus",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "Malvus",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "Selaxis",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "Deathchill",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "Drios the Faint",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "Bathric the Cold",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "Vengella the Cruel",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "Wyrana the Mighty",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Yojo II",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "Ranalar the Sweet",          30000,  200, 112,  4,  5, RACE_AMBERITE},
		{ "Horbag the Unclean",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Elelen the Telepath",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "Isedrelias",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "Vegnar One-eye",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "Rodish the Chaotic",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "Hesin Swordmaster",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "Elvererith the Cheat",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "Zzathath the Imp",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif
	},

	{
		/* Weapon Smith - 28 unique names */
#ifdef JP
		{ "残忍なるアーノルド",        5000,   210,  115,   6,   6,  RACE_HALF_TROLL},
		{ "獣殺しのアーンダル", 10000,  185,  110,   5,   9,  RACE_HALF_ELF},
		{ "獣マスターのエディー", 25000,  190,  115,   5,   7,  RACE_HOBBIT},
		{ "竜殺しのオグライン", 30000,  195,  112,   4,   8,  RACE_DWARF},
		{ "熟練者ドリュー",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{ "龍の子オラックス",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "病気持ちのアンスラックス",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "頑丈者アルコス",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "腐れ者のサリアス",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{ "晒し骨のトゥエシク",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "ビリオス",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ファスガル",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "パラディンのエレフリス",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "キ'トリッ'ク",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "蜘蛛の友ドゥロカス",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "巨人殺しのフングス",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "デランサ",      10000,   210, 115,  6,  6, RACE_ELF},
		{ "レンジャーのソルビスタニ",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ノロマのゾリル",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "イーオン・フラックス",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "強者ナドック",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{ "弱虫エラモグ",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "公正なエオウィリス",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "バルログ殺しのヒュイモグ",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "冷酷ピーダス",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "ヴァモグ スレイヤー",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "性悪フーシュナク",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "舞闘バレン",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ "残忍なるアーノルド",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "獣殺しのアーンダル",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ビーストマスター・エディー",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "竜殺しのオグライン",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Drew the Skilled",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{ "Orrax Dragonson",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "Anthrax Disease-Carrier",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Arkhoth the Stout",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Sarlyas the Rotten",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{ "Tuethic Bare-Bones",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "Bilious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Fasgul",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "Ellefris the Paladin",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "K'trrik'k",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "Drocus Spiderfriend",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "Fungus Giant-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Delantha",      10000,   210, 115,  6,  6, RACE_ELF},
		{ "Solvistani the Ranger",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Xoril the Slow",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "Aeon Flux",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "Nadoc the Strong",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{ "Eramog the Weak",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "Eowilith the Fair",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "Huimog Balrog-Slayer",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "Peadus the Cruel",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "Vamog Slayer",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "Hooshnak the Vicious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Balenn War-Dancer",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
	},
	{
		/* Temple - 22 unique names */
#ifdef JP
		{ "質素なルードヴィヒ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "パラディンのガンナー",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "選ばれしトリン",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "賢明なるサラストロ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
		{ "パーシヴァル卿",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "神聖なるアセナス",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "マッキノン",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "謹み婦人",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ドルイドのハシュニック",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "フィナク",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "クリキック",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "荒くれ者モリヴァル",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "暗きホシャック",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "賢者アタール",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "清きイベニッド",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "エリディシュ",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "呪術師ヴルドゥシュ",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "狂戦士ハオブ",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "若きプルーグディシュ",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "きちがいラムワイズ",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "有徳者ムワート",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "弱虫ダードバード",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "質素なルードヴィヒ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "パラディンのガンナー",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "選ばれしトリン",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "賢明なるサラストロ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
		{ "パーシヴァル卿",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "神聖なるアセナス",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "マッキノン",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "謹み婦人",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ドルイドのハシュニック",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "フィナク",          30000,  185, 109,  5, 15, RACE_YEEK},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "Krikkik",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "Morival the Wild",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "Hoshak the Dark",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "Atal the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Ibenidd the Chaste",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Eridish",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Vrudush the Shaman",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "Haob the Berserker",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "Proogdish the Youthfull",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "Lumwise the Mad",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "Muirt the Virtuous",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "Dardobard the Weak",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif
	},
	{
		/* Alchemist - 26 unique names */
#ifdef JP
		{ "化学者マウザー",             10000,  190,  111,   5,   8,  RACE_HALF_ELF},
		{ "カオスのウィズル",   10000,  190,  110,   6,   8,  RACE_HOBBIT},
		{ "強欲ミダス",              15000,  200,  116,   6,   9,  RACE_GNOME},
		{ "貧弱ジャ=ファー",                   15000,  220,  111,   4,   9,  RACE_ELF},/*FIRST*/
		{ "カカルラカカル",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "錬金術師ジャル=エス",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "用心深いファネラス",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "キチガイのルンシー",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "グランブルワース",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "フリッター",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "ザリルス",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "古きエグバート",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "誇り高きヴァリンドラ",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "錬金術師タエン",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "巧言カイド",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "暗きフリア",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "質素なドムリ",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "魔の子ヤァジュッカ",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "薬草師ジェララルドール",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "賢者オレラルダン",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "デモニシストのフゾグロ",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "錬金術師ドゥリアシュ",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "強者ネリア",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "辛口リグナス",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "ティルバ",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "金持ちミリルドリック",       15000,  220, 111,  4,  9, RACE_HUMAN},

		{ "科学者マウザー",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "カオスのウィズル",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "強欲ミダス",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "錬金術師ジャ=ファー",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "カカルラカカル",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "錬金術師ジャル=エス",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Fanelath the Cautious",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "Runcie the Insane",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "Grumbleworth",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Flitter",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "Xarillus",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "Egbert the Old",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "Valindra the Proud",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "Taen the Alchemist",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "Cayd the Sweet",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "Fulir the Dark",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "Domli the Humble",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "Yaarjukka Demonspawn",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "Gelaraldor the Herbmaster",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "Olelaldan the Wise",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "Fthoglo the Demonicist",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "Dridash the Alchemist",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "Nelir the Strong",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "Lignus the Pungent",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "Tilba",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "Myrildric the Wealthy",       15000,  220, 111,  4,  9, RACE_HUMAN},

		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
	},

	{
		/* Magic Shop - 23 unique names */
#ifdef JP
		{ "ソーサラーのロ=パン",       20000,  200,  110,   7,   8,  RACE_HALF_ELF},
		{ "偉大なるブガービイ",         20000,  215,  113,   6,  10,  RACE_GNOME},
		{ "イェンダーの魔法使い",     30000,  200,  110,   7,  10,  RACE_HUMAN},
		{ "死霊使いリャク",30000,      175,  110,   5,  11,  RACE_HIGH_ELF},
		{ "魔術師スキドゥニー",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "幻術師キリア",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "死霊術師ニッキ",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ソロストラン",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "烏賊口アチシェ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "貴族のカザ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "暗きファジル",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "偉大なるケルドーン",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "フィランスロプス",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "魔女のアグナー",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "死霊術師ビュリアンス",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "ハイメイジのヴイラク",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "知恵者マディッシュ",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "ファレブリンボール",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "陰険フェリル=ガンド",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "呪術師サレゴード",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "神秘家クトゥアロス",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "幻術師イベリ",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "死霊術師ヘトー",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "魔術師ロ=パン",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "偉大なるブガービイ",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "イェンダーの魔法使い",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "死霊術師リャク",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "魔術師スキドゥニー",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "幻術師キリア",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "死霊術師ニッキ",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ソロストラン",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "烏賊口アチシェ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Kaza the Noble",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Fazzil the Dark",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Keldorn the Grand",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "Philanthropus",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "Agnar the Enchantress",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Buliance the Necromancer",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "Vuirak the High-Mage",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "Madish the Smart",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "Falebrimbor",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Felil-Gand the Subtle",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Thalegord the Shaman",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "Cthoaloth the Mystic",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Ibeli the Illusionist",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "Heto the Necromancer",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
	},
	{
		/* Black Market - 32 unique names */
#ifdef JP
		{ "ガリー=ギガズ",            20000,  250,  150,  10,   5,  RACE_HALF_TROLL},
		{ "ゴブリンのヒストーア",       20000,  250,  150,  10,   5,  RACE_HALF_ORC},
		{ "フェレンギ人クアーク",           30000,  250,  150,  10,   5,  RACE_HUMAN},
		{ "公正なる(?)トッピ",                     30000,  250,  150,  10,   5,  RACE_ELF},
		{ "死人ヴァッサ",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "裏切り者カイン",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "ブボニカス",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "コープスライト",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "血に飢えしパリッシュ",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "ヴァイル",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "信頼のプレンティス",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "人間殺しのグリエラ",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "エンジェル",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "水膨れフロツァム",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "ニーヴァル",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "明るいアナスタシア",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "死霊術師チャリティー", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "ボクサーのプグナシオス",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "幸運なフットソア",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "光指のシドリア",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "手品師リアソー",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "やりくり上手のジャナッカ",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "悪党シーナ",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "大爪アルニッキ",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "貧乏チャエアンド",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "山賊アファードーフ",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "強欲ラザクスル",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "ファラレウィン",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "しわしわヴォスール",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "ハンサムなアラオード",          20000,  250, 150, 10,  5, RACE_AMBERITE},
		{ "負け犬セラドフリド",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "片足のエルーロ",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#else
		{ "Gary Gygaz",                 20000,  250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Quark the Ferengi",          30000,  250, 150, 10,  5, RACE_DWARF},
		{ "Topi the Fair(?)",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Vhassa the Dead",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Kyn the Treacherous",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Bubonicus",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Corpselight",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Parrish the Bloodthirsty",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Vile",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Prentice the Trusted",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Griella Humanslayer",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "Angel",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Flotsam the Bloated",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Nieval",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Anastasia the Luminous",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Charity the Necromancer", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "Pugnacious the Pugilist",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Footsore the Lucky",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Sidria Lighfingered",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Riatho the Juggler",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "Janaaka the Shifty",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "Cina the Rogue",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "Arunikki Greatclaw",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "Chaeand the Poor",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Afardorf the Brigand",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "Lathaxl the Greedy",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "Falarewyn",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "Vosur the Wrinkled",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "Araord the Handsome",          20000,  250, 150, 10,  5, RACE_AMBERITE},
		{ "Theradfrid the Loser",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "One-Legged Eroolo",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#endif
	},
	{
		/* Home */
#ifdef JP
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
		{ "我が家",                          0,      100, 100,  0, 99, 99},
#else
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
#endif

	},

	{
		/* Bookstore - 21 unique names */
#ifdef JP
		{ "強欲ドラフ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "賢者オドナー", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "中立のガンダー", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "忍耐の人ロ=シャ", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ランドルフ・カーター", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "隼のサライ", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "千里眼ボドリル", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "沈黙のヴェオロイン", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "学者のヴァンシラス", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "物書きオセイン", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "本の虫オルヴァー", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "浅井墓男", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "デスマスク", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "学者のアスーヌ", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "死人のプリランド", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "鉄のロナール", 25000, 120, 110, 7, 19, RACE_GOLEM},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "Shallowgrave", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Death Mask", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "Asuunu the Learned", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "Prirand the Dead", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "Ronar the Iron", 25000, 120, 110, 7, 19, RACE_GOLEM},
#endif
#ifdef JP
		{ "ガリル=ガミル", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "本食いローバグ", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "キリアリキーク", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "静かなるリリン", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "王者イサング", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "強欲ドラフ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "賢者オドナー", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "中立のガンダー", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "忍耐の人ロ=シャ", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ランドルフ・カーター", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "隼サライ", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "千里眼ボドリル", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "沈黙のヴェオロイン", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "学者のヴァンシラス", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "物書きオセイン", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "本の虫オルヴァー", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Galil-Gamir", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Rorbag Book-Eater", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "Kiriarikirk", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "Rilin the Quiet", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "Isung the Lord", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif
	},

	{
		/* Museum */
#ifdef JP
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
		{ "博物館",                          0,      100, 100,  0, 99, 99},
#else
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
#endif
	},
};
