﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Interface.h
	momiji interface.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

using namespace System::Runtime;

namespace Momiji{
namespace Core {

	public interface class IData
	{
	};

	public interface class IPacket
	{
		property IData^ data{ IData^ get(); };
		property System::UInt64 tick{ System::UInt64 get(); };
	};

	public interface class IStreamPacket
		: public IPacket
	{
		property IStreamPacket^ next{ IStreamPacket^ get(); };
		property System::Boolean hasNext{ System::Boolean get(); };
	};

	public interface class ITrack
	{
		void Rewind();
		array<IStreamPacket^>^ GetStreamPacket(System::Double deltaTime);
		property IStreamPacket^ head{ IStreamPacket^ get(); };
	};

	public interface class IStream
	{
		array<IStreamPacket^>^ GetStreamPacket(System::Double deltaTime);
		void Rewind();
	};

	public interface class ITimer
	{
		void Start(System::UInt32 period);
		void Stop();
		delegate void Event(const System::Double deltaTime);
		event Event^ OnInterval;
	};

	public interface class IOut
	{
		void Send(IData^ data);
	};
}
}
