﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.cpp
	kernel streaming.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Interop.Kernel32.h"
#include "Momiji.Interop.Ks.h"

#include "Momiji.Core.Ks.h"

namespace Momiji {
namespace Core {
namespace Ks {

	Overlapped::Overlapped()
	:	_waitHandle(gcnew System::Threading::ManualResetEvent(false))
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->_overlapped.EventHandle = this->_waitHandle->SafeWaitHandle->DangerousGetHandle();
		this->_overlappedHandle = InteropServices::GCHandle::Alloc(this->_overlapped);
	}

	Overlapped::~Overlapped()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Overlapped();
	}

	Overlapped::!Overlapped()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		if (this->_overlappedHandle.IsAllocated)
		{
			this->_overlappedHandle.Free();
		}
		delete _overlapped;
		delete _waitHandle;
	}

	void Overlapped::Reset()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->_waitHandle->Reset();
	}


	Irp::Irp()
		: _handle(Open())
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}

	Irp::~Irp()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Irp();
	}

	Irp::!Irp()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->Close();
	}

	void Irp::Close()
	{
		if (this->_handle == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] Handle is null",__FUNCTION__);
			#endif
			return;
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] Handle invalid:{1} closed:{2}",__FUNCTION__, this->_handle->IsInvalid, this->_handle->IsClosed);
		#endif
		if (
			!this->_handle->IsInvalid
		&&	!this->_handle->IsClosed
		)
		{
			this->_handle->Close();
		}
		else
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] openしていない状態なので、無視します。", __FUNCTION__);
			#endif
		}

	}

	System::UInt32 Irp::IOSync(
		Interop::Ks::IOCTL_KS ioControlCode,
		System::IntPtr inBuffer,
		System::UInt32 inBufferSize,
		System::IntPtr outBuffer,
		System::UInt32 outBufferSize,
		System::UInt32% bytesReturned
	)
	{
	#ifdef _DEBUG
		System::Console::WriteLine("[{0}] ioControlCode {1}",__FUNCTION__, ioControlCode);
	#endif
		if (this == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] this is null",__FUNCTION__);
				System::Console::WriteLine("=========================================================");
			#endif
			return 0;
		}

		if (this->_handle->IsInvalid || this->_handle->IsClosed)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] Handle invalid:{1} closed:{2}",__FUNCTION__, this->_handle->IsInvalid, this->_handle->IsClosed);
				System::Console::WriteLine("=========================================================");
			#endif
			return 0;
		}
		
		auto o = gcnew Overlapped();
		try
		{
			if (!Interop::Ks::Function::DeviceIoControl(
					this->_handle, 
					ioControlCode,
					inBuffer, 
					inBufferSize, 
					outBuffer, 
					outBufferSize, 
					bytesReturned,
					o->overlapped
			)) {
				auto error = InteropServices::Marshal::GetHRForLastWin32Error();
				//System::Console::WriteLine("[{0}] error {1} pulBytesReturned {2}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString(), bytesReturned);

				if (error != 0x800703E5)//ERROR_IO_PENDING
				{
					System::Console::WriteLine("[{0}] DeviceIoControl error {1}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
					return error;
				}

				if (!Interop::Ks::Function::GetOverlappedResult(
						this->_handle, 
						o->overlapped,
						bytesReturned,
						true
				)) {
					auto error = InteropServices::Marshal::GetHRForLastWin32Error();
					System::Console::WriteLine("[{0}] GetOverlappedResult error {1}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
					return error;
				}

				System::Console::WriteLine(
					"[{0}] over rapped InternalHigh[{1}] InternalLow[{2}] OffsetHigh[{3}] OffsetLow[{4}]",
					__FUNCTION__, 
					o->overlapped.InternalHigh,
					o->overlapped.InternalLow,
					o->overlapped.OffsetHigh,
					o->overlapped.OffsetLow
				);
			}
			System::Console::WriteLine("[{0}] pendding {1}",__FUNCTION__, o->pendding);
			return 0;
		}
		finally
		{
			delete o;
		}
	}

	/*
	System::UInt32 Irp::DeviceIoControlSync(
		Interop::Ks::IOCTL_KS ioControlCode,
		System::IntPtr inBuffer,
		System::UInt32 inBufferSize,
		System::IntPtr outBuffer,
		System::UInt32 outBufferSize,
		System::UInt32% bytesReturned
	)
	{
	#ifdef _DEBUG
	//	System::Console::WriteLine("[{0}] ioControlCode {1}",__FUNCTION__, ioControlCode);
	#endif

		if (this == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] this is null",__FUNCTION__);
				System::Console::WriteLine("=========================================================");
			#endif
			return 0;
		}

		if (this->_handle->IsInvalid || this->_handle->IsClosed)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] Handle invalid:{1} closed:{2}",__FUNCTION__, this->_handle->IsInvalid, this->_handle->IsClosed);
				System::Console::WriteLine("=========================================================");
			#endif
			return 0;
		}
		
		auto error = 
			Interop::Ks::Function::KsSynchronousDeviceControl(
				this->_handle, 
				ioControlCode,
				inBuffer, 
				inBufferSize, 
				outBuffer, 
				outBufferSize, 
				bytesReturned
			);
		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] error {1} pulBytesReturned {2}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error), bytesReturned);
		#endif
		return error;
	}
	*/

	generic<typename IN>
	System::UInt32 Irp::IOSync(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in,
		System::IntPtr outBuffer,
		System::UInt32 outBufferSize,
		System::UInt32% bytesReturned
	)
	{
		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] in {1}",__FUNCTION__, in);
		#endif

		auto inBufferSize = InteropServices::Marshal::SizeOf(IN::typeid);
		auto inBuffer = InteropServices::Marshal::AllocHGlobal(inBufferSize);
		//System::Console::WriteLine("[{0}] inBufferSize {1}",__FUNCTION__, inBufferSize);

		InteropServices::Marshal::StructureToPtr(in, inBuffer, false);

		try
		{
			return
				this->IOSync(
					ioControlCode,
					inBuffer, 
					inBufferSize, 
					outBuffer, 
					outBufferSize, 
					bytesReturned
				);
		}
		finally
		{
			InteropServices::Marshal::FreeHGlobal(inBuffer);
		}
	}

	generic<typename IN, typename OUT>
	System::UInt32 Irp::IOSync(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in,
		OUT% out
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
			System::Console::WriteLine("[{0}] {1}",__FUNCTION__, in);
		#endif

		auto outBufferSize = InteropServices::Marshal::SizeOf(OUT::typeid);
		auto outBuffer = InteropServices::Marshal::AllocHGlobal(outBufferSize);
		InteropServices::Marshal::StructureToPtr(out, outBuffer, false);

		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] outBufferSize {1}",__FUNCTION__, outBufferSize);
		#endif

		System::UInt32 bytesReturned = 0;

		try
		{
			auto error =
				this->IOSync<IN>(
					ioControlCode,
					in,
					outBuffer,
					outBufferSize,
					bytesReturned
				);

			if (error != 0)
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] error",__FUNCTION__);
					System::Console::WriteLine("=========================================================");
				#endif
				return error;
			}

			out = safe_cast<OUT>(InteropServices::Marshal::PtrToStructure(outBuffer, OUT::typeid));
			#ifdef _DEBUG
			//	System::Console::WriteLine("[{0}] out {1}",__FUNCTION__, out);
			//	System::Console::WriteLine("=========================================================");
			#endif

			return 0;
		}
		finally
		{
			InteropServices::Marshal::FreeHGlobal(outBuffer);
		}
	}

	generic<typename IN, typename OUT>
	Irp::Tuple<OUT>^ Irp::GetSingle(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
			System::Console::WriteLine("[{0}] {1}",__FUNCTION__, in);
		#endif

		auto outBufferSize = InteropServices::Marshal::SizeOf(OUT::typeid);
		auto outBuffer = InteropServices::Marshal::AllocHGlobal(outBufferSize);

		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] outBufferSize {1}",__FUNCTION__, outBufferSize);
		#endif

		System::UInt32 bytesReturned = 0;

		try
		{
			auto error =
				this->IOSync<IN>(
					ioControlCode,
					in,
					outBuffer,
					outBufferSize,
					bytesReturned
				);

			if (error != 0)
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] null",__FUNCTION__);
					System::Console::WriteLine("=========================================================");
				#endif
				return nullptr;
			}

			OUT out = safe_cast<OUT>(InteropServices::Marshal::PtrToStructure(outBuffer, OUT::typeid));
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] out {1}",__FUNCTION__, out);
				System::Console::WriteLine("=========================================================");
			#endif

			return gcnew Tuple<OUT>(out);
		}
		finally
		{
			InteropServices::Marshal::FreeHGlobal(outBuffer);
		}
	}

	generic<typename IN>
	System::UInt32 Irp::Put(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in,
		System::UInt32% bytesReturned
	)
	{
		return
			this->IOSync<IN>(
				ioControlCode,
				in,
				System::IntPtr::Zero,
				0,
				bytesReturned
			);
	}

	generic<typename IN, typename OUT>
	array<OUT>^ Irp::GetMultiple(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
			System::Console::WriteLine("[{0}] {1}",__FUNCTION__, in);
		#endif

		System::UInt32 bytesReturned = 0;

		auto error =
			this->Put<IN>(
				ioControlCode,
				in,
				bytesReturned
			);

		if (error != 0x800700EA)//ERROR_MORE_DATA
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] null",__FUNCTION__);
				System::Console::WriteLine("=========================================================");
			#endif
			return nullptr;
		}

		auto outBufferSize = bytesReturned;
		auto outBuffer = InteropServices::Marshal::AllocHGlobal(outBufferSize);

		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] outBufferSize {1}",__FUNCTION__, outBufferSize);
		#endif

		try
		{
			auto error =
				this->IOSync<IN>(
					ioControlCode,
					in,
					outBuffer,
					outBufferSize,
					bytesReturned
				);
			#ifdef _DEBUG
			//	System::Console::WriteLine("[{0}] outBufferSize {1}",__FUNCTION__, bytesReturned);
			#endif
			InteropServices::Marshal::ThrowExceptionForHR(error);

			auto items = safe_cast<Interop::Ks::KsMultipleItem^>(InteropServices::Marshal::PtrToStructure(outBuffer, Interop::Ks::KsMultipleItem::typeid));
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] items {1} ",__FUNCTION__, items);
			#endif

			System::Collections::Generic::List<OUT>^ result = gcnew System::Collections::Generic::List<OUT>;

			auto ptr = outBuffer + InteropServices::Marshal::SizeOf(Interop::Ks::KsMultipleItem::typeid);
			for (System::UInt32 idx = 0; idx < items->Count; idx++)
			{
				OUT out = safe_cast<OUT>(InteropServices::Marshal::PtrToStructure(ptr, OUT::typeid));
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] [{1}] item {2} ",__FUNCTION__, idx, out);
				#endif
				result->Add(out);

				if (Interop::Ks::KsDataFormat::typeid == OUT::typeid)
				{
					Interop::Ks::KsDataFormat^ dataFormat = safe_cast<Interop::Ks::KsDataFormat^>(out);

					if (dataFormat->FormatSize >= safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(Interop::Ks::KsDataRangeAudio::typeid)))
					{
						auto w = safe_cast<Interop::Ks::KsDataRangeAudio^>(InteropServices::Marshal::PtrToStructure(ptr, Interop::Ks::KsDataRangeAudio::typeid));
						#ifdef _DEBUG
							System::Console::WriteLine("[{0}] [{1}]",__FUNCTION__, w);
						#endif
					}
					/*else if (dataFormat->FormatSize != safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(Interop::Ks::KsDataFormat::typeid)))
					{
						auto ptr2 = ptr + safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(Interop::Ks::KsDataFormat::typeid));
						auto w = safe_cast<Interop::Winmm::WaveFormat^>(InteropServices::Marshal::PtrToStructure(ptr2, Interop::Winmm::WaveFormat::typeid));
						#ifdef _DEBUG
							System::Console::WriteLine("[{0}] [{1}]",__FUNCTION__, w);
						#endif
					}*/

					ptr += dataFormat->FormatSize;
				}
				else
				{
					ptr += InteropServices::Marshal::SizeOf(OUT::typeid);
				}
			}

			#ifdef _DEBUG
				System::Console::WriteLine("=========================================================");
			#endif
			return result->ToArray();
		}
		finally
		{
			InteropServices::Marshal::FreeHGlobal(outBuffer);
		}
	}


	generic<typename IN, typename OUT>
	array<OUT>^ Irp::GetArray(
		Interop::Ks::IOCTL_KS ioControlCode,
		IN% in
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
			System::Console::WriteLine("[{0}] {1}",__FUNCTION__, in);
		#endif

		System::UInt32 bytesReturned = 0;

		auto error =
			this->Put<IN>(
				ioControlCode,
				in,
				bytesReturned
			);

		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] bytesReturned {1}",__FUNCTION__, bytesReturned);
		#endif

		if (error != 0x800700EA)//ERROR_MORE_DATA
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] {1}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
				System::Console::WriteLine("=========================================================");
			#endif
			return nullptr;
		}

		if (bytesReturned == 0)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] bytesReturned == 0",__FUNCTION__);
				System::Console::WriteLine("=========================================================");
			#endif
			return nullptr;
		}

		auto itemSize = InteropServices::Marshal::SizeOf(OUT::typeid);
		if ((bytesReturned % itemSize) != 0)
		{
			//割り切れないのでＮＧ
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] 割り切れない bytesReturned[{1}] typeid size[{2}]",__FUNCTION__, bytesReturned, itemSize);
				System::Console::WriteLine("=========================================================");
			#endif
			return nullptr;
		}

		auto itemCount = (bytesReturned / itemSize);

		auto outBufferSize = bytesReturned;
		auto outBuffer = InteropServices::Marshal::AllocHGlobal(outBufferSize);

		try
		{
			auto error =
				this->IOSync<IN>(
					ioControlCode,
					in,
					outBuffer,
					outBufferSize,
					bytesReturned
				);
			#ifdef _DEBUG
			//	System::Console::WriteLine("[{0}] bytesReturned {1}",__FUNCTION__, bytesReturned);
			#endif

			InteropServices::Marshal::ThrowExceptionForHR(error);

			System::Collections::Generic::List<OUT>^ result = gcnew System::Collections::Generic::List<OUT>;

			auto ptr = outBuffer;
			for (System::UInt32 idx = 0; idx < itemCount; idx++)
			{
				OUT out = safe_cast<OUT>(InteropServices::Marshal::PtrToStructure(ptr, OUT::typeid));
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] [{1}] item {2} ",__FUNCTION__, idx, out);
				#endif
				result->Add(out);
				ptr += itemSize;
			}

			#ifdef _DEBUG
				System::Console::WriteLine("=========================================================");
			#endif
			return result->ToArray();
		}
		finally
		{
			InteropServices::Marshal::FreeHGlobal(outBuffer);
		}
	}


}
}
}
