/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Midi.Out.cpp
	midi output component.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Interop.MMDeviceAPI.h"
#include "Momiji.Core.MMDeviceAPI.h"

namespace Momiji {
namespace Core {
namespace MMDeviceAPI {

	Devices::Devices(
		Interop::MMDeviceAPI::EDataFlow dataFlow
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][dataFlow:{1}]",__FUNCTION__, dataFlow);
		#endif

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][dataFlow:{1}]",__FUNCTION__, Interop::MMDeviceAPI::FunctionDiscoveryKeys_devpkey::PKEY_Device);
		#endif
		


		Interop::MMDeviceAPI::IMMDeviceEnumerator^ a = gcnew Interop::MMDeviceAPI::MMDeviceEnumeratorClass();
		Interop::MMDeviceAPI::IMMDeviceCollection^ b;

		a->EnumAudioEndpoints(dataFlow, 1, b);

		System::UInt32 c;
		b->GetCount(c);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IMMDeviceCollection.GetCount:{1}]",__FUNCTION__, c);
		#endif

		for (auto i = 0; i < c; i++) {
			Interop::MMDeviceAPI::IMMDevice^ d;

			b->Item(i, d);

			System::String^ e;
			d->GetId(e);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IMMDevice.GetId:{1}]",__FUNCTION__, e);
		#endif

			Interop::MMDeviceAPI::DEVICE_STATE f;
			d->GetState(f);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IMMDevice.GetState:{1:F}]",__FUNCTION__, f);
		#endif

			Interop::PropIdl::IPropertyStore^ g;
			d->OpenPropertyStore(Interop::MMDeviceAPI::STGM::READ, g);

			System::UInt32 h;
			g->GetCount(h);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IPropertyStore.GetCount:{1}]",__FUNCTION__, h);
		#endif

			for (auto j = 0; j < h; j++) {
				auto x = gcnew Interop::PropIdl::PROPERTYKEY();
				g->GetAt(j, x);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IPropertyStore.GetAt:{1}]",__FUNCTION__, x);
		#endif
				auto y = gcnew Interop::PropIdl::PROPVARIANT();
				auto marshaler = Interop::PropIdl::PROPVARIANTMarshaler::GetInstance("");
				auto z = marshaler->MarshalManagedToNative(y);
				try
				{
					g->GetValue(x, z);
					y = safe_cast<Interop::PropIdl::PROPVARIANT^>(marshaler->MarshalNativeToManaged(z));
				}
				finally
				{
					marshaler->CleanUpNativeData(z);
				}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][IPropertyStore.GetValue:{1}]",__FUNCTION__, y);
		#endif
			}

			delete g;
			delete d;
		}

		delete b;
		delete a;

	}

	Devices::~Devices()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Devices();
	}

	Devices::!Devices()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	//	this->_handle->Close();
	}

	Devices::Detail::Detail(
		Devices^ devices,
		System::UInt32 index
	)//:
	//	_devices(devices)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

//		this->GetDetail(index);
	}

	Devices::Detail::~Detail()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Detail();
	}

	Devices::Detail::!Detail()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}
/*
	void Devices::Detail::GetDetail(
		System::UInt32 index
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][index: {1}]",__FUNCTION__, index);
		#endif

		auto data = Interop::Setupapi::SpDeviceInterfaceData();
		data.cbSize = safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(data));
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] data->cbSize {1}",__FUNCTION__, data.cbSize);
		#endif
		if (
			!Interop::Setupapi::Function::SetupDiEnumDeviceInterfaces(
				this->_devices->_handle,
				nullptr,
				this->_devices->_category,
				index,
				data
			)
		)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] error [{1}]",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
			#endif
			if (error == 0x80070103) //ERROR_NO_MORE_ITEMS
			{
				this->_noMoreItems = true;
				return;
			}
			else
			{
				InteropServices::Marshal::ThrowExceptionForHR(error);
			}
		}
			
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] data [{1}]", __FUNCTION__, data);
		#endif

		this->_data = data;

		//f[^TCYmF
		System::UInt32 reqired = 0;
		
		if (
			!Interop::Setupapi::Function::SetupDiGetDeviceInterfaceDetail(
				this->_devices->_handle,
				this->_data,
				System::IntPtr::Zero,
				0,
				reqired,
				System::IntPtr::Zero
			)
		)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] error [{1}]",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
			#endif
			if (error != 0x8007007A)//ERROR_INSUFFICIENT_BUFFER
			{
				InteropServices::Marshal::ThrowExceptionForHR(error);
			}
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] reqired {1}",__FUNCTION__, reqired);
		#endif
		
		//EEE͂Ă̂́AǍ́A1024byteŒœǂݍł
		auto detail = Interop::Setupapi::SpDeviceInterfaceDetailData();
		detail.cbSize = safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(detail.cbSize) + InteropServices::Marshal::SystemDefaultCharSize);

		auto info = Interop::Setupapi::SpDevinfoData();
		info.cbSize = safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(info));
		
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] detail->cbSize {1}",__FUNCTION__, detail.cbSize);
		#endif

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] info->cbSize {1}",__FUNCTION__, info.cbSize);
		#endif

		if (
			!Interop::Setupapi::Function::SetupDiGetDeviceInterfaceDetail(
				this->_devices->_handle,
				this->_data,
				detail,
				reqired,
				reqired,
				info
			)
		)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] detail [{1}]",__FUNCTION__, detail);
			System::Console::WriteLine("[{0}] info [{1}]", __FUNCTION__, info);
		#endif

		this->_devicePath = detail.DevicePath;
		this->_info = info;
	}

	Interop::Setupapi::SpDeviceInterfaceData^ Devices::Detail::GetAlias(
		Interop::Guiddef::Guid subCategory
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][{1}]",__FUNCTION__, subCategory);
		#endif
		auto data = Interop::Setupapi::SpDeviceInterfaceData();
		data.cbSize = safe_cast<System::UInt32>(InteropServices::Marshal::SizeOf(data));

		if (
			!Interop::Setupapi::Function::SetupDiGetDeviceInterfaceAlias(
				this->_devices->_handle,
				this->_data,
				subCategory,
				data
			)
		)
		{
			#ifdef _DEBUG
				auto error = InteropServices::Marshal::GetHRForLastWin32Error();
				System::Console::WriteLine("[{0}] error [{1}]",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
			#endif
			return nullptr;
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] alias [{1}]", __FUNCTION__, data);
		#endif
		return data;
	}

	System::String^ Devices::Detail::GetDeviceRegistryProperty(
		Interop::Setupapi::SPDRP spdrp
	)
	{
		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}][{1}]",__FUNCTION__, spdrp);
		#endif
		System::UInt32 regDataType = 0;
		System::UInt32 reqired = 0;
		if (
			!Interop::Setupapi::Function::SetupDiGetDeviceRegistryProperty(
				this->_devices->_handle,
				this->_info,
				spdrp,
				regDataType,
				nullptr,
				0,
				reqired
			)
		)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			#ifdef _DEBUG
			//	System::Console::WriteLine("[{0}] error {1:X}",__FUNCTION__, error);
			#endif
			if (error != 0x8007007A)//ERROR_INSUFFICIENT_BUFFER
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] {1} [{2}]",__FUNCTION__, spdrp, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
				#endif
				return nullptr;
			}
		}
		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}] reqired {1}",__FUNCTION__, reqired);
		#endif
		auto buf = gcnew System::Text::StringBuilder(safe_cast<System::Int32>(reqired));

		if (
			!Interop::Setupapi::Function::SetupDiGetDeviceRegistryProperty(
				this->_devices->_handle,
				this->_info,
				spdrp,
				regDataType,
				buf,
				reqired,
				reqired
			)
		)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			#ifdef _DEBUG
			//	System::Console::WriteLine("[{0}] error {1:X}",__FUNCTION__, error);
			#endif
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] {1} [{2}]",__FUNCTION__, spdrp, buf->ToString());
		#endif
		return buf->ToString();
	}

	System::String^ Devices::Detail::GetDeviceRegistryProperty(
		System::String^ name
	)
	{
		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}][{1}]",__FUNCTION__, name);
		#endif
		Interop::Setupapi::Function::RegKey^ regKey;
		
		{
			regKey =
				Interop::Setupapi::Function::SetupDiOpenDeviceInterfaceRegKey(
					this->_devices->_handle,
					this->_data,
					0,
					Interop::Kernel32::ACCESS_TYPES::KEY_READ
				);
			if (regKey->IsInvalid)
			{
				#ifdef _DEBUG
					auto error = InteropServices::Marshal::GetHRForLastWin32Error();
					System::Console::WriteLine("[{0}] error {1:X}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
				#endif
				return nullptr;
			}
		}

		try
		{
			System::UInt32 type = 0;
			System::UInt32 size = 1024;
			auto data = InteropServices::Marshal::AllocHGlobal(size);
			try
			{
				System::UInt32 error =
					Interop::Setupapi::Function::RegQueryValueEx(
						regKey,
						name,
						System::IntPtr::Zero,
						type,
						data,
						size
					);
				#ifdef _DEBUG
				//	System::Console::WriteLine("[{0}] error {1:X}",__FUNCTION__, error);
				#endif
				if (error != 0)
				{
					#ifdef _DEBUG
						System::Console::WriteLine("[{0}] msg {1}",__FUNCTION__, InteropServices::Marshal::GetExceptionForHR(error)->ToString());
					#endif
					return nullptr;
				}

				auto result = InteropServices::Marshal::PtrToStringAuto(data);
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] {1} [{2}]",__FUNCTION__, name, result);
				#endif
				return result;
			}
			finally
			{
				InteropServices::Marshal::FreeHGlobal(data);
			}
		}
		finally
		{
			delete regKey;
		}
	}



	Devices::DetailEnum::DetailEnum(
		Devices^ devices
	):
		_devices(devices),
		_index(0) //ʓIȗp@͊OāAMoveNext+1Ă
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}

	System::Boolean Devices::DetailEnum::MoveNext()
	{
		auto detail =
			gcnew Detail(
				this->_devices,
				this->_index++
			);

		this->_detail =
			(detail->IsNoMoreItems)
				? nullptr
				: detail
				;
		return !detail->IsNoMoreItems;
	}

	void Devices::DetailEnum::Reset()
	{
		this->_detail = nullptr;
		this->_index = 0;
	}
	*/
}
}
}
