﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Midi.Out.h
	midi output component.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Core.Interface.h"
#include "Momiji.Core.Winmm.h"
#include "Momiji.Core.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Midi {
namespace Out {

	public ref class Device
	{
	private:
		initonly System::UInt32				_deviceID;
		Interop::Winmm::Function::MidiOut^	_handle;
		Core::Winmm::DriverCallBack^		_callBack;
		Core::Buffer::BufferPool<Interop::Winmm::MidiHeader^>^ _headerPool;
		Core::Buffer::BufferPool<array<System::Byte>^>^ _bufferPool; //TODO: バッファは後で外部で持つようにする

	public:
		Device(System::UInt32 deviceID);
		virtual ~Device();
	protected:
		!Device();

	private:
		System::IntPtr Prepare(array<System::Byte>^ data, System::UInt32 useSize);
		void Unprepare(System::IntPtr headerPtr);

		Interop::Winmm::MidiHeader^ AllocateHeader();
		array<System::Byte>^ AllocateBuffer();

	public:
		static System::UInt32 GetNumDevices();
		static Interop::Winmm::MidiOutCapabilities^ GetCapabilities(System::UInt32 uDeviceID);
		Interop::Winmm::MidiOutCapabilities^ GetCapabilities();

	private:
		void Open();
		void Close();

	public:
		void SendShort(System::UInt32 dwMsg);
		void SendLong(array<System::Byte>^ data, System::UInt32 useSize);

	public:
		//TODO: このイベントは使い道が無い。。。
		event System::EventHandler<System::EventArgs^>^ OnOpen;
		event System::EventHandler<System::EventArgs^>^ OnClose;

	private:
		void OnEventHandler(System::Object^ sender, Interop::Winmm::DriverCallBack::DriverEventArgs^ args);
		void DoOpen(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoClose(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoDone(System::IntPtr dwParam1, System::IntPtr dwParam2);
	};

	public ref class MidiOutException
		: public System::Exception
	{
	private:
		initonly Interop::Winmm::MMRESULT _mmResult;
		System::String^ Initialize();

	public:
		MidiOutException(Interop::Winmm::MMRESULT v): _mmResult(v), System::Exception(Initialize()){};
		MidiOutException(System::String^ v): System::Exception(v){};
		virtual ~MidiOutException(void){};

		property Interop::Winmm::MMRESULT mmResult
		{
			Interop::Winmm::MMRESULT get(void) {return this->_mmResult;};
		}
	};

	public ref class Devices
		: public Core::IOut
	{
	private:
		System::Collections::Generic::List<Device^>^ _outs;

	public:
		Devices();
		virtual ~Devices();

		void AddPort(System::UInt32 deviceID);
	protected:
		!Devices();

	public:
		virtual void Send(Core::IData^ data);
	};

}
}
}
}
