﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Timer.MMTimer.h
	timer component. multi media timer version.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Core.Interface.h"
#include "Momiji.Core.Winmm.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Timer {

	public ref class MMTimer
		: public Core::ITimer
	{
	private:
		System::UInt32				_timerID;
		Core::Winmm::TimerCallBack^	_callBack;

		System::Diagnostics::Stopwatch^	_stopWatch;
	public:
		MMTimer();
		virtual ~MMTimer();
	protected:
		!MMTimer();

	public:
		static Interop::Winmm::TimeCapabilities^ getCapabilities();

	public:
		virtual void Start(System::UInt32 period);
		virtual void Stop();

	public:
		virtual event Core::ITimer::Event^ OnInterval;

	private:
		void OnEventHandler(System::Object^ sender, Interop::Winmm::TimerCallBack::TimerEventArgs^ args);
		void DoInterval(System::IntPtr dw1, System::IntPtr dw2);
	};

	public ref class MMTimerException: System::Exception
	{
	private:
		initonly Interop::Winmm::MMRESULT _mmResult;
		System::String^ Initialize();

	public:
		MMTimerException(Interop::Winmm::MMRESULT v): _mmResult(v), System::Exception(Initialize()){};
		MMTimerException(System::String^ v): System::Exception(v){};
		virtual ~MMTimerException(){};

		property Interop::Winmm::MMRESULT mmResult
		{
			Interop::Winmm::MMRESULT get() {return this->_mmResult;};
		}
	};

}
}
}
