﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Vst.Buffer.cpp
	buffer for VST.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Core.Vst.Buffer.h"

namespace Momiji{
namespace Core {
namespace Vst {
namespace Buffer {

	generic<typename T> 
	VstBuffer<T>::VstBuffer(
		System::Int32 channel,
		System::Int32 size
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->Alloc(channel, size);
	}

	generic<typename T> 
	VstBuffer<T>::~VstBuffer()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!VstBuffer();
	}

	generic<typename T> 
	VstBuffer<T>::!VstBuffer()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->Free();
	}

	generic<typename T>
	void VstBuffer<T>::Alloc(
		System::Int32 channel, 
		System::Int32 size
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->_buffer = gcnew array<array<T>^>(channel);
		this->_channelBufferHandles = gcnew array<InteropServices::GCHandle>(channel);

		auto channelBufferPtrs = gcnew array<System::IntPtr>(channel);
		this->_bufferHandle = InteropServices::GCHandle::Alloc(channelBufferPtrs, InteropServices::GCHandleType::Pinned);

		for (auto idx = 0; idx < channel; idx++)
		{
			this->_buffer[idx] = gcnew array<T>(size);
			this->_channelBufferHandles[idx] = 
				InteropServices::GCHandle::Alloc(this->_buffer[idx], InteropServices::GCHandleType::Pinned);
			channelBufferPtrs[idx] = this->_channelBufferHandles[idx].AddrOfPinnedObject();
		}
	}

	generic<typename T> 
	void VstBuffer<T>::Free()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		for (auto idx = 0; idx < this->_channelBufferHandles->Length; idx++)
		{
			this->_channelBufferHandles[idx].Free();
		}
		this->_bufferHandle.Free();
	}

	generic<typename T> 
	void VstBuffer<T>::Reset(array<array<T>^>^ data)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		for (auto idx = 0; idx < data->Length; idx++)
		{
			System::Array::Copy(data[idx], this->_buffer[idx], data[idx]->Length);
		}
	}

}
}
}
}
