﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Wave.Data.h
	wave data.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Winmm.h"
#include "Momiji.Core.Interface.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Wave {

	generic<typename T>
	public ref class WaveData
		: public Core::IData
	{
	private:
		initonly System::UInt16	_port;
		initonly array<T>^ _data;
		initonly System::UInt32 _useSize;

	public:
		WaveData(
			System::UInt16	port,
			array<T>^ data,
			System::UInt32 useSize
		): _port(port), _data(data), _useSize(useSize) {}

	public:
		property System::UInt16 port { System::UInt16 get() {return this->_port;} }
		property array<T>^ data { array<T>^ get() {return this->_data;} }
		property System::UInt32 useSize { System::UInt32 get() { return this->_useSize; } }
	};


}
}
}
