﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Winmm.cpp
	
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Interop.Winmm.h"
#include "Momiji.Core.Winmm.h"

namespace Momiji {
namespace Core {
namespace Winmm {

	DriverCallBack::DriverCallBack(System::Boolean async):
		_async(async)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->_callBack = InteropServices::GCHandle::Alloc(gcnew Interop::Winmm::DriverCallBack::Delegate(this, &DriverCallBack::DriverCallBackProc));
	}

	DriverCallBack::~DriverCallBack()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!DriverCallBack();
	}

	DriverCallBack::!DriverCallBack()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		if (this->_callBack.IsAllocated)
		{
			this->_callBack.Free();
		}
	}

	Interop::Winmm::DriverCallBack::Delegate^ DriverCallBack::GetDriverCallBackProc()
	{
		return safe_cast<Interop::Winmm::DriverCallBack::Delegate^>(this->_callBack.Target);
	}

	void DriverCallBack::DriverCallBackProc(
		System::IntPtr	hdrvr,
		Interop::Winmm::DriverCallBack::MM_EXT_WINDOW_MESSAGE	uMsg,
		System::IntPtr	dwUser,
		System::IntPtr	dw1,
		System::IntPtr	dw2
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1,8:X}][{2,8:X}][{3,8:X}][{4,8:X}][{5,8:X}]", __FUNCTION__, hdrvr, uMsg, dwUser, dw1, dw2);
		#endif
		try
		{
			auto params = gcnew Interop::Winmm::DriverCallBack::DriverEventArgs();
			params->hdrvr = hdrvr;
			params->uMsg = uMsg;
			params->dwUser = dwUser;
			params->dw1 = dw1;
			params->dw2 = dw2;

			if (this->_async)
			{
				System::Threading::ThreadPool::QueueUserWorkItem(
					gcnew System::Threading::WaitCallback(this, &DriverCallBack::DoEvent),
					params
				);
			}
			else
			{
				this->DoEvent(params);
			}
		}
		catch(System::Exception^ e)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] コールバック中のエラー[{1}]", __FUNCTION__, e->ToString());
			#endif
		}
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] OUT", __FUNCTION__);
		#endif
	}

	void DriverCallBack::DoEvent(
		System::Object^	stateInfo
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] start", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif

		auto params = safe_cast<Interop::Winmm::DriverCallBack::DriverEventArgs^>(stateInfo);
		try
		{
			this->OnEvent(this, params);
		}
		catch(System::Exception^ e)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] コールバック中のエラー[{1}]", __FUNCTION__, e->ToString());
			#endif
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] end", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif
	}





	TimerCallBack::TimerCallBack(System::Boolean async):
		_async(async)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->_callBack = InteropServices::GCHandle::Alloc(gcnew Interop::Winmm::TimerCallBack::Delegate(this, &TimerCallBack::TimerCallBackProc));
	}

	TimerCallBack::~TimerCallBack()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!TimerCallBack();
	}

	TimerCallBack::!TimerCallBack()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		if (this->_callBack.IsAllocated)
		{
			this->_callBack.Free();
		}
	}

	Interop::Winmm::TimerCallBack::Delegate^ TimerCallBack::GetTimerCallBackProc()
	{
		return safe_cast<Interop::Winmm::TimerCallBack::Delegate^>(this->_callBack.Target);
	}

	void TimerCallBack::TimerCallBackProc(
		System::UInt32	uTimerID,
		System::UInt32	uMsg,
		System::IntPtr	dwUser,
		System::IntPtr	dw1,
		System::IntPtr	dw2
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1,8:X}][{2,8:X}][{3,8:X}][{4,8:X}][{5,8:X}]", __FUNCTION__, uTimerID, uMsg, dwUser, dw1, dw2);
		#endif
		try
		{
			auto params = gcnew Interop::Winmm::TimerCallBack::TimerEventArgs();
			params->uTimerID = uTimerID;
			params->uMsg = uMsg;
			params->dwUser = dwUser;
			params->dw1 = dw1;
			params->dw2 = dw2;

			if (this->_async)
			{
				System::Threading::ThreadPool::QueueUserWorkItem(
					gcnew System::Threading::WaitCallback(this, &TimerCallBack::DoEvent),
					params
				);
			}
			else
			{
				this->DoEvent(params);
			}
		}
		catch(System::Exception^ e)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] コールバック中のエラー[{1}]", __FUNCTION__, e->ToString());
			#endif
		}
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] OUT", __FUNCTION__);
		#endif
	}

	void TimerCallBack::DoEvent(
		System::Object^	stateInfo
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] start", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif

		auto params = safe_cast<Interop::Winmm::TimerCallBack::TimerEventArgs^>(stateInfo);
		try
		{
			this->OnEvent(this, params);
		}
		catch(System::Exception^ e)
		{
			System::Console::WriteLine("[{0}] コールバック中のエラー[{1}]", __FUNCTION__, e->ToString());
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] end", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif
	}
}
}
}
