﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Winmm.h

---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Core.Interface.h"
#include "Momiji.Interop.Winmm.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Winmm {

	ref class DriverCallBack
	{
	private:
		InteropServices::GCHandle _callBack;
		System::Boolean _async;

	public:
		DriverCallBack(System::Boolean async);
		virtual ~DriverCallBack();
	protected:
		!DriverCallBack();

	private:
		void DriverCallBackProc(
			System::IntPtr	hdrvr,
			Interop::Winmm::DriverCallBack::MM_EXT_WINDOW_MESSAGE	uMsg,
			System::IntPtr	dwUser,
			System::IntPtr	dw1,
			System::IntPtr	dw2
		);
		void DoEvent(System::Object^ args);

	public:
		Interop::Winmm::DriverCallBack::Delegate^ GetDriverCallBackProc();

		event System::EventHandler<Interop::Winmm::DriverCallBack::DriverEventArgs^>^ OnEvent;
	};

	ref class TimerCallBack
	{
	private:
		InteropServices::GCHandle _callBack;
		System::Boolean _async;

	public:
		TimerCallBack(System::Boolean async);
		virtual ~TimerCallBack();
	protected:
		!TimerCallBack();

	private:
		void TimerCallBackProc(
			System::UInt32	uTimerID,
			System::UInt32	uMsg,
			System::IntPtr	dwUser,
			System::IntPtr	dw1,
			System::IntPtr	dw2
		);
		void DoEvent(System::Object^ args);

	public:
		Interop::Winmm::TimerCallBack::Delegate^ GetTimerCallBackProc();

		event System::EventHandler<Interop::Winmm::TimerCallBack::TimerEventArgs^>^ OnEvent;
	};

}
}
}
