﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Interop.Guiddef.cpp
	
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Interop.Guiddef.h"


namespace Momiji{
namespace Interop {
namespace Guiddef {

	value struct GuidInfo {
		Guid			_guid;
		System::String^	_name;

	};

	ref class GuidMap {
	private:
		static GuidMap^ _instance;
		static System::Object^ _lock = gcnew System::Object();

		System::Collections::Generic::Dictionary<System::String^, GuidInfo>^ _guidMap;

		GuidMap()
			: _guidMap(gcnew System::Collections::Generic::Dictionary<System::String^, GuidInfo>())
		{
		};

		static property GuidMap^ Instance {
			GuidMap^ get() {
				if (_instance == nullptr) {
					System::Threading::Monitor::Enter(_lock);
					try {
						if (_instance == nullptr) { _instance = gcnew GuidMap(); }
					} finally {
						System::Threading::Monitor::Exit(_lock);
					}
				}
				return _instance;
			};
		};

	public:
		static Guid Regist(System::String^ guid, System::String^ name) {
			GuidMap^ map = GuidMap::Instance;
			System::String^ upperGuid = guid->ToUpper();
			GuidInfo info;
			if (map->_guidMap->TryGetValue(upperGuid, info)) {
				return info._guid;
			}
			//info = gcnew GuidInfo();
			info._guid = Guid(upperGuid);
			info._name = name;
			map->_guidMap->Add(upperGuid, info);
			return info._guid;
		};

		static System::String^ Name(System::String^ guid) {
			GuidMap^ map = GuidMap::Instance;
			System::String^ upperGuid = guid->ToUpper();
			GuidInfo info;
			if (!map->_guidMap->TryGetValue(upperGuid, info)) {
				return "unknown";
			}
			return info._name;
		};
	};



//	Guid::Guid(){}
	Guid::Guid(System::String^ guid): data(System::Guid(guid)) {}

	Guid Guid::Regist(System::String^ guid, System::String^ name) {
		return GuidMap::Regist(guid, name);
	}

	System::String^ Guid::ToString()
	{
		System::String^ guid = this->data.ToString();
		return guid + "(" + GuidMap::Name(guid) +")";
	}



}
}
}
