﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Interop.Ks.h
	windows multi media dll importer.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Interop.Kernel32.h"
#include "Momiji.Interop.Winmm.h"

using namespace System::Runtime;

namespace Momiji{
namespace Interop {
namespace Ks {

#define KSPROXY_API_DLLIMPORT		WIN32_DLL_IMPORT("Ksproxy.ax")
#define KSUSER_API_DLLIMPORT		WIN32_DLL_IMPORT("ksuser")

	public enum class IOCTL_KS: System::UInt32
	{
		#define FILE_DEVICE_KS                  0x0000002f

		#define METHOD_BUFFERED                 0
		#define METHOD_IN_DIRECT                1
		#define METHOD_OUT_DIRECT               2
		#define METHOD_NEITHER                  3

		#define FILE_ANY_ACCESS                 0
		#define FILE_READ_ACCESS          ( 0x0001 )    // file & pipe
		#define FILE_WRITE_ACCESS         ( 0x0002 )    // file & pipe

		#define CTL_CODE( DeviceType, Function, Method, Access ) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method))

		PROPERTY		= CTL_CODE(FILE_DEVICE_KS, 0x000, METHOD_NEITHER, FILE_ANY_ACCESS),
		ENABLE_EVENT	= CTL_CODE(FILE_DEVICE_KS, 0x001, METHOD_NEITHER, FILE_ANY_ACCESS),
		DISABLE_EVENT	= CTL_CODE(FILE_DEVICE_KS, 0x002, METHOD_NEITHER, FILE_ANY_ACCESS),
		METHOD			= CTL_CODE(FILE_DEVICE_KS, 0x003, METHOD_NEITHER, FILE_ANY_ACCESS),
		WRITE_STREAM	= CTL_CODE(FILE_DEVICE_KS, 0x004, METHOD_NEITHER, FILE_WRITE_ACCESS),
		READ_STREAM		= CTL_CODE(FILE_DEVICE_KS, 0x005, METHOD_NEITHER, FILE_READ_ACCESS),
		RESET_STATE		= CTL_CODE(FILE_DEVICE_KS, 0x006, METHOD_NEITHER, FILE_ANY_ACCESS),
		HANDSHAKE		= CTL_CODE(FILE_DEVICE_KS, 0x007, METHOD_NEITHER, FILE_ANY_ACCESS),

	};


	WIN32_DLL_STRUCTLAYOUT public value struct KsReset
	{
		enum class ENUM: System::UInt32
		{
			BEGIN,
			END
		};

		ENUM Value;

		virtual System::String^ ToString() override
		{
			return 
				"value["+Value.ToString("F")+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsState
	{
		enum class ENUM: System::UInt32
		{
			STOP,
			ACQUIRE,
			PAUSE,
			RUN
		};

		ENUM Value;

		virtual System::String^ ToString() override
		{
			return 
				"value["+Value.ToString("F")+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPriority
	{
		enum class CLASS: System::UInt32
		{
			NONE			= 0x00000000,
			LOW				= 0x00000001,
			NORMAL			= 0x40000000,
			HIGH			= 0x80000000,
			EXCLUSIVE		= 0xFFFFFFFF,
		};

		CLASS			PriorityClass;
		System::UInt32	PrioritySubClass;

		virtual System::String^ ToString() override
		{
			return "priorityClass["+PriorityClass.ToString("F")+"] prioritySubClass["+PrioritySubClass+"]";
		}
	};

	template<typename ID, typename TYPE>
	WIN32_DLL_STRUCTLAYOUT public value struct KsIdentifier
	{
		Guiddef::Guid	Set;
		ID				Id;
		TYPE			Flags;

		virtual System::String^ ToString() override
		{
			return 
				System::String::Format(
					"guid[{0}] id[{1:F}] flags[{2:F}]",
					Set,
					Id,
					Flags
				);
		}
	};

	public enum class EVENT_TYPE: System::UInt32
	{
		NONE			= 0x00000000,
		ENABLE			= 0x00000001,
		ONESHOT			= 0x00000002,
		ENABLEBUFFERED	= 0x00000004,
		SETSUPPORT		= 0x00000100,
		BASICSUPPORT	= 0x00000200,
		QUERYBUFFER		= 0x00000400,
		
		TOPOLOGY		= 0x10000000,
	};

	public enum class METHOD_TYPE: System::UInt32
	{
		NONE			= 0x00000000,
		READ			= 0x00000001,
		WRITE			= 0x00000002,
		MODIFY			= 0x00000003,
		SOURCE			= 0x00000004,

		SEND			= 0x00000001,
		SETSUPPORT		= 0x00000100,
		BASICSUPPORT	= 0x00000200,

		TOPOLOGY		= 0x10000000,
	};

	public enum class PROPERTY_ID: System::UInt32
	{
		CINSTANCES = 0,
		CTYPES,
		DATAFLOW,
		DATARANGES,
		DATAINTERSECTION,
		INTERFACES,
		MEDIUMS,
		COMMUNICATION,
		GLOBALCINSTANCES,
		NECESSARYINSTANCES,
		PHYSICALCONNECTION,
		CATEGORY,
		NAME,
		CONSTRAINEDDATARANGES,
		PROPOSEDATAFORMAT,
	};

	public enum class PROPERTY_TYPE: System::UInt32
	{
		NONE			= 0x00000000,
		GET				= 0x00000001,
		SET				= 0x00000002,
		SETSUPPORT		= 0x00000100,
		BASICSUPPORT	= 0x00000200,
		RELATIONS		= 0x00000400,
		SERIALIZESET	= 0x00000800,
		UNSERIALIZESET	= 0x00001000,
		SERIALIZERAW	= 0x00002000,
		UNSERIALIZERAW	= 0x00004000,
		SERIALIZESIZE	= 0x00008000,
		DEFAULTVALUES	= 0x00010000,

		TOPOLOGY		= 0x10000000,
	};

	public enum class PROPERTY_ID_CONNECTION: System::UInt32
	{
		STATE = 0,
		PRIORITY,
		DATAFORMAT,
		ALLOCATORFRAMING,
		PROPOSEDATAFORMAT,
		ACQUIREORDERING,
		ALLOCATORFRAMING_EX,
		STARTAT,
	};

	public enum class PROPERTY_ID_AUDIO: System::UInt32
	{
		NONE			= 0x00000000,
		LATENCY			= 1,
		COPY_PROTECTION,
		CHANNEL_CONFIG,
		VOLUMELEVEL,
		POSITION,
		DYNAMIC_RANGE,
		QUALITY,
		SAMPLING_RATE,
		DYNAMIC_SAMPLING_RATE,
		MIX_LEVEL_TABLE,
		MIX_LEVEL_CAPS,
		MUX_SOURCE,
		MUTE,
		BASS,
		MID,
		TREBLE,
		BASS_BOOST,
		EQ_LEVEL,
		NUM_EQ_BANDS,
		EQ_BANDS,
		AGC,
		DELAY,
		LOUDNESS,
		WIDE_MODE,                 //Reserved for system use
		WIDENESS,
		REVERB_LEVEL,
		CHORUS_LEVEL,
		DEV_SPECIFIC,
		DEMUX_DEST,
		STEREO_ENHANCE,            //Reserved for system use
		MANUFACTURE_GUID,          //Reserved for system use
		PRODUCT_GUID,              //Reserved for system use
		CPU_RESOURCES,
		STEREO_SPEAKER_GEOMETRY,
		SURROUND_ENCODE,
		_3D_INTERFACE,
		PEAKMETER,
		ALGORITHM_INSTANCE,
		FILTER_STATE,
		PREFERRED_STATUS,
		PEQ_MAX_BANDS,
		PEQ_NUM_BANDS,
		PEQ_BAND_CENTER_FREQ,
		PEQ_BAND_Q_FACTOR,
		PEQ_BAND_LEVEL,
		CHORUS_MODULATION_RATE,			
		CHORUS_MODULATION_DEPTH,
		REVERB_TIME,
		REVERB_DELAY_FEEDBACK,
		POSITIONEX,
		MIC_ARRAY_GEOMETRY,

	};

	public enum class PROPERTY_ID_WAVE: System::UInt32
	{
		COMPATIBLE_CAPABILITIES,
		INPUT_CAPABILITIES,
		OUTPUT_CAPABILITIES,
		BUFFER,
		FREQUENCY,
		VOLUME,
		PAN
	};

	public enum class PROPERTY_ID_TOPOLOGY: System::UInt32
	{
		CATEGORIES,
		NODES,
		CONNECTIONS,
		NAME
	};

	template<typename TYPE>
	WIN32_DLL_STRUCTLAYOUT public value struct KsBasicSupport
	{
		TYPE Value;

		virtual System::String^ ToString() override
		{
			return 
				System::String::Format(
					"value[{0:F}]",
					Value
				);
		}
	};

	template<typename ID, typename TYPE>
	WIN32_DLL_STRUCTLAYOUT public value struct KsNode
	{
		KsIdentifier<ID, TYPE>	Property;
		System::UInt32			NodeId;
		System::UInt32			Reserved;

		virtual System::String^ ToString() override
		{
			return "property["+Property.ToString()+"] nodeId["+NodeId+"]";
		}
	};

	template<typename ID>
	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyPin
	{
		KsIdentifier<ID, Interop::Ks::PROPERTY_TYPE>	Property;
		System::UInt32									PinId;
		System::UInt32									Reserved;

		virtual System::String^ ToString() override
		{
			return "property["+Property.ToString()+"] pinId["+PinId+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsMultipleItem
	{
		System::UInt32	Size;
		System::UInt32	Count;

		virtual System::String^ ToString() override
		{
			return "size["+Size+"] count["+Count+"]";
		}
	};

	template<typename ID>
	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyPinAndMultipleItem
	{
		KsPropertyPin<ID>	PropertyPin;
		KsMultipleItem		MultipleItem;

		virtual System::String^ ToString() override
		{
			return "propertyPin["+PropertyPin.ToString()+"] multipleItem["+MultipleItem.ToString()+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsCInstances
	{
		System::UInt32 PossibleCount;
		System::UInt32 CurrentCount;

		virtual System::String^ ToString() override
		{
			return "possibleCount["+PossibleCount+"] currentCount["+CurrentCount+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinDataFlow
	{
		enum class ENUM: System::UInt32
		{
			NONE,
			IN,
			OUT
		};

		ENUM Value;

		virtual System::String^ ToString() override
		{
			return 
				"value["+Value.ToString("F")+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsDataFormat
	{
		System::UInt32	FormatSize;
		System::UInt32	Flags;
		System::UInt32	SampleSize;
		System::UInt32	Reserved;
		Guiddef::Guid	MajorFormat;
		Guiddef::Guid	SubFormat;
		Guiddef::Guid	Specifier;

		virtual System::String^ ToString() override
		{
			return 
				"formatSize["+FormatSize+"] flags["+Flags+"] sampleSize["+SampleSize+"] majorFormat["+MajorFormat+"] subFormat["+SubFormat+"] specifier["+Specifier+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinCommunication
	{
		enum class ENUM: System::UInt32
		{
			NONE,
			SINK,
			SOURCE,
			BOTH,
			BRIDGE,
		};

		ENUM Value;

		virtual System::String^ ToString() override
		{
			return 
				"value["+Value.ToString("F")+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinInterface
	{
		enum class ID: System::UInt32
		{
			STANDARD_STREAMING,
			STANDARD_LOOPED_STREAMING,
			STANDARD_CONTROL,		//Reserved for system use

		};

		Guiddef::Guid	Set;
		ID				Id;
		System::UInt32	Flags;

		virtual System::String^ ToString() override
		{
			return "guid["+Set+"] id["+Id.ToString("F")+"] flags["+Flags+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinInterfaceMedia
	{
		enum class ID: System::UInt32
		{
			MEDIA_MUSIC,			//Reserved for system use
			MEDIA_WAVE_BUFFERED,	//Reserved for system use
			MEDIA_WAVE_QUEUED,
		};

		Guiddef::Guid	Set;
		ID				Id;
		System::UInt32	Flags;

		virtual System::String^ ToString() override
		{
			return "guid["+Set+"] id["+Id.ToString("F")+"] flags["+Flags+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinMedium
	{
		enum class ID: System::UInt32
		{
			STANDARD_ANYINSTANCE,
			//STANDARD_DEVIO = STANDARD_ANYINSTANCE,

		};

		Guiddef::Guid	Set;
		ID				Id;
		System::UInt32	Flags;

		virtual System::String^ ToString() override
		{
			return "guid["+Set+"] id["+Id.ToString("F")+"] flags["+Flags+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsDataFormatWaveFormatEx
	{
		KsDataFormat DataFormat;
		Interop::Winmm::WaveFormatEx^ wfe;

		virtual System::String^ ToString() override
		{
			return 
				"dataFormat["+DataFormat.ToString()+"] wfe["+wfe->ToString()+"]";
		}
	};


	// DirectSound buffer description
	WIN32_DLL_STRUCTLAYOUT public value struct KsDSoundBufferDesc
	{
		System::UInt32					Flags;
		System::UInt32					Control;
		Interop::Winmm::WaveFormatEx^	wfe;
	};

	// DirectSound format
	WIN32_DLL_STRUCTLAYOUT public value struct KsDataFormatDSound
	{
		KsDataFormat		DataFormat;
		KsDSoundBufferDesc	BufferDesc;

		virtual System::String^ ToString() override
		{
			return 
				"dataFormat["+DataFormat.ToString()+"] bufferDesc["+BufferDesc.ToString()+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsDataRangeAudio
	{
		KsDataFormat	DataRange;
		System::UInt32	MaximumChannels;
		System::UInt32	MinimumBitsPerSample;
		System::UInt32	MaximumBitsPerSample;
		System::UInt32	MinimumSampleFrequency;
		System::UInt32	MaximumSampleFrequency;

		virtual System::String^ ToString() override
		{
			return 
				"dataRange["+DataRange.ToString()+"] maximumChannels["+MaximumChannels+"] minimumBitsPerSample["+MinimumBitsPerSample+"] maximumBitsPerSample["+MaximumBitsPerSample+"] MinimumSampleFrequency["+MinimumSampleFrequency+"] MaximumSampleFrequency["+MaximumSampleFrequency+"]";
		}
	};

	template<typename ID, typename TYPE>
	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyDesctiption
	{
		System::UInt32			AccessFlags;
		System::UInt32			DescriptionSize;
		KsIdentifier<ID, TYPE>	PropTypeSet;
		System::UInt32			MembersListCount;
		System::UInt32			Reserved;
	};


	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyMembersHeader
	{
		enum class MEMBERS_FLAGS: System::UInt32
		{
			NONE			= 0x00000000,
			RANGES			= 0x00000001,
			STEPPEDRANGES	= 0x00000002,
			VALUES			= 0x00000003,
		};

		enum class FLAGS: System::UInt32
		{
			NONE						= 0x00000000,
			DEFAULT						= 0x00000001,
			BASICSUPPORT_MULTICHANNEL	= 0x00000002,
			BASICSUPPORT_UNIFORM		= 0x00000004,
		};

		MEMBERS_FLAGS	MembersFlags;
		System::UInt32	MembersSize;
		System::UInt32	MembersCount;
		FLAGS			Flags;
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyBoundsLong
	{
		System::Int32	Minimum;
		System::Int32	Maximum;
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertyBoundsLongLong
	{
		System::Int64	Minimum;
		System::Int64	Maximum;
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertySteppingLong
	{
		System::UInt32			SteppingDelta;
		System::UInt32			Reserved;
		KsPropertyBoundsLong	Bounds;
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPropertySteppingLongLong
	{
		System::UInt64				SteppingDelta;
		KsPropertyBoundsLongLong	Bounds;
	};


	//この状態で一度に取得する手段は無い？？
	/*WIN32_DLL_STRUCTLAYOUT */public value struct KsPinDescriptor
	{
		array<KsPinInterface^>^		Interfaces;
		array<KsPinMedium^>^		Mediums;
		array<KsDataFormat^>^		DataRanges;
		KsPinDataFlow::ENUM			DataFlow;
		KsPinCommunication::ENUM	Communication;
		Guiddef::Guid				Category;
		Guiddef::Guid				Name;
		array<KsDataFormat^>^		ConstrainedDataRanges;
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsPinConnect
	{
		KsPinInterface	Interface;
		KsPinMedium		Medium;
		System::UInt32	PinId;
		System::IntPtr	PinToHandle;
		KsPriority      Priority;
		KsDataFormat	DataFormat;
		Interop::Winmm::WaveFormatExtensible WaveFormat;

		virtual System::String^ ToString() override
		{
			return "interface["+Interface.ToString()+"] medium["+Medium.ToString()+"] pinId["+PinId+"] pinToHandle["+PinToHandle+"] priority["+Priority.ToString()+"] dataFormat["+DataFormat.ToString()+"] waveFormat["+WaveFormat.ToString()+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsName 
	{
		[InteropServices::MarshalAs(InteropServices::UnmanagedType::ByValTStr, SizeConst=1024)]
			System::String^		Name;

		virtual System::String^ ToString() override
		{
			return 
				"name["+Name+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsTime
	{
		System::Int64	Time;
		System::UInt32	Numerator;
		System::UInt32	Denominator;

		virtual System::String^ ToString() override
		{
			return 
				"time["+Time+"] numerator["+Numerator+"] denominator["+Denominator+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsStreamHeader
	{
		System::UInt32	Size;
		System::UInt32	TypeSpecificFlags;
		KsTime			PresentationTime;
		System::Int64	Duration;
		System::UInt32	FrameExtent;
		System::UInt32	DataUsed;
		System::IntPtr	Data;
		System::UInt32	OptionsFlags;
		System::UInt32	Reserved;

		virtual System::String^ ToString() override
		{
			return 
				"size["+Size+"] typeSpecificFlags["+TypeSpecificFlags+"] presentationTime["+PresentationTime.ToString()+"] duration["+Duration+"] frameExtent["+FrameExtent+"] dataUsed["+DataUsed+"] data["+Data+"] optionsFlags["+OptionsFlags+"] reserved["+Reserved+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public value struct KsTopologyConnection
	{
		System::UInt32	FromNode;
		System::UInt32	FromNodePin;
		System::UInt32	ToNode;
		System::UInt32	ToNodePin;

		virtual System::String^ ToString() override
		{
			return 
				"fromNode["+FromNode+"] fromNodePin["+FromNodePin+"] toNode["+ToNode+"] toNodePin["+ToNodePin+"]";
		}
	};





	public value class Function
	{
	public:
		/*
		KSDDKAPI
		HRESULT
		WINAPI
		KsResolveRequiredAttributes(
			__in PKSDATARANGE DataRange,
			__in_opt PKSMULTIPLE_ITEM Attributes
			);

		KSDDKAPI
		HRESULT
		WINAPI
		KsOpenDefaultDevice(
			__in REFGUID Category,
			__in ACCESS_MASK Access,
			__out PHANDLE DeviceHandle
			);
			*/

		
		KERNEL32_DLLIMPORT static System::Boolean DeviceIoControl(
			[InteropServices::In]	Interop::Kernel32::Function::File^	hDevice,
			[InteropServices::In]	IOCTL_KS	dwIoControlCode,
			[InteropServices::In]	System::IntPtr	lpInBuffer,
			[InteropServices::In]	System::UInt32	nInBufferSize,
			[InteropServices::In]	System::IntPtr	lpOutBuffer,
			[InteropServices::In]	System::UInt32	nOutBufferSize,
			[InteropServices::Out]	System::UInt32%	lpBytesReturned,
			[InteropServices::In, InteropServices::Out]	System::Threading::NativeOverlapped%	lpOverlapped
		);
		
		KERNEL32_DLLIMPORT static System::Boolean GetOverlappedResult(
			[InteropServices::In]	Interop::Kernel32::Function::File^	hDevice,
			[InteropServices::In, InteropServices::Out]	System::Threading::NativeOverlapped%	lpOverlapped,
			[InteropServices::Out]	System::UInt32%		lpNumberOfBytesTransferred,
			[InteropServices::In]	System::Boolean		bWait
		);

		KSPROXY_API_DLLIMPORT static System::UInt32 KsSynchronousDeviceControl(
			[InteropServices::In]	Interop::Kernel32::Function::File^ hDevice,
			[InteropServices::In]	IOCTL_KS		dwIoControlCode,
			[InteropServices::In]	System::IntPtr	lpInBuffer,
			[InteropServices::In]	System::UInt32	nInBufferSize,
			[InteropServices::In]	System::IntPtr	lpOutBuffer,
			[InteropServices::In]	System::UInt32	nOutBufferSize,
			[InteropServices::Out]	System::UInt32%	lpBytesReturned
		);

		KSUSER_API_DLLIMPORT static System::UInt32 KsCreatePin(
			[InteropServices::In]	Interop::Kernel32::Function::File^	FilterHandle,
			[InteropServices::In]	KsPinConnect%						Connect,
			[InteropServices::In]	Interop::Kernel32::ACCESS_TYPES		DesiredAccess,
			[InteropServices::Out]	Interop::Kernel32::Function::File^% ConnectionHandle
		);






		/*
		KSDDKAPI
		HRESULT
		WINAPI
		KsGetMultiplePinFactoryItems(
			__in HANDLE  FilterHandle,
			__in ULONG   PinFactoryId,
			__in ULONG   PropertyId,
			__deref_out PVOID*  Items
			);
		KSDDKAPI
		HRESULT
		WINAPI
		KsGetMediaTypeCount(
			__in HANDLE      FilterHandle,
			__in ULONG       PinFactoryId,
			__out ULONG*      MediaTypeCount
			);
		KSDDKAPI
		HRESULT
		WINAPI
		KsGetMediaType(
			__in int         Position,
			__out AM_MEDIA_TYPE* AmMediaType,
			__in HANDLE      FilterHandle,
			__in ULONG       PinFactoryId
			);
		*/
	};


	public ref class StaticKs sealed
	{
	public:
		static initonly Guiddef::Guid CATEGORY_AUDIO			= Guiddef::Guid::Regist("6994AD04-93EF-11D0-A3CC-00A0C9223196", "StaticKs::CATEGORY_AUDIO");
		static initonly Guiddef::Guid CATEGORY_CAPTURE			= Guiddef::Guid::Regist("65E8773D-8F56-11D0-A3B9-00A0C9223196", "StaticKs::CATEGORY_CAPTURE");
		static initonly Guiddef::Guid CATEGORY_RENDER			= Guiddef::Guid::Regist("65E8773E-8F56-11D0-A3B9-00A0C9223196", "StaticKs::CATEGORY_RENDER");

		static initonly Guiddef::Guid MEDIATYPE_Audio			= Guiddef::Guid::Regist("73647561-0000-0010-8000-00aa00389b71", "StaticKs::MEDIATYPE_Audio");

		static initonly Guiddef::Guid SUBTYPE_WAVEFORMATEX		= Guiddef::Guid::Regist("00000000-0000-0010-8000-00aa00389b71", "StaticKs::SUBTYPE_WAVEFORMATEX");
		static initonly Guiddef::Guid SUBTYPE_PCM				= Guiddef::Guid::Regist("00000001-0000-0010-8000-00aa00389b71", "StaticKs::SUBTYPE_PCM");
		static initonly Guiddef::Guid SUBTYPE_IEEE_FLOAT		= Guiddef::Guid::Regist("00000003-0000-0010-8000-00aa00389b71", "StaticKs::SUBTYPE_IEEE_FLOAT");
		static initonly Guiddef::Guid SUBTYPE_ANALOG			= Guiddef::Guid::Regist("6dba3190-67bd-11cf-a0f7-0020afd156e4", "StaticKs::SUBTYPE_ANALOG");
		
		static initonly Guiddef::Guid SPECIFIER_VC_ID			= Guiddef::Guid::Regist("AD98D184-AAC3-11D0-A41C-00A0C9223196", "StaticKs::SPECIFIER_VC_ID");
		static initonly Guiddef::Guid SPECIFIER_WAVEFORMATEX	= Guiddef::Guid::Regist("05589f81-c356-11ce-bf01-00aa0055595a", "StaticKs::SPECIFIER_WAVEFORMATEX");
		static initonly Guiddef::Guid SPECIFIER_DSOUND			= Guiddef::Guid::Regist("518590a2-a184-11d0-8522-00c04fd9baf3", "StaticKs::SPECIFIER_DSOUND");

		static initonly Guiddef::Guid INTERFACESETID_Standard	= Guiddef::Guid::Regist("1A8766A0-62CE-11CF-A5D6-28DB04C10000", "StaticKs::INTERFACESETID_Standard");
		static initonly Guiddef::Guid INTERFACESETID_FileIo		= Guiddef::Guid::Regist("8C6F932C-E771-11D0-B8FF-00A0C9223196", "StaticKs::INTERFACESETID_FileIo");
		static initonly Guiddef::Guid INTERFACESETID_Media		= Guiddef::Guid::Regist("3A13EB40-30A7-11D0-A5D6-28DB04C10000", "StaticKs::INTERFACESETID_Media");
		
		static initonly Guiddef::Guid MEDIUMSETID_Standard		= Guiddef::Guid::Regist("4747B320-62CE-11CF-A5D6-28DB04C10000", "StaticKs::MEDIUMSETID_Standard");
		
		static initonly Guiddef::Guid PROPSETID_Topology		= Guiddef::Guid::Regist("720D4AC0-7533-11D0-A5D6-28DB04C10000", "StaticKs::PROPSETID_Topology");
		static initonly Guiddef::Guid PROPSETID_Pin				= Guiddef::Guid::Regist("8C134960-51AD-11CF-878A-94F801C10000", "StaticKs::PROPSETID_Pin");
		static initonly Guiddef::Guid PROPSETID_Connection		= Guiddef::Guid::Regist("1D58C920-AC9B-11CF-A5D6-28DB04C10000", "StaticKs::PROPSETID_Connection");
		static initonly Guiddef::Guid PROPSETID_Audio			= Guiddef::Guid::Regist("45FFAAA0-6E1B-11D0-BCF2-444553540000", "StaticKs::PROPSETID_Audio");
		static initonly Guiddef::Guid PROPSETID_Wave			= Guiddef::Guid::Regist("924e54b0-630f-11cf-ada7-08003e30494a", "StaticKs::PROPSETID_Wave");


	};

/*
typedef enum {
    KSPROPERTY_WAVE_COMPATIBLE_CAPABILITIES,
    KSPROPERTY_WAVE_INPUT_CAPABILITIES,
    KSPROPERTY_WAVE_OUTPUT_CAPABILITIES,
    KSPROPERTY_WAVE_BUFFER,
    KSPROPERTY_WAVE_FREQUENCY,
    KSPROPERTY_WAVE_VOLUME,
    KSPROPERTY_WAVE_PAN
} KSPROPERTY_WAVE;

typedef struct {
    ULONG        ulDeviceType;
} KSWAVE_COMPATCAPS, *PKSWAVE_COMPATCAPS;

#define KSWAVE_COMPATCAPS_INPUT                 0x00000000
#define KSWAVE_COMPATCAPS_OUTPUT                0x00000001

typedef struct {
    ULONG  MaximumChannelsPerConnection;
    ULONG  MinimumBitsPerSample;
    ULONG  MaximumBitsPerSample;
    ULONG  MinimumSampleFrequency;
    ULONG  MaximumSampleFrequency;
    ULONG  TotalConnections;
    ULONG  ActiveConnections;
} KSWAVE_INPUT_CAPABILITIES, *PKSWAVE_INPUT_CAPABILITIES;

typedef struct {
    ULONG  MaximumChannelsPerConnection;
    ULONG  MinimumBitsPerSample;
    ULONG  MaximumBitsPerSample;
    ULONG  MinimumSampleFrequency;
    ULONG  MaximumSampleFrequency;
    ULONG  TotalConnections;
    ULONG  StaticConnections;
    ULONG  StreamingConnections;
    ULONG  ActiveConnections;
    ULONG  ActiveStaticConnections;
    ULONG  ActiveStreamingConnections;
    ULONG  Total3DConnections;
    ULONG  Static3DConnections;
    ULONG  Streaming3DConnections;
    ULONG  Active3DConnections;
    ULONG  ActiveStatic3DConnections;
    ULONG  ActiveStreaming3DConnections;
    ULONG  TotalSampleMemory;
    ULONG  FreeSampleMemory;
    ULONG  LargestFreeContiguousSampleMemory;
} KSWAVE_OUTPUT_CAPABILITIES, *PKSWAVE_OUTPUT_CAPABILITIES;

typedef struct {
    LONG  LeftAttenuation;
    LONG  RightAttenuation;
} KSWAVE_VOLUME, *PKSWAVE_VOLUME;

#define KSWAVE_BUFFER_ATTRIBUTEF_LOOPING   0x00000001
#define KSWAVE_BUFFER_ATTRIBUTEF_STATIC    0x00000002

typedef struct {
    ULONG   Attributes;
    ULONG   BufferSize;
    PVOID   BufferAddress;
} KSWAVE_BUFFER, *PKSWAVE_BUFFER;



*/


}
}
}
