/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Interop.PropIdl.h
	
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Interop.Guiddef.h"

using namespace System::Runtime;

namespace Momiji{
namespace Interop {
namespace PropIdl {

	//Propsys.h
	WIN32_DLL_STRUCTLAYOUT public ref struct PROPERTYKEY
	{
	public:
		Guiddef::Guid fmtid;
		System::UInt32 pid;

		virtual System::String^ ToString() override sealed
		{
			return 
				"fmtid["+fmtid+"] pid["+pid+"]";
		}
		PROPERTYKEY()
		{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}

		~PROPERTYKEY()
		{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}
	};

	public enum class VT : System::UInt16
    {
		EMPTY	= 0,
		NULL	= 1,
		I2	= 2,
		I4	= 3,
		R4	= 4,
		R8	= 5,
		CY	= 6,
		DATE	= 7,
		BSTR	= 8,
		DISPATCH	= 9,
		ERROR	= 10,
		BOOL	= 11,
		VARIANT	= 12,
		UNKNOWN	= 13,
		DECIMAL	= 14,
		I1	= 16,
		UI1	= 17,
		UI2	= 18,
		UI4	= 19,
		I8	= 20,
		UI8	= 21,
		INT	= 22,
		UINT	= 23,
		VOID	= 24,
		HRESULT	= 25,
		PTR	= 26,
		SAFEARRAY	= 27,
		CARRAY	= 28,
		USERDEFINED	= 29,
		LPSTR	= 30,
		LPWSTR	= 31,
		RECORD	= 36,
		INT_PTR	= 37,
		UINT_PTR	= 38,
		FILETIME	= 64,
		BLOB	= 65,
		STREAM	= 66,
		STORAGE	= 67,
		STREAMED_OBJECT	= 68,
		STORED_OBJECT	= 69,
		BLOB_OBJECT	= 70,
		CF	= 71,
		CLSID	= 72,
		VERSIONED_STREAM	= 73,
		BSTR_BLOB	= 0xfff,
		VECTOR	= 0x1000,
		ARRAY	= 0x2000,
		BYREF	= 0x4000,
		RESERVED	= 0x8000,
		ILLEGAL	= 0xffff,
		ILLEGALMASKED	= 0xfff,
		TYPEMASK	= 0xfff
    };


	WIN32_DLL_STRUCTLAYOUT public ref struct BLOB
	{
		System::UInt32			cbSize;
		array<System::Byte>^	pBlobData;

		virtual System::String^ ToString() override sealed
		{
			return "vt["+cbSize.ToString()+"] wReserved1["+pBlobData->ToString()+"]";
		}
	};

	WIN32_DLL_STRUCTLAYOUT public ref struct PROPVARIANT
	{
		VT				vt;
		System::UInt16	wReserved1;
		System::UInt16	wReserved2;
		System::UInt16	wReserved3;

		System::Object^	value;

		virtual System::String^ ToString() override sealed
		{
			return "vt["+vt.ToString()+"] wReserved1["+wReserved1+"] wReserved2["+wReserved2+"] wReserved3["+wReserved3+"] value["+value+"]";
		}
		PROPVARIANT()
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}

		~PROPVARIANT()
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}
	};


	public ref class PROPVARIANTMarshaler : InteropServices::ICustomMarshaler
	{
	private:
		static PROPVARIANTMarshaler^ instance;
	public:
		virtual System::Object^ MarshalNativeToManaged(System::IntPtr val)
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}][val:{1}]",__FUNCTION__, val);
		#endif
			auto obj = gcnew PROPVARIANT();

			obj->vt			= safe_cast<VT>(InteropServices::Marshal::ReadInt16(val, 0));
			obj->wReserved1	= InteropServices::Marshal::ReadInt16(val, 2);
			obj->wReserved2	= InteropServices::Marshal::ReadInt16(val, 4);
			obj->wReserved3	= InteropServices::Marshal::ReadInt16(val, 6);

			switch(obj->vt) {

			//EMPTY	= 0,
			//NULL	= 1,

			case VT::I2 :
				{
					obj->value = InteropServices::Marshal::ReadInt16(val, 8);
					break;
				}

			case VT::I4 :
				{
					obj->value = InteropServices::Marshal::ReadInt32(val, 8);
					break;
				}
				
			//R4	= 4,
			//R8	= 5,
			//CY	= 6,
			//DATE	= 7,
			//BSTR	= 8,
			//DISPATCH	= 9,
			//ERROR	= 10,
			//BOOL	= 11,
			//VARIANT	= 12,
			//UNKNOWN	= 13,
			//DECIMAL	= 14,

			//I1	= 16,
			//UI1	= 17,
			//UI2	= 18,

			case VT::UI4 :
				{
					auto temp = gcnew array<System::Byte>(4);
					auto ptr = val + 8;
					InteropServices::Marshal::Copy(ptr, temp, 0, 4);
					obj->value = System::BitConverter::ToUInt32(temp, 0);
					break;
				}

			//I8	= 20,
			//UI8	= 21,
			//INT	= 22,
			//UINT	= 23,
			//VOID	= 24,
			//HRESULT	= 25,
			//PTR	= 26,
			//SAFEARRAY	= 27,
			//CARRAY	= 28,
			//USERDEFINED	= 29,
			//LPSTR	= 30,

			case VT::LPWSTR :
				{
					auto ptr = InteropServices::Marshal::ReadIntPtr(val, 8);
					obj->value = InteropServices::Marshal::PtrToStringUni(ptr);
					InteropServices::Marshal::FreeCoTaskMem(ptr);
					break;
				}

			//RECORD	= 36,
			//INT_PTR	= 37,
			//UINT_PTR	= 38,
			//FILETIME	= 64,

			//BLOB	= 65,
			case VT::BLOB :
				{
					auto blob = gcnew BLOB();
					
					auto temp = gcnew array<System::Byte>(4);
					auto ptr = val + 8;
					InteropServices::Marshal::Copy(ptr, temp, 0, 4);
					blob->cbSize = System::BitConverter::ToUInt32(temp, 0);

					ptr += 4;
					blob->pBlobData = gcnew array<System::Byte>(blob->cbSize);
					InteropServices::Marshal::Copy(ptr, blob->pBlobData, 0, blob->cbSize);

					obj->value = blob;
					break;
				}

			//STREAM	= 66,
			//STORAGE	= 67,
			//STREAMED_OBJECT	= 68,
			//STORED_OBJECT	= 69,
			//BLOB_OBJECT	= 70,
			//CF	= 71,


			case VT::CLSID :
				{
					auto ptr = InteropServices::Marshal::ReadIntPtr(val, 8);
					obj->value = InteropServices::Marshal::PtrToStructure(ptr, Guiddef::Guid::typeid);
					InteropServices::Marshal::FreeCoTaskMem(ptr);
					break;
				}


			//VERSIONED_STREAM	= 73,
			//BSTR_BLOB	= 0xfff,
			//VECTOR	= 0x1000,
			//ARRAY	= 0x2000,
			//BYREF	= 0x4000,
			//RESERVED	= 0x8000,
			//ILLEGAL	= 0xffff,
			//ILLEGALMASKED	= 0xfff,
			//TYPEMASK	= 0xfff

			default:
				{
					System::Console::WriteLine("[{0}]T|[ǧ^[VT:{1}]",__FUNCTION__, obj->vt);
					break;
				}
			}

		#ifdef _DEBUG
		//	System::Console::WriteLine("[{0}][obj:{1}]",__FUNCTION__, obj);
		#endif
			return obj;
		}
	
		virtual System::IntPtr MarshalManagedToNative(System::Object^ obj)
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}][obj:{1}]",__FUNCTION__, obj);
		#endif
			if(obj == nullptr)
			{
				return System::IntPtr::Zero;
			}

			auto val = InteropServices::Marshal::AllocCoTaskMem(32);
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}][val:{1}]",__FUNCTION__, val);
		#endif

			return val;
		}

		virtual void CleanUpNativeData(System::IntPtr val)
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}][val:{1}]",__FUNCTION__, val);
		#endif
			InteropServices::Marshal::FreeCoTaskMem(val);
		}

		virtual void CleanUpManagedData(System::Object^ obj)
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}][obj:{1}]",__FUNCTION__, obj);
		#endif

		}

		virtual System::Int32 GetNativeDataSize()
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
			return 0;
		}

		static InteropServices::ICustomMarshaler^ GetInstance(System::String^ cookie)
		{
		#ifdef _DEBUG
//			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
			if (instance == nullptr)
			{
				instance = gcnew PROPVARIANTMarshaler();
			}
			return instance;
		}

		PROPVARIANTMarshaler()
		{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}

		~PROPVARIANTMarshaler()
		{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		}
	};

	/*
	WIN32_DLL_STRUCTLAYOUT_UNION_ANSI
	public ref struct PROPVARIANT
	{
		[InteropServices::FieldOffset(0)]	VT				vt;
		[InteropServices::FieldOffset(2)]	System::UInt16	wReserved1;
		[InteropServices::FieldOffset(4)]	System::UInt16	wReserved2;
		[InteropServices::FieldOffset(6)]	System::UInt16	wReserved3;

		[InteropServices::FieldOffset(8)]	System::SByte	cVal;
		[InteropServices::FieldOffset(8)]	System::Byte	bVal;
        [InteropServices::FieldOffset(8)]	System::Int16	iVal;
        [InteropServices::FieldOffset(8)]	System::UInt16	uiVal;
        [InteropServices::FieldOffset(8)]	System::Int32 lVal;
        [InteropServices::FieldOffset(8)]	System::UInt32 ulVal;
        [InteropServices::FieldOffset(8)]	System::Int32 intVal;
        [InteropServices::FieldOffset(8)]	System::UInt32 uintVal;

        [InteropServices::FieldOffset(8)]	LARGE_INTEGER hVal;
        [InteropServices::FieldOffset(8)]	ULARGE_INTEGER uhVal;
        [InteropServices::FieldOffset(8)]	FLOAT fltVal;
        [InteropServices::FieldOffset(8)]	DOUBLE dblVal;
        [InteropServices::FieldOffset(8)]	VARIANT_BOOL boolVal;
        [InteropServices::FieldOffset(8)]	_VARIANT_BOOL bool;
        [InteropServices::FieldOffset(8)]	SCODE scode;
        [InteropServices::FieldOffset(8)]	CY cyVal;
        [InteropServices::FieldOffset(8)]	DATE date;

        [InteropServices::FieldOffset(8)]	InteropServices::ComTypes::FILETIME	filetime;
        
		[InteropServices::FieldOffset(8)]	CLSID *puuid;
        [InteropServices::FieldOffset(8)]	CLIPDATA *pclipdata;
        [InteropServices::FieldOffset(8)]	BSTR bstrVal;
        [InteropServices::FieldOffset(8)]	BSTRBLOB bstrblobVal;
        [InteropServices::FieldOffset(8)]	BLOB blob;
        [InteropServices::FieldOffset(8)]	LPSTR pszVal;
        [InteropServices::FieldOffset(8)]	LPWSTR pwszVal;
        [InteropServices::FieldOffset(8)]	IUnknown *punkVal;
        [InteropServices::FieldOffset(8)]	IDispatch *pdispVal;
        [InteropServices::FieldOffset(8)]	IStream *pStream;
        [InteropServices::FieldOffset(8)]	IStorage *pStorage;
        [InteropServices::FieldOffset(8)]	LPVERSIONEDSTREAM pVersionedStream;
        [InteropServices::FieldOffset(8)]	LPSAFEARRAY parray;
        [InteropServices::FieldOffset(8)]	CAC cac;
        [InteropServices::FieldOffset(8)]	CAUB caub;
        [InteropServices::FieldOffset(8)]	CAI cai;
        [InteropServices::FieldOffset(8)]	CAUI caui;
        [InteropServices::FieldOffset(8)]	CAL cal;
        [InteropServices::FieldOffset(8)]	CAUL caul;
        [InteropServices::FieldOffset(8)]	CAH cah;
        [InteropServices::FieldOffset(8)]	CAUH cauh;
        [InteropServices::FieldOffset(8)]	CAFLT caflt;
        [InteropServices::FieldOffset(8)]	CADBL cadbl;
        [InteropServices::FieldOffset(8)]	CABOOL cabool;
        [InteropServices::FieldOffset(8)]	CASCODE cascode;
        [InteropServices::FieldOffset(8)]	CACY cacy;
        [InteropServices::FieldOffset(8)]	CADATE cadate;
        [InteropServices::FieldOffset(8)]	CAFILETIME cafiletime;
        [InteropServices::FieldOffset(8)]	CACLSID cauuid;
        [InteropServices::FieldOffset(8)]	CACLIPDATA caclipdata;
        [InteropServices::FieldOffset(8)]	CABSTR cabstr;
        [InteropServices::FieldOffset(8)]	CABSTRBLOB cabstrblob;
        [InteropServices::FieldOffset(8)]	CALPSTR calpstr;
        [InteropServices::FieldOffset(8)]	CALPWSTR calpwstr;
        [InteropServices::FieldOffset(8)]	CAPROPVARIANT capropvar;
        [InteropServices::FieldOffset(8)]	CHAR *pcVal;
        [InteropServices::FieldOffset(8)]	UCHAR *pbVal;
        [InteropServices::FieldOffset(8)]	SHORT *piVal;
        [InteropServices::FieldOffset(8)]	USHORT *puiVal;
        [InteropServices::FieldOffset(8)]	LONG *plVal;
        [InteropServices::FieldOffset(8)]	ULONG *pulVal;
        [InteropServices::FieldOffset(8)]	INT *pintVal;
        [InteropServices::FieldOffset(8)]	UINT *puintVal;
        [InteropServices::FieldOffset(8)]	FLOAT *pfltVal;
        [InteropServices::FieldOffset(8)]	DOUBLE *pdblVal;
        [InteropServices::FieldOffset(8)]	VARIANT_BOOL *pboolVal;
        [InteropServices::FieldOffset(8)]	DECIMAL *pdecVal;
        [InteropServices::FieldOffset(8)]	SCODE *pscode;
        [InteropServices::FieldOffset(8)]	CY *pcyVal;
        [InteropServices::FieldOffset(8)]	DATE *pdate;
        [InteropServices::FieldOffset(8)]	BSTR *pbstrVal;
        [InteropServices::FieldOffset(8)]	IUnknown **ppunkVal;
        [InteropServices::FieldOffset(8)]	IDispatch **ppdispVal;
        [InteropServices::FieldOffset(8)]	LPSAFEARRAY *pparray;
        [InteropServices::FieldOffset(8)]	PROPVARIANT *pvarVal;

	};
	*/

	//propsys.h
	[InteropServices::ComImport]
	[InteropServices::Guid("886D8EEB-8CF2-4446-8D02-CDBA1DBDCF99")]
	[InteropServices::InterfaceType(InteropServices::ComInterfaceType::InterfaceIsIUnknown)]
	public interface class IPropertyStore
	{
		void GetCount(
			[InteropServices::Out] System::UInt32%	cProps
		);

		void GetAt(
			[InteropServices::In]	System::UInt32	iProp, 
			[InteropServices::Out]	PROPERTYKEY^	pkey
		);

		void GetValue(
			[InteropServices::In]	PROPERTYKEY^	key, 
			[InteropServices::Out]	System::IntPtr	pv		//TODO: JX^}[V[w肷ƁAoutp[^Œl󂯎Ȃ
		);

		void SetValue(
			[InteropServices::In]	PROPERTYKEY^	key, 
			[InteropServices::In]	System::IntPtr	propvar
		);

		void Commit();
	};



	/*

typedef struct tagVersionedStream
    {
    GUID guidVersion;
    IStream *pStream;
    } 	VERSIONEDSTREAM;

typedef struct tagVersionedStream *LPVERSIONEDSTREAM;


// Flags for IPropertySetStorage::Create
#define	PROPSETFLAG_DEFAULT	( 0 )

#define	PROPSETFLAG_NONSIMPLE	( 1 )

#define	PROPSETFLAG_ANSI	( 2 )

//   (This flag is only supported on StgCreatePropStg & StgOpenPropStg
#define	PROPSETFLAG_UNBUFFERED	( 4 )

//   (This flag causes a version-1 property set to be created
#define	PROPSETFLAG_CASE_SENSITIVE	( 8 )


// Flags for the reservied PID_BEHAVIOR property
#define	PROPSET_BEHAVIOR_CASE_SENSITIVE	( 1 )

#ifdef MIDL_PASS
// This is the PROPVARIANT definition for marshaling.
typedef struct tag_inner_PROPVARIANT PROPVARIANT;

#else
// This is the standard C layout of the PROPVARIANT.
typedef struct tagPROPVARIANT PROPVARIANT;
#endif
typedef struct tagCAC
    {
    ULONG cElems;
    CHAR *pElems;
    } 	CAC;

typedef struct tagCAUB
    {
    ULONG cElems;
    UCHAR *pElems;
    } 	CAUB;

typedef struct tagCAI
    {
    ULONG cElems;
    SHORT *pElems;
    } 	CAI;

typedef struct tagCAUI
    {
    ULONG cElems;
    USHORT *pElems;
    } 	CAUI;

typedef struct tagCAL
    {
    ULONG cElems;
    LONG *pElems;
    } 	CAL;

typedef struct tagCAUL
    {
    ULONG cElems;
    ULONG *pElems;
    } 	CAUL;

typedef struct tagCAFLT
    {
    ULONG cElems;
    FLOAT *pElems;
    } 	CAFLT;

typedef struct tagCADBL
    {
    ULONG cElems;
    DOUBLE *pElems;
    } 	CADBL;

typedef struct tagCACY
    {
    ULONG cElems;
    CY *pElems;
    } 	CACY;

typedef struct tagCADATE
    {
    ULONG cElems;
    DATE *pElems;
    } 	CADATE;

typedef struct tagCABSTR
    {
    ULONG cElems;
    BSTR *pElems;
    } 	CABSTR;

typedef struct tagCABSTRBLOB
    {
    ULONG cElems;
    BSTRBLOB *pElems;
    } 	CABSTRBLOB;

typedef struct tagCABOOL
    {
    ULONG cElems;
    VARIANT_BOOL *pElems;
    } 	CABOOL;

typedef struct tagCASCODE
    {
    ULONG cElems;
    SCODE *pElems;
    } 	CASCODE;

typedef struct tagCAPROPVARIANT
    {
    ULONG cElems;
    PROPVARIANT *pElems;
    } 	CAPROPVARIANT;

typedef struct tagCAH
    {
    ULONG cElems;
    LARGE_INTEGER *pElems;
    } 	CAH;

typedef struct tagCAUH
    {
    ULONG cElems;
    ULARGE_INTEGER *pElems;
    } 	CAUH;

typedef struct tagCALPSTR
    {
    ULONG cElems;
    LPSTR *pElems;
    } 	CALPSTR;

typedef struct tagCALPWSTR
    {
    ULONG cElems;
    LPWSTR *pElems;
    } 	CALPWSTR;

typedef struct tagCAFILETIME
    {
    ULONG cElems;
    FILETIME *pElems;
    } 	CAFILETIME;

typedef struct tagCACLIPDATA
    {
    ULONG cElems;
    CLIPDATA *pElems;
    } 	CACLIPDATA;

typedef struct tagCACLSID
    {
    ULONG cElems;
    CLSID *pElems;
    } 	CACLSID;


struct tag_inner_PROPVARIANT
    {
    VARTYPE vt;
    PROPVAR_PAD1 wReserved1;
    PROPVAR_PAD2 wReserved2;
    PROPVAR_PAD3 wReserved3;
    /* [switch_type]  union 
        {
         /* Empty union arm 
        CHAR cVal;
        UCHAR bVal;
        SHORT iVal;
        USHORT uiVal;
        LONG lVal;
        ULONG ulVal;
        INT intVal;
        UINT uintVal;
        LARGE_INTEGER hVal;
        ULARGE_INTEGER uhVal;
        FLOAT fltVal;
        DOUBLE dblVal;
        VARIANT_BOOL boolVal;
        _VARIANT_BOOL bool;
        SCODE scode;
        CY cyVal;
        DATE date;
        FILETIME filetime;
        CLSID *puuid;
        CLIPDATA *pclipdata;
        BSTR bstrVal;
        BSTRBLOB bstrblobVal;
        BLOB blob;
        LPSTR pszVal;
        LPWSTR pwszVal;
        IUnknown *punkVal;
        IDispatch *pdispVal;
        IStream *pStream;
        IStorage *pStorage;
        LPVERSIONEDSTREAM pVersionedStream;
        LPSAFEARRAY parray;
        CAC cac;
        CAUB caub;
        CAI cai;
        CAUI caui;
        CAL cal;
        CAUL caul;
        CAH cah;
        CAUH cauh;
        CAFLT caflt;
        CADBL cadbl;
        CABOOL cabool;
        CASCODE cascode;
        CACY cacy;
        CADATE cadate;
        CAFILETIME cafiletime;
        CACLSID cauuid;
        CACLIPDATA caclipdata;
        CABSTR cabstr;
        CABSTRBLOB cabstrblob;
        CALPSTR calpstr;
        CALPWSTR calpwstr;
        CAPROPVARIANT capropvar;
        CHAR *pcVal;
        UCHAR *pbVal;
        SHORT *piVal;
        USHORT *puiVal;
        LONG *plVal;
        ULONG *pulVal;
        INT *pintVal;
        UINT *puintVal;
        FLOAT *pfltVal;
        DOUBLE *pdblVal;
        VARIANT_BOOL *pboolVal;
        DECIMAL *pdecVal;
        SCODE *pscode;
        CY *pcyVal;
        DATE *pdate;
        BSTR *pbstrVal;
        IUnknown **ppunkVal;
        IDispatch **ppdispVal;
        LPSAFEARRAY *pparray;
        PROPVARIANT *pvarVal;
        } 	;
    } ;
#ifndef MIDL_PASS
    DECIMAL decVal;
  };
};



	[ComConversionLoss]
	[StructLayout(LayoutKind.Explicit, Pack = 8, Size = 8)]
	public struct __MIDL___MIDL_itf_mmdeviceapi_0003_0085_0001
	{
		[FieldOffset(0)]
		public sbyte cVal;
		[FieldOffset(0)]
		public byte bVal;
		[FieldOffset(0)]
		public short iVal;
		[FieldOffset(0)]
		public ushort uiVal;
		[FieldOffset(0)]
		public int lVal;
		[FieldOffset(0)]
		public uint ulVal;
		[FieldOffset(0)]
		public int intVal;
		[FieldOffset(0)]
		public uint uintVal;
		[FieldOffset(0)]
		public _LARGE_INTEGER hVal;
		[FieldOffset(0)]
		public _ULARGE_INTEGER uhVal;
		[FieldOffset(0)]
		public float fltVal;
		[FieldOffset(0)]
		public double dblVal;
		[FieldOffset(0)]
		public short boolVal;
		[FieldOffset(0)]
		public short @bool;
		[FieldOffset(0)]
		[MarshalAs(UnmanagedType.Error)]
		public int scode;
		[FieldOffset(0)]
		[MarshalAs(UnmanagedType.Currency)]
		public decimal cyVal;
		[FieldOffset(0)]
		public DateTime date;
		[FieldOffset(0)]
		public _FILETIME filetime;
		[FieldOffset(0)]
		public tagBSTRBLOB bstrblobVal;
		[FieldOffset(0)]
		public tagBLOB blob;
		[FieldOffset(0)]
		public tagCAC cac;
		[FieldOffset(0)]
		public tagCAUB caub;
		[FieldOffset(0)]
		public tagCAI cai;
		[FieldOffset(0)]
		public tagCAUI caui;
		[FieldOffset(0)]
		public tagCAL cal;
		[FieldOffset(0)]
		public tagCAUL caul;
		[FieldOffset(0)]
		public tagCAFLT caflt;
		[FieldOffset(0)]
		public tagCADBL cadbl;
		[FieldOffset(0)]
		public tagCABOOL cabool;
		[FieldOffset(0)]
		public tagCASCODE cascode;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pcVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pbVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr piVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr puiVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr plVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pulVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pintVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr puintVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pfltVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pdblVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pboolVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pscode;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 8)]
	public struct _LARGE_INTEGER
	{
		public long QuadPart;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 8)]
	public struct _ULARGE_INTEGER
	{
		public ulong QuadPart;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _FILETIME
	{
		public uint dwLowDateTime;
		public uint dwHighDateTime;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagBSTRBLOB
	{
		public uint cbSize;
		[ComConversionLoss]
		public IntPtr pData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagBLOB
	{
		public uint cbSize;
		[ComConversionLoss]
		public IntPtr pBlobData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAC
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAUB
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAI
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAUI
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAL
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAUL
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAFLT
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCADBL
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCABOOL
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCASCODE
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCLIPDATA
	{
		public uint cbSize;
		public int ulClipFmt;
		[ComConversionLoss]
		public IntPtr pClipData;
	}
	[Guid("0C733A30-2A1C-11CE-ADE5-00AA0044773D"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface ISequentialStream
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteRead(out byte pv, [In] uint cb, out uint pcbRead);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteWrite([In] ref byte pv, [In] uint cb, out uint pcbWritten);
	}
	[Guid("0000000C-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface IStream : ISequentialStream
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteRead(out byte pv, [In] uint cb, out uint pcbRead);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteWrite([In] ref byte pv, [In] uint cb, out uint pcbWritten);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteSeek([In] _LARGE_INTEGER dlibMove, [In] uint dwOrigin, out _ULARGE_INTEGER plibNewPosition);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void SetSize([In] _ULARGE_INTEGER libNewSize);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteCopyTo([MarshalAs(UnmanagedType.Interface)] [In] IStream pstm, [In] _ULARGE_INTEGER cb, out _ULARGE_INTEGER pcbRead, out _ULARGE_INTEGER pcbWritten);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Commit([In] uint grfCommitFlags);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Revert();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LockRegion([In] _ULARGE_INTEGER libOffset, [In] _ULARGE_INTEGER cb, [In] uint dwLockType);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void UnlockRegion([In] _ULARGE_INTEGER libOffset, [In] _ULARGE_INTEGER cb, [In] uint dwLockType);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Stat(out tagSTATSTG pstatstg, [In] uint grfStatFlag);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Clone([MarshalAs(UnmanagedType.Interface)] out IStream ppstm);
	}
	[StructLayout(LayoutKind.Sequential, Pack = 8)]
	public struct tagSTATSTG
	{
		[MarshalAs(UnmanagedType.LPWStr)]
		public string pwcsName;
		public uint type;
		public _ULARGE_INTEGER cbSize;
		public _FILETIME mtime;
		public _FILETIME ctime;
		public _FILETIME atime;
		public uint grfMode;
		public uint grfLocksSupported;
		public Guid clsid;
		public uint grfStateBits;
		public uint reserved;
	}
	[Guid("0000000B-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface IStorage
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void CreateStream([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [In] uint grfMode, [In] uint reserved1, [In] uint reserved2, [MarshalAs(UnmanagedType.Interface)] out IStream ppstm);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteOpenStream([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [In] uint cbReserved1, [In] ref byte reserved1, [In] uint grfMode, [In] uint reserved2, [MarshalAs(UnmanagedType.Interface)] out IStream ppstm);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void CreateStorage([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [In] uint grfMode, [In] uint reserved1, [In] uint reserved2, [MarshalAs(UnmanagedType.Interface)] out IStorage ppstg);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void OpenStorage([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [MarshalAs(UnmanagedType.Interface)] [In] IStorage pstgPriority, [In] uint grfMode, [ComAliasName("MMDeviceAPILib.wireSNB")] [In] ref tagRemSNB snbExclude, [In] uint reserved, [MarshalAs(UnmanagedType.Interface)] out IStorage ppstg);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteCopyTo([In] uint ciidExclude, [In] ref Guid rgiidExclude, [ComAliasName("MMDeviceAPILib.wireSNB")] [In] ref tagRemSNB snbExclude, [MarshalAs(UnmanagedType.Interface)] [In] IStorage pstgDest);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void MoveElementTo([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [MarshalAs(UnmanagedType.Interface)] [In] IStorage pstgDest, [MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsNewName, [In] uint grfFlags);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Commit([In] uint grfCommitFlags);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Revert();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteEnumElements([In] uint reserved1, [In] uint cbReserved2, [In] ref byte reserved2, [In] uint reserved3, [MarshalAs(UnmanagedType.Interface)] out IEnumSTATSTG ppenum);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void DestroyElement([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RenameElement([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsOldName, [MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsNewName);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void SetElementTimes([MarshalAs(UnmanagedType.LPWStr)] [In] string pwcsName, [In] ref _FILETIME pctime, [In] ref _FILETIME patime, [In] ref _FILETIME pmtime);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void SetClass([In] ref Guid clsid);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void SetStateBits([In] uint grfStateBits, [In] uint grfMask);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Stat(out tagSTATSTG pstatstg, [In] uint grfStatFlag);
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagRemSNB
	{
		public uint ulCntStr;
		public uint ulCntChar;
		[ComConversionLoss]
		public IntPtr rgString;
	}
	[Guid("0000000D-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface IEnumSTATSTG
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteNext([In] uint celt, out tagSTATSTG rgelt, out uint pceltFetched);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Skip([In] uint celt);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Reset();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void Clone([MarshalAs(UnmanagedType.Interface)] out IEnumSTATSTG ppenum);
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagVersionedStream
	{
		public Guid guidVersion;
		[MarshalAs(UnmanagedType.Interface)]
		public IStream pStream;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARRAY
	{
		public ushort cDims;
		public ushort fFeatures;
		public uint cbElements;
		public uint cLocks;
		public _wireSAFEARRAY_UNION uArrayStructs;
		[ComConversionLoss]
		public IntPtr rgsabound;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARRAY_UNION
	{
		public uint sfType;
		public __MIDL_IOleAutomationTypes_0001 u;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Explicit, Pack = 4, Size = 24)]
	public struct __MIDL_IOleAutomationTypes_0001
	{
		[FieldOffset(0)]
		public _BYTE_SIZEDARR ByteStr;
		[FieldOffset(0)]
		public _SHORT_SIZEDARR WordStr;
		[FieldOffset(0)]
		public _LONG_SIZEDARR LongStr;
		[FieldOffset(0)]
		public _HYPER_SIZEDARR HyperStr;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _BYTE_SIZEDARR
	{
		public uint clSize;
		[ComConversionLoss]
		public IntPtr pData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _SHORT_SIZEDARR
	{
		public uint clSize;
		[ComConversionLoss]
		public IntPtr pData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _LONG_SIZEDARR
	{
		public uint clSize;
		[ComConversionLoss]
		public IntPtr pData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _HYPER_SIZEDARR
	{
		public uint clSize;
		[ComConversionLoss]
		public IntPtr pData;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagSAFEARRAYBOUND
	{
		public uint cElements;
		public int lLbound;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_BSTR
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr aBstr;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _FLAGGED_WORD_BLOB
	{
		public uint fFlags;
		public uint clSize;
		[ComConversionLoss]
		public IntPtr asData;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_UNKNOWN
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr apUnknown;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_DISPATCH
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr apDispatch;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_VARIANT
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr aVariant;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 8)]
	public struct _wireVARIANT
	{
		public uint clSize;
		public uint rpcReserved;
		public ushort vt;
		public ushort wReserved1;
		public ushort wReserved2;
		public ushort wReserved3;
		public __MIDL_IOleAutomationTypes_0004 DUMMYUNIONNAME;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Explicit, Pack = 8, Size = 16)]
	public struct __MIDL_IOleAutomationTypes_0004
	{
		[FieldOffset(0)]
		public long llVal;
		[FieldOffset(0)]
		public int lVal;
		[FieldOffset(0)]
		public byte bVal;
		[FieldOffset(0)]
		public short iVal;
		[FieldOffset(0)]
		public float fltVal;
		[FieldOffset(0)]
		public double dblVal;
		[FieldOffset(0)]
		public short boolVal;
		[FieldOffset(0)]
		[MarshalAs(UnmanagedType.Error)]
		public int scode;
		[FieldOffset(0)]
		[MarshalAs(UnmanagedType.Currency)]
		public decimal cyVal;
		[FieldOffset(0)]
		public DateTime date;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pbVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr piVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr plVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pllVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pfltVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pdblVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pboolVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pscode;
		[FieldOffset(0)]
		public sbyte cVal;
		[FieldOffset(0)]
		public ushort uiVal;
		[FieldOffset(0)]
		public uint ulVal;
		[FieldOffset(0)]
		public ulong ullVal;
		[FieldOffset(0)]
		public int intVal;
		[FieldOffset(0)]
		public uint uintVal;
		[FieldOffset(0)]
		public decimal decVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pcVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr puiVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pulVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pullVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr pintVal;
		[ComConversionLoss]
		[FieldOffset(0)]
		public IntPtr puintVal;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireBRECORD
	{
		public uint fFlags;
		public uint clSize;
		[MarshalAs(UnmanagedType.Interface)]
		public IRecordInfo pRecInfo;
		[ComConversionLoss]
		public IntPtr pRecord;
	}
	[Guid("0000002F-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface IRecordInfo
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RecordInit([Out] IntPtr pvNew);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RecordClear([In] IntPtr pvExisting);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RecordCopy([In] IntPtr pvExisting, [Out] IntPtr pvNew);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetGuid(out Guid pguid);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetName([MarshalAs(UnmanagedType.BStr)] out string pbstrName);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetSize(out uint pcbSize);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeInfo([MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTypeInfo);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetField([In] IntPtr pvData, [MarshalAs(UnmanagedType.LPWStr)] [In] string szFieldName, [MarshalAs(UnmanagedType.Struct)] out object pvarField);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetFieldNoCopy([In] IntPtr pvData, [MarshalAs(UnmanagedType.LPWStr)] [In] string szFieldName, [MarshalAs(UnmanagedType.Struct)] out object pvarField, out IntPtr ppvDataCArray);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void PutField([In] uint wFlags, [In] [Out] IntPtr pvData, [MarshalAs(UnmanagedType.LPWStr)] [In] string szFieldName, [MarshalAs(UnmanagedType.Struct)] [In] ref object pvarField);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void PutFieldNoCopy([In] uint wFlags, [In] [Out] IntPtr pvData, [MarshalAs(UnmanagedType.LPWStr)] [In] string szFieldName, [MarshalAs(UnmanagedType.Struct)] [In] ref object pvarField);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetFieldNames([In] [Out] ref uint pcNames, [MarshalAs(UnmanagedType.BStr)] out string rgBstrNames);
		[MethodImpl(MethodImplOptions.PreserveSig | MethodImplOptions.InternalCall)]
		int IsMatchingType([MarshalAs(UnmanagedType.Interface)] [In] IRecordInfo pRecordInfo);
		[MethodImpl(MethodImplOptions.PreserveSig | MethodImplOptions.InternalCall)]
		IntPtr RecordCreate();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RecordCreateCopy([In] IntPtr pvSource, out IntPtr ppvDest);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RecordDestroy([In] IntPtr pvRecord);
	}
	[ComConversionLoss, Guid("00020401-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface ITypeInfo
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetTypeAttr([Out] IntPtr ppTypeAttr, [ComAliasName("MMDeviceAPILib.DWORD")] out uint pDummy);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeComp([MarshalAs(UnmanagedType.Interface)] out ITypeComp ppTComp);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetFuncDesc([In] uint index, [Out] IntPtr ppFuncDesc, [ComAliasName("MMDeviceAPILib.DWORD")] out uint pDummy);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetVarDesc([In] uint index, [Out] IntPtr ppVarDesc, [ComAliasName("MMDeviceAPILib.DWORD")] out uint pDummy);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetNames([In] int memid, [MarshalAs(UnmanagedType.BStr)] out string rgBstrNames, [In] uint cMaxNames, out uint pcNames);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetRefTypeOfImplType([In] uint index, out uint pRefType);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetImplTypeFlags([In] uint index, out int pImplTypeFlags);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalGetIDsOfNames();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalInvoke();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetDocumentation([In] int memid, [In] uint refPtrFlags, [MarshalAs(UnmanagedType.BStr)] out string pbstrName, [MarshalAs(UnmanagedType.BStr)] out string pBstrDocString, out uint pdwHelpContext, [MarshalAs(UnmanagedType.BStr)] out string pBstrHelpFile);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetDllEntry([In] int memid, [In] tagINVOKEKIND invkind, [In] uint refPtrFlags, [MarshalAs(UnmanagedType.BStr)] out string pBstrDllName, [MarshalAs(UnmanagedType.BStr)] out string pbstrName, out ushort pwOrdinal);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetRefTypeInfo([In] uint hreftype, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalAddressOfMember();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteCreateInstance([In] ref Guid riid, [MarshalAs(UnmanagedType.IUnknown)] out object ppvObj);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetMops([In] int memid, [MarshalAs(UnmanagedType.BStr)] out string pBstrMops);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetContainingTypeLib([MarshalAs(UnmanagedType.Interface)] out ITypeLib ppTLib, out uint pIndex);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalReleaseTypeAttr();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalReleaseFuncDesc();
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalReleaseVarDesc();
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagTYPEATTR
	{
		public Guid guid;
		public uint lcid;
		public uint dwReserved;
		public int memidConstructor;
		public int memidDestructor;
		[MarshalAs(UnmanagedType.LPWStr)]
		public string lpstrSchema;
		public uint cbSizeInstance;
		public tagTYPEKIND typekind;
		public ushort cFuncs;
		public ushort cVars;
		public ushort cImplTypes;
		public ushort cbSizeVft;
		public ushort cbAlignment;
		public ushort wTypeFlags;
		public ushort wMajorVerNum;
		public ushort wMinorVerNum;
		public tagTYPEDESC tdescAlias;
		public tagIDLDESC idldescType;
	}
	[ComConversionLoss, Guid("00020403-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface ITypeComp
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteBind([MarshalAs(UnmanagedType.LPWStr)] [In] string szName, [In] uint lHashVal, [In] ushort wFlags, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo, out tagDESCKIND pDescKind, [Out] IntPtr ppFuncDesc, [Out] IntPtr ppVarDesc, [MarshalAs(UnmanagedType.Interface)] out ITypeComp ppTypeComp, [ComAliasName("MMDeviceAPILib.DWORD")] out uint pDummy);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteBindType([MarshalAs(UnmanagedType.LPWStr)] [In] string szName, [In] uint lHashVal, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo);
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagFUNCDESC
	{
		public int memid;
		[ComConversionLoss]
		public IntPtr lprgscode;
		[ComConversionLoss]
		public IntPtr lprgelemdescParam;
		public tagFUNCKIND funckind;
		public tagINVOKEKIND invkind;
		public tagCALLCONV callconv;
		public short cParams;
		public short cParamsOpt;
		public short oVft;
		public short cScodes;
		public tagELEMDESC elemdescFunc;
		public ushort wFuncFlags;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagVARDESC
	{
		public int memid;
		[MarshalAs(UnmanagedType.LPWStr)]
		public string lpstrSchema;
		public __MIDL_IOleAutomationTypes_0006 DUMMYUNIONNAME;
		public tagELEMDESC elemdescVar;
		public ushort wVarFlags;
		public tagVARKIND varkind;
	}
	public enum tagINVOKEKIND
	{
		INVOKE_FUNC = 1,
		INVOKE_PROPERTYGET,
		INVOKE_PROPERTYPUT = 4,
		INVOKE_PROPERTYPUTREF = 8
	}
	[ComConversionLoss, Guid("00020402-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport]
	public interface ITypeLib
	{
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetTypeInfoCount(out uint pcTInfo);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeInfo([In] uint index, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeInfoType([In] uint index, out tagTYPEKIND pTKind);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeInfoOfGuid([In] ref Guid guid, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetLibAttr([Out] IntPtr ppTLibAttr, [ComAliasName("MMDeviceAPILib.DWORD")] out uint pDummy);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void GetTypeComp([MarshalAs(UnmanagedType.Interface)] out ITypeComp ppTComp);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteGetDocumentation([In] int index, [In] uint refPtrFlags, [MarshalAs(UnmanagedType.BStr)] out string pbstrName, [MarshalAs(UnmanagedType.BStr)] out string pBstrDocString, out uint pdwHelpContext, [MarshalAs(UnmanagedType.BStr)] out string pBstrHelpFile);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteIsName([MarshalAs(UnmanagedType.LPWStr)] [In] string szNameBuf, [In] uint lHashVal, out int pfName, [MarshalAs(UnmanagedType.BStr)] out string pBstrLibName);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void RemoteFindName([MarshalAs(UnmanagedType.LPWStr)] [In] string szNameBuf, [In] uint lHashVal, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalType = "System.Runtime.InteropServices.CustomMarshalers.TypeToTypeInfoMarshaler")] out Type ppTInfo, out int rgMemId, [In] [Out] ref ushort pcFound, [MarshalAs(UnmanagedType.BStr)] out string pBstrLibName);
		[MethodImpl(MethodImplOptions.InternalCall)]
		void LocalReleaseTLibAttr();
	}
	public enum tagTYPEKIND
	{
		TKIND_ENUM,
		TKIND_RECORD,
		TKIND_MODULE,
		TKIND_INTERFACE,
		TKIND_DISPATCH,
		TKIND_COCLASS,
		TKIND_ALIAS,
		TKIND_UNION,
		TKIND_MAX
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagTYPEDESC
	{
		public __MIDL_IOleAutomationTypes_0005 DUMMYUNIONNAME;
		public ushort vt;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Explicit, Pack = 4, Size = 4)]
	public struct __MIDL_IOleAutomationTypes_0005
	{
		[FieldOffset(0)]
		public uint hreftype;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagIDLDESC
	{
		[ComAliasName("MMDeviceAPILib.ULONG_PTR")]
		public uint dwReserved;
		public ushort wIDLFlags;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagARRAYDESC
	{
		public tagTYPEDESC tdescElem;
		public ushort cDims;
		[ComConversionLoss]
		public IntPtr rgbounds;
	}
	public enum tagDESCKIND
	{
		DESCKIND_NONE,
		DESCKIND_FUNCDESC,
		DESCKIND_VARDESC,
		DESCKIND_TYPECOMP,
		DESCKIND_IMPLICITAPPOBJ,
		DESCKIND_MAX
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagELEMDESC
	{
		public tagTYPEDESC tdesc;
		public tagPARAMDESC paramdesc;
	}
	public enum tagFUNCKIND
	{
		FUNC_VIRTUAL,
		FUNC_PUREVIRTUAL,
		FUNC_NONVIRTUAL,
		FUNC_STATIC,
		FUNC_DISPATCH
	}
	public enum tagCALLCONV
	{
		CC_FASTCALL,
		CC_CDECL,
		CC_MSCPASCAL,
		CC_PASCAL = 2,
		CC_MACPASCAL,
		CC_STDCALL,
		CC_FPFASTCALL,
		CC_SYSCALL,
		CC_MPWCDECL,
		CC_MPWPASCAL,
		CC_MAX
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagPARAMDESC
	{
		[ComConversionLoss]
		public IntPtr pparamdescex;
		public ushort wParamFlags;
	}
	[StructLayout(LayoutKind.Sequential, Pack = 8)]
	public struct tagPARAMDESCEX
	{
		public uint cBytes;
		[MarshalAs(UnmanagedType.Struct)]
		public object varDefaultValue;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Explicit, Pack = 4, Size = 4)]
	public struct __MIDL_IOleAutomationTypes_0006
	{
		[FieldOffset(0)]
		public uint oInst;
	}
	public enum tagVARKIND
	{
		VAR_PERINSTANCE,
		VAR_STATIC,
		VAR_CONST,
		VAR_DISPATCH
	}
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagTLIBATTR
	{
		public Guid guid;
		public uint lcid;
		public tagSYSKIND syskind;
		public ushort wMajorVerNum;
		public ushort wMinorVerNum;
		public ushort wLibFlags;
	}
	public enum tagSYSKIND
	{
		SYS_WIN16,
		SYS_WIN32,
		SYS_MAC,
		SYS_WIN64
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_BRECORD
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr aRecord;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct _wireSAFEARR_HAVEIID
	{
		public uint Size;
		[ComConversionLoss]
		public IntPtr apUnknown;
		public Guid iid;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAH
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAUH
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCACY
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCADATE
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAFILETIME
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCACLSID
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCACLIPDATA
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCABSTR
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCABSTRBLOB
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCALPSTR
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCALPWSTR
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}
	[ComConversionLoss]
	[StructLayout(LayoutKind.Sequential, Pack = 4)]
	public struct tagCAPROPVARIANT
	{
		public uint cElems;
		[ComConversionLoss]
		public IntPtr pElems;
	}

	*/
}
}
}
