﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Sequencer.Midi.Smf.cpp
	stream component of standard midi file.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Winmm.h"

#include "Momiji.Core.Interface.h"
#include "Momiji.Core.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Sequencer {
namespace Wave {

	public ref class WaveStream
		: public Core::IStream
	{
	public:
		enum class TYPE: System::UInt32 
		{
			HEADER		= 0x52494646L,	//	RIFF
			HEADER_R	= 0x46464952L,	//		読み込み用
		};

		enum class FORMAT: System::UInt32
		{
			WAVE		= 0x57415645L,	//	WAVE
			WAVE_R		= 0x45564157L,	//		読み込み用
		};

		enum class SUB: System::UInt32
		{
			fmt_		= 0x666D7420L,	//	fmt
			fmt__R		= 0x20746D66L,	//		読み込み用

			data		= 0x64617461L,	//	data
			data_R		= 0x61746164L,	//		読み込み用

			LIST		= 0x4C495354L,	//	LIST
			LIST_R		= 0x5453494CL,	//		読み込み用

		};

		//RIFF Header Chunk
		WIN32_DLL_STRUCTLAYOUT value struct RIFFHEADER_CHUNK 
		{
			System::UInt32	dwType;
			System::UInt32	dwLength;
			System::UInt32	dwFormat;
		};

		//RIFF Sub Chunk
		WIN32_DLL_STRUCTLAYOUT value struct RIFFSUB_CHUNK 
		{
			System::UInt32	dwType;
			System::UInt32	dwLength;
		};

	private:
		System::IO::MemoryMappedFiles::MemoryMappedFile^			_mmap;
		System::IO::MemoryMappedFiles::MemoryMappedViewAccessor^	_view;

		Momiji::Interop::Winmm::WaveFormatEx _wfx;

		System::Int64 _dataStartPosition;
		System::UInt32 _dataSize;
		System::Int64 _dataSeekPosition;

	public:
		WaveStream(System::String^ path);
		virtual ~WaveStream();

	protected:
		!WaveStream();

	private:
		void Open(System::String^ path);
		void CheckWave();

	public:
		virtual array<Core::IStreamPacket^>^ GetStreamPacket(System::Double deltaTime) {return nullptr;};
		virtual void Rewind() {};

		//System::UInt32 WaveStream::Read(array<System::Byte>^ buffer, System::UInt32 samplesPerBuffer);
		System::UInt32 WaveStream::Read(Momiji::Core::Buffer::BufferPool<array<System::Byte>^>::Buffer^ buffer, System::UInt32 samplesPerBuffer);

		property Momiji::Interop::Winmm::WaveFormatEx format { Momiji::Interop::Winmm::WaveFormatEx get() {return this->_wfx;} } 

	};

	public ref class WaveException
		: System::Exception
	{
	public:
		WaveException(System::String^ v): System::Exception(v){};
	};

}
}
}
