﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Sequencer.Midi.Smf.h
	stream component of standard midi file.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

using namespace System::Runtime;

namespace Momiji{
	/**
	<remarks>
	ユーティリティクラス（未整理ロジック）
	</remarks>
	*/
	value class Util
	{
	public:
		/**
		<summary>
		ntohs
		</summary>
		<param name="data">ビッグエンディアンの２バイトデータ</param>
		<returns>システムがリトルエンディアンであれば、変換して返す。</returns>
		*/
		static System::UInt16 ToHostOrder(System::UInt16 data)
		{
			if (System::BitConverter::IsLittleEndian)
			{
				return safe_cast<System::UInt16>(
					((data >> 8) & 0x00FF) | 
					((data << 8) & 0xFF00)
					);
			}
			return data;
		};

		/**
		<summary>
		ntohl
		</summary>
		<param name="data">ビッグエンディアンの４バイトデータ</param>
		<returns>システムがリトルエンディアンであれば、変換して返す。</returns>
		*/
		static System::UInt32 ToHostOrder(System::UInt32 data)
		{
			if (System::BitConverter::IsLittleEndian)
			{
				return (
					((data >> 24) & 0x000000FFL) |
					((data >> 8 ) & 0x0000FF00L) |
					((data << 8 ) & 0x00FF0000L) |
					((data << 24) & 0xFF000000L)
					);
			}
			return data;
		};
	};

}
