#include "stdafx.h"

#using <Momiji.Core.dll>
#using <System.Windows.Forms.dll>

using namespace System;
using namespace System::Runtime;

public ref class Controller
{
private:
	Momiji::Core::ITimer^ _timer;
	Momiji::Core::IStream^ _stream;
	Momiji::Core::IOut^ _out;

	//Momiji::Core::Vst::Host::Master^ _host;

	Collections::Generic::List<Momiji::Core::Vst::Host::Master^>^ _hosts;

	int _interval;
	int _sampleMax;
	int _ch;
	array<System::Single>^ _data;
	Momiji::Core::Vst::Buffer::VstBuffer<System::Single>^ _inBuffer;
	Momiji::Core::Vst::Buffer::VstBuffer<System::Single>^ _outBuffer;


public:
	Controller()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->_interval = 10;
		this->_sampleMax = 48000.0 * this->_interval * 2 / 1000.0;

		this->_ch = 1;
		this->_data = gcnew array<System::Single>(this->_sampleMax * 2);
		this->_inBuffer = gcnew Momiji::Core::Vst::Buffer::VstBuffer<System::Single>(2,this->_sampleMax);
		this->_outBuffer = gcnew Momiji::Core::Vst::Buffer::VstBuffer<System::Single>(2,this->_sampleMax);

		this->_hosts = gcnew Collections::Generic::List<Momiji::Core::Vst::Host::Master^>;
	}

	~Controller()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Controller();
	}

	void Start()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		if (this->_timer != nullptr)
		{
			this->_timer->Start(this->_interval);
		}
	}

	void Stop()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		if (this->_timer != nullptr)
		{
			this->_timer->Stop();
		}
	}

protected:
	!Controller()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->Stop();
	}

private:
	void OnInterval(System::Double deltaTime)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}][{1}]",__FUNCTION__, deltaTime);
		#endif
		auto stream = this->_stream;
		auto out = this->_out;
		auto hosts = this->_hosts;

		if (stream == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}]V[PT̂ŉ܂",__FUNCTION__);
			#endif
			return;
		}
		if (out == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}]o͂̂ŉ܂",__FUNCTION__);
			#endif
			return;
		}
		if (hosts == nullptr)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}]VST̂ŉ܂",__FUNCTION__);
			#endif
			return;
		}

		int sample = 48000.0 * deltaTime / 1000.0;
		//System::Console::WriteLine("[{0}][{1}][{2}][{3}]",__FUNCTION__, this->_sampleMax, sample, deltaTime);

		if (sample > this->_sampleMax) {
			sample = this->_sampleMax;
		}

		auto events = gcnew Collections::Generic::List< Collections::Generic::List<Momiji::Interop::Vst::VstEvent>^ >;
		for (int i = 0; i < this->_ch; i++) 
		{
			events->Add(gcnew Collections::Generic::List<Momiji::Interop::Vst::VstEvent>);
		}

		auto packets = stream->GetStreamPacket(deltaTime);
		auto startTick = 0;
		for each(auto packet in packets)
		{
			auto midi = dynamic_cast<Momiji::Core::Midi::ShortData^>(packet->data);
			if (midi == nullptr)
			{
				continue;
			}

			if (startTick == 0) {startTick = packet->tick;}
			auto delta = (packet->tick - startTick);

			auto e = Momiji::Interop::Vst::VstEvent();
			e.type = Momiji::Interop::Vst::VstEvent::VstEventTypes::kVstMidiType;
			e.flags = Momiji::Interop::Vst::VstEvent::VstMidiEventFlags::kVstMidiEventIsRealtime;
			e.deltaFrames = ((sample < delta) ? sample : delta) * 10000; //͂Ƌ߂悤ɂ
			e.midiData = midi->shortData;
			events[0/*midi->port*/]->Add(e);
		}

		auto pos = 0;
		for (int i = 0; i < this->_ch; i++)
		{
			auto host = hosts[i];

			host->ProcessEvents(events[i]->ToArray());
			host->Process(this->_inBuffer, this->_outBuffer, sample/*this->_outBuffer->Length()/**/);

			for (int idx = 0; idx < sample; idx++)
			{
				this->_data[pos++] += this->_outBuffer->GetBuffer()[0][idx];
				this->_data[pos++] += this->_outBuffer->GetBuffer()[1][idx];
			}
		}

		delete events;

		auto buffer = gcnew Momiji::Core::Wave::WaveData<System::Single>(0, this->_data, pos);

		out->Send(buffer);

		pos = 0;
		for (int i = 0; i < this->_ch; i++)
		{
			for (int idx = 0; idx < sample; idx++)
			{
				this->_data[pos++] = 0;
				this->_data[pos++] = 0;
			}
		}

		buffer = nullptr;
	}


public:
	void Assign(Momiji::Core::ITimer^ timer)
	{
		auto e = gcnew Momiji::Core::ITimer::Event(this, &Controller::OnInterval);
		if (this->_timer != nullptr)
		{
			this->_timer->OnInterval -= e;
		}

		this->_timer = timer;
		this->_timer->OnInterval += e;
	}

	void Assign(Momiji::Core::IStream^ stream)
	{
		this->_stream = stream;
	}

	void Assign(Momiji::Core::IOut^ out)
	{
		this->_out = out;
	}

	void Add(Momiji::Core::Vst::Host::Master^ host)
	{
		this->_hosts->Add(host);
	}

};


void test0()
{
	auto vstFileName = System::String::Empty;
	{
		auto dialog = gcnew System::Windows::Forms::OpenFileDialog();
		try
		{
			dialog->InitialDirectory = System::IO::Directory::GetCurrentDirectory();
			dialog->Filter = "vst|*.dll";
			if (dialog->ShowDialog() == System::Windows::Forms::DialogResult::Cancel)
			{
				Console::WriteLine("============ ");
				return;
			}

			vstFileName = dialog->FileName;
		}
		finally
		{
			delete dialog;
		}
	}

	auto smfFileName = System::String::Empty;
	{
		auto dialog = gcnew System::Windows::Forms::OpenFileDialog();
		try
		{
			dialog->InitialDirectory = System::IO::Directory::GetCurrentDirectory();
			dialog->Filter = "smf|*.mid";
			if (dialog->ShowDialog() == System::Windows::Forms::DialogResult::Cancel)
			{
				Console::WriteLine("============ ");
				return;
			}

			smfFileName = dialog->FileName;
		}
		finally
		{
			delete dialog;
		}
	}

	Momiji::Core::ITimer^ t;
	Momiji::Core::IStream^ s;
	Momiji::Core::Wave::Out::Device^ o;
	Momiji::Core::Vst::Host::Master^ h;
	Controller^ c;
	try
	{
		t = gcnew Momiji::Core::Timer::MMTimer();
		s = gcnew Momiji::Sequencer::Midi::Smf::SmfStream(smfFileName);
		o = gcnew Momiji::Core::Wave::Out::Device(
				0,
				2,
				48000,
				System::Runtime::InteropServices::Marshal::SizeOf(System::Single::typeid) * 8,
				(
					Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_LEFT
				|	Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_RIGHT
				),
				Momiji::Interop::Ks::StaticKs::SUBTYPE_IEEE_FLOAT,
				48000
			);

		c = gcnew Controller();
		c->Assign(t);
		c->Assign(s);
		c->Assign(o);

		for (int i = 0; i < 1/*16*/; i++) {
			h = gcnew Momiji::Core::Vst::Host::Master(vstFileName);
			h->SetSampleRate(48000);
			h->SetBlockSize(48000);
			h->Resume();
			h->Suspend();
			h->StartProcess();
			h->Resume();

			c->Add(h);
		}

		c->Start();
		Console::WriteLine("============ enter stop");
		System::Console::ReadLine();
		c->Stop();

		Console::WriteLine("============ enter start");
		System::Console::ReadLine();
		c->Start();

		Console::WriteLine("============ enter stop - rewind - start");
		System::Console::ReadLine();
		c->Stop();
		s->Rewind();

		c->Start();
		Console::WriteLine("============ enter stop");
		System::Console::ReadLine();
		c->Stop();
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
	finally
	{
		if (c != nullptr)
		{
			delete c;
		}

		if (h != nullptr)
		{
			delete h;
		}
		if (s != nullptr)
		{
			delete s;
		}
		if (t != nullptr)
		{
			delete t;
		}
		if (o != nullptr)
		{
			delete o;
		}
	}

}



[System::STAThread]
int main(array<System::String ^> ^args)
{
	Console::WriteLine("====================================================test0");
	try
	{
		test0();
	}
	catch(Exception^ e)
	{
		Console::WriteLine("exception: {0}", e);
	}
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
