<?php

class Account extends Zend_Db_Table_Abstract {
  protected $_name = 'necosuke_lpo_mast_account';
  protected $_rowClass = 'AccountRow';
  protected $_dependentTables = array('Lpo');

  public function insert($data) {
    $data['hash'] = sha1(
      'NECOSUKELPO'.$data['email'].$data['name'].date('YmdHis')
    );
    $data['created']  = new Zend_Db_Expr('now()');
    $data['updated']  = new Zend_Db_Expr('now()');

    /*
    if(array_key_exists('password', $data)) {
      $data['password'] = new Zend_Db_Expr(
        $this->getDefaultAdapter()->quoteInto('sha1(?)', $data['password'])
      );
    }
    */

    $ret = parent::insert($data);

    $db = Zend_Db_Table_Abstract::getDefaultAdapter();
    if($id = $db->lastInsertId()) {
      $config = Zend_Controller_Front::getInstance()->getParam('config');
      $table_name = sprintf($config->db->table->user->log, $id);

      $sql =<<<END
CREATE TABLE IF NOT EXISTS {$table_name}
(
  id           INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  status       ENUM('active', 'deleted')  NOT NULL DEFAULT 'active',
  `date`       DATETIME         NOT NULL,
  log          ENUM('landing', 'conversion') NOT NULL,
  lpo_id       INT(10) UNSIGNED NOT NULL,
  condition_id INT(10) UNSIGNED NOT NULL,
  content_id   INT(10) UNSIGNED NOT NULL,

  PRIMARY KEY (id),
  INDEX (log, lpo_id),
  INDEX (log, condition_id),
  INDEX (log, content_id)
) TYPE=InnoDB
END;
      $db->getConnection()->exec($sql);
    }

    return $ret;
  }

  public function update($data, $where) {
    $data['updated']  = new Zend_Db_Expr('now()');

    if(array_key_exists('password', $data)) {
      $data['password'] = new Zend_Db_Expr(
        $this->getDefaultAdapter()->quoteInto('sha1(?)', $data['password'])
      );
    }

    return parent::update($data, $where);
  }

  public function getAccountByHash($hash) {
    return $this->fetchRow(
      $this->select()
        ->where('status = ?', 'active')
        ->where('hash = ?', $hash)
    );
  }
}

class AccountRow extends Zend_Db_Table_Row_Abstract {
  public function getContentRows($url, $ref) {
    $ret = array();

    $db = Zend_Db_Table_Abstract::getDefaultAdapter();

    $lpo_t = new Lpo();
    foreach(
      $this->findDependentRowset(
        'Lpo',
        null,
        $lpo_t->select()
          ->where('status = ?', 'active')
          ->where(
            sprintf(
              'landing_url = %s OR landing_url = %s',
              $db->quote($url),
              $db->quote(array_shift(explode('?', $url)))
            )
          )
          ->order('name')
      ) as $lpo
    ) {
      if($data = $lpo->getContent($url, $ref)) {
        $ret[] = $data;
      }
    }

    return $ret;
  }

  public function getConversionLpoRows($url) {
  }

  public function getLpo($lpo_id) {
    $lpo_t = new Lpo();

    return $lpo_t->fetchRow(
      $lpo_t->select()
        ->where('account_id = ?', $this->id)
        ->where('status != ?', 'deleted')
        ->where('id = ?', $lpo_id)
    );
  }

  public function getCondition($condition_id) {
    $condition_t = new Condition();
    $condition   = $condition_t->find($condition_id)->current();

    if(
      $condition &&
      $condition->status != 'deleted' &&
      $this->getLpo($condition->lpo_id)
    ) {
      return $condition;
    } else {
      return null;
    }
  }

  public function getContent($content_id) {
    $content_t = new Content();
    $content   = $content_t->find($content_id)->current();

    if(
      $content &&
      $content->status != 'deleted' &&
      $this->getCondition($content->condition_id)
    ) {
      return $content;
    } else {
      return null;
    }
  }
}
