/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/13
 */
public interface NinaAction {

	/**
	 * 
	 * @param e
	 * @param rd
	 * @param accept
	 */
	public void labelAdded(NinaEvent e, NinaFrameReader rd,
			boolean accept);

	/**
	 * 
	 * @param q
	 * @param ver
	 */
	public void link(NinaEvent q, Object ver);

	/**
	 * 
	 * @return
	 */
	public String getLabel();

	/**
	 * 
	 * @return
	 */
	public Object getVertex();

	/**
	 * 
	 * @return
	 */
	public void setVertex(Object o);

	/**
	 * @param q
	 */
	public void doneBlockSearching(NinaEvent q);

	/**
	 * @param q
	 * @param o
	 */
	public void setEdge(NinaEvent q, Object o);

	/**
	 * 
	 * @param q
	 * @param p
	 * @param s
	 */
	public void setEdgeResource(NinaEvent q, NinaParser p, String s);

	/**
	 * 
	 * @return
	 */
	public Object accept();

}
